/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.view;

import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.DHCPClass;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.LSA2Group;
import COM.ibm.raleigh.dhcpsgui.biz.Lease;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeletonManager;
import COM.ibm.raleigh.dhcpsgui.biz.PXEOptionSkeletonManager;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.dhcpsgui.view.FlatTreeNode;
import COM.ibm.raleigh.dhcpsgui.view.ListView;
import COM.ibm.raleigh.dhcpsgui.view.View;
import COM.ibm.raleigh.dhcpsgui.view.ViewUser;
import java.util.Enumeration;
import java.util.Vector;

public class OptionsForItemView
extends ListView
implements View {
    private static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_OPTIONS_FOR_ITEM_VIEW_HEADING = DHCPServerGUI.getResourceString("TEXT_OPTIONS_FOR_ITEM_VIEW_HEADING");
    private static final String TEXT_OPTION_COLUMN_NAME = DHCPServerGUI.getResourceString("TEXT_OPTION_COLUMN_NAME");
    private static final String TEXT_OPTION_COLUMN_VALUE = DHCPServerGUI.getResourceString("TEXT_OPTION_COLUMN_VALUE");
    private static final String TEXT_OPTION_ROOT_NAME = DHCPServerGUI.getResourceString("TEXT_OPTION_ROOT_NAME");
    private static final String TEXT_NAME_GLOBAL = DHCPServerGUI.getResourceString("TEXT_NAME_GLOBAL");
    private static final String TEXT_NAME_SUBNET = DHCPServerGUI.getResourceString("TEXT_NAME_SUBNET");
    private static final String TEXT_NAME_CLASS = DHCPServerGUI.getResourceString("TEXT_NAME_CLASS");
    private static final String TEXT_NAME_CLIENT = DHCPServerGUI.getResourceString("TEXT_NAME_CLIENT");
    private static final String LEASE_TIME_DEFAULT = DHCPServerGUI.getResourceString("TEXT_LEASE_TIME_DEFAULT");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    private static final String TEXT_NAME_HERE = "";
    ConfigItem curElement = null;

    public OptionsForItemView(ConfigItem configItem, ViewUser viewUser) {
        super(configItem, viewUser, 3, String.valueOf(configItem.getName()) + " " + TEXT_OPTIONS_FOR_ITEM_VIEW_HEADING + "XXXXXXXXXXXXXXXXXXXXXXX", TEXT_OPTION_ROOT_NAME);
        int[] nArray = new int[]{160, 65, 130};
        Vector<String> vector = new Vector<String>();
        vector.addElement(TEXT_OPTION_COLUMN_NAME);
        vector.addElement(ListView.TEXT_COLUMN_WHERE_DEFINED);
        vector.addElement(TEXT_OPTION_COLUMN_VALUE);
        this.addLabels(vector, nArray);
    }

    public void setCurrentItem(ConfigItem configItem) {
        this.curElement = configItem;
        super.updateLabel(String.valueOf(configItem.getName()) + " " + TEXT_OPTIONS_FOR_ITEM_VIEW_HEADING);
    }

    protected void createFlatTree() {
        this.theRootNode.clear();
        Vector vector = new Vector();
        Enumeration enumeration = this.curElement.getInheritedOptions();
        while (enumeration.hasMoreElements()) {
            ConfigItem configItem = (ConfigItem)enumeration.nextElement();
            vector = this.getListData(configItem);
            FlatTreeNode flatTreeNode = new FlatTreeNode(vector, this.getSchemeName(configItem), configItem);
            flatTreeNode.setParent(this.theRootNode);
            this.theRootNode.addChild(flatTreeNode);
        }
        if (!Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            this.addDefaultLeaseTime();
        }
    }

    private void addDefaultLeaseTime() {
        Option option = this.curElement.getOption("51");
        if (option == null) {
            ServerParameters serverParameters = Configuration.currentConfiguration.getServerParameters();
            Lease lease = serverParameters.getLease();
            Vector<String> vector = new Vector<String>();
            vector.addElement(LEASE_TIME_DEFAULT);
            vector.addElement(serverParameters.getName());
            vector.addElement(String.valueOf(lease.getLeaseTimeDefault()) + " " + lease.getLeaseTimeDefaultUnits());
            FlatTreeNode flatTreeNode = new FlatTreeNode(vector, this.getSchemeName(serverParameters), serverParameters);
            flatTreeNode.setParent(this.theRootNode);
            this.theRootNode.addChild(flatTreeNode);
        }
    }

    protected Vector getListData(ConfigItem configItem) {
        String string = null;
        Vector<String> vector = new Vector<String>();
        ConfigItem configItem2 = configItem.getParent();
        string = configItem2 == this.curElement ? TEXT_NAME_HERE : configItem2.getItemType();
        Option option = (Option)configItem;
        vector.addElement(String.valueOf(option.getTag()) + " " + option.getBriefDescription());
        vector.addElement(string);
        String string2 = Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? PXEOptionSkeletonManager.getOptionSkeleton(option.getTag()).getDisplayableValue(option.getValue()) : OptionSkeletonManager.getOptionSkeleton(option.getTag()).getDisplayableValue(option.getValue());
        vector.addElement(string2);
        return vector;
    }

    public Object meetsCriteria(ConfigItem configItem) {
        if (configItem instanceof Option) {
            return configItem;
        }
        return null;
    }

    private String getSchemeName(ConfigItem configItem) {
        ConfigItem configItem2 = configItem.getParent();
        String string = configItem2 instanceof Global || configItem2 instanceof BINLGlobal ? "DHCP Global Options" : (configItem2 instanceof Subnetwork || configItem2 instanceof LSA2Group ? "DHCP Pool Options" : (configItem2 instanceof DHCPClass ? "DHCP Class Options" : (configItem2 instanceof Client ? "DHCP Client Options" : "DHCP No Icon")));
        return string;
    }

    protected Object meetsObserverCriteria(ConfigItem configItem) {
        return null;
    }

    public void refresh(boolean bl) {
        this.conditionsChanged = bl;
        this.refresh();
    }

    public void refresh(boolean bl, boolean bl2) {
        this.conditionsChanged = bl;
        this.refresh();
    }

    public void refresh() {
        ConfigItem configItem = this.userToBeNotified.getNodeSelected();
        if (configItem != this.currentItemSelected) {
            if (this.meetsCriteria(configItem) != null) {
                this.needsRepaint = true;
                this.currentItemSelected = configItem;
                if (!this.conditionsChanged) {
                    this.highlightItem(this.currentItemSelected);
                }
            } else {
                if (this.currentItemSelected != null) {
                    this.needsRepaint = true;
                    if (!this.conditionsChanged) {
                        this.tv.unSelectTreeViewNode();
                    }
                }
                this.currentItemSelected = null;
            }
        }
        if (this.conditionsChanged) {
            this.createFlatTree();
        }
        if (this.conditionsChanged || this.needsRepaint) {
            if (configItem instanceof Option) {
                this.highlightItem(configItem);
            } else {
                this.tv.unSelectTreeViewNode();
            }
            this.tv.committ(this.conditionsChanged);
        }
        this.conditionsChanged = false;
        this.needsRepaint = false;
    }
}

