/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.attribView;

import COM.ibm.eNetwork.jdi.gui.attribView.AttribViewNode;
import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.DrawableObject;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.ImagesForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.LeftAlignedNode;
import COM.ibm.eNetwork.jdi.gui.common.ViewCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class AttribViewCanvas
extends ViewCanvas {
    protected boolean bDragging = false;
    protected int iMaxHeight;
    protected int iXoffset;
    protected Vector vOffsets;
    protected boolean bUpdateVector = true;
    protected AttribViewNode avnEnd;
    protected int iLastX = -1;
    protected int iStartX = -1;
    protected int iEdgeIndex = -1;
    protected AttribViewNode avnOne;
    protected AttribViewNode avnTwo;
    protected static final int DELTA = 10;
    protected static final int MIN_NODE_SIZE = 5;

    public AttribViewCanvas(ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        this.copyAttribs(colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.setAttribs();
        this.vOffsets = new Vector();
        boolean bl = false;
        if (imagesForCanvas.getImage(2) == null) {
            bl = true;
        }
        this.avnEnd = new AttribViewNode("", colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.avnEnd.setSize(10, 10);
        this.avnEnd.setBackgroundPainting(bl);
        this.avnEnd.committ();
    }

    public void draw(Graphics graphics) {
        int n = 0;
        Rectangle rectangle = null;
        Dimension dimension = null;
        Dimension dimension2 = this.getSize();
        LeftAlignedNode leftAlignedNode = (LeftAlignedNode)this.lanCurrent;
        graphics.setColor(this.cfcColor.getColor(0));
        if (this.ifcImage.getImage(2) == null) {
            graphics.fillRect(0, 0, dimension2.width, dimension2.height);
        }
        while (leftAlignedNode != null && n < dimension2.width) {
            dimension = leftAlignedNode.getSize();
            rectangle = new Rectangle(n, 0, dimension.width, dimension.height);
            ((AttribViewNode)leftAlignedNode).draw(graphics, rectangle);
            n += dimension.width;
            this.lanCurrentEnd = leftAlignedNode;
            leftAlignedNode = (LeftAlignedNode)leftAlignedNode.getNext();
        }
        if (leftAlignedNode == null) {
            try {
                int n2 = dimension2.width - n;
                int n3 = dimension2.height;
                this.avnEnd.setSize(n2, n3);
                rectangle = new Rectangle(n, 0, n2 + 1, n3);
                this.avnEnd.draw(graphics, rectangle);
            }
            catch (Exception exception) {}
        }
        this.updateVector();
    }

    public boolean setDragging(boolean bl) {
        boolean bl2 = false;
        if (!bl && this.bDragging) {
            this.completeDragging();
            bl2 = true;
        }
        if (bl && !this.bDragging) {
            this.startDragging();
        }
        this.bDragging = bl;
        return bl2;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void completeDragging() {
        Cloneable cloneable;
        int n = this.iStartX - this.iLastX;
        try {
            cloneable = this.avnOne.getSize();
            this.avnOne.setSize(cloneable.width - n, cloneable.height);
            this.bUpdateVector = true;
            this.repaint();
        }
        catch (Exception exception) {}
        cloneable = new Point(-1, -1);
        this.drag((Point)cloneable);
        this.iStartX = -1;
    }

    protected void startDragging() {
        AttribViewNode attribViewNode = (AttribViewNode)this.lanCurrent;
        int n = 1;
        while (n < this.iEdgeIndex) {
            attribViewNode = (AttribViewNode)attribViewNode.getNext();
            ++n;
        }
        this.avnOne = attribViewNode;
        this.avnTwo = (AttribViewNode)attribViewNode.getNext();
        if (this.avnTwo == null && this.iEdgeIndex == this.vOffsets.size() - 2) {
            this.avnTwo = this.avnEnd;
        }
        if (this.avnOne == null || this.avnTwo == null) {
            this.avnOne = null;
            this.avnTwo = null;
        }
    }

    protected void XORLine(int n) {
        Dimension dimension = this.getSize();
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(Color.white);
        graphics.drawLine(n, 0, n, dimension.height - 1);
        graphics.drawLine(n + 1, 0, n + 1, dimension.height - 1);
        graphics.setPaintMode();
    }

    public void drag(Point point) {
        try {
            if (!this.bDragging) {
                return;
            }
            if (this.avnOne != null) {
                Dimension dimension = this.avnOne.getSize();
                if (point.x < this.iStartX - dimension.width + 5) {
                    return;
                }
            }
            if (this.iLastX > 0) {
                this.XORLine(this.iLastX);
            }
            if (point.x > 0) {
                this.XORLine(point.x);
            }
            this.iLastX = point.x;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String toString() {
        return "AttribView Canvas";
    }

    public Vector getFieldOffsets() {
        return this.vOffsets;
    }

    public void addNode(LeftAlignedNode leftAlignedNode, LeftAlignedNode leftAlignedNode2) {
        super.addNode(leftAlignedNode, leftAlignedNode2);
        if (leftAlignedNode != null && leftAlignedNode.getHeight() > this.iMaxHeight) {
            this.iMaxHeight = leftAlignedNode.getHeight();
        }
    }

    public void addNode(LeftAlignedNode leftAlignedNode) {
        super.addNode(leftAlignedNode);
        if (leftAlignedNode != null && leftAlignedNode.getHeight() > this.iMaxHeight) {
            this.iMaxHeight = leftAlignedNode.getHeight();
        }
        if (this.lanCurrent == null) {
            this.lanCurrent = this.lanTop;
        }
    }

    public int getMaxHeight() {
        return this.iMaxHeight;
    }

    public void committ() {
        AttribViewNode attribViewNode = (AttribViewNode)this.lanTop;
        attribViewNode = (AttribViewNode)this.lanTop;
        while (attribViewNode != null) {
            attribViewNode.setSize(attribViewNode.getWidth(), this.iMaxHeight);
            attribViewNode = (AttribViewNode)attribViewNode.getNext();
        }
        this.bUpdateVector = true;
        this.updateVector();
    }

    private void updateVector() {
        if (!this.bUpdateVector) {
            return;
        }
        LeftAlignedNode leftAlignedNode = (LeftAlignedNode)this.lanCurrent;
        Dimension dimension = null;
        Integer n = null;
        int n2 = 0;
        this.vOffsets.removeAllElements();
        while (leftAlignedNode != null) {
            dimension = leftAlignedNode.getSize();
            n = new Integer(n2);
            this.vOffsets.addElement(n);
            n2 += dimension.width;
            leftAlignedNode = (LeftAlignedNode)leftAlignedNode.getNext();
        }
        this.avnEnd.setSize(350, 1);
        this.vOffsets.addElement(new Integer(n2));
        this.vOffsets.addElement(new Integer(n2 + 350));
        this.bUpdateVector = false;
    }

    public DrawableObject findOnMouseMove(int n, int n2) {
        return null;
    }

    public DrawableObject findOnKeyUp(int n) {
        return null;
    }

    public DrawableObject findOnKeyDown(int n) {
        return null;
    }

    public DrawableObject findOnMouseUp(int n, int n2) {
        return null;
    }

    public DrawableObject findOnMouseDown(int n, int n2) {
        return null;
    }

    public DrawableObject findOnGotFocus() {
        return null;
    }

    public DrawableObject findCurrent() {
        return null;
    }

    public boolean isDraggablepoint(Point point) {
        try {
            int n = 0;
            int n2 = 1;
            while (n2 < this.vOffsets.size()) {
                n = (Integer)this.vOffsets.elementAt(n2);
                if (point.x < n + 10 && point.x > n - 10) {
                    this.iEdgeIndex = n2;
                    this.iStartX = point.x;
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void repaint() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            super.repaint();
            return;
        }
        this.update(graphics);
    }
}

