/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.colorSelector;

import COM.ibm.eNetwork.jdi.gui.common.ExtendedCanvas;
import COM.ibm.eNetwork.jdi.gui.common.ImagesForCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;

public class SpectrumCanvas
extends ExtendedCanvas {
    protected static int[] iPixels = null;
    protected static Image colorMap = null;
    protected static int iUpWidth = 7;
    protected static int iUpHeight = 4;
    protected static int[] pixUp = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
    protected Image imagePointer = ImagesForCanvas.createImage(this, iUpWidth, iUpHeight, pixUp);
    protected int iPointerX;
    protected int iPointerY;

    public Color findColor(int n, int n2) {
        try {
            int[] nArray = new int[3];
            int n3 = this.getSize().width;
            int n4 = iPixels[n + n2 * n3];
            nArray[0] = n4 % 65536 / 256;
            nArray[1] = n4 / 65536;
            nArray[2] = n4 % 256;
            return new Color(nArray[0], nArray[1], nArray[2]);
        }
        catch (Exception exception) {
            return Color.black;
        }
    }

    public void setPointer(int n, int n2) {
        this.iPointerX = n;
        this.iPointerY = n2;
        this.repaint();
    }

    public void setPointer(Color color) {
        int n = color.getRed();
        int n2 = color.getBlue();
        int n3 = color.getGreen();
        if (n3 == 0 && n < 255) {
            this.iPointerX = n / 2;
        } else if (n3 < 255 && n == 255) {
            this.iPointerX = 127 + n3 / 2;
        } else if (n3 == 255 && n < 255) {
            this.iPointerX = 387 - n / 2;
        } else if (n3 < 255 && n == 0) {
            this.iPointerX = 508 - n3 / 2;
        }
        this.iPointerY = n2;
        this.repaint();
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.createColorMap(n, n2);
        super.setSize(n, n2);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.createColorMap(n3, n4);
        super.setBounds(n, n2, n3, n4);
    }

    protected void createColorMap(int n, int n2) {
        try {
            this.getSize();
            iPixels = new int[n * n2];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 2;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n) {
                int n10 = n4 << 8 | n5 << 16;
                n3 = n9;
                n6 = 0;
                while (n6 < n2) {
                    SpectrumCanvas.iPixels[n3] = n10 | n6;
                    n3 += n;
                    ++n6;
                }
                n5 += n8;
                if ((n4 += n7) > 255) {
                    n4 = 255;
                    n7 = 0;
                    n8 = 2;
                } else if (n4 < 0) {
                    n4 = 0;
                    n7 = 0;
                    n8 = -2;
                }
                if (n5 > 255) {
                    n5 = 255;
                    n8 = 0;
                    n7 = -2;
                } else if (n5 < 0) {
                    n5 = 0;
                    n8 = 0;
                }
                ++n9;
            }
            if (colorMap != null) {
                colorMap.flush();
                System.gc();
            }
            colorMap = this.createImage(new MemoryImageSource(n, n2, (ColorModel)new DirectColorModel(24, 65280, 0xFF0000, 255), iPixels, 0, n));
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void draw(Graphics graphics) {
        graphics.drawImage(colorMap, 0, 0, null);
        graphics.setXORMode(Color.white);
        graphics.drawImage(this.imagePointer, this.iPointerX, this.iPointerY, this);
        graphics.setPaintMode();
        this.drawOutline(graphics, this.getSize());
    }

    public void drawOutline(Graphics graphics, Dimension dimension) {
        SystemColor systemColor = SystemColor.control;
        Color color = systemColor.brighter();
        Color color2 = systemColor.darker();
        Color color3 = color2.darker();
        graphics.setColor(color);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.setColor(color2);
        graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, dimension.height - 1, dimension.width - 1, 1);
        graphics.setColor(color3);
        graphics.drawLine(0, dimension.height, dimension.width, dimension.height);
        graphics.drawLine(dimension.width, dimension.height, dimension.width, 1);
    }
}

