/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.common;

import COM.ibm.eNetwork.jdi.gui.common.StorageObject;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public class FontsForCanvas
extends StorageObject {
    protected static Font fontNormal = new Font("Helvetica", 0, 13);
    protected static Font fontSelected = new Font("Helvetica", 1, 13);
    protected static Toolkit t = Toolkit.getDefaultToolkit();
    protected FontMetrics fm;
    protected Font font;
    protected static final int NO_FONT = -1;
    protected static final int FONTSFORCANVAS_FIRST = 0;
    protected static final int FONTSFORCANVAS_LAST = 1;
    public static final int SELECTED = 0;
    public static final int NORMAL = 0;

    public FontsForCanvas() {
    }

    public boolean isValidRange(int n) {
        return n >= 0 && n <= 1;
    }

    public FontsForCanvas(Font font, Font font2) {
        this.addFont(font, 0);
        this.addFont(font2, 0);
    }

    public void setDefaults() {
        this.addFont(fontNormal, 0);
        this.addFont(fontSelected, 0);
    }

    public void addFont(Font font, int n) {
        this.add(font, n);
    }

    public Font getFont(int n) {
        return (Font)this.get(n);
    }

    public void removeFont(int n) {
        this.remove(n);
    }

    public static int getFontDescent(Font font) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            FontMetrics fontMetrics = toolkit.getFontMetrics(font);
            return fontMetrics.getDescent();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getFontDescent(int n) {
        try {
            this.font = this.getFont(n);
            this.fm = t.getFontMetrics(this.font);
            return this.fm.getDescent();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getFontHeight(int n) {
        try {
            this.font = this.getFont(n);
            this.fm = t.getFontMetrics(this.font);
            return this.fm.getHeight() + this.fm.getDescent();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int getFontHeight(Font font) {
        try {
            FontMetrics fontMetrics = null;
            fontMetrics = t.getFontMetrics(font);
            return fontMetrics.getHeight() + fontMetrics.getDescent();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getFontMaxWidth(int n) {
        try {
            this.font = this.getFont(n);
            this.fm = t.getFontMetrics(this.font);
            return this.fm.charWidth('W');
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getFontAverageWidth(int n) {
        try {
            this.font = this.getFont(n);
            this.fm = t.getFontMetrics(this.font);
            return this.fm.charWidth('V');
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getStringWidth(String string, int n) {
        try {
            this.font = this.getFont(n);
            this.fm = t.getFontMetrics(this.font);
            return this.fm.stringWidth(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

