/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.common;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.DrawableNode;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.ImagesForCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class LeftAlignedNode
extends DrawableNode {
    protected int iVertSpace;
    protected int iHorzSpace;

    public LeftAlignedNode(String string, DrawableNode drawableNode, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        super(string, drawableNode, colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.calcSpaces();
    }

    public LeftAlignedNode(String string, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        super(string, colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.calcSpaces();
    }

    protected void calcSpaces() {
        this.iHorzSpace = this.ffcFont.getFontMaxWidth(0);
        this.iVertSpace = this.ffcFont.getFontDescent(0) / 2;
    }

    public void draw(Graphics graphics, Rectangle rectangle) {
        Point point = new Point(rectangle.x, rectangle.y);
        this.setLocation(point);
        this.paintBackground(graphics, rectangle);
        this.drawGraphic(graphics, rectangle);
        this.drawCaption(this.cfcColor.getColor(1), graphics, rectangle);
    }

    protected void drawGraphic(Graphics graphics, Rectangle rectangle) {
        int n = this.getOffsetForCenter(2);
        Rectangle rectangle2 = null;
        int n2 = 0;
        rectangle2 = new Rectangle(this.getGraphicX(rectangle), this.getGraphicY(rectangle, n), 0, 0);
        if (this.getSelected()) {
            n2 = 1;
        }
        this.ifcImage.drawImage(n2, graphics, rectangle2);
    }

    protected int getGraphicX(Rectangle rectangle) {
        return rectangle.x + this.iHorzSpace;
    }

    protected int getGraphicY(Rectangle rectangle, int n) {
        return n + rectangle.y;
    }

    protected void drawCaption(Color color, Graphics graphics, Rectangle rectangle) {
        int n = this.getOffsetForCenter(1);
        int n2 = 0;
        if (this.getSelected()) {
            n2 = 0;
        }
        graphics.setFont(this.ffcFont.getFont(n2));
        graphics.setColor(color);
        String string = this.computeText(n2);
        graphics.drawString(string, this.getCaptionX(rectangle), this.getCaptionY(rectangle, n));
    }

    protected String computeText(int n) {
        try {
            int n2 = this.getWidth() - this.ifcImage.getImageHeight(n) - 2 * this.iHorzSpace;
            String string = this.getText();
            int n3 = this.ffcFont.getStringWidth(string, n);
            if (n3 < n2) {
                return string;
            }
            int n4 = n3 - n2;
            int n5 = this.ffcFont.getFontAverageWidth(n);
            int n6 = (int)((float)n4 / (float)n5 + 3.0f);
            int n7 = string.length() - n6 - 1;
            if (n7 < 1) {
                return "";
            }
            return String.valueOf(string.substring(0, n7)) + "...";
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected int getCaptionX(Rectangle rectangle) {
        return this.iHorzSpace * 4 / 3 + rectangle.x + this.ifcImage.getImageWidth(0);
    }

    protected int getCaptionY(Rectangle rectangle, int n) {
        return rectangle.y + this.getHeight() - this.iVertSpace - n - this.ffcFont.getFontDescent(0);
    }

    protected int getOffsetForCenter(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.getSelected()) {
            n8 = 0;
            n9 = 1;
        }
        n6 = this.ifcImage.getImageHeight(n9);
        n5 = this.ffcFont.getFontHeight(n8);
        n2 = n5 - n6;
        n3 = this.getHeight() - n5;
        n4 = this.getHeight() - n6;
        if (n == 1) {
            if (n2 < 0) {
                n7 = (n2 *= -1) / 2;
                return n7 += n4 / 2;
            }
            return n7 += n3 / 2;
        }
        if (n == 2) {
            if (n2 > 0) {
                n7 = n2 / 2;
                return n7 += n3 / 4 * 3;
            }
            return n7 += n4 / 2;
        }
        System.out.println("Error: unknow offset type");
        return 0;
    }

    public void committ() {
        this.calcSpaces();
        int n = 0;
        int n2 = 0;
        int n3 = this.ifcImage.getImageHeight(0);
        int n4 = this.ffcFont.getFontHeight(0);
        n += this.iHorzSpace * 5 / 2;
        n += this.ifcImage.getImageWidth(0);
        n2 = n3 > n4 ? (n2 += n3) : (n2 += n4);
        this.setSize(n += this.ffcFont.getStringWidth(this.getText(), 0), n2 += 2 * this.iVertSpace);
    }
}

