/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.imageButton;

import COM.ibm.eNetwork.jdi.common.misc.Timer;
import COM.ibm.eNetwork.jdi.gui.imageButton.ImageButtonPainter;
import COM.ibm.eNetwork.jdi.gui.tooltip.Tooltip;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ImageButton
extends Canvas
implements MouseListener,
FocusListener,
KeyListener,
ComponentListener {
    public static final int IMAGE_AND_TEXT = 1;
    public static final int IMAGE_ONLY = 2;
    public static final int TEXT_ONLY = 3;
    public static final boolean FLAT_BUTTON = true;
    public static final boolean REGULAR_BUTTON = false;
    public static final boolean TRANSPARENT = true;
    public static final boolean OPAQUE = false;
    public static final int TEXT_SOUTH = 10;
    public static final int TEXT_NORTH = 11;
    public static final int TEXT_WEST = 12;
    public static final int TEXT_EAST = 13;
    protected static Timer timer = null;
    protected ImageButtonPainter ibpPainter;
    protected Tooltip tooltip;
    private Image imageBaseOffscreen;
    private Image imageHighlightedOffscreen;
    private Image imageSelectedOffscreen;
    private Graphics gBaseOffscreen;
    private Graphics gHighlightedOffscreen;
    private Graphics gSelectedOffscreen;
    protected int iViewMode;
    protected boolean boolFlatButton = true;
    protected boolean boolTransparent = false;
    protected String sLabel;
    protected String sTipString;
    protected String sActionCommand;
    protected boolean boolHighlighted = false;
    protected boolean boolSelected = false;
    protected boolean boolInitialized = false;
    protected boolean boolFocused = false;
    protected boolean boolEnabled = true;
    protected boolean boolMousePressed = false;
    protected boolean boolFocusTraversable = false;
    protected Dimension dMinSize;
    protected ActionListener actionListener;

    public ImageButton() {
        this(null, null, null, "", true, 3, 10, false, true);
    }

    public ImageButton(Image image, Image image2, Image image3, String string, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        this.setBackground(SystemColor.control);
        this.ibpPainter = new ImageButtonPainter(this, image, image2, image3, string, bl, n, n2, bl2);
        this.sLabel = string;
        this.sActionCommand = string;
        this.sTipString = string;
        this.iViewMode = n;
        this.boolFocusTraversable = bl3;
        if (timer == null) {
            timer = new Timer(500);
        }
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addComponentListener(this);
    }

    public ImageButton(Image image, String string) {
        this(image, null, null, string, true, 1, 10, false, true);
    }

    public ImageButton(String string) {
        this(null, null, null, string, true, 3, 10, false, true);
    }

    public ImageButton(Image image) {
        this(image, null, null, "", true, 2, 10, false, true);
    }

    public void setSettings(Image image, Image image2, Image image3, String string, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        this.ibpPainter.setSettings(this, image, image2, image3, string, bl, n, n2, bl2);
        this.sLabel = string;
        this.sActionCommand = string;
        this.sTipString = string;
        this.iViewMode = n;
        this.boolFocusTraversable = bl3;
    }

    public void setImages(Image image, Image image2, Image image3) {
        this.ibpPainter.setImages(image, image2, image3);
        this.boolInitialized = false;
        this.invalidate();
    }

    public Dimension commit() {
        if (this.dMinSize == null) {
            this.dMinSize = this.ibpPainter.computeMinimumSize();
        }
        this.setSize(this.dMinSize);
        return this.dMinSize;
    }

    public void setTextOrientation(int n) {
        this.ibpPainter.setTextOrientation(n);
        this.boolInitialized = false;
        this.invalidate();
    }

    public int getTextOrientation() {
        return this.ibpPainter.getTextOrientation();
    }

    protected void init() {
        Dimension dimension = this.getSize();
        if (this.tooltip == null) {
            this.tooltip = new Tooltip(this.getTopLevelParent(this), this.sTipString);
            timer.addTimerListener(this.tooltip);
        }
        if (this.imageBaseOffscreen != null) {
            this.imageBaseOffscreen.flush();
        }
        this.imageBaseOffscreen = this.createImage(dimension.width, dimension.height);
        if (this.imageBaseOffscreen != null) {
            if (this.gBaseOffscreen != null) {
                this.gBaseOffscreen.dispose();
            }
            this.gBaseOffscreen = this.imageBaseOffscreen.getGraphics();
            if (this.isEnabled()) {
                this.ibpPainter.drawNormalButton(this.gBaseOffscreen, dimension);
            } else {
                this.ibpPainter.drawDisabledButton(this.gBaseOffscreen, dimension);
            }
        } else {
            System.err.println("Couldn't make base offscreen image");
        }
        if (this.imageHighlightedOffscreen != null) {
            this.imageHighlightedOffscreen.flush();
        }
        this.imageHighlightedOffscreen = this.createImage(dimension.width, dimension.height);
        if (this.imageHighlightedOffscreen != null) {
            if (this.gHighlightedOffscreen != null) {
                this.gHighlightedOffscreen.dispose();
            }
            this.gHighlightedOffscreen = this.imageHighlightedOffscreen.getGraphics();
            this.ibpPainter.drawHighlightedButton(this.gHighlightedOffscreen, dimension);
        } else {
            System.err.println("Couldn't make highlighted offscreen image");
        }
        if (this.imageSelectedOffscreen != null) {
            this.imageSelectedOffscreen.flush();
        }
        this.imageSelectedOffscreen = this.createImage(dimension.width, dimension.height);
        if (this.imageBaseOffscreen != null) {
            if (this.gSelectedOffscreen != null) {
                this.gSelectedOffscreen.dispose();
            }
            this.gSelectedOffscreen = this.imageSelectedOffscreen.getGraphics();
            this.ibpPainter.drawSelectedButton(this.gSelectedOffscreen, dimension);
        } else {
            System.err.println("Couldn't make selected offscreen image");
        }
        this.boolInitialized = true;
    }

    public void setViewMode(int n) {
        this.iViewMode = n;
        this.ibpPainter.setViewMode(n);
        this.boolInitialized = false;
        this.invalidate();
    }

    public int getViewMode() {
        return this.ibpPainter.getViewMode();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (!this.boolInitialized) {
            this.init();
        }
        if (!this.isEnabled()) {
            graphics.drawImage(this.imageBaseOffscreen, 0, 0, this);
            return;
        }
        if (this.boolSelected) {
            graphics.drawImage(this.imageSelectedOffscreen, 0, 0, this);
            return;
        }
        if (this.boolHighlighted) {
            graphics.drawImage(this.imageHighlightedOffscreen, 0, 0, this);
            if (this.boolFocused) {
                Dimension dimension = this.getSize();
                graphics.drawRect(3, 3, dimension.width - 7, dimension.height - 7);
                return;
            }
        } else {
            graphics.drawImage(this.imageBaseOffscreen, 0, 0, this);
            if (this.boolFocused) {
                Dimension dimension = this.getSize();
                graphics.drawRect(3, 3, dimension.width - 7, dimension.height - 7);
            }
        }
    }

    public String getTipString() {
        return this.sTipString;
    }

    public void setTipString(String string) {
        this.sTipString = string;
        if (this.tooltip != null) {
            this.tooltip.setLabel(string);
        }
    }

    public void setEnabled(boolean bl) {
        this.boolEnabled = bl;
        if (this.boolInitialized) {
            this.init();
            this.repaint();
        }
    }

    public boolean isEnabled() {
        return this.boolEnabled;
    }

    public Dimension getMinimumSize() {
        if (this.dMinSize == null) {
            this.dMinSize = this.ibpPainter.computeMinimumSize();
        }
        return this.dMinSize;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setLabel(String string) {
        this.sLabel = string;
        this.ibpPainter.setLabel(string);
        if (this.boolInitialized) {
            this.init();
            this.repaint();
        }
    }

    public String getLabel() {
        return this.ibpPainter.getLabel();
    }

    public void setActionCommand(String string) {
        this.sActionCommand = string;
    }

    public String getActionCommand() {
        return this.sActionCommand;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.boolMousePressed = true;
            this.requestFocus();
            this.boolSelected = true;
            this.tooltip.setFastDisplay(false);
            this.tooltip.hideTooltip();
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.boolSelected = false;
            if (this.contains(mouseEvent.getX(), mouseEvent.getY()) && this.boolMousePressed && this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.sActionCommand));
            }
            this.repaint();
        }
        this.boolMousePressed = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.sTipString.equals("")) {
            Point point = this.getLocationOnScreen();
            int n = point.x + this.getSize().width / 2;
            int n2 = point.y + this.getSize().height + 2;
            this.tooltip.showAfterDelay(n, n2);
        }
        if (this.isEnabled()) {
            if (this.boolMousePressed) {
                this.boolSelected = true;
            } else {
                this.boolHighlighted = true;
            }
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.tooltip.hideTooltip();
        if (this.isEnabled()) {
            this.boolHighlighted = false;
            this.boolSelected = false;
            this.repaint();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.boolInitialized) {
            this.init();
            this.repaint();
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isEnabled() && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32)) {
            this.requestFocus();
            this.boolSelected = true;
            this.tooltip.hideTooltip();
            this.tooltip.setFastDisplay(false);
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.sActionCommand));
            }
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.isEnabled() && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32)) {
            this.boolSelected = false;
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.boolFocused = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.tooltip != null) {
            this.tooltip.hideTooltip();
        }
        this.boolFocused = false;
        this.boolHighlighted = false;
        this.boolSelected = false;
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return this.boolFocusTraversable;
    }

    private Frame getTopLevelParent(Component component) {
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        if (component2 instanceof Frame) {
            return (Frame)component2;
        }
        return null;
    }

    public Insets getInsets() {
        return this.ibpPainter.getInsets();
    }
}

