/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.jvcScrollbar;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.ExtendedCanvas;
import COM.ibm.eNetwork.jdi.gui.common.ImagesForCanvas;
import COM.ibm.eNetwork.jdi.gui.jvcScrollbar.JVCScrollbarSlider;
import COM.ibm.eNetwork.jdi.gui.jvcScrollbar.orientations;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class JVCScrollbarCanvas
extends ExtendedCanvas
implements orientations {
    protected int iMax = 10;
    protected int iMin = 1;
    protected int iOrientation = 1;
    protected int iVisible = 1;
    protected int iUnitInc = 1;
    protected int iBlockInc = 1;
    protected int iValue = 1;
    public static final int UNIT_INCREMENT = -1;
    public static final int UNIT_DECREMENT = -2;
    public static final int BLOCK_INCREMENT = -3;
    public static final int BLOCK_DECREMENT = -4;
    public static final int BELOW_SLIDER = 1;
    public static final int ABOVE_SLIDER = 2;
    public static final int ON_SLIDER = 3;
    public static final int NO_POS = 4;
    protected Point pSlider;
    protected Dimension dSlider;
    protected JVCScrollbarSlider slider;
    protected boolean bDragging = false;

    public JVCScrollbarCanvas() {
        this.cfcColor.addColor(new Color(214, 214, 214), 0);
        this.pSlider = new Point(1, 1);
        this.dSlider = new Dimension(10, 10);
        this.slider = new JVCScrollbarSlider(this.cfcColor, this.ffcFont, this.ifcImage);
    }

    public JVCScrollbarCanvas(ColorsForCanvas colorsForCanvas, ImagesForCanvas imagesForCanvas) {
        this.copyAttribs(colorsForCanvas, this.ffcFont, imagesForCanvas);
        this.setAttribs();
        this.pSlider = new Point(1, 1);
        this.dSlider = new Dimension(10, 10);
        this.slider = new JVCScrollbarSlider(colorsForCanvas, this.ffcFont, imagesForCanvas);
    }

    public void committ() {
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.calcSliderSize();
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.calcSliderSize();
    }

    protected void calcSliderSize() {
        try {
            Dimension dimension = this.getSize();
            if (this.iOrientation == 1) {
                dimension.height /= this.iMax;
                if (dimension.height < 5) {
                    dimension.height = 5;
                }
            } else {
                dimension.width /= this.iMax;
                if (dimension.width < 5) {
                    dimension.width = 5;
                }
            }
            this.dSlider = dimension;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void draw(Graphics graphics) {
        try {
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            graphics.setColor(SystemColor.control.brighter());
            if (this.iOrientation == 1) {
                graphics.drawRect(rectangle.x, rectangle.y - 1, rectangle.width - 1, rectangle.height + 1);
                this.slider.draw(graphics, new Rectangle(this.pSlider.x, this.pSlider.y, this.dSlider.width - 3, this.dSlider.height));
                return;
            }
            graphics.drawRect(rectangle.x - 1, rectangle.y, rectangle.width + 1, rectangle.height - 1);
            this.slider.draw(graphics, new Rectangle(this.pSlider.x, this.pSlider.y, this.dSlider.width, this.dSlider.height - 3));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setMaximum(int n) {
        if (n < 1) {
            n = 1;
        }
        this.iMax = n;
        this.calcSliderSize();
        this.setValue(this.iValue);
    }

    public int getMaximum() {
        return this.iMax;
    }

    public int getValue() {
        return this.iValue;
    }

    public void setValue(int n) {
        if (n == -1) {
            this.setValue(this.iValue + this.iUnitInc);
            return;
        }
        if (n == -2) {
            this.setValue(this.iValue - this.iUnitInc);
            return;
        }
        if (n == -4) {
            this.setValue(this.iValue - this.iBlockInc);
            return;
        }
        if (n == -3) {
            this.setValue(this.iValue + this.iBlockInc);
            return;
        }
        if (n < this.iMin) {
            n = this.iMin;
        }
        if (n > this.iMax) {
            n = this.iMax;
        }
        this.iValue = n;
        this.calcSliderPos();
        this.repaint();
    }

    protected void calcSliderPos() {
        try {
            float f = (float)(this.iValue - this.iMin) / (float)(this.iMax - this.iMin);
            Dimension dimension = this.getSize();
            if (this.iOrientation == 1) {
                dimension.height -= this.dSlider.height;
                this.pSlider.y = (int)((float)dimension.height * f);
                return;
            }
            dimension.width -= this.dSlider.width;
            this.pSlider.x = (int)((float)dimension.width * f);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setMinimum(int n) {
        if (n < 0) {
            return;
        }
        this.iMin = n;
    }

    public int getMinimum() {
        return this.iMin;
    }

    public void setVisibleAmount(int n) {
        this.iVisible = n;
    }

    public int getVisibleAmount() {
        return this.iVisible;
    }

    public void setOrientation(int n) {
        this.iOrientation = n;
    }

    public int getOrientation() {
        return this.iOrientation;
    }

    public void setBlockIncrement(int n) {
        if (n > this.iMax / 2) {
            n = this.iMax / 2;
        }
        this.iBlockInc = n;
    }

    public int getBlockIncrement() {
        return this.iBlockInc;
    }

    public void setUnitIncrement(int n) {
        this.iUnitInc = n;
    }

    public int getUnitIncrement() {
        return this.iUnitInc;
    }

    public void setDragging(boolean bl) {
        this.bDragging = bl;
    }

    public int getMouseToSliderPos(Point point) {
        if (this.iOrientation == 1) {
            if (point.y < this.pSlider.y) {
                return 2;
            }
            if (point.y > this.pSlider.y + this.dSlider.height) {
                return 1;
            }
            return 3;
        }
        if (this.iOrientation == 0) {
            if (point.x < this.pSlider.x) {
                return 2;
            }
            if (point.x > this.pSlider.x + this.dSlider.width) {
                return 1;
            }
            return 3;
        }
        return 4;
    }

    public boolean dragSlider(Point point) {
        if (!this.bDragging) {
            return false;
        }
        int n = 0;
        float f = 0.0f;
        Dimension dimension = this.getSize();
        if (this.iOrientation == 1) {
            f = (float)point.y / (float)dimension.height;
            n = (int)(f * (float)(this.iMax - this.iMin)) + this.iMin;
        } else {
            f = (float)point.x / (float)dimension.width;
            n = (int)(f * (float)(this.iMax - this.iMin)) + this.iMin;
        }
        this.setValue(n);
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public String toString() {
        if (this.iOrientation == 1) {
            return "Vertical JVCScrollbar Canvas";
        }
        return "Horizontal JVCScrollbar Canvas";
    }
}

