/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.tabView;

import COM.ibm.eNetwork.jdi.gui.tabView.CardView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabsView;
import COM.ibm.eNetwork.jdi.gui.tabView.tabOrientation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class TabViewLayout
implements LayoutManager,
tabOrientation {
    protected TabsView tv;
    protected CardView cv;
    protected Hashtable hash = new Hashtable();
    protected static final int XOFFSET = 10;
    protected static final int YOFFSET = 10;
    public static final String TABS_VIEW = "tv";
    public static final String CARD_VIEW = "cv";

    public void addLayoutComponent(String string, Component component) {
        this.hash.put(string, component);
    }

    public void removeLayoutComponent(Component component) {
        this.hash.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        return container.getSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        if (container instanceof TabView) {
            return ((TabView)container).getMinSize();
        }
        return new Dimension(50, 50);
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        TabView tabView = (TabView)container;
        this.tv = (TabsView)this.hash.get(TABS_VIEW);
        this.cv = (CardView)this.hash.get(CARD_VIEW);
        switch (tabView.getOrientation()) {
            case 1: {
                this.resizeForTop(dimension.width, dimension.height);
                return;
            }
            case 8: {
                this.resizeForRight(dimension.width, dimension.height);
                return;
            }
            case 4: {
                this.resizeForLeft(dimension.width, dimension.height);
                return;
            }
        }
        this.resizeForBottom(dimension.width, dimension.height);
    }

    protected void resizeForBottom(int n, int n2) {
        int n3 = this.tv.getMaxHeight();
        Dimension dimension = new Dimension(n, n2 - n3 + 2);
        this.cv.setSize(dimension);
        this.tv.setSize(n - 20, n3);
        this.tv.setLocation(10, dimension.height - 2);
    }

    protected void resizeForTop(int n, int n2) {
        int n3 = this.tv.getMaxHeight();
        Dimension dimension = new Dimension(n, n2 - n3 + 2);
        this.cv.setSize(dimension);
        this.cv.setLocation(0, n3 - 2);
        this.tv.setSize(n - 20, n3);
        this.tv.setLocation(10, 0);
    }

    protected void resizeForRight(int n, int n2) {
        int n3 = this.tv.getMaxWidth();
        Dimension dimension = new Dimension(n - n3 + 2, n2);
        this.cv.setSize(dimension);
        this.cv.setLocation(0, 0);
        this.tv.setSize(n3, n2 - 20);
        this.tv.setLocation(n - n3, 10);
    }

    protected void resizeForLeft(int n, int n2) {
        int n3 = this.tv.getMaxWidth();
        Dimension dimension = new Dimension(n - n3, n2);
        this.cv.setSize(dimension);
        this.cv.setLocation(n3, 0);
        this.tv.setSize(n3, n2 - 20);
        this.tv.setLocation(0, 10);
    }

    public String toString() {
        return "TabViewLayout";
    }
}

