/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.tabView;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.Controler;
import COM.ibm.eNetwork.jdi.gui.common.ExtendedPanel;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.ImagesForCanvas;
import COM.ibm.eNetwork.jdi.gui.jvcScrollbar.JVCScrollbar;
import COM.ibm.eNetwork.jdi.gui.tabView.BottomTab;
import COM.ibm.eNetwork.jdi.gui.tabView.LeftTab;
import COM.ibm.eNetwork.jdi.gui.tabView.LtoRTabCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.RightTab;
import COM.ibm.eNetwork.jdi.gui.tabView.Tab;
import COM.ibm.eNetwork.jdi.gui.tabView.TabCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEventListener;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.eNetwork.jdi.gui.tabView.TabsViewControler;
import COM.ibm.eNetwork.jdi.gui.tabView.TopTab;
import COM.ibm.eNetwork.jdi.gui.tabView.TtoBTabCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.ableToUseTabsView;
import COM.ibm.eNetwork.jdi.gui.tabView.tabOrientation;
import java.awt.Dimension;
import java.awt.SystemColor;

public class TabsView
extends ExtendedPanel
implements tabOrientation {
    protected int iOrientation = 2;
    protected ableToUseTabsView atutvParent;
    protected JVCScrollbar sb;
    protected Dimension dimtc;
    protected TabCanvas tc;
    protected TabsViewControler tvc;
    protected boolean bPaintTabBackground = true;

    public TabsView(ableToUseTabsView ableToUseTabsView2, Dimension dimension, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas, int n) {
        this.copyAttribs(colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.setAttribs();
        this.iOrientation = n;
        this.atutvParent = ableToUseTabsView2;
        this.setLayout(null);
        this.sb = this.createScrollBar();
        this.add(this.sb);
        this.tc = this.createTabCanvas();
        this.add(this.tc);
        this.setSize(dimension);
        if (imagesForCanvas.getImage(2) != null) {
            this.bPaintTabBackground = false;
        }
        this.setBackground(SystemColor.control);
    }

    protected JVCScrollbar createScrollBar() {
        int n = 0;
        if (this.iOrientation == 1 || this.iOrientation == 2) {
            n = 0;
        } else if (this.iOrientation == 8 || this.iOrientation == 4) {
            n = 1;
        }
        return new JVCScrollbar(n, 1, 1, 1, 2);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setAutoFocus(boolean bl) {
        this.tvc.setAutoFocus(bl);
    }

    public void selectTab(TabViewNode tabViewNode) {
        Tab tab = this.tc.findTab(tabViewNode);
        System.err.println("Select tab:" + tab);
        this.tvc.selectTab(tab);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.positionScrollbar();
        this.positionTabCanvas();
        this.tc.repaint();
    }

    private void positionScrollbar() {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        switch (this.iOrientation) {
            case 1: {
                this.sb.setBounds(n - 30, n2 - 15, 30, 15);
                this.dimtc = new Dimension(n - 30, n2);
                break;
            }
            case 4: {
                this.sb.setBounds(n - 15, n2 - 30, 15, 30);
                this.dimtc = new Dimension(n, n2 - 30);
                break;
            }
            case 8: {
                this.sb.setBounds(0, n2 - 30, 15, 30);
                this.dimtc = new Dimension(n, n2 - 30);
                break;
            }
            default: {
                this.sb.setBounds(n - 30, 0, 30, 15);
                this.dimtc = new Dimension(n - 30, this.getSize().height);
            }
        }
        this.sb.setVisible(true);
    }

    protected TabCanvas createTabCanvas() {
        if (this.iOrientation == 1 || this.iOrientation == 2) {
            LtoRTabCanvas ltoRTabCanvas = new LtoRTabCanvas(this.cfcColor, this.ffcFont, this.ifcImage);
            this.tvc = new TabsViewControler((TabView)this.atutvParent);
            ltoRTabCanvas.setControler(this.tvc);
            this.tvc.registerScrollbar(this.sb);
            return ltoRTabCanvas;
        }
        if (this.iOrientation == 8 || this.iOrientation == 4) {
            TtoBTabCanvas ttoBTabCanvas = new TtoBTabCanvas(this.cfcColor, this.ffcFont, this.ifcImage);
            this.tvc = new TabsViewControler((TabView)this.atutvParent);
            ttoBTabCanvas.setControler(this.tvc);
            this.tvc.registerScrollbar(this.sb);
            return ttoBTabCanvas;
        }
        return null;
    }

    public void setControler(Controler controler) {
        this.tc.setControler(controler);
    }

    protected void positionTabCanvas() {
        if (this.iOrientation == 1 || this.iOrientation == 2) {
            this.tc.setBounds(0, 0, this.dimtc.width, this.dimtc.height);
            return;
        }
        if (this.iOrientation == 8 || this.iOrientation == 4) {
            this.tc.setBounds(0, 0, this.dimtc.width, this.dimtc.height);
        }
    }

    public int getMaxWidth() {
        if (this.iOrientation == 4 || this.iOrientation == 8) {
            return ((TtoBTabCanvas)this.tc).getMaxWidth();
        }
        return 0;
    }

    public int getMaxHeight() {
        if (this.iOrientation == 2 || this.iOrientation == 1) {
            return ((LtoRTabCanvas)this.tc).getMaxHeight();
        }
        return 0;
    }

    public void addTab(TabViewNode tabViewNode) {
        if (tabViewNode == null) {
            return;
        }
        this.sb.setValue(this.sb.getValue() + 1);
        switch (this.iOrientation) {
            case 1: {
                TopTab topTab = new TopTab(tabViewNode);
                topTab.setParentBackground(SystemColor.control);
                topTab.setBackgroundPainting(this.bPaintTabBackground);
                topTab.committ();
                this.tc.addNode(topTab);
                return;
            }
            case 8: {
                RightTab rightTab = new RightTab(tabViewNode);
                rightTab.setParentBackground(SystemColor.control);
                rightTab.setBackgroundPainting(this.bPaintTabBackground);
                rightTab.committ();
                this.tc.addNode(rightTab);
                return;
            }
            case 4: {
                LeftTab leftTab = new LeftTab(tabViewNode);
                leftTab.setParentBackground(SystemColor.control);
                leftTab.setBackgroundPainting(this.bPaintTabBackground);
                leftTab.committ();
                this.tc.addNode(leftTab);
                return;
            }
        }
        BottomTab bottomTab = new BottomTab(tabViewNode);
        bottomTab.setParentBackground(SystemColor.control);
        bottomTab.setBackgroundPainting(this.bPaintTabBackground);
        bottomTab.committ();
        this.tc.addNode(bottomTab);
    }

    public void removeTab(TabViewNode tabViewNode) {
        try {
            Tab tab;
            Tab tab2 = this.tc.findTab(tabViewNode);
            boolean bl = tab2.getSelected();
            this.tc.deleteNode(tab2);
            if (bl && (tab = this.tc.findSelectedTab()) != null) {
                TabViewNode tabViewNode2 = tab.getTabViewNode();
                this.atutvParent.tabSelected(tabViewNode2);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void committ() {
        this.tc.committ();
    }

    public void addListener(TabViewEventListener tabViewEventListener) {
        this.tvc.addListener(tabViewEventListener);
    }

    public void removeListener(TabViewEventListener tabViewEventListener) {
        this.tvc.removeListener(tabViewEventListener);
    }
}

