/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.tabView;

import COM.ibm.eNetwork.jdi.gui.common.Controler;
import COM.ibm.eNetwork.jdi.gui.common.ExtendedCanvas;
import COM.ibm.eNetwork.jdi.gui.jvcScrollbar.JVCScrollbar;
import COM.ibm.eNetwork.jdi.gui.tabView.Tab;
import COM.ibm.eNetwork.jdi.gui.tabView.TabCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEvent;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEventListener;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;

public class TabsViewControler
extends Controler
implements MouseListener,
KeyListener,
FocusListener,
AdjustmentListener,
ComponentListener {
    protected TabCanvas tvc;
    protected TabView tv;
    protected JVCScrollbar sb;
    protected boolean bLeftMouseButtonClicked = false;

    public TabsViewControler(TabView tabView) {
        this.tv = tabView;
    }

    public void register(ExtendedCanvas extendedCanvas) {
        try {
            TabCanvas tabCanvas = (TabCanvas)extendedCanvas;
            tabCanvas.addMouseListener(this);
            tabCanvas.addKeyListener(this);
            tabCanvas.addFocusListener(this);
            tabCanvas.addComponentListener(this);
            this.tvc = tabCanvas;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void unregister(ExtendedCanvas extendedCanvas) {
        try {
            TabCanvas tabCanvas = (TabCanvas)extendedCanvas;
            tabCanvas.removeMouseListener(this);
            tabCanvas.removeKeyListener(this);
            tabCanvas.removeFocusListener(this);
            tabCanvas.removeComponentListener(this);
            this.tvc = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            Tab tab = (Tab)this.tvc.findCurrent();
            Tab tab2 = null;
            int n = keyEvent.getKeyCode();
            boolean bl = true;
            switch (n) {
                case 39: {
                    tab2 = (Tab)tab.getNext();
                    bl = this.preSelectEvent(tab2);
                    if (bl) {
                        this.tvc.selectNextTab();
                        this.postSelectEvent(tab2);
                        return;
                    }
                    break;
                }
                case 37: {
                    tab2 = (Tab)tab.getPrev();
                    bl = this.preSelectEvent(tab2);
                    if (bl) {
                        this.tvc.selectPrevTab();
                        this.postSelectEvent(tab2);
                        return;
                    }
                    break;
                }
                case 40: {
                    tab2 = (Tab)tab.getNext();
                    bl = this.preSelectEvent(tab2);
                    if (bl) {
                        this.tvc.selectNextTab();
                        this.postSelectEvent(tab2);
                        return;
                    }
                    break;
                }
                case 38: {
                    tab2 = (Tab)tab.getPrev();
                    bl = this.preSelectEvent(tab2);
                    if (bl) {
                        this.tvc.selectPrevTab();
                        this.postSelectEvent(tab2);
                        return;
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            this.tvc.requestFocus();
            Point point = mouseEvent.getPoint();
            Tab tab = (Tab)this.tvc.findOnMouseUp(point.x, point.y);
            boolean bl = this.preSelectEvent(tab);
            if (bl) {
                this.tvc.selectTab(tab);
                this.postSelectEvent(tab);
                return;
            }
        }
        catch (Exception exception) {}
    }

    protected boolean leftMouseClick(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getModifiers();
            if (n == 16) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            if (this.bAutoFocus) {
                this.tvc.requestFocus();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.bLeftMouseButtonClicked = true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        try {
            if (!this.tvc.getFocus()) {
                this.tvc.setFocus(true);
                this.tvc.repaint();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void focusLost(FocusEvent focusEvent) {
        try {
            if (this.tvc.getFocus()) {
                this.tvc.setFocus(false);
                this.tvc.repaint();
                return;
            }
        }
        catch (Exception exception) {}
    }

    protected boolean isMyEvent(AWTEvent aWTEvent) {
        try {
            if (aWTEvent instanceof TabViewEvent) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean sendEvent(AWTEvent aWTEvent) {
        try {
            Enumeration enumeration = this.hListeners.elements();
            TabViewEvent tabViewEvent = (TabViewEvent)aWTEvent;
            if (enumeration.hasMoreElements()) {
                TabViewEventListener tabViewEventListener = (TabViewEventListener)enumeration.nextElement();
                return tabViewEvent.sendEvent(tabViewEventListener);
            }
        }
        catch (Exception exception) {}
        return true;
    }

    protected boolean preSelectEvent(Tab tab) {
        try {
            return this.createEvent(329, tab);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean postSelectEvent(Tab tab) {
        try {
            this.tv.tabSelected(tab.getTabViewNode());
            return this.createEvent(332, tab);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean createEvent(int n, Tab tab) {
        try {
            TabViewEvent tabViewEvent = new TabViewEvent(this.tv, tab, n);
            return this.postEvent(tabViewEvent);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void selectTab(Tab tab) {
        boolean bl = this.preSelectEvent(tab);
        if (bl) {
            this.tvc.selectTab(tab);
            this.postSelectEvent(tab);
        }
    }

    public void registerScrollbar(JVCScrollbar jVCScrollbar) {
        try {
            jVCScrollbar.addAdjustmentListener(this);
            this.sb = jVCScrollbar;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void unregisterScrollbars(JVCScrollbar jVCScrollbar) {
        try {
            jVCScrollbar.removeAdjustmentListener(this);
            this.sb = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        try {
            JVCScrollbar jVCScrollbar = (JVCScrollbar)adjustmentEvent.getAdjustable();
            if (jVCScrollbar == this.sb) {
                this.scrollEvent(adjustmentEvent);
                return;
            }
        }
        catch (Exception exception) {}
    }

    protected void scrollEvent(AdjustmentEvent adjustmentEvent) {
        try {
            int n = adjustmentEvent.getAdjustmentType();
            switch (n) {
                case 1: {
                    this.tvc.moveToNextTab();
                    return;
                }
                case 2: {
                    this.tvc.moveToPrevTab();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void scrollbarEnablementCheck() {
        try {
            Tab tab = (Tab)this.tvc.findHeadNode();
            boolean bl = true;
            int n = 1;
            if (tab != null && tab.getPrev() == null) {
                bl = false;
            }
            if (this.sb.getOrientation() == 0) {
                n = 3;
            }
            this.sb.setArrowEnabled(n, bl);
            tab = (Tab)this.tvc.findEndNode();
            bl = true;
            n = 2;
            if (tab != null && tab.getNext() == null) {
                bl = false;
            }
            if (this.sb.getOrientation() == 0) {
                n = 4;
            }
            this.sb.setArrowEnabled(n, bl);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

