/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.tooltip;

import COM.ibm.eNetwork.jdi.common.misc.TimerListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.Window;

public class Tooltip
extends Window
implements TimerListener {
    protected int iTimerCount = 0;
    protected int iStartWaitTime;
    protected String sLabel = "";
    protected static boolean boolFastDisplay;
    protected static Tooltip currentToolTip;
    protected boolean boolWaitingToShow = false;
    protected boolean boolListeningToTimer = false;

    public Tooltip(Frame frame, String string) {
        super(frame);
        this.sLabel = string;
        ((Component)this).setBackground(SystemColor.info);
        ((Component)this).setVisible(false);
        this.init();
    }

    private void init() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.sLabel) + 4;
        int n2 = fontMetrics.getHeight() + 2;
        ((Component)this).setSize(n, n2);
    }

    public void showAfterDelay(int n, int n2) {
        if (!this.isVisible()) {
            if (currentToolTip == null) {
                currentToolTip = this;
            } else {
                ((Component)currentToolTip).hide();
                currentToolTip = this;
            }
            ((Component)this).setLocation(n, n2);
            this.iTimerCount = 0;
            this.boolWaitingToShow = true;
            this.boolListeningToTimer = true;
        }
    }

    protected void showNow() {
        ((Component)this).setVisible(true);
        this.toFront();
        this.repaint();
        this.boolWaitingToShow = false;
        if (this.boolListeningToTimer) {
            this.boolListeningToTimer = false;
        }
    }

    public void hideTooltip() {
        this.boolListeningToTimer = false;
        this.boolWaitingToShow = false;
        ((Component)this).setVisible(false);
        if (currentToolTip == this) {
            currentToolTip = null;
        }
        this.iTimerCount = 50;
        this.boolListeningToTimer = true;
    }

    public void paint(Graphics graphics) {
        if (currentToolTip != this) {
            ((Component)this).hide();
        }
        Dimension dimension = this.getSize();
        graphics.setColor(SystemColor.infoText);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(this.sLabel);
        graphics.drawString(this.sLabel, (dimension.width - n) / 2, (dimension.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
    }

    public String getLabel() {
        return this.sLabel;
    }

    public void setLabel(String string) {
        this.sLabel = string;
    }

    public synchronized void setFastDisplay(boolean bl) {
        boolFastDisplay = bl;
    }

    public void timerFired() {
        if (this.boolListeningToTimer) {
            ++this.iTimerCount;
            if (this.boolWaitingToShow) {
                if (this.iTimerCount == 4) {
                    this.boolListeningToTimer = false;
                    boolFastDisplay = true;
                    this.showNow();
                } else if (boolFastDisplay && this.iTimerCount == 1) {
                    this.boolListeningToTimer = false;
                    boolFastDisplay = true;
                    this.showNow();
                }
            }
            if (this.iTimerCount > 49 && this.iTimerCount < 75) {
                if (currentToolTip != null) {
                    this.boolListeningToTimer = false;
                    return;
                }
                this.iTimerCount = 75;
                return;
            }
            if (this.iTimerCount > 75) {
                if (currentToolTip != null) {
                    this.boolListeningToTimer = false;
                    return;
                }
                boolFastDisplay = false;
                this.boolListeningToTimer = false;
            }
        }
    }

    static {
        currentToolTip = null;
    }
}

