/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.treeView;

import COM.ibm.eNetwork.jdi.gui.common.Controler;
import COM.ibm.eNetwork.jdi.gui.common.ExtendedCanvas;
import COM.ibm.eNetwork.jdi.gui.jvcScrollbar.JVCScrollbar;
import COM.ibm.eNetwork.jdi.gui.treeView.TreeView;
import COM.ibm.eNetwork.jdi.gui.treeView.TreeViewCanvas;
import COM.ibm.eNetwork.jdi.gui.treeView.TreeViewEvent;
import COM.ibm.eNetwork.jdi.gui.treeView.TreeViewEventListener;
import COM.ibm.eNetwork.jdi.gui.treeView.TreeViewNode;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;

public class TreeViewControler
extends Controler
implements MouseListener,
KeyListener,
FocusListener,
AdjustmentListener {
    protected TreeViewCanvas tvc;
    protected JVCScrollbar sbHorz;
    protected JVCScrollbar sbVert;
    protected TreeView tv;
    protected boolean bRightMouseButtonClicked = false;
    protected int iKeyCounter;
    protected boolean bDraggable = false;
    protected boolean bMultiSelect = false;

    public TreeViewControler(TreeView treeView) {
        this.tv = treeView;
    }

    public void register(ExtendedCanvas extendedCanvas) {
        try {
            TreeViewCanvas treeViewCanvas = (TreeViewCanvas)extendedCanvas;
            this.tv.addFocusListener(this);
            treeViewCanvas.addMouseListener(this);
            treeViewCanvas.addKeyListener(this);
            treeViewCanvas.addFocusListener(this);
            this.tvc = treeViewCanvas;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void unregister(ExtendedCanvas extendedCanvas) {
        try {
            TreeViewCanvas treeViewCanvas = (TreeViewCanvas)extendedCanvas;
            treeViewCanvas.removeMouseListener(this);
            treeViewCanvas.removeKeyListener(this);
            treeViewCanvas.removeFocusListener(this);
            this.tvc = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void registerScrollbars(JVCScrollbar jVCScrollbar, JVCScrollbar jVCScrollbar2) {
        try {
            jVCScrollbar.addAdjustmentListener(this);
            jVCScrollbar2.addAdjustmentListener(this);
            this.sbHorz = jVCScrollbar;
            this.sbVert = jVCScrollbar2;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void unregisterScrollbars(JVCScrollbar jVCScrollbar, JVCScrollbar jVCScrollbar2) {
        try {
            jVCScrollbar.removeAdjustmentListener(this);
            jVCScrollbar2.removeAdjustmentListener(this);
            this.sbHorz = null;
            this.sbVert = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findCurrent();
            int n = keyEvent.getKeyCode();
            boolean bl = true;
            switch (n) {
                case 10: {
                    this.createEvent(231, treeViewNode);
                    return;
                }
                case 39: {
                    bl = this.preToggleEvent(treeViewNode);
                    if (bl) {
                        this.tvc.toggleTreeViewNode(treeViewNode);
                        this.postToggleEvent(treeViewNode);
                        return;
                    }
                    break;
                }
                case 37: {
                    bl = this.preToggleEvent(treeViewNode);
                    if (bl) {
                        this.tvc.toggleTreeViewNode(treeViewNode);
                        bl = this.postToggleEvent(treeViewNode);
                        return;
                    }
                    break;
                }
                case 40: {
                    ++this.iKeyCounter;
                    bl = this.createEvent(232, (TreeViewNode)treeViewNode.getNext());
                    if (bl) {
                        this.tvc.selectNextNode();
                        this.createEvent(228, (TreeViewNode)treeViewNode.getNext());
                        return;
                    }
                    break;
                }
                case 38: {
                    ++this.iKeyCounter;
                    bl = this.createEvent(232, (TreeViewNode)treeViewNode.getPrev());
                    if (bl) {
                        this.tvc.selectPrevNode();
                        this.createEvent(228, (TreeViewNode)treeViewNode.getPrev());
                        return;
                    }
                    break;
                }
                case 33: {
                    treeViewNode = this.tvc.selectPrevPage();
                    this.createEvent(228, treeViewNode);
                    return;
                }
                case 34: {
                    treeViewNode = this.tvc.selectNextPage();
                    this.createEvent(228, treeViewNode);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.iKeyCounter > 2) {
            this.tvc.absoluteRepaint();
        }
        this.iKeyCounter = 0;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            this.bRightMouseButtonClicked = this.rightMouseClick(mouseEvent);
            this.tvc.requestFocus();
            Point point = mouseEvent.getPoint();
            this.tvc.calibratePoint(point);
            TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findOnMouseUp(point.x, point.y);
            boolean bl = true;
            if (treeViewNode == null && this.bRightMouseButtonClicked) {
                PopupMenu popupMenu = this.tv.getPopupMenu();
                Point point2 = mouseEvent.getPoint();
                this.tv.add(popupMenu);
                popupMenu.show(this.tv, point2.x, point2.y);
                return;
            }
            if (treeViewNode == null) {
                return;
            }
            if (treeViewNode.hitPlus(point.x)) {
                bl = this.preToggleEvent(treeViewNode);
                if (bl) {
                    this.tvc.toggleTreeViewNode(treeViewNode);
                    this.postToggleEvent(treeViewNode);
                    return;
                }
            } else {
                if (mouseEvent.getClickCount() > 1 && !this.bRightMouseButtonClicked) {
                    this.createEvent(231, treeViewNode);
                    return;
                }
                if (this.bMultiSelect && !treeViewNode.getSelected() && this.ctrlKeyPressed(mouseEvent)) {
                    bl = this.createEvent(232, treeViewNode);
                    if (bl) {
                        this.tvc.multiSelectNode(treeViewNode);
                        this.tvc.repaint();
                        this.createEvent(228, treeViewNode);
                        return;
                    }
                } else if (!treeViewNode.getSelected()) {
                    bl = this.createEvent(232, treeViewNode);
                    if (bl) {
                        this.tvc.selectNode(treeViewNode);
                        this.tvc.repaint();
                        this.createEvent(228, treeViewNode);
                        return;
                    }
                } else {
                    if (!this.bRightMouseButtonClicked && treeViewNode.getSelected() && this.ctrlKeyPressed(mouseEvent)) {
                        this.tvc.unselectNode(treeViewNode);
                        this.tvc.repaint();
                        return;
                    }
                    if (treeViewNode.getPopupMenu() != null && this.bRightMouseButtonClicked && !this.multipleNodesSelected()) {
                        PopupMenu popupMenu = treeViewNode.getPopupMenu();
                        Point point3 = mouseEvent.getPoint();
                        this.tv.add(popupMenu);
                        popupMenu.show(this.tv, point3.x, point3.y);
                        return;
                    }
                    if (this.tv.getMultiPopupMenu() != null && this.bRightMouseButtonClicked && this.multipleNodesSelected()) {
                        PopupMenu popupMenu = this.tv.getMultiPopupMenu();
                        Point point4 = mouseEvent.getPoint();
                        this.tv.add(popupMenu);
                        popupMenu.show(this.tv, point4.x, point4.y);
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    protected boolean multipleNodesSelected() {
        try {
            Vector vector = this.tvc.findSelectedTreeViewNodes();
            if (vector == null) {
                return false;
            }
            return vector.size() >= 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean ctrlKeyPressed(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getModifiers();
            return (n & 2) == 2;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    protected boolean rightMouseClick(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getModifiers();
            return n == 4;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            if (this.bAutoFocus) {
                this.tvc.requestFocus();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        try {
            Object object = focusEvent.getSource();
            if (object instanceof TreeView) {
                this.tvc.requestFocus();
                return;
            }
            if (object instanceof TreeViewCanvas) {
                TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findOnGotFocus();
                treeViewNode.setFocus(true);
                this.tvc.repaint();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void focusLost(FocusEvent focusEvent) {
        try {
            TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findOnGotFocus();
            treeViewNode.setFocus(false);
            this.tvc.repaint();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        try {
            JVCScrollbar jVCScrollbar = (JVCScrollbar)adjustmentEvent.getAdjustable();
            if (jVCScrollbar == this.sbHorz) {
                this.horzScrollEvent(adjustmentEvent);
                return;
            }
            if (jVCScrollbar == this.sbVert) {
                this.vertScrollEvent(adjustmentEvent);
                return;
            }
        }
        catch (Exception exception) {}
    }

    protected boolean isMyEvent(AWTEvent aWTEvent) {
        try {
            if (aWTEvent instanceof TreeViewEvent) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean sendEvent(AWTEvent aWTEvent) {
        try {
            Enumeration enumeration = this.hListeners.elements();
            TreeViewEvent treeViewEvent = (TreeViewEvent)aWTEvent;
            if (enumeration.hasMoreElements()) {
                TreeViewEventListener treeViewEventListener = (TreeViewEventListener)enumeration.nextElement();
                return treeViewEvent.sendEvent(treeViewEventListener);
            }
        }
        catch (Exception exception) {}
        return true;
    }

    protected void vertScrollEvent(AdjustmentEvent adjustmentEvent) {
        try {
            int n = adjustmentEvent.getAdjustmentType();
            switch (n) {
                case 1: {
                    this.tvc.moveToNextNode();
                    return;
                }
                case 4: {
                    this.tvc.moveToNextPage(true);
                    return;
                }
                case 2: {
                    this.tvc.moveToPrevNode();
                    return;
                }
                case 3: {
                    this.tvc.moveToPrevPage(true);
                    return;
                }
                case 5: {
                    this.tvc.moveToNodeX(adjustmentEvent.getValue());
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void horzScrollEvent(AdjustmentEvent adjustmentEvent) {
        try {
            if (adjustmentEvent.getAdjustmentType() != 5) {
                this.tvc.setHorzOffset(adjustmentEvent.getValue());
                return;
            }
        }
        catch (Exception exception) {}
    }

    protected boolean preToggleEvent(TreeViewNode treeViewNode) {
        try {
            if (!treeViewNode.hasChild()) {
                return false;
            }
            if (treeViewNode.getExpanded()) {
                return this.createEvent(234, treeViewNode);
            }
            return this.createEvent(233, treeViewNode);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean postToggleEvent(TreeViewNode treeViewNode) {
        try {
            if (treeViewNode.getExpanded()) {
                return this.createEvent(229, treeViewNode);
            }
            return this.createEvent(230, treeViewNode);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean createEvent(int n, TreeViewNode treeViewNode) {
        try {
            TreeViewEvent treeViewEvent = new TreeViewEvent(this.tv, treeViewNode, n);
            return this.postEvent(treeViewEvent);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void setAsDraggableComponent(boolean bl) {
        this.bDraggable = bl;
    }

    public void setMultiSelect(boolean bl) {
        this.bMultiSelect = bl;
    }
}

