/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcpauth;

import COM.ibm.raleigh.tcpauth.MyPrivateKey;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAParams;
import java.util.Random;

public class MySign {
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private BigInteger x;
    private MessageDigest md = MessageDigest.getInstance("SHA");
    private BigInteger r;
    private Random rd;
    private BigInteger k;
    private BigInteger ki;

    public MySign(MyPrivateKey myPrivateKey) throws NoSuchAlgorithmException {
        DSAParams dSAParams = myPrivateKey.getParams();
        this.rd = new Random();
        this.p = dSAParams.getP();
        this.q = dSAParams.getQ();
        this.g = dSAParams.getG();
        this.x = myPrivateKey.getX();
    }

    public void init() {
        this.md.reset();
        this.k = new BigInteger(this.q.bitLength(), this.rd);
        this.k = this.k.mod(this.q);
        this.ki = this.k.modInverse(this.q);
        this.r = this.g.modPow(this.k, this.p).mod(this.q);
    }

    public void update(byte[] byArray) {
        this.md.update(byArray);
    }

    byte[] sign() {
        byte[] byArray = this.md.digest();
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 0;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        BigInteger bigInteger = new BigInteger(byArray2);
        bigInteger = bigInteger.mod(this.q);
        BigInteger bigInteger2 = this.x.multiply(this.r);
        bigInteger2 = bigInteger2.add(bigInteger);
        bigInteger2 = bigInteger2.mod(this.q);
        bigInteger2 = bigInteger2.multiply(this.ki);
        bigInteger2 = bigInteger2.mod(this.q);
        byte[] byArray3 = bigInteger2.toByteArray();
        byte[] byArray4 = this.r.toByteArray();
        int n = byArray3.length + byArray4.length + 4;
        if (byArray3.length > 127) {
            ++n;
        }
        if (byArray4.length > 127) {
            ++n;
        }
        int n2 = n + 2;
        if (n > 255) {
            n2 += 2;
        } else if (n > 127) {
            ++n2;
        }
        byte[] byArray5 = new byte[n2];
        byArray5[0] = 48;
        if (n > 255) {
            byArray5[1] = -126;
            byArray5[2] = (byte)(n >> 8);
            byArray5[3] = (byte)n;
            n2 = 4;
        } else if (n > 127) {
            byArray5[1] = -127;
            byArray5[2] = (byte)n;
            n2 = 3;
        } else {
            byArray5[1] = (byte)n;
            n2 = 2;
        }
        byArray5[n2++] = 2;
        if (byArray4.length > 127) {
            byArray5[n2++] = -127;
        }
        byArray5[n2++] = (byte)byArray4.length;
        System.arraycopy(byArray4, 0, byArray5, n2, byArray4.length);
        n2 += byArray4.length;
        byArray5[n2++] = 2;
        if (byArray3.length > 127) {
            byArray5[n2++] = -127;
        }
        byArray5[n2++] = (byte)byArray3.length;
        System.arraycopy(byArray3, 0, byArray5, n2, byArray3.length);
        return byArray5;
    }
}

