/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dadmgui;

import COM.ibm.raleigh.dadmgui.ButtonKeyListener;
import COM.ibm.raleigh.dadmgui.DadminFrame;
import COM.ibm.raleigh.dadmgui.DadminNLS;
import COM.ibm.raleigh.dadmgui.MessageBox;
import COM.ibm.raleigh.dadmgui.MyWindowListener;
import COM.ibm.raleigh.dadmgui.ServerField;
import COM.ibm.raleigh.dadmgui.SockHandler;
import COM.ibm.raleigh.dadmgui.dadminRequest;
import COM.ibm.raleigh.dadmgui.validip;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class dAddress
extends Dialog
implements ActionListener {
    private static final String copyright1 = "(c) Copyright IBM Corp 1992, 1997.  All rights reserved.";
    private Button addressButton;
    private Button poolButton;
    private Button cancelButton;
    private Button helpButton;
    private TextField serverText;
    private TextField pwText;
    private TextField IPAddress;
    private DadminFrame da;
    private Frame f;

    public dAddress(DadminFrame dadminFrame, Frame frame, String string) {
        super(frame, string, false);
        this.da = dadminFrame;
        this.f = frame;
        try {
            this.setLocale(dadminFrame.getLocale());
        }
        catch (Exception exception) {}
        this.addressButton = new Button(DadminNLS.nls("Address"));
        this.poolButton = new Button(DadminNLS.nls("Pool"));
        this.cancelButton = new Button(DadminNLS.nls("Cancel"));
        this.helpButton = new Button(DadminNLS.nls("Help"));
        ButtonKeyListener buttonKeyListener = new ButtonKeyListener();
        this.addressButton.addKeyListener(buttonKeyListener);
        this.poolButton.addKeyListener(buttonKeyListener);
        this.cancelButton.addKeyListener(buttonKeyListener);
        this.helpButton.addKeyListener(buttonKeyListener);
        this.setLayout(new BorderLayout());
        ServerField serverField = new ServerField(this, dadminFrame.serverHost, dadminFrame.serverPassword, dadminFrame.isApplication);
        this.serverText = serverField.getServerText();
        this.pwText = serverField.getPwText();
        this.IPAddress = new TextField("", 15);
        Label label = new Label(DadminNLS.nls("s08"));
        Panel panel = new Panel();
        panel.add(label);
        panel.add(this.IPAddress);
        this.add("Center", panel);
        Panel panel2 = new Panel();
        panel2.add(this.addressButton);
        panel2.add(this.poolButton);
        panel2.add(this.cancelButton);
        panel2.add(this.helpButton);
        this.add("South", panel2);
        this.pack();
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)this).setVisible(true);
        dadminFrame.setEnabled(false);
        this.addWindowListener(new MyWindowListener(dadminFrame));
        this.poolButton.addActionListener(this);
        this.addressButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.da.setEnabled(true);
            this.da.toFront();
            super.dispose();
            return;
        }
        if (actionEvent.getSource() == this.addressButton || actionEvent.getSource() == this.poolButton) {
            String string = this.serverText.getText();
            if (this.da.isApplication) {
                if ((string = validip.host(string)).length() == 0) {
                    new MessageBox((Window)this, this.f, this.getTitle(), DadminNLS.nls("s04"));
                    return;
                }
                this.da.serverHost = string;
            }
            this.da.serverPassword = this.pwText.getText();
            String string2 = this.IPAddress.getText();
            int n = actionEvent.getSource() == this.poolButton ? validip.v(string2, true) : validip.v(string2, false);
            if (n == 0) {
                new MessageBox((Window)this, this.f, this.getTitle(), DadminNLS.nls("s09"));
                return;
            }
            dadminRequest dadminRequest2 = new dadminRequest(string, this.da);
            dadminRequest2.makeIPAddr(n, actionEvent.getSource() == this.poolButton);
            this.da.displayText(DadminNLS.nls("s10", string2, string));
            SockHandler sockHandler = new SockHandler(this.da, string, dadminRequest2, this.da.serverPassword);
            sockHandler.start();
            this.da.setEnabled(true);
            this.da.toFront();
            super.dispose();
            return;
        }
        if (actionEvent.getSource() == this.helpButton) {
            this.da.doHelp("#HDRADDPOOL");
            return;
        }
    }
}

