/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.AddHostMgr;
import COM.ibm.raleigh.ddnssgui.client.DomainNameAndIPListPanel;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.DomainNameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.DomainNameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.ListPanelGrid;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.BitSet;
import java.util.ResourceBundle;

class AddHostFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener,
ListPanelUser,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int WRAPPED_TEXT_WIDTH = 100;
    private static final int NUM_ROWS_VISIBLE = 8;
    private static final int NUM_TEXT_FIELD_COLUMNS = 10;
    private static final int NUM_BUTTONS = 3;
    private final int OK_BUTTON = 0;
    private final int CANCEL_BUTTON = 1;
    private final int HELP_BUTTON = 2;
    private final String FULLY_QUALIFIED_DELIMITER = ".";
    private static final int LIST_ROWS = 2;
    private static final int LIST_COLUMNS = 2;
    private AddHostMgr parent;
    private ResourceBundle resources;
    private Panel wizardPanel;
    private WrappedTextPanel wizardInfoPanel;
    private Label domainNameLabel;
    private Choice domainName;
    private DomainNameAndIPListPanel hostPanel;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private msgBox invalidBox;

    public AddHostFrame(AddHostMgr addHostMgr) {
        this.setResizable(false);
        this.parent = addHostMgr;
        this.resources = this.parent.MyParent.clientResources;
        this.setTitle(this.resources.getString("ADD_HOSTS_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public String getFullyQualifiedDomainName() {
        return this.domainName.getSelectedItem().trim();
    }

    public void setFullyQualifiedDomainName(String string) {
        if (string != null && string.length() > 0) {
            this.domainName.select(string.trim());
        }
    }

    public String[] getFullyQualifiedDomainNameList() {
        int n = this.domainName.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = new String(this.domainName.getItem(n2).trim());
            ++n2;
        }
        return stringArray;
    }

    public void setFullyQualifiedDomainNameList(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.domainName.addItem(stringArray[n].trim());
                ++n;
            }
            if (stringArray.length > 1) {
                this.domainName.setEnabled(true);
            }
        }
    }

    public DomainNameAndIpAddressList getHostList() {
        return this.hostPanel.getDomainNameAndIPList();
    }

    public void setHostList(DomainNameAndIpAddressList domainNameAndIpAddressList) {
        this.hostPanel.removeAll();
        if (domainNameAndIpAddressList != null) {
            this.hostPanel.setDomainNameAndIPList(domainNameAndIpAddressList);
        }
        this.checkOK();
    }

    public DomainNameAndIpAddress getHost() {
        return this.hostPanel.getDomainNameAndIP();
    }

    public void setHost(DomainNameAndIpAddress domainNameAndIpAddress) {
        if (domainNameAndIpAddress != null) {
            this.hostPanel.setDomainNameAndIP(domainNameAndIpAddress);
        }
    }

    public void setEnabled(boolean bl) {
        this.wizardInfoPanel.setEnabled(bl);
        this.domainNameLabel.setEnabled(bl);
        this.domainName.setEnabled(bl);
        this.hostPanel.setEnabled(bl);
        this.wizardPanel.setEnabled(bl);
        if (bl) {
            this.checkOK();
            this.enableCancel();
        }
        if (!bl) {
            this.disableOK();
            this.disableCancel();
        }
    }

    public boolean isInList(DomainNameAndIpAddress domainNameAndIpAddress, int n) {
        return this.hostPanel.isInList(domainNameAndIpAddress, n);
    }

    public void addToList(DomainNameAndIpAddress domainNameAndIpAddress) {
        this.hostPanel.addToDomainNameAndIPList(domainNameAndIpAddress);
        this.checkOK();
    }

    public void replaceHostInList(DomainNameAndIpAddress domainNameAndIpAddress) {
        if (domainNameAndIpAddress != null) {
            int n = this.hostPanel.getHostListIndex(domainNameAndIpAddress);
            if (n != -1) {
                this.hostPanel.replaceHostInList(domainNameAndIpAddress);
            }
            this.checkOK();
        }
    }

    public boolean isUniqueHostInDomain(String string, String string2) {
        return this.parent.isUniqueHost(string, string2);
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.wizardPanel = new Panel();
        this.wizardInfoPanel = new WrappedTextPanel(this.resources.getString("ADD_HOSTS_INFO_LABEL"), 100);
        this.domainNameLabel = new Label(this.resources.getString("DOMAIN_NAME_LABEL"), 0);
        this.domainNameLabel.setEnabled(true);
        this.domainName = new Choice();
        this.domainName.addItemListener(this);
        BitSet bitSet = new BitSet(4);
        bitSet.set(0);
        bitSet.set(1);
        ListPanelGrid listPanelGrid = new ListPanelGrid(2, 2, bitSet, 1);
        this.hostPanel = new DomainNameAndIPListPanel(this, this.resources, this.resources.getString("HOST_PANEL_LABEL"), 8, "", listPanelGrid, this.resources.getString("DETAILS_BUTTON_LABEL"));
        this.hostPanel.setMultipleMode(false);
        this.initButtonPanel();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        this.wizardInfoPanel.getNumDividedTextLines();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        this.wizardPanel.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.constrain(this.wizardInfoPanel, gridBagLayout2, gridBagConstraints2, 0, 0, 0, 1);
        this.wizardPanel.add(this.wizardInfoPanel);
        this.constrain(this.domainNameLabel, gridBagLayout2, gridBagConstraints2, 0, 1, 1, 1);
        this.wizardPanel.add(this.domainNameLabel);
        gridBagConstraints2.fill = 2;
        this.constrain(this.domainName, gridBagLayout2, gridBagConstraints2, 1, 1, 0, 1);
        this.wizardPanel.add(this.domainName);
        this.constrain(this.hostPanel, gridBagLayout2, gridBagConstraints2, 0, 2, 0, 0);
        this.wizardPanel.add(this.hostPanel);
        this.add(this.wizardPanel, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 0);
    }

    private void checkOK() {
        if (this.hostPanel.getItemCount() > 0) {
            this.enableOK();
            return;
        }
        this.disableOK();
    }

    private void enableOK() {
        this.buttonPanel.setEnabled(true, this.buttons[0]);
    }

    private void disableOK() {
        this.buttonPanel.setEnabled(false, this.buttons[0]);
    }

    private void enableCancel() {
        this.buttonPanel.setEnabled(true, this.buttons[1]);
    }

    private void disableCancel() {
        this.buttonPanel.setEnabled(false, this.buttons[1]);
    }

    private void handleDetailsButton() {
        boolean bl = false;
        DomainNameAndIpAddress domainNameAndIpAddress = null;
        this.hostPanel.setDomainName(this.getFullyQualifiedDomainName());
        if (!(this.hostPanel.isHostNameEmpty() || this.hostPanel.isDomainNameEmpty() || this.hostPanel.isIPAddressEmpty())) {
            domainNameAndIpAddress = this.getHost();
            bl = true;
        } else {
            int n = this.hostPanel.getSelectedIndex();
            if (n >= 0 && this.hostPanel.getItemCount() > 0) {
                domainNameAndIpAddress = this.hostPanel.getDomainNameAndIP(n);
            } else {
                domainNameAndIpAddress = null;
                this.invalidBox = new msgBox(this.resources, this.resources.getString("ADD_HOSTS_FRAME_NAME"), this.resources.getString("INVALID_DETAILS_BUTTON_DATA_TEXT"), 1, true, this);
            }
            bl = false;
        }
        if (bl && this.hostPanel.isInList(domainNameAndIpAddress, 1)) {
            this.invalidBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("DUPLICATE_HOST_NAME_TEXT"), 1, true);
            this.hostPanel.selectAll(1);
            this.hostPanel.requestFocus(1);
            return;
        }
        if (domainNameAndIpAddress != null && this.hostPanel.validateFields(domainNameAndIpAddress.getFqName(), domainNameAndIpAddress.getIpAddress()) && this.isUniqueHostInDomain(domainNameAndIpAddress.getFqName(), domainNameAndIpAddress.getDomainName())) {
            this.parent.doDetails(domainNameAndIpAddress);
        }
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
        this.disableOK();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.domainName) {
            this.domainName.select(this.domainName.getSelectedItem());
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.CancelAndExit();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void handleButton(Button button) {
        if (button == this.buttons[0]) {
            this.parent.SaveAndExit(this.getHostList());
        }
        if (button == this.buttons[1]) {
            this.parent.CancelAndExit();
        }
        if (button == this.buttons[2]) {
            this.parent.MyParent.handleHelp("ddscwnh.htm#HDRWNH");
        }
        if (button == this.hostPanel.getAddButton()) {
            this.checkOK();
        }
        if (button == this.hostPanel.getRemoveButton()) {
            this.checkOK();
        }
        if (button == this.hostPanel.getOptionalButton()) {
            this.handleDetailsButton();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

