/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.client.TTLPanel;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

class DynamicDataPropertiesFrame
extends Frame
implements WindowListener,
ActionListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int FIRST_FIELD = 0;
    public static final int EXPIRATION_TIME_FIELD = 0;
    public static final int EXTENSION_TIME_FIELD = 1;
    private static final int TABVIEW_DYNAMIC_DATA_PROPERTIES_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int NUM_TABS = 1;
    private static final int NUM_BUTTONS = 3;
    private final int OK_BUTTON = 0;
    private final int CANCEL_BUTTON = 1;
    private final int HELP_BUTTON = 2;
    private static final int NUM_TEXT_FIELD_COLUMNS = 16;
    private static final int TTL_TEXT_LINE_LENGTH = 75;
    private MainFrame parent;
    private ResourceBundle resources;
    private Panel ttlPanel;
    private TTLPanel expirationPanel;
    private TTLPanel extensionPanel;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private TabView tabView;
    private TabViewNode[] tabNodes;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);
    private msgBox okBox;
    private msgBox invalidBox;

    public DynamicDataPropertiesFrame(MainFrame mainFrame) {
        this.setResizable(false);
        this.parent = mainFrame;
        this.resources = this.parent.clientResources;
        this.setTitle(this.resources.getString("DDPF_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void selectFirstTab() {
        if (this.tabView != null) {
            this.tabView.selectTab(this.tabNodes[0]);
        }
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.expirationPanel.requestFocus(0);
                return;
            }
            case 1: {
                this.extensionPanel.requestFocus(0);
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                this.expirationPanel.selectAll(0);
                return;
            }
            case 1: {
                this.extensionPanel.selectAll(0);
                return;
            }
        }
    }

    public int getExpirationTime() {
        int n = this.expirationPanel.getTTL();
        if (n == -1) {
            n = 3600;
        }
        return n;
    }

    public void setExpirationTime(int n) {
        this.expirationPanel.setTTL(n);
    }

    public int getExtensionTime() {
        int n = this.extensionPanel.getTTL();
        if (n == -1) {
            n = 3110400;
        }
        return n;
    }

    public void setExtensionTime(int n) {
        this.extensionPanel.setTTL(n);
    }

    public void setEnabled(boolean bl) {
        this.ttlPanel.setEnabled(bl);
        this.expirationPanel.setEnabled(bl);
        this.extensionPanel.setEnabled(bl);
    }

    public synchronized void setEnabledButtons(boolean bl) {
        if (bl) {
            this.enableOK();
            this.enableCancel();
            this.enableHelp();
            return;
        }
        this.disableOK();
        this.disableCancel();
        this.disableHelp();
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.ttlPanel = new Panel();
        this.expirationPanel = new TTLPanel(this.resources, this.resources.getString("DYNAMIC_DATA_EXPIRATION_TIME_LABEL"), false, this.resources.getString("DYNAMIC_DATA_EXPIRATION_INFO_TEXT"), 75);
        this.extensionPanel = new TTLPanel(this.resources, this.resources.getString("DYNAMIC_DATA_EXTENSION_TIME_LABEL"), false, this.resources.getString("DYNAMIC_DATA_EXTENSION_INFO_TEXT"), 75);
        this.initButtonPanel();
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("DDPF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("DDPF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        this.createTabs();
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.layoutTTLPanel(gridBagConstraints);
        this.add((Component)this.tabView, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        this.addTabs();
        this.tabView.committ();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 0);
        this.addWindowListener(this);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private void enableOK() {
        this.buttonPanel.setEnabled(true, this.buttons[0]);
    }

    private void disableOK() {
        this.buttonPanel.setEnabled(false, this.buttons[0]);
    }

    private void enableCancel() {
        this.buttonPanel.setEnabled(true, this.buttons[1]);
    }

    private void disableCancel() {
        this.buttonPanel.setEnabled(false, this.buttons[1]);
    }

    private void enableHelp() {
        this.buttonPanel.setEnabled(true, this.buttons[2]);
    }

    private void disableHelp() {
        this.buttonPanel.setEnabled(false, this.buttons[2]);
    }

    private void layoutTTLPanel(GridBagConstraints gridBagConstraints) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        this.ttlPanel.setLayout(gridBagLayout);
        gridBagConstraints2.fill = 2;
        this.constrain(this.expirationPanel, gridBagLayout, gridBagConstraints2, 0, 0, 0, 1);
        this.ttlPanel.add(this.expirationPanel);
        this.constrain(this.extensionPanel, gridBagLayout, gridBagConstraints2, 0, 1, 0, 1);
        this.ttlPanel.add(this.extensionPanel);
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0] && this.validateFields()) {
            this.parent.setDynamicDataProperties(this.getExpirationTime(), this.getExtensionTime());
            this.parent.requestFocus();
            this.dispose();
        }
        if (button == this.buttons[1]) {
            this.parent.requestFocus();
            this.dispose();
        }
        if (button == this.buttons[2]) {
            this.parent.handleHelp("ddscnbt.htm#HDRNBT");
        }
    }

    private boolean validateFields() {
        boolean bl = true;
        if (!this.expirationPanel.isValidTTL()) {
            this.tabView.selectTab(this.tabNodes[0]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("DDPF_FRAME_NAME"), this.resources.getString("INVALID_EXPIRATION_TIME_TEXT"), 1, true, this);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        }
        if (bl && !this.extensionPanel.isValidTTL()) {
            this.tabView.selectTab(this.tabNodes[0]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("DDPF_FRAME_NAME"), this.resources.getString("INVALID_EXTENSION_TIME_TEXT"), 1, true, this);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        }
        return bl;
    }

    private void createTabs() {
        this.tabNodes = new TabViewNode[1];
        int n = 0;
        while (n < 1) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private void addTabs() {
        this.tabNodes[0].setText(this.resources.getString("TABVIEW_DYNAMIC_DATA_PROPERTIES_LABEL"));
        this.tabNodes[0].setPanel(this.ttlPanel);
        int n = 0;
        while (n < 1) {
            this.tabView.addTab(this.tabNodes[n]);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.requestFocus();
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

