/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.HostFrame;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

class HostCfgPanel
extends Panel
implements ItemListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int FIRST_FIELD = 0;
    public static final int HOST_NAME_FIELD = 0;
    private static final int NUM_TEXT_COLUMNS = 10;
    private HostFrame parent;
    private ResourceBundle resources;
    private Label hostNameLabel;
    private TextField hostName;
    private Label domainNameLabel;
    private Choice domainName;
    GridBagLayout gridBag = new GridBagLayout();
    GridBagConstraints constraints = new GridBagConstraints();

    public HostCfgPanel(HostFrame hostFrame, ResourceBundle resourceBundle) {
        this.parent = hostFrame;
        this.resources = resourceBundle;
        this.setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.hostName.requestFocus();
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                if (!this.hostName.isEnabled()) break;
                this.hostName.selectAll();
                return;
            }
        }
    }

    public String getHostName() {
        return this.hostName.getText().trim().toLowerCase();
    }

    public void setHostName(String string) {
        if (string != null) {
            ((TextComponent)this.hostName).setText(string.toLowerCase());
            this.checkToDisableNames();
        }
    }

    public String getFullyQualifiedDomainName() {
        return this.domainName.getSelectedItem().trim().toLowerCase();
    }

    public void setFullyQualifiedDomainName(String string) {
        if (string != null && string.length() > 0) {
            this.domainName.select(string.trim().toLowerCase());
            this.checkToDisableNames();
        }
    }

    public String[] getFullyQualifiedDomainNameList() {
        int n = this.domainName.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = new String(this.domainName.getItem(n2).trim().toLowerCase());
            ++n2;
        }
        return stringArray;
    }

    public void setFullyQualifiedDomainNameList(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.domainName.addItem(stringArray[n].trim().toLowerCase());
                ++n;
            }
            if (stringArray.length > 1) {
                this.domainName.setEnabled(true);
            }
            this.checkToDisableNames();
        }
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.hostNameLabel.setEnabled(false);
            this.hostName.setEnabled(false);
            ((Component)this.hostName).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            this.domainNameLabel.setEnabled(false);
            this.domainName.setEnabled(false);
            this.domainName.setBackground(DDNSUtility.BACKGROUND_COLOR);
        }
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void initComponents() {
        this.hostNameLabel = new Label(this.resources.getString("HOST_NAME_LABEL"), 0);
        this.hostName = new TextField("", 10);
        this.domainNameLabel = new Label(this.resources.getString("DOMAIN_NAME_LABEL"), 0);
        this.domainName = new Choice();
        this.domainName.addItemListener(this);
    }

    private void addComponentsToGrid() {
        this.setLayout(this.gridBag);
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.add(this.hostNameLabel, this.gridBag, this.constraints, 0, 0, 1, 1);
        this.constraints.fill = 2;
        this.add(this.hostName, this.gridBag, this.constraints, 1, 0, 0, 1);
        this.constraints.fill = 0;
        this.add(this.domainNameLabel, this.gridBag, this.constraints, 0, 1, 1, 1);
        this.constraints.fill = 2;
        this.add(this.domainName, this.gridBag, this.constraints, 1, 1, 0, 1);
    }

    private void checkToDisableNames() {
        if (this.getHostName().compareTo("") != 0) {
            this.setEnabled(false);
            return;
        }
        this.hostNameLabel.setEnabled(true);
        this.hostName.setEnabled(true);
        this.domainNameLabel.setEnabled(true);
        this.domainName.setEnabled(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.domainName) {
            this.domainName.select(this.domainName.getSelectedItem());
        }
    }
}

