/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.client.RecordsPanel;
import COM.ibm.raleigh.ddnssgui.common.AliasHostObject;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.HostObject;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.ReservedName;
import COM.ibm.raleigh.ddnssgui.common.ReverseHost;
import COM.ibm.raleigh.ddnssgui.common.SecondaryDomain;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

class HostRecordsFrame
extends Frame
implements WindowListener,
ActionListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int NUM_BUTTONS = 1;
    private final int OK_BUTTON = 0;
    private String[] txtData;
    RecordsPanel theTextArea;
    private String SingletxtData;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private ResourceBundle resources;

    public HostRecordsFrame(ResourceBundle resourceBundle) {
        this.resources = resourceBundle;
        this.setTitle(this.resources.getString("APP_TITLE"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
    }

    public HostRecordsFrame(ResourceBundle resourceBundle, String[] stringArray) {
        this.resources = resourceBundle;
        this.setTitle(this.resources.getString("APP_TITLE"));
        this.txtData = stringArray;
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public HostRecordsFrame(ResourceBundle resourceBundle, String string) {
        this.resources = resourceBundle;
        this.setTitle(this.resources.getString("APP_TITLE"));
        this.SingletxtData = string;
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents2();
        this.addComponentsToGrid();
    }

    public void showPrimarySOAData(String string, MainFrame mainFrame, String string2) {
        Object[] objectArray = new Object[]{string};
        this.setTitle(MessageFormat.format(this.resources.getString("DOMAIN_DATA_FRAME_NAME"), objectArray));
        mainFrame.dataOut.sendToServer("PDOM=GET,name=" + string + "," + "EPDOM" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = mainFrame.dataOut.receiveFromServer();
        PrimaryDomain primaryDomain = new PrimaryDomain(dDNSNetworkStringParser.getParsed());
        mainFrame.dataOut.sendToServer("NSO=GET,name=" + string2 + "," + "ENSO" + ",");
        dDNSNetworkStringParser = mainFrame.dataOut.receiveFromServer();
        NameServerObject nameServerObject = new NameServerObject(dDNSNetworkStringParser.getParsed());
        this.txtData = primaryDomain.writeSOARec(mainFrame.getNameServerName(), false);
        this.initComponents();
        String[] stringArray = primaryDomain.writeDynamicRecs();
        if (stringArray != null) {
            this.addMoreText(stringArray);
        }
        if ((stringArray = this.writeDomainData(primaryDomain, nameServerObject.firstName(), nameServerObject.getJustFQNames(), mainFrame)) != null) {
            this.addMoreText(stringArray);
        }
        this.addComponentsToGrid();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void showSecondarySOAData(String string, MainFrame mainFrame, String string2) {
        Object[] objectArray = new Object[]{string};
        this.setTitle(MessageFormat.format(this.resources.getString("DOMAIN_DATA_FRAME_NAME"), objectArray));
        mainFrame.dataOut.sendToServer("SDOM=GET,name=" + string + "," + "ESDOM" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = mainFrame.dataOut.receiveFromServer();
        SecondaryDomain secondaryDomain = new SecondaryDomain(dDNSNetworkStringParser.getParsed());
        mainFrame.dataOut.sendToServer("NSO=GET,name=" + string2 + "," + "ENSO" + ",");
        dDNSNetworkStringParser = mainFrame.dataOut.receiveFromServer();
        new NameServerObject(dDNSNetworkStringParser.getParsed());
        this.txtData = secondaryDomain.writeSOARec(mainFrame.getNameServerName(), false);
        this.initComponents();
        String[] stringArray = secondaryDomain.writeDynamicRecs();
        if (stringArray != null) {
            this.addMoreText(stringArray);
        }
        this.addComponentsToGrid();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void showBootFileData(String string, MainFrame mainFrame) {
        Object[] objectArray = new Object[]{string};
        this.setTitle(MessageFormat.format(this.resources.getString("BOOT_FILE_DATA_FRAME_NAME"), objectArray));
        RequestList requestList = new RequestList(17);
        this.txtData = requestList.getReturnedList(this.resources, mainFrame.dataOut);
        if (this.txtData == null || this.txtData.length == 0) {
            this.txtData = new String[1];
            this.txtData[0] = this.resources.getString("NO_BOOT_FILE_DATA");
        }
        this.initComponents();
        this.addComponentsToGrid();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void showCacheFileData(String string, MainFrame mainFrame) {
        Object[] objectArray = new Object[]{string};
        this.setTitle(MessageFormat.format(this.resources.getString("ROOT_SERVER_DATA_FRAME_NAME"), objectArray));
        mainFrame.dataOut.sendToServer("NSO=GET,name=" + string + "," + "ENSO" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = mainFrame.dataOut.receiveFromServer();
        NameServerObject nameServerObject = new NameServerObject(dDNSNetworkStringParser.getParsed());
        NameAndIpAddressList nameAndIpAddressList = nameServerObject.getRootServers();
        Vector<String> vector = new Vector<String>();
        int n = nameServerObject.getRootNSTTL();
        String string2 = n < 0 ? " " : String.valueOf(n);
        if (nameAndIpAddressList != null) {
            Enumeration enumeration = nameAndIpAddressList.elements();
            while (enumeration.hasMoreElements()) {
                NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
                vector.addElement(".  " + string2 + " IN  NS  " + nameAndIpAddress.getFqName() + ".");
                vector.addElement(String.valueOf(nameAndIpAddress.getFqName()) + "." + string2 + " IN  A  " + nameAndIpAddress.getIpAddress());
            }
        }
        if (!vector.isEmpty()) {
            this.txtData = new String[vector.size()];
            vector.copyInto(this.txtData);
        } else {
            this.txtData = new String[1];
            this.txtData[0] = this.resources.getString("NO_ROOT_SERVER_DATA");
        }
        this.initComponents();
        this.addComponentsToGrid();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void showHostRecords(String string, MainFrame mainFrame, String string2) {
        Object[] objectArray = new Object[]{string, !string2.equals(".") ? string2 : ""};
        this.setTitle(MessageFormat.format(this.resources.getString("RESOURCE_RECORD_FRAME_NAME"), objectArray));
        mainFrame.dataOut.sendToServer("HOST=GET,name=" + string + "," + "dname=" + string2 + "," + "EHOST" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = mainFrame.dataOut.receiveFromServer();
        HostObject hostObject = new HostObject(dDNSNetworkStringParser.getParsed());
        this.txtData = hostObject.writeDataRecords();
        this.initComponents();
        this.addComponentsToGrid();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void showAliasRecords(String string, MainFrame mainFrame, String string2) {
        Object[] objectArray = new Object[]{string, !string2.equals(".") ? string2 : ""};
        this.setTitle(MessageFormat.format(this.resources.getString("RESOURCE_RECORD_FRAME_NAME"), objectArray));
        mainFrame.dataOut.sendToServer("ALIAS=GET,name=" + string + "," + "dname=" + string2 + "," + "EALIAS" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = mainFrame.dataOut.receiveFromServer();
        AliasHostObject aliasHostObject = new AliasHostObject(dDNSNetworkStringParser.getParsed());
        this.txtData = aliasHostObject.writeDataRecords();
        this.initComponents();
        this.addComponentsToGrid();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void showReverseRecords(String string, MainFrame mainFrame, String string2) {
        Object[] objectArray = new Object[]{ReverseHost.reverseAddr(string, string2)};
        this.setTitle(MessageFormat.format(this.resources.getString("REV_HOST_RESOURCE_RECORD_FRAME_NAME"), objectArray));
        mainFrame.dataOut.sendToServer(String.valueOf(ReverseHost.REVH_tag) + "=GET," + "name=" + ReverseHost.reverseAddr(string, string2) + "," + "dname=" + string2 + "," + ReverseHost.EREVH_tag + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = mainFrame.dataOut.receiveFromServer();
        ReverseHost reverseHost = new ReverseHost(dDNSNetworkStringParser.getParsed());
        this.txtData = reverseHost.writeDataRecords();
        this.initComponents();
        this.addComponentsToGrid();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void showReverseReservedRecords(String string, MainFrame mainFrame, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        this.setTitle(MessageFormat.format(this.resources.getString("RESOURCE_RECORD_FRAME_NAME"), objectArray));
        mainFrame.dataOut.sendToServer("RN=GET,name=" + ReverseHost.reverseAddr(string, string2) + "," + "dname=" + string2 + "," + "ERN" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = mainFrame.dataOut.receiveFromServer();
        ReservedName reservedName = new ReservedName(dDNSNetworkStringParser.getParsed());
        this.txtData = reservedName.writeDataRecords();
        this.initComponents();
        this.addComponentsToGrid();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void showReservedRecords(String string, MainFrame mainFrame, String string2) {
        Object[] objectArray = new Object[]{string, !string2.equals(".") ? string2 : ""};
        this.setTitle(MessageFormat.format(this.resources.getString("RESOURCE_RECORD_FRAME_NAME"), objectArray));
        mainFrame.dataOut.sendToServer("RN=GET,name=" + string + "," + "dname=" + string2 + "," + "ERN" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = mainFrame.dataOut.receiveFromServer();
        ReservedName reservedName = new ReservedName(dDNSNetworkStringParser.getParsed());
        this.txtData = reservedName.writeDataRecords();
        this.initComponents();
        this.addComponentsToGrid();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    private void initComponents() {
        this.initButtonPanel();
        this.theTextArea = new RecordsPanel();
        this.theTextArea.setEnabled(false);
        if (this.txtData != null) {
            this.theTextArea.addRecords(this.txtData);
        }
        this.addWindowListener(this);
    }

    private void initComponents2() {
        this.initButtonPanel();
        this.theTextArea = new RecordsPanel();
        this.theTextArea.setEnabled(false);
        this.theTextArea.addRecords(this.SingletxtData);
        this.addWindowListener(this);
    }

    public void addMoreText(String[] stringArray) {
        if (stringArray != null) {
            this.theTextArea.addRecords(stringArray);
        }
    }

    public void addMoreText(String string) {
        if (string != null) {
            this.theTextArea.addRecords(string);
        }
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.theTextArea, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[1];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private String[] writeDomainData(PrimaryDomain primaryDomain, String string, String[] stringArray, MainFrame mainFrame) {
        NameAndIpAddressList nameAndIpAddressList;
        String[] stringArray2;
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement("@     IN    NS  " + stringArray[n] + ".");
                ++n;
            }
        }
        if ((stringArray2 = primaryDomain.getMailExchange()) != null) {
            int n = 0;
            while (n < stringArray2.length) {
                int n2 = primaryDomain.getMailTTL();
                if (!primaryDomain.getDomName().equals(".")) {
                    if (n2 < 0) {
                        vector.addElement(String.valueOf(primaryDomain.getDomName()) + "." + " IN MX   " + stringArray2[n] + ".");
                    } else {
                        vector.addElement(String.valueOf(primaryDomain.getDomName()) + "." + "  " + n2 + " IN MX   " + stringArray2[n] + ".");
                    }
                } else if (n2 < 0) {
                    vector.addElement(String.valueOf(primaryDomain.getDomName()) + " IN MX   " + stringArray2[n] + ".");
                } else {
                    vector.addElement(String.valueOf(primaryDomain.getDomName()) + "  " + n2 + " IN MX   " + stringArray2[n] + ".");
                }
                ++n;
            }
        }
        if ((nameAndIpAddressList = primaryDomain.getNameServerSetforDomain()) != null) {
            Enumeration enumeration = nameAndIpAddressList.elements();
            while (enumeration.hasMoreElements()) {
                NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
                String string2 = nameAndIpAddress.getFqName();
                if (this.alreadyWritten(stringArray, string2)) continue;
                int n = primaryDomain.getNameServerTTL();
                if (!primaryDomain.getDomName().equals(".")) {
                    if (n < 0) {
                        vector.addElement(String.valueOf(primaryDomain.getDomName()) + "." + "   IN NS   " + string2 + ".");
                    } else {
                        vector.addElement(String.valueOf(primaryDomain.getDomName()) + "." + "   " + n + " IN NS   " + string2 + ".");
                    }
                } else if (n < 0) {
                    vector.addElement(String.valueOf(primaryDomain.getDomName()) + "   IN NS   " + string2 + ".");
                } else {
                    vector.addElement(String.valueOf(primaryDomain.getDomName()) + "   " + n + " IN NS   " + string2 + ".");
                }
                if (nameAndIpAddress.getIpAddress().equals("-")) continue;
                if (n < 0) {
                    vector.addElement(String.valueOf(string2) + "." + " IN A   " + nameAndIpAddress.getIpAddress());
                    continue;
                }
                vector.addElement(String.valueOf(string2) + "." + "   " + n + " IN A   " + nameAndIpAddress.getIpAddress());
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean alreadyWritten(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button && (Button)object == this.buttons[0]) {
            this.dispose();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button && (Button)object == this.buttons[0]) {
            this.dispose();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

