/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

class SeparateDataFrame
extends Frame
implements WindowListener,
ActionListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int NUM_BUTTONS = 3;
    public static final int YES_BUTTON = 0;
    public static final int NO_BUTTON = 1;
    public static final int HELP_BUTTON = 2;
    private static final int NUM_TEXT_FIELD_COLUMNS = 40;
    private MainFrame parent;
    private ResourceBundle resources;
    private WrappedTextPanel explanation;
    private List domList;
    private Panel separateDataPanel;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private GridBagLayout gridBag;
    private GridBagConstraints constraints;
    private GridBagLayout gridBagPanel;
    private GridBagConstraints constraintsPanel;

    public SeparateDataFrame(MainFrame mainFrame) {
        this.setResizable(false);
        this.parent = mainFrame;
        this.resources = this.parent.clientResources;
        this.setTitle(this.resources.getString("SEPARATE_DATA_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public boolean anyDomainsExist() {
        return this.domList.getItemCount() > 0;
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.buttonPanel.requestFocus(this.buttons[0]);
                return;
            }
            case 1: {
                this.buttonPanel.requestFocus(this.buttons[1]);
                return;
            }
            case 2: {
                this.buttonPanel.requestFocus(this.buttons[2]);
                return;
            }
        }
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.separateDataPanel = new Panel();
        this.explanation = new WrappedTextPanel(this.resources.getString("SEPARATE_DATA_EXPLANATION_LABEL"));
        this.domList = new List();
        RequestList requestList = new RequestList(16);
        String[] stringArray = requestList.getReturnedList(this.resources, this.parent.dataOut);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.domList.addItem(stringArray[n]);
                ++n;
            }
        }
        this.initButtonPanel();
        this.gridBag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.gridBagPanel = new GridBagLayout();
        this.constraintsPanel = new GridBagConstraints();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        this.setLayout(this.gridBag);
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraintsPanel.fill = 2;
        this.constraintsPanel.anchor = 10;
        this.constraintsPanel.weightx = 1.0;
        this.constraintsPanel.weighty = 1.0;
        this.separateDataPanel.setLayout(this.gridBagPanel);
        this.constrain(this.explanation, this.gridBagPanel, this.constraintsPanel, 0, 0, 0, 1);
        this.separateDataPanel.add(this.explanation);
        this.constrain(this.domList, this.gridBagPanel, this.constraintsPanel, 0, 2, 0, 0);
        this.separateDataPanel.add(this.domList);
        this.add(this.separateDataPanel, this.gridBag, this.constraints, 0, 0, 0, 1);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.add(this.buttonPanel, this.gridBag, this.constraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("YES_BUTTON");
        this.buttonLabels[1] = this.resources.getString("NO_BUTTON");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0]) {
            this.parent.separateDomainData();
            this.dispose();
            this.parent.requestFocus();
        }
        if (button == this.buttons[1]) {
            this.parent.requestFocus();
            this.dispose();
        }
        if (button == this.buttons[2]) {
            this.parent.handleHelp("ddscwnd.htm#HDRWND");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.requestFocus();
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

