/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.QuickSort;
import COM.ibm.raleigh.ddnssgui.common.TreeNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HostList {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String HLIST_tag = new String("HLIST");
    public static final String EHLIST_tag = new String("EHLIST");
    public static final String reqName_tag = new String("ReqName");
    public static final int ALL_HOSTS = 999999;
    private static final String numNode_tag = new String("NumNode");
    private static final String node_tag = new String("Node");
    public static final String startNo_tag = new String("startNo");
    public static final String getNo_tag = new String("getNo");
    private String domName;
    Vector theListOfHosts;
    int startReturnAtNumber;
    int totalNumberToGet;
    int totalNumberHave;

    public static String handleReqForHostList(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        Integer n;
        String string2;
        String string3 = new String("");
        ParsedObject parsedObject2 = parsedVector.getElement(reqName_tag);
        if (parsedObject2 != null && (string2 = (String)parsedObject2.getValue()) != null) {
            string3 = new String(string2);
        }
        int n2 = 0;
        int n3 = 999999;
        parsedObject2 = parsedVector.getElement(startNo_tag);
        if (parsedObject2 != null && (string2 = (String)parsedObject2.getValue()) != null) {
            n = Integer.valueOf(string2);
            n2 = n;
        }
        if ((parsedObject2 = parsedVector.getElement(getNo_tag)) != null && (string2 = (String)parsedObject2.getValue()) != null) {
            n = Integer.valueOf(string2);
            n3 = n;
        }
        Vector vector = configurationManager.getHostsForDomain(string3);
        QuickSort quickSort = new QuickSort();
        try {
            quickSort.sort(vector);
        }
        catch (Exception exception) {}
        HostList hostList = new HostList(string3, vector, n2, n3);
        return hostList.toString();
    }

    public HostList(String string) {
        this.domName = new String(string);
        this.startReturnAtNumber = 0;
        this.totalNumberToGet = 999999;
    }

    public HostList(String string, int n, int n2) {
        this.domName = new String(string);
        this.startReturnAtNumber = n;
        this.totalNumberToGet = n2;
    }

    public HostList(String string, Vector vector) {
        this.domName = new String(string);
        this.theListOfHosts = vector;
        this.startReturnAtNumber = 0;
        this.totalNumberToGet = 999999;
    }

    public HostList(String string, Vector vector, int n, int n2) {
        this.domName = new String(string);
        this.theListOfHosts = vector;
        this.startReturnAtNumber = n;
        this.totalNumberToGet = n2;
    }

    public HostList(ParsedVector parsedVector, Hashtable hashtable) {
        this.theListOfHosts = null;
        this.domName = new String("");
        this.theListOfHosts = this.fromString(parsedVector, hashtable);
    }

    public int getStartNo() {
        return this.startReturnAtNumber;
    }

    public int getReturnedNo() {
        return this.totalNumberToGet + 1;
    }

    public int getAllNo() {
        return this.totalNumberHave;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(HLIST_tag);
        stringBuffer.append("," + reqName_tag + "=" + this.domName);
        if (this.theListOfHosts != null) {
            if (!this.theListOfHosts.isEmpty()) {
                stringBuffer.append("," + numNode_tag + "=" + this.theListOfHosts.size());
                stringBuffer.append("," + startNo_tag + "=" + this.startReturnAtNumber);
                int n = this.totalNumberToGet == 999999 ? this.theListOfHosts.size() : this.totalNumberToGet;
                Enumeration enumeration = this.theListOfHosts.elements();
                int n2 = 0;
                while (n2 < this.startReturnAtNumber) {
                    enumeration.nextElement();
                    ++n2;
                }
                n2 = 0;
                while (enumeration.hasMoreElements() && n2 < n) {
                    TreeNode treeNode = (TreeNode)enumeration.nextElement();
                    stringBuffer.append("," + node_tag + "," + treeNode.toNetString());
                    ++n2;
                }
                stringBuffer.append("," + getNo_tag + "=" + String.valueOf(n2 - 1));
            } else {
                stringBuffer.append("," + numNode_tag + "=0");
                stringBuffer.append("," + getNo_tag + "=" + this.totalNumberToGet);
                stringBuffer.append("," + startNo_tag + "=" + this.startReturnAtNumber);
            }
        } else {
            stringBuffer.append("," + numNode_tag + "=0");
            stringBuffer.append("," + getNo_tag + "=" + this.totalNumberToGet);
            stringBuffer.append("," + startNo_tag + "=" + this.startReturnAtNumber);
        }
        stringBuffer.append("," + EHLIST_tag + ",");
        return stringBuffer.toString();
    }

    public Vector getTheList() {
        return this.theListOfHosts;
    }

    public Vector fromString(ParsedVector parsedVector, Hashtable hashtable) {
        Integer n;
        ParsedObject parsedObject = parsedVector.getElement(numNode_tag);
        String string = (String)parsedObject.getValue();
        if (string != null) {
            n = Integer.valueOf(string);
            this.totalNumberHave = n;
            if (this.totalNumberHave == 0) {
                return null;
            }
        }
        if ((string = (String)(parsedObject = parsedVector.getElement(startNo_tag)).getValue()) != null) {
            n = Integer.valueOf(string);
            this.startReturnAtNumber = n;
        }
        if ((string = (String)(parsedObject = parsedVector.getElement(getNo_tag)).getValue()) != null) {
            n = Integer.valueOf(string);
            this.totalNumberToGet = n;
            if (this.totalNumberToGet == 999999) {
                this.totalNumberToGet = this.totalNumberHave;
            }
        }
        Vector<TreeNode> vector = new Vector<TreeNode>(this.totalNumberHave);
        boolean bl = false;
        String[] stringArray = parsedVector.getKeys();
        int n2 = 0;
        while (n2 < stringArray.length) {
            ParsedVector parsedVector2;
            if (stringArray[n2].equals(node_tag) && (parsedVector2 = (ParsedVector)(parsedObject = parsedVector.get(n2)).getValue()) != null) {
                vector.addElement(new TreeNode(parsedVector2, hashtable));
            }
            ++n2;
        }
        return vector;
    }
}

