/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DDNSStringTranslator;
import COM.ibm.raleigh.ddnssgui.common.HostOrAlias;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.Platform;
import COM.ibm.raleigh.ddnssgui.common.PlatformList;
import java.util.Vector;

public class HostObject
extends HostOrAlias {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String HOST_tag = "HOST";
    public static final String EHOST_tag = "EHOST";
    private static final String numAddr_tag = "NumAddr";
    private static final String addr_tag = "Addr";
    private static final String cPU_tag = "CPUL";
    private static final String numMx_tag = "NumMx";
    private static final String mX_tag = "MX";
    private static final String numTxt_tag = "NumTxt";
    private static final String tXT_tag = "TXT";
    private static final String aTTL_tag = "ATTL";
    private static final String pTRTTL_tag = "PTRTTL";
    private static final String xTTL_tag = "XTTL";
    private static final String hTTL_tag = "HTTL";
    private static final String tTTL_tag = "TTTL";
    private static final String base_tag = "super";
    private Vector ipAddress;
    private PlatformList cPUtypeAndOpSys;
    private Vector mailExchange;
    private Vector textEntryField;
    private int arecTTL;
    private int pTRrecTTL;
    private int mXrecTTL;
    private int hINFOrecTTL;
    private int tXTrecTTL;

    public static String handleHostActions(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        HostObject hostObject;
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        ParsedObject parsedObject2 = parsedVector.getElement("dname");
        String string2 = parsedObject2 != null ? new String((String)parsedObject2.getValue()) : new String("");
        if (parsedObject.getValue().equals("ADD")) {
            HostObject hostObject2 = new HostObject(parsedVector);
            bl = configurationManager.giveAHost(hostObject2, string2);
        } else if (parsedObject.getValue().equals("MOD")) {
            HostObject hostObject3 = new HostObject(parsedVector);
            bl = configurationManager.updateAHost(hostObject3, string2, parsedVector);
        } else if (parsedObject.getValue().equals("DEL")) {
            parsedObject = parsedVector.getElement("name");
            if (parsedObject != null) {
                bl = configurationManager.deleteAHost((String)parsedObject.getValue(), string2);
            }
        } else if (parsedObject.getValue().equals("LNK")) {
            HostObject hostObject4 = new HostObject(parsedVector);
            HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(hostObject4.getHostName(), string2);
            if (hostOrAlias != null) {
                configurationManager.linkHost(hostOrAlias, string2);
            }
            bl = true;
        } else if (parsedObject.getValue().equals("GET") && (parsedObject = parsedVector.getElement("name")) != null && (hostObject = (HostObject)configurationManager.getAHost((String)parsedObject.getValue(), string2)) != null) {
            stringBuffer = new StringBuffer(hostObject.toString("GET"));
            bl = true;
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    public HostObject() {
        this.setDefaults();
    }

    public HostObject(ParsedVector parsedVector) {
        this.setDefaults();
        this.fromString(parsedVector);
    }

    public void addIpAddress(String string) {
        this.ipAddress.addElement(string);
    }

    public void setIpAddress(String string) {
        this.ipAddress = new Vector();
        this.ipAddress.addElement(string);
    }

    public String getAnIpAddress() {
        if (!this.ipAddress.isEmpty()) {
            return (String)this.ipAddress.elementAt(0);
        }
        return null;
    }

    public void addAllIpAddresses(String[] stringArray) {
        this.ipAddress = new Vector(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.ipAddress.addElement(stringArray[n]);
            ++n;
        }
    }

    public void addCpuOpSys(String string, String string2) {
        this.cPUtypeAndOpSys.addPlatform(new Platform(string, string2));
    }

    public void addCpuOpSys(Platform platform) {
        this.cPUtypeAndOpSys.addPlatform(platform);
    }

    public void setCpuOpSys(PlatformList platformList) {
        this.cPUtypeAndOpSys = new PlatformList(platformList);
    }

    public void setMailExchange(String[] stringArray) {
        this.mailExchange = new Vector(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.mailExchange.addElement(stringArray[n]);
            ++n;
        }
    }

    public void addMailExchange(String string) {
        if (string.endsWith(".")) {
            this.mailExchange.addElement(string.substring(0, string.length() - 1));
            return;
        }
        this.mailExchange.addElement(string);
    }

    public void setTextEntry(String[] stringArray) {
        this.textEntryField = new Vector(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.textEntryField.addElement(stringArray[n]);
            ++n;
        }
    }

    public void addTextEntry(String string) {
        this.textEntryField.addElement(string);
    }

    public String[] getAllIpAddresses() {
        Object[] objectArray = null;
        if (this.ipAddress.isEmpty()) {
            return null;
        }
        objectArray = new String[this.ipAddress.size()];
        this.ipAddress.copyInto(objectArray);
        return objectArray;
    }

    public PlatformList getCpuOpSys() {
        return this.cPUtypeAndOpSys;
    }

    public String[] getMailExchange() {
        Object[] objectArray = null;
        if (this.mailExchange.isEmpty()) {
            return null;
        }
        objectArray = new String[this.mailExchange.size()];
        this.mailExchange.copyInto(objectArray);
        return objectArray;
    }

    public String[] getTextEntry() {
        if (this.textEntryField.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[this.textEntryField.size()];
        this.textEntryField.copyInto(objectArray);
        return objectArray;
    }

    public void setATTL(int n) {
        this.arecTTL = n;
    }

    public void setGreaterATTL(int n) {
        if (this.arecTTL < n) {
            this.arecTTL = n;
        }
    }

    public int getATTL() {
        return this.arecTTL;
    }

    public void setPTRTTL(int n) {
        this.pTRrecTTL = n;
    }

    public void setGreaterPTRTTL(int n) {
        if (this.pTRrecTTL < n) {
            this.pTRrecTTL = n;
        }
    }

    public int getPTRTTL() {
        return this.pTRrecTTL;
    }

    public void setTXTTTL(int n) {
        this.tXTrecTTL = n;
    }

    public void setGreaterTXTTTL(int n) {
        if (this.tXTrecTTL < n) {
            this.tXTrecTTL = n;
        }
    }

    public int getTXTTTL() {
        return this.tXTrecTTL;
    }

    public void setMXTTL(int n) {
        this.mXrecTTL = n;
    }

    public void setGreaterMXTTL(int n) {
        if (this.mXrecTTL < n) {
            this.mXrecTTL = n;
        }
    }

    public int getMXTTL() {
        return this.mXrecTTL;
    }

    public void setHINFOTTL(int n) {
        this.hINFOrecTTL = n;
    }

    public void setGreaterHINFOTTL(int n) {
        if (this.hINFOrecTTL < n) {
            this.hINFOrecTTL = n;
        }
    }

    public int getHINFOTTL() {
        return this.hINFOrecTTL;
    }

    public String[] writeDataRecords() {
        Object object;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        String string;
        StringBuffer stringBuffer3;
        StringBuffer stringBuffer4;
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = null;
        boolean bl = false;
        StringBuffer stringBuffer5 = new StringBuffer(" ");
        int n = 0;
        while (n < this.hostName.length()) {
            stringBuffer5.append(" ");
            ++n;
        }
        if (!this.ipAddress.isEmpty()) {
            n = 0;
            while (n < this.ipAddress.size()) {
                if (this.arecTTL >= 0) {
                    stringBuffer4 = new StringBuffer(String.valueOf(this.hostName) + " " + String.valueOf(this.arecTTL) + " IN    A   ");
                    stringBuffer3 = new StringBuffer(String.valueOf(stringBuffer5.toString()) + String.valueOf(this.arecTTL) + " IN    A   ");
                } else {
                    stringBuffer4 = new StringBuffer(String.valueOf(this.hostName) + " IN    A   ");
                    stringBuffer3 = new StringBuffer(String.valueOf(stringBuffer5.toString()) + " IN    A   ");
                }
                string = new String();
                try {
                    string = (String)this.ipAddress.elementAt(n);
                    if (!bl) {
                        stringBuffer2 = stringBuffer4.append(string);
                        bl = true;
                    } else {
                        stringBuffer2 = stringBuffer3.append(string);
                    }
                    vector.addElement(stringBuffer2.toString());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (!this.cPUtypeAndOpSys.isEmpty()) {
            if (this.hINFOrecTTL >= 0) {
                stringBuffer3 = new StringBuffer(String.valueOf(stringBuffer5.toString()) + String.valueOf(this.hINFOrecTTL) + " IN    HINFO   ");
                stringBuffer = new StringBuffer(String.valueOf(this.hostName) + " " + String.valueOf(this.hINFOrecTTL) + " IN    HINFO   ");
            } else {
                stringBuffer3 = new StringBuffer(String.valueOf(stringBuffer5.toString()) + " IN    HINFO   ");
                stringBuffer = new StringBuffer(String.valueOf(this.hostName) + " IN    HINFO   ");
            }
            n = 0;
            while (n < this.cPUtypeAndOpSys.size()) {
                stringBuffer4 = bl ? new StringBuffer(stringBuffer3.toString()) : new StringBuffer(stringBuffer.toString());
                string = new String();
                try {
                    object = this.cPUtypeAndOpSys.getPlatform(n);
                    string = new String("\"" + ((Platform)object).getCPU() + "\"  \"" + ((Platform)object).getOS() + "\"");
                    stringBuffer2 = stringBuffer4.append(string);
                    if (!bl) {
                        stringBuffer4 = new StringBuffer(stringBuffer3.toString());
                        bl = true;
                    }
                    vector.addElement(stringBuffer2.toString());
                    bl = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (!this.mailExchange.isEmpty()) {
            if (this.mXrecTTL >= 0) {
                stringBuffer3 = new StringBuffer(String.valueOf(stringBuffer5.toString()) + String.valueOf(this.mXrecTTL) + " IN    MX   ");
                stringBuffer = new StringBuffer(String.valueOf(this.hostName) + " " + String.valueOf(this.mXrecTTL) + " IN    MX   ");
            } else {
                stringBuffer3 = new StringBuffer(String.valueOf(stringBuffer5.toString()) + " IN    MX   ");
                stringBuffer = new StringBuffer(String.valueOf(this.hostName) + " IN    MX   ");
            }
            n = 0;
            while (n < this.mailExchange.size()) {
                stringBuffer4 = bl ? new StringBuffer(stringBuffer3.toString()) : new StringBuffer(stringBuffer.toString());
                string = new String();
                try {
                    string = (String)this.mailExchange.elementAt(n);
                    stringBuffer2 = stringBuffer4.append(String.valueOf(string) + ".");
                    if (!bl) {
                        stringBuffer4 = new StringBuffer(stringBuffer3.toString());
                        bl = true;
                    }
                    vector.addElement(stringBuffer2.toString());
                    bl = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (!this.textEntryField.isEmpty()) {
            if (this.tXTrecTTL >= 0) {
                stringBuffer3 = new StringBuffer(String.valueOf(stringBuffer5.toString()) + String.valueOf(this.tXTrecTTL) + " IN    TXT   ");
                stringBuffer = new StringBuffer(String.valueOf(this.hostName) + " " + String.valueOf(this.tXTrecTTL) + " IN    TXT   ");
            } else {
                stringBuffer3 = new StringBuffer(String.valueOf(stringBuffer5.toString()) + " IN    TXT   ");
                stringBuffer = new StringBuffer(String.valueOf(this.hostName) + " IN    TXT   ");
            }
            n = 0;
            while (n < this.textEntryField.size()) {
                stringBuffer4 = bl ? new StringBuffer(stringBuffer3.toString()) : new StringBuffer(stringBuffer.toString());
                string = new String();
                try {
                    string = (String)this.textEntryField.elementAt(n);
                    object = new DDNSStringTranslator(string);
                    if (string.indexOf(" ") < 0) {
                        stringBuffer2 = stringBuffer4.append(((DDNSStringTranslator)object).toEscapedString());
                    } else {
                        stringBuffer2 = !string.startsWith("\\\"") ? stringBuffer4.append("\"" + ((DDNSStringTranslator)object).toEscapedString()) : stringBuffer4.append(((DDNSStringTranslator)object).toEscapedString());
                        if (!string.endsWith("\\\"")) {
                            stringBuffer2.append("\"");
                        }
                    }
                    if (!bl) {
                        stringBuffer4 = new StringBuffer(stringBuffer3.toString());
                        bl = true;
                    }
                    vector.addElement(stringBuffer2.toString());
                    bl = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (!this.otherRecords.isEmpty()) {
            n = 0;
            while (n < this.otherRecords.size()) {
                stringBuffer4 = new StringBuffer(this.hostName);
                stringBuffer3 = new StringBuffer(stringBuffer5.toString());
                string = new String();
                try {
                    string = (String)this.otherRecords.elementAt(n);
                    if (!bl) {
                        stringBuffer2 = stringBuffer4.append(string);
                        bl = true;
                    } else {
                        stringBuffer2 = stringBuffer3.append(string);
                    }
                    vector.addElement(stringBuffer2.toString());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (!this.sIGRecords.isEmpty()) {
            n = 0;
            while (n < this.sIGRecords.size()) {
                stringBuffer4 = new StringBuffer(String.valueOf(this.hostName) + " ");
                stringBuffer3 = new StringBuffer(stringBuffer5.toString());
                string = new String();
                try {
                    string = (String)this.sIGRecords.elementAt(n);
                    if (!bl) {
                        stringBuffer2 = stringBuffer4.append(string);
                        bl = true;
                    } else {
                        stringBuffer2 = stringBuffer3.append(string);
                    }
                    vector.addElement(stringBuffer2.toString());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (!this.kEYRecords.isEmpty()) {
            n = 0;
            while (n < this.kEYRecords.size()) {
                stringBuffer4 = new StringBuffer(String.valueOf(this.hostName) + " ");
                stringBuffer3 = new StringBuffer(stringBuffer5.toString());
                string = new String();
                try {
                    string = (String)this.kEYRecords.elementAt(n);
                    if (!bl) {
                        stringBuffer2 = stringBuffer4.append(string);
                        bl = true;
                    } else {
                        stringBuffer2 = stringBuffer3.append(string);
                    }
                    vector.addElement(stringBuffer2.toString());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void Dump() {
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("HOST=" + string);
        stringBuffer.append(this.buildRestOfString());
        stringBuffer.append(",EHOST,");
        return stringBuffer.toString();
    }

    public String toString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("HOST=" + string);
        stringBuffer.append("," + string2);
        stringBuffer.append(this.buildRestOfString());
        stringBuffer.append(",EHOST,");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            int n3;
            Integer n4;
            String string;
            ParsedVector parsedVector2;
            ParsedObject parsedObject;
            if (stringArray[n].equals(base_tag)) {
                parsedObject = parsedVector.getElement(base_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    super.fromString(parsedVector2);
                }
            } else if (stringArray[n].equals(aTTL_tag)) {
                parsedObject = parsedVector.getElement(aTTL_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    this.arecTTL = n4;
                }
            } else if (stringArray[n].equals(pTRTTL_tag)) {
                parsedObject = parsedVector.getElement(pTRTTL_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    this.pTRrecTTL = n4;
                }
            } else if (stringArray[n].equals(xTTL_tag)) {
                parsedObject = parsedVector.getElement(xTTL_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    this.mXrecTTL = n4;
                }
            } else if (stringArray[n].equals(hTTL_tag)) {
                parsedObject = parsedVector.getElement(hTTL_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    this.hINFOrecTTL = n4;
                }
            } else if (stringArray[n].equals(tTTL_tag)) {
                parsedObject = parsedVector.getElement(tTTL_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    this.tXTrecTTL = n4;
                }
            } else if (stringArray[n].equals(numAddr_tag)) {
                parsedObject = parsedVector.getElement(numAddr_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    n3 = n4;
                    if (n3 > 0) {
                        this.ipAddress = new Vector(n3);
                        n2 = 1;
                        while (n2 <= n3) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.ipAddress.addElement(new String(string));
                            }
                            ++n2;
                        }
                    } else {
                        this.ipAddress = new Vector();
                    }
                } else {
                    this.ipAddress = new Vector();
                }
            } else if (stringArray[n].equals(cPU_tag)) {
                parsedObject = parsedVector.getElement(cPU_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.cPUtypeAndOpSys = parsedVector2 != null ? new PlatformList(parsedVector2) : new PlatformList();
            } else if (stringArray[n].equals(numTxt_tag)) {
                parsedObject = parsedVector.getElement(numTxt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    n3 = n4;
                    if (n3 > 0) {
                        this.textEntryField = new Vector(n3);
                        n2 = 1;
                        while (n2 <= n3) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.textEntryField.addElement(new String(string));
                            }
                            ++n2;
                        }
                    } else {
                        this.textEntryField = new Vector();
                    }
                } else {
                    this.textEntryField = new Vector();
                }
            } else if (stringArray[n].equals(numMx_tag)) {
                parsedObject = parsedVector.getElement(numMx_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    n3 = n4;
                    if (n3 > 0) {
                        this.mailExchange = new Vector(n3);
                        n2 = 1;
                        while (n2 <= n3) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.mailExchange.addElement(new String(string));
                            }
                            ++n2;
                        }
                    } else {
                        this.mailExchange = new Vector();
                    }
                } else {
                    this.mailExchange = new Vector();
                }
            }
            ++n;
        }
    }

    private void setDefaults() {
        this.ipAddress = new Vector();
        this.cPUtypeAndOpSys = new PlatformList();
        this.mailExchange = new Vector();
        this.textEntryField = new Vector();
        this.arecTTL = -1;
        this.pTRrecTTL = -1;
        this.tXTrecTTL = -1;
        this.mXrecTTL = -1;
        this.hINFOrecTTL = -1;
    }

    private String buildRestOfString() {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(",super," + super.toString());
        stringBuffer.append(",ATTL=" + String.valueOf(this.arecTTL));
        stringBuffer.append(",PTRTTL=" + String.valueOf(this.pTRrecTTL));
        stringBuffer.append(",XTTL=" + String.valueOf(this.mXrecTTL));
        stringBuffer.append(",HTTL=" + String.valueOf(this.hINFOrecTTL));
        stringBuffer.append(",TTTL=" + String.valueOf(this.tXTrecTTL));
        if (!this.ipAddress.isEmpty()) {
            stringBuffer.append(",NumAddr=" + String.valueOf(this.ipAddress.size()));
            n = 0;
            while (n < this.ipAddress.size()) {
                try {
                    string = (String)this.ipAddress.elementAt(n);
                    stringBuffer.append(",Addr=" + string);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        } else {
            stringBuffer.append(",NumAddr=0");
        }
        if (!this.cPUtypeAndOpSys.isEmpty()) {
            stringBuffer.append(",CPUL");
            stringBuffer.append("," + this.cPUtypeAndOpSys.toString());
        } else {
            stringBuffer.append(",CPUL");
        }
        if (!this.mailExchange.isEmpty()) {
            stringBuffer.append(",NumMx=" + String.valueOf(this.mailExchange.size()));
            n = 0;
            while (n < this.mailExchange.size()) {
                try {
                    string = (String)this.mailExchange.elementAt(n);
                    stringBuffer.append(",MX=" + string);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        } else {
            stringBuffer.append(",NumMx=0");
        }
        if (!this.textEntryField.isEmpty()) {
            stringBuffer.append(",NumTxt=" + String.valueOf(this.textEntryField.size()));
            n = 0;
            while (n < this.textEntryField.size()) {
                try {
                    string = (String)this.textEntryField.elementAt(n);
                    stringBuffer.append(",TXT=\"" + string + "\"");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        } else {
            stringBuffer.append(",NumTxt=0");
        }
        return stringBuffer.toString();
    }
}

