/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DomainObject;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import java.util.Vector;

public class SecondaryDomain
extends DomainObject {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String SDOM_tag = "SDOM";
    public static final String ESDOM_tag = "ESDOM";
    private static final String numMast_tag = "NumMast";
    private static final String mast_tag = "Mast";
    private static final String base_tag = "super";
    private Vector masterServersForDomain = new Vector();

    public static String handleSecondaryDomainActions(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        SecondaryDomain secondaryDomain;
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        if (parsedObject.getValue().equals("ADD")) {
            SecondaryDomain secondaryDomain2 = new SecondaryDomain(parsedVector);
            configurationManager.giveADomain(secondaryDomain2);
            bl = true;
        } else if (parsedObject.getValue().equals("MOD")) {
            SecondaryDomain secondaryDomain3 = new SecondaryDomain(parsedVector);
            bl = configurationManager.updateADomain(secondaryDomain3.getDomName(), parsedVector);
        } else if (parsedObject.getValue().equals("DEL")) {
            parsedObject = parsedVector.getElement("name");
            if (parsedObject != null) {
                bl = configurationManager.deleteADomain((String)parsedObject.getValue());
            }
        } else if (parsedObject.getValue().equals("LNK")) {
            ParsedObject parsedObject2 = parsedVector.getElement("NameServ");
            String string2 = parsedObject2 != null ? new String((String)parsedObject2.getValue()) : new String("");
            NameServerObject nameServerObject = configurationManager.getANameServer(string2);
            SecondaryDomain secondaryDomain4 = new SecondaryDomain(parsedVector);
            if (nameServerObject != null) {
                configurationManager.linkDomain(secondaryDomain4, nameServerObject);
                bl = true;
            }
        } else if (parsedObject.getValue().equals("GET") && (parsedObject = parsedVector.getElement("name")) != null && (secondaryDomain = (SecondaryDomain)configurationManager.getADomain((String)parsedObject.getValue())) != null) {
            stringBuffer = new StringBuffer(secondaryDomain.toString("GET"));
            bl = true;
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    public SecondaryDomain() {
    }

    public SecondaryDomain(ParsedVector parsedVector) {
        this.fromString(parsedVector);
    }

    public void addMasterServer(String string) {
        if (string != null) {
            this.masterServersForDomain.addElement(string);
        }
    }

    public boolean areMasterServers() {
        return !this.masterServersForDomain.isEmpty();
    }

    public void setMasterServersforDomain(String[] stringArray) {
        if (stringArray != null) {
            this.masterServersForDomain = new Vector(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.masterServersForDomain.addElement(stringArray[n]);
                ++n;
            }
            return;
        }
        this.masterServersForDomain = new Vector();
    }

    public String[] getMasterServersforDomain() {
        if (this.masterServersForDomain.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[this.masterServersForDomain.size()];
        int n = 0;
        while (n < this.masterServersForDomain.size()) {
            String string;
            try {
                string = (String)this.masterServersForDomain.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            stringArray[n] = string;
            ++n;
        }
        return stringArray;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("SDOM=" + string);
        stringBuffer.append(",super," + super.toString());
        stringBuffer.append(this.buildRestOfString());
        return stringBuffer.toString();
    }

    public String toString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("SDOM=" + string);
        stringBuffer.append("," + string2 + "," + base_tag + "," + super.toString());
        stringBuffer.append(this.buildRestOfString());
        return stringBuffer.toString();
    }

    private String buildRestOfString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.masterServersForDomain.isEmpty()) {
            stringBuffer.append(",NumMast=" + String.valueOf(this.masterServersForDomain.size()));
            int n = 0;
            while (n < this.masterServersForDomain.size()) {
                try {
                    String string = (String)this.masterServersForDomain.elementAt(n);
                    stringBuffer.append(",Mast=" + string);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        } else {
            stringBuffer.append(",NumMast=0");
        }
        stringBuffer.append(",ESDOM,");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(base_tag)) {
                parsedObject = parsedVector.getElement(base_tag);
                ParsedVector parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    super.fromString(parsedVector2);
                }
            } else if (stringArray[n].equals(numMast_tag) && (string = (String)(parsedObject = parsedVector.getElement(numMast_tag)).getValue()) != null) {
                Integer n2 = Integer.valueOf(string);
                int n3 = n2;
                if (n3 > 0) {
                    this.masterServersForDomain = new Vector(n3);
                    int n4 = 1;
                    while (n4 <= n3) {
                        parsedObject = parsedVector.get(n + n4);
                        string = (String)parsedObject.getValue();
                        if (string != null) {
                            this.masterServersForDomain.addElement(new String(string));
                        }
                        ++n4;
                    }
                } else {
                    this.masterServersForDomain = new Vector();
                }
            }
            ++n;
        }
    }
}

