/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.AliasHostObject;
import COM.ibm.raleigh.ddnssgui.common.AnIncludeFile;
import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DDNSStringTranslator;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.DomainObject;
import COM.ibm.raleigh.ddnssgui.common.FileEntry;
import COM.ibm.raleigh.ddnssgui.common.FileItem;
import COM.ibm.raleigh.ddnssgui.common.HostObject;
import COM.ibm.raleigh.ddnssgui.common.HostOrAlias;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.Platform;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import COM.ibm.raleigh.ddnssgui.common.ReservedName;
import COM.ibm.raleigh.ddnssgui.common.RootDomainFileEntry;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.TheDomainFile;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import java.io.BufferedWriter;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class TheRootDomainFile
extends TheDomainFile {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String ROOT_DOMAIN_REPLACEMENT_STRING = "123-ROOT-321";
    String originalDomainName;

    public TheRootDomainFile(String string, TraceClient traceClient, ResourceBundle resourceBundle) {
        super(string, traceClient, resourceBundle);
        this.originalDomainName = new String(string);
        if (this.theDomain.equals(".")) {
            this.theDomain = new String(ROOT_DOMAIN_REPLACEMENT_STRING);
        }
    }

    public String processLineFromFile(String string, String string2, String string3) {
        String string4 = string2;
        RootDomainFileEntry rootDomainFileEntry = new RootDomainFileEntry(string, string4, this.theStrings);
        if (rootDomainFileEntry.getRecType().equals("$INCLUDE")) {
            if (this.isUniqueIncludeFileName(rootDomainFileEntry.getRecordData(), string3)) {
                this.addIncl(rootDomainFileEntry.getRecordData());
                string4 = rootDomainFileEntry.getOriginFromInclude(string4);
                AnIncludeFile anIncludeFile = new AnIncludeFile(this.theDomain, this.theTrace, this, this.theStrings);
                boolean bl = anIncludeFile.readFile(DDNSUtility.stripFileName(rootDomainFileEntry.getRecordData()), string4);
                if (!bl) {
                    this.addErrors(rootDomainFileEntry);
                }
            } else {
                this.addErrors(rootDomainFileEntry);
            }
        } else if (rootDomainFileEntry.getRecType().equals("$ORIGIN")) {
            if ((string4 = string4.equals(".") && this.originalDomainName.equals(".") ? ROOT_DOMAIN_REPLACEMENT_STRING : rootDomainFileEntry.getRecordData()).equals(".") && this.originalDomainName.equals(".")) {
                string4 = ROOT_DOMAIN_REPLACEMENT_STRING;
            }
            if (string4.equals("@")) {
                string4 = new String(String.valueOf(this.theDomain) + ".");
            }
        } else if (rootDomainFileEntry.areErrors()) {
            this.addErrors(rootDomainFileEntry);
        } else {
            this.addToFile(rootDomainFileEntry.getRecType(), rootDomainFileEntry);
        }
        return string4;
    }

    public void finishResolving(ConfigurationManager configurationManager) {
        Object object;
        String string;
        String string2;
        FileEntry fileEntry;
        int n;
        DomainObject domainObject = configurationManager.getADomain(this.theDomain);
        NameServerObject nameServerObject = configurationManager.getFirstNameServer();
        if (!this.nameServerRecords.isEmpty()) {
            n = 0;
            while (n < this.nameServerRecords.size()) {
                String string3;
                fileEntry = (FileEntry)this.nameServerRecords.elementAt(n);
                string2 = fileEntry.getRecordData();
                string = fileEntry.getUnqualifiedRecordData(this.theDomain);
                object = fileEntry.getOwnerName();
                if (((String)object).equals(".")) {
                    object = ROOT_DOMAIN_REPLACEMENT_STRING;
                }
                int n2 = fileEntry.getTTL();
                if (string.indexOf(".") < 0) {
                    HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(string2);
                    string3 = "-";
                    if (hostOrAlias == null) {
                        this.addErrors(fileEntry);
                    } else if (hostOrAlias instanceof HostObject) {
                        string3 = ((HostObject)hostOrAlias).getAnIpAddress();
                    }
                    if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                        if (!nameServerObject.isMyNameServerName(string2)) {
                            domainObject.addNameServerforDomain(string2, string3);
                        }
                        domainObject.setGreaterNameServerTTL(n2);
                    } else {
                        domainObject.addChildNameServer(string2, string3, (String)object, fileEntry.getAllComments());
                        domainObject.setGreaterNameServerTTL(n2);
                    }
                } else {
                    int n3 = string.lastIndexOf(".");
                    if (n3 <= 0) {
                        this.addErrors(fileEntry);
                    } else {
                        string3 = string.substring(n3 + 1);
                        Vector vector = this.findCorrespondingA(string2);
                        if (domainObject.isAChildDomain(string3) || this.isLaterInList(String.valueOf(string3) + "." + this.theDomain)) {
                            if (vector.isEmpty()) {
                                String string4 = domainObject.getNameServerAddrFor(string2);
                                if (string4 == null) {
                                    string4 = domainObject.getChildNameServerAddrFor(string2);
                                }
                                if (string4 == null) {
                                    this.addErrors(fileEntry);
                                } else {
                                    if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                                        if (!nameServerObject.isMyNameServerName(string2)) {
                                            domainObject.addNameServerforDomain(string2, string4);
                                        }
                                    } else {
                                        domainObject.addChildNameServer(string2, string4, (String)object, fileEntry.getAllComments());
                                    }
                                    domainObject.setGreaterNameServerTTL(n2);
                                }
                            } else {
                                int n4 = 0;
                                while (n4 < vector.size()) {
                                    if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                                        if (!nameServerObject.isMyNameServerName(string2)) {
                                            domainObject.addNameServerforDomain(string2, (String)vector.elementAt(n4));
                                        }
                                    } else {
                                        domainObject.addChildNameServer(string2, (String)vector.elementAt(n4), (String)object, fileEntry.getAllComments());
                                    }
                                    domainObject.setGreaterNameServerTTL(n2);
                                    ++n4;
                                }
                            }
                        } else if (vector.isEmpty()) {
                            String string5 = domainObject.getNameServerAddrFor(string2);
                            if (string5 == null) {
                                string5 = domainObject.getChildNameServerAddrFor(string2);
                            }
                            if (string5 == null) {
                                string5 = "-";
                            }
                            if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                                if (!nameServerObject.isMyNameServerName(string2)) {
                                    domainObject.addNameServerforDomain(string2, string5);
                                }
                            } else {
                                domainObject.addChildNameServer(string2, string5, (String)object, fileEntry.getAllComments());
                            }
                            domainObject.setGreaterNameServerTTL(n2);
                        } else {
                            int n5 = 0;
                            while (n5 < vector.size()) {
                                HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(string2);
                                if (hostOrAlias != null) {
                                    ((HostObject)hostOrAlias).addIpAddress((String)vector.elementAt(n5));
                                } else {
                                    HostObject hostObject = new HostObject();
                                    hostObject.setHostName(string);
                                    hostObject.addIpAddress((String)vector.elementAt(n5));
                                }
                                if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                                    if (!nameServerObject.isMyNameServerName(string2)) {
                                        domainObject.addNameServerforDomain(string2, (String)vector.elementAt(n5));
                                    }
                                } else {
                                    domainObject.addChildNameServer(string2, (String)vector.elementAt(n5), (String)object, fileEntry.getAllComments());
                                }
                                domainObject.setGreaterNameServerTTL(n2);
                                ++n5;
                            }
                        }
                    }
                }
                ++n;
            }
        }
        if (!this.pendingObjects.isEmpty()) {
            n = 0;
            while (n < this.pendingObjects.size()) {
                fileEntry = (FileEntry)this.pendingObjects.elementAt(n);
                string2 = fileEntry.getRecordData();
                string = fileEntry.getUnqualifiedOwnerName(this.theDomain);
                if (string.equalsIgnoreCase(this.theDomain)) {
                    object = configurationManager.getADomain(this.theDomain);
                    if (object != null) {
                        this.pendingComments = new Vector();
                        this.giveCommentsToEntry((FileItem)object, fileEntry);
                        if (fileEntry.getRecType().equals("SIG")) {
                            ((FileItem)object).addSIGRec(string2);
                        } else if (fileEntry.getRecType().equals("KEY")) {
                            ((FileItem)object).addKEYRec(string2);
                        }
                        ((FileItem)object).setDataDynamic(true);
                    } else {
                        this.addErrors(fileEntry);
                    }
                } else {
                    object = (HostOrAlias)configurationManager.getAHost(string, this.theDomain);
                    if (object == null) {
                        ReservedName reservedName = new ReservedName(string);
                        reservedName.setDataDynamic(true);
                        if (fileEntry.getRecType().equals("SIG")) {
                            reservedName.addSIGRec(string2);
                        } else if (fileEntry.getRecType().equals("KEY")) {
                            reservedName.addKEYRec(string2);
                        }
                        if (configurationManager.giveAHost(reservedName, this.theDomain, "TheDomainFile")) {
                            configurationManager.linkHost(reservedName, this.theDomain);
                        }
                        this.pendingComments = new Vector();
                        this.giveCommentsToEntry(reservedName, fileEntry);
                    } else {
                        ((FileItem)object).setDataDynamic(true);
                        if (fileEntry.getRecType().equals("SIG")) {
                            ((FileItem)object).addSIGRec(string2);
                        } else if (fileEntry.getRecType().equals("KEY")) {
                            ((FileItem)object).addKEYRec(string2);
                        }
                        this.pendingComments = new Vector();
                        this.giveCommentsToEntry((FileItem)object, fileEntry);
                    }
                }
                ++n;
            }
        }
        if (!this.dottedNames.isEmpty()) {
            n = 0;
            while (n < this.dottedNames.size()) {
                fileEntry = (FileEntry)this.dottedNames.elementAt(n);
                this.addIgnored(fileEntry);
                ++n;
            }
        }
    }

    protected void parseRecord(String string, FileEntry fileEntry, ConfigurationManager configurationManager, HostOrAlias hostOrAlias, int n) {
        if (fileEntry.getRecType().equals("A")) {
            if (this.notReverseOrAlias(hostOrAlias, fileEntry)) {
                if (TcpipValidation.IsValidTcpipAddr(fileEntry.getRecordData())) {
                    hostOrAlias = this.findCorrespondingHost(string, this.theDomain, hostOrAlias, configurationManager);
                    ((HostObject)hostOrAlias).addIpAddress(fileEntry.getRecordData());
                    ((HostObject)hostOrAlias).setGreaterATTL(n);
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                    return;
                }
                this.giveCommentsToEntry(fileEntry, null);
                this.addErrors(fileEntry);
                return;
            }
        } else if (fileEntry.getRecType().equals("CNAME")) {
            if (this.notReverseOrHost(hostOrAlias, fileEntry)) {
                hostOrAlias = this.findCorrespondingAlias(string, this.theDomain, hostOrAlias, configurationManager);
                ((AliasHostObject)hostOrAlias).setRealHostName(fileEntry.getRecordData());
                ((AliasHostObject)hostOrAlias).setGreaterCNAMEttl(n);
                this.giveCommentsToEntry(hostOrAlias, fileEntry);
                return;
            }
        } else if (fileEntry.getRecType().equals("HINFO")) {
            if (this.notReverseOrAlias(hostOrAlias, fileEntry)) {
                hostOrAlias = this.findCorrespondingHost(string, this.theDomain, hostOrAlias, configurationManager);
                Platform platform = this.validateHINFOrecord(fileEntry.getRecordData());
                if (platform != null) {
                    ((HostObject)hostOrAlias).addCpuOpSys(platform);
                    ((HostObject)hostOrAlias).setGreaterHINFOTTL(n);
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                    return;
                }
                this.addErrors(fileEntry);
                return;
            }
        } else if (fileEntry.getRecType().equals("MX")) {
            if (string.equals(this.theDomain) || string.equals(String.valueOf(this.theDomain) + ".")) {
                DomainObject domainObject = configurationManager.getADomain(this.theDomain);
                if (domainObject != null) {
                    domainObject.addMailExchange(fileEntry.getRecordData());
                    domainObject.setGreaterMailTTL(n);
                    this.giveCommentsToEntry(domainObject, fileEntry);
                    return;
                }
            } else if (this.notReverseOrAlias(hostOrAlias, fileEntry)) {
                hostOrAlias = this.findCorrespondingHost(string, this.theDomain, hostOrAlias, configurationManager);
                ((HostObject)hostOrAlias).addMailExchange(fileEntry.getRecordData());
                ((HostObject)hostOrAlias).setGreaterMXTTL(n);
                this.giveCommentsToEntry(hostOrAlias, fileEntry);
                return;
            }
        } else {
            if (fileEntry.getRecType().equals("NS")) {
                this.giveCommentsToEntry(fileEntry, null);
                this.addNSRec(fileEntry);
                return;
            }
            if (fileEntry.getRecType().equals("TXT")) {
                if (this.notReverseOrAlias(hostOrAlias, fileEntry)) {
                    String string2 = null;
                    String string3 = this.stripExteriorQuotes(fileEntry.getRecordData().trim());
                    if (string3 != null) {
                        DDNSStringTranslator dDNSStringTranslator = new DDNSStringTranslator(string3);
                        string2 = dDNSStringTranslator.toEscapedString();
                    }
                    if (string3 == null || string2 == null || !string2.equals(string3) || string2.indexOf(10) >= 0) {
                        this.addErrors(fileEntry);
                        return;
                    }
                    hostOrAlias = this.findCorrespondingHost(string, this.theDomain, hostOrAlias, configurationManager);
                    ((HostObject)hostOrAlias).addTextEntry(string2);
                    ((HostObject)hostOrAlias).setGreaterTXTTTL(n);
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                    return;
                }
            } else {
                if (fileEntry.getRecType().equals("SIG")) {
                    if (hostOrAlias == null) {
                        if (string.equals(this.theDomain)) {
                            DomainObject domainObject = configurationManager.getADomain(this.theDomain);
                            if (domainObject != null) {
                                domainObject.addSIGRec(fileEntry.getRecordData());
                                return;
                            }
                            this.addPendingO(fileEntry);
                            this.giveCommentsToEntry(fileEntry, null);
                            return;
                        }
                        this.addPendingO(fileEntry);
                        this.giveCommentsToEntry(fileEntry, null);
                        return;
                    }
                    hostOrAlias.addSIGRec(fileEntry.getRecordData());
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                    return;
                }
                if (fileEntry.getRecType().equals("KEY")) {
                    if (hostOrAlias == null) {
                        if (string.equals(this.theDomain)) {
                            DomainObject domainObject = configurationManager.getADomain(".");
                            if (domainObject != null) {
                                domainObject.addKEYRec(fileEntry.getRecordData());
                                return;
                            }
                            this.addPendingO(fileEntry);
                            this.giveCommentsToEntry(fileEntry, null);
                            return;
                        }
                        this.addPendingO(fileEntry);
                        this.giveCommentsToEntry(fileEntry, null);
                        return;
                    }
                    hostOrAlias.addKEYRec(fileEntry.getRecordData());
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                    return;
                }
                if (fileEntry.getRecType().equals("OTHER") && this.notReverseOrAlias(hostOrAlias, fileEntry)) {
                    hostOrAlias = this.findCorrespondingHost(string, this.theDomain, hostOrAlias, configurationManager);
                    hostOrAlias.addOtherRec(fileEntry.getRecordData());
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                }
            }
        }
    }

    protected void writeNameServersForDomain(BufferedWriter bufferedWriter, PrimaryDomain primaryDomain, ConfigurationManager configurationManager, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        NameAndIpAddressList nameAndIpAddressList = primaryDomain.getNameServerSetforDomain();
        if (nameAndIpAddressList != null) {
            Enumeration enumeration = nameAndIpAddressList.elements();
            while (enumeration.hasMoreElements()) {
                NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
                String string = nameAndIpAddress.getFqName();
                if (this.alreadyWritten(stringArray, string)) continue;
                int n = primaryDomain.getNameServerTTL();
                if (n < 0) {
                    vector.addElement(".   IN NS   " + string + ".");
                    continue;
                }
                vector.addElement(".   " + n + " IN NS   " + string + ".");
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            this.writeOutput(bufferedWriter, (String[])objectArray);
        }
    }
}

