/*************************************************************************
*
* WSTRACE.CMD - 
*
*
* Licensed Materials - Property of IBM
*
* IBM TCP/IP for OS/2
*
* (C) Copyright IBM Corp. 1996
*
**************************************************************************
*                  
*
*  PURPOSE:   Enables and disables WinSock trace in an OS/2 Session.
*                Sets the following environment variables to communicate 
*                trace options to WinSock code executing in the trace 
*                enabled OS/2 Session:
*
*                wstrace - nonzero indicates trace is active.  
*                            Null/zero indicates trace is inactive.
*                wsfile   - Fully-qualified name of the trace output file.
*                wspipe  - Name of the OS/2 pipe used for trace output.
*                wsbuff  - Size of trace buffer to allocate.
*  
*  COMMAND SYNTAX:   wstrace  [on]  [filename] [-p] [pipename] [-b] [buffsize]
*                                    [off]
*
*************************************************************************/

/* Initialization */

'@set WSTRACE='
'@set WSBUFF='
'@set WSFILE='
'@set WSPIPE='

error=0;
output=0

/* get the input */

parse arg argv;
say '';
parse value argv with curarg nxtarg;

IF ((curarg = "off") | (curarg = "OFF"))
THEN DO
       '@set WSTRACE=';
       say '    WinSock Trace is OFF';
       Exit
     END
ELSE DO
     IF ((curarg = "1") | (curarg = "ON") | (curarg = "on"))
     THEN DO
          level=1;
          END
     ELSE DO
          IF (curarg = "2")
          THEN DO
               level=2;
               END
          ELSE DO
               level=1;
               nxtarg=argv;
               END
          END
     DO WHILE (nxtarg <> "") & (error = 0)                              /* Process remaining args */
           argv = nxtarg;
           parse value argv with curarg nxtarg;

           SELECT
                               /* Process PipeName */
               
               WHEN ((curarg = "-p") | (curarg = "-P")) THEN DO
                  IF (output = 1) 
                  THEN DO
                        error=1;
                  END
                  ELSE DO 
                        output = 1;                   
                        IF ((subword(nxtarg,1,1) = "-b") | (subword(nxtarg,1,1) ="-B") | (nxtarg = ""))
                        THEN DO
                              '@set WSPIPE=\PIPE\WSPIPE';   /* set defaut pipeName */
                        END
                        ELSE DO                                  /* set user defined pipeName */
                              argv = nxtarg;
                              parse value argv with curarg nxtarg;
                              '@set WSPIPE=\PIPE\'curarg;
                        END   
                  END /* else */
               END  /* when */

                             /* Process Buffer Size */

               WHEN ((curarg = "-b") | (curarg = "-B")) THEN DO
                  IF ((subword(nxtarg,1,1) = "-p") | (subword(nxtarg,1,1) ="-P") | (nxtarg = ""))
                  THEN DO
                        '@set WSBUFF=64';                /* set default buffer size */
                  END
                  ELSE DO                                 /* set user defined buffer size */
                        argv = nxtarg;
                        parse value argv with curarg nxtarg;
                        '@set WSBUFF='curarg;
                  END
               END  /* when */

                            /* Process Trace FileName */

               OTHERWISE
                  IF (output=1)
                  THEN DO
                        error=2;
                  END
                  ELSE DO 
                  output=1;
                        '@set WSFILE='curarg;           /* set user defined FileName */ 
                  END /* else */
           END  /* select */
       END /* while */                           
END /* if */


If (error <> 0)
THEN DO 
      say 'You must specify only 1 output';
      say 'WSTRACE Syntax: wstrace  [on|off|1|2] [filename |-p [pipename]] [-b buffsize]'
END
ELSE DO
                           /* Print out the Results */
pn=value('WSPIPE',,'os2environment')
IF pn <> ""
THEN say'    WSPIPE = 'pn;
ELSE NOP;

fn=value('WSFILE',,'os2environment')
IF fn <> ''
THEN say'    WSFILE = 'fn;
ELSE DO
      IF pn = ""
      THEN DO
            '@set WSFILE=WSTRACE.DMP';
            say'    WSFILE = WSTRACE.DMP';
      END
END
   
fn=value('WSBUFF',,'os2environment')
IF fn <> ''
THEN DO
       IF (fn < 1) | (fn > 2000)
       THEN DO
              say '' 
              say '    Invalid Buffer Size specified: 'fn;
             '@set WSBUFF=64';
             say '    Buffer Size set to 64K';
       END
       ELSE say '    WSBUFF = 'fn'K';
END
ELSE DO
       '@set WSBUFF=64';
       say '    WSBUFF = 64K';
END
IF level=1 THEN DO
'@set WSTRACE=1';
END
ELSE DO
'@set WSTRACE=2';
END
say ''
say '    WinSock Trace is ON';
say '    Trace level is:' level;

END /* else */

Return;                 /* All Done ! */
         
