/* */

parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then parse var string "'"BootDrive" "AppServer" "Action"'"
if (string<>"" & BootDrive="") then parse var string BootDrive" "AppServer" "Action
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */

  p.Title = "AHD"
  p.ThisCMDFileName = "CreateAHD.CMD"
  p.ObjectID = "<Ahd Executable>"
  p.DirName = "AHD"
  p.Location = "<WP_CLIENTAPPSFOLDER>"
  p.FitToCheck = ""
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = "\OS2"   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""

  call StartUp

  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = "EXENAME="p.ExeDir"\AHD.EXE;STARTUPDIR="p.StartDir";"
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
  CreateCollision = p.Flag

  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = p.ObjectIDPre || "_Shadow>"  /* Set to blank for no desktop shadow */
  p.Doc= "OBJECTID="p.ObjectIDPre"_DOC>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\README.TXT;STARTUPDIR="p.StartDir";"  /* Set to blank for no readme */

  p.ObjectIDFolder = p.ObjectIDPre || "_FOLDER>" /* Set to blank for no folder */
  if (p.ObjectIDShadow="") then
     p.ObjectIDFolderShadow = p.ObjectIDPre || "_FOLDER_SHODOW>"
  else
     p.ObjectIDFolderShadow = ""
  p.ObjectIDFolderCleanUp = p.ObjectIDPre || "_FOLDER_CLEANUP>"
  p.ObjectIDFolderICON1 = WiseManager"\"p.DirName"\"p.DirName".ICO"
  p.ObjectIDFolderICON2 = WiseManager"\"p.DirName"\"p.DirName"1.ICO"
 
  call MyRegisterClasses
  call MyCreateObjects

syntax:
signal CMDExit
return 0

MyRegisterClasses:
return 0
 
MyCreateObjects:

  rc = CreateObject( 'WPFolder',,
      'American Heritage' || CRLF || 'Dictionary',,
      p.Location,,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='p.ObjectIDFolderICON1';'||,
          'ICONNFILE=1,'p.ObjectIDFolderICON2';'||,
          'OBJECTID=<AhdApp>;',,
      CreateCollision )

    rc = CreateObject( 'WPProgram',,
      'American Heritage' || CRLF || 'Dictionary',,
        '<AhdApp>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='RunFrom'\AHD\AHD.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<Ahd Executable>;',,
        CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'American Heritage' || CRLF || 'Dictionary',,
      '<WP_DESKTOP>',,
      'NOPRINT=YES;'||,
         'DEFAULTVIEW=UNKNOWN;'||,
         'HELPPANEL=1277;'||,
         'SHADOWID=<Ahd Executable>;'||,
         'OBJECTID=<AhdAppShadow>',,
      CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Read Me',,
        '<AhdApp>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=E.EXE;'||,
            'PARAMETERS='RunFrom'\AHD\readme;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<Ahd Readme>;',,
        CreateCollision )

    /* Misc program files goes here */
    PgmFiles = ""     /* ABC.EXE DEF.CMD */
    do while (PgmFiles<>"")
       PgmFiles = strip(PgmFiles)
       parse var PgmFiles p.Title"."suf" "PgmFiles
       if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
       p.SetupString = "EXENAME="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
       p.ObjectID = "<Acrobat_"p.Title""suf">"
       rc = CreateObject( p.Class, p.Title, p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
    end /* do */
 
    /* Misc text files goes here */
    TxtFiles = ""     /* ABC.TXT DEF.TXT */
    do while (TxtFiles<>"")
       TxtFiles = strip(TxtFiles)
       parse var TxtFiles p.Title"."suf" "TxtFiles
       if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
       if (translate(suf)="INF") then prog = "View"
       else prog = "E"
       p.SetupString = "EXENAME="prog".EXE;PARAMETERS="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
       p.ObjectID = "<Acrobat_"p.Title""suf">"
       rc = CreateObject( p.Class, p.Title || "."suf"", p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
    end /* do */

return
 
