/* */
 
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then do
   parse var string "'"BootDrive" "AppServer" "Action"'"
end
if (string<>"" & BootDrive="") then do
   parse var string BootDrive" "AppServer" "Action
end
 
  p.Title = "MMOS2base"  /* Name of this application */
  p.ThisCMDFileName = "CreateMMOS2base.CMD"  /* Name of this command file */
  p.DirName = "MMOS2base"  /* Name of main dir */
  p.Location = "<WP_APPSFOLDER>"  /* Location to place main folder */
  p.ObjectID = "<OBJECT_MMOS2base>"  /* Object to start (usually the main exe) */
  p.FitToCheck = BootDrive"\MMOS2\MMPM.INI"
  p.FileToCheck = ""   /* File to check to see if this is a fresh install */
  p.DirToCheck = ""   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = "MMFinder MMPARTS"   /* Class to check to see if this is a fresh install (classname dllname) */

  call StartUp
 
  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
 
  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= ""
  p.ObjectIDFolder = "" /* Set to blank for no folder */
 
  CreateCollision = p.Flag
  Call RegisterClasses
  Call CreateObjects
 
  /* "start "BootDrive"\MMOS2\INSTALL\INSTSND.CMD "BootDrive"'" */
  Call RXFUNCADD "mciRxInstMMSound", "MMSND", "mciRxInstMMSound"
  rc = mciRxInstMMSound(BootDrive)

syntax:
signal CMDExit
return 0
 
 
CreateObjects:

rc = CreateObject( 'WPFolder',,
    'Multimedia',,
    '<WP_PROGRAMSFOLDER>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='WiseManager'\MMOS2Base\MMPMFLDR.ICO;'||,
        'ICONNFILE='WiseManager'\MMOS2Base\MMPMFLD2.ICO;'||,
        'OBJECTID=<MMPM2_FOLDER>',,
    "Update" )

  rc = CreateObject( 'MMFolder',,
      'Bitmaps',,
      '<MMPM2_FOLDER>',,
      'HELPPANEL=48033;'||,
      'HELPLIBRARY=MMPARTS.HLP;'||,
        'ALWAYSSORT=YES;'||,
          'OBJECTID=<MMPM2_BITMAP>',,
      CreateCollision )

  call FillFolder '<MMPM2_BITMAP>', BootDrive'\OS2\BITMAP'

  rc = CreateObject( 'MMVolume',,
      'Volume',,
      '<MMPM2_FOLDER>',,
      'NOCOPY=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMVOLUME>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Digital Video',,
      '<MMPM2_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=MPPM.EXE;'||,
          'STARTUPDIR='BootDrive'\MMOS2\MOVIES;'||,
          'PARAMETERS=Digitalvideo01;'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\MMOS2base\MMOS2Base\Digital Video.ICO;'||,
          'OBJECTID=<MMPM2_SOFTWARE_MOTION_VIDEO1>',, 
      CreateCollision )

/*
  rc = CreateObject( 'MMFinder',,
      'Digital video',,
      '<MMPM2_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
      'NOPRINT=YES;'||,
          'OBJECTID=<MMPM2_VIDEOFINDER>',,
      CreateCollision )
*/
   call SysDestroyObject "<MMPM2_VIDEOFINDER>"


  MPGFile = BootDrive'\MMOS2\MOVIES\_VIDCDI.MPG'
  if (VRFileExists(MPGFile)=1) then
  rc = CreateObject( 'WPProgram',,
      'Software'||CRLF||'VideoCD Player',,
      '<MMPM2_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=MPPM.EXE;'||,
          'PARAMETERS='MPGFile';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<OM_VCD_SW>',,
      CreateCollision )

  rc = CreateObject( 'MMFolder',,
      'Movies',,
      '<MMPM2_FOLDER>',,
      'HELPPANEL=48033;'||,
      'HELPLIBRARY=MMPARTS.HLP;'||,
          'ICONFILE='WiseManager'\MMOS2base\multimedia\Moveies.ICO;'||,
          'ICONNFILE='WiseManager'\MMOS2base\multimedia\Moveies1.ICO;'||,
        'ALWAYSSORT=YES;'||,
          'OBJECTID=<MMPM2_Movies>',,
      CreateCollision )

  call FillFolder '<MMPM2_Movies>', BootDrive'\MMOS2\MOVIES'

  iFile = BootDrive'\eCS\introduction.flc'
  rc = CreateObject( 'WPShadow',,
      FILESPEC('Name',iFile),,
      '<MMPM2_Movies>',,
      'SHADOWID='iFile';'||,
          'OBJECTID=<'translate(ifile,"____",".:\/")'_SHAD>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Image',,
      '<MMPM2_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=MPPM.EXE;'||,
          'STARTUPDIR='BootDrive'\MMOS2\Images;'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\MMOS2base\MMOS2Base\Image.ICO;'||,
          'OBJECTID=<MMPM_IMAGEFINDER>',,
      CreateCollision )

/*
  rc = CreateObject( 'MMFinder',,
      'Image',,
      '<MMPM2_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
      'NOPRINT=YES;'||,
          'OBJECTID=<MMPM2_IMAGEFINDER>',,
      CreateCollision )
*/

  rc = CreateObject( 'WPProgram',,
      'MIDI',,
      '<MMPM2_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=MPPM.EXE;'||,
          'STARTUPDIR='BootDrive'\MMOS2\SOUNDS;'||,
          'PARAMETERS=Sequencer01;'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\MMOS2base\MMOS2Base\MIDI.ICO;'||,
          'OBJECTID=<MMPM_MIDIPLAYER1>',,
      CreateCollision )

/*
  rc = CreateObject( 'MMFinder',,
      'MIDI',,
      '<MMPM2_FOLDER>',,
      'NOPRINT=YES;'||,
          'OBJECTID=<MMPM2_MIDIFINDER>',,
      CreateCollision )
*/
   call SysDestroyObject "<MMPM2_MIDIFINDER>"

  rc = CreateObject( 'WPProgram',,
      'Digital Audio',,
      '<MMPM2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=WEPM.EXE;'||,
          'STARTUPDIR='BootDrive'\MMOS2\SOUNDS;'||,
          'PARAMETERS=Waveaudio01;'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\MMOS2base\MMOS2Base\Digital Audio.ICO;'||,
          'OBJECTID=<MMPM_DAPLAYER1>',, 
      CreateCollision )

/*
  rc = CreateObject( 'MMFinder',,
      'Digital audio',,
      '<MMPM2_FOLDER>',,
      'NOPRINT=YES;'||,
          'OBJECTID=<MMPM2_AUDIOFINDER>',,
      CreateCollision )
*/
   call SysDestroyObject "<MMPM2_AUDIOFINDER>"

  rc = CreateObject( 'WPProgram',,
      'Compact Disc',,
      '<MMPM2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=CDPM.EXE;'||,
          'STARTUPDIR='BootDrive'\MMOS2\SOUNDS;'||,
          'PARAMETERS=CDaudio01;'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\CDPM.ICO;'||,
          'OBJECTID=<MMPM_CDPLAYER1>',, 
      CreateCollision )

/*
  rc = CreateObject( 'MMCDDevice',,
      'Compact Disc',,
      '<MMPM2_FOLDER>',,
      'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMCDDEVICE01>',,
      CreateCollision )
*/

  rc = CreateObject( 'MMFolder',,
      'Images',,
      '<MMPM2_FOLDER>',,
      'HELPPANEL=48033;'||,
      'HELPLIBRARY=MMPARTS.HLP;'||,
        'ALWAYSSORT=YES;'||,
          'OBJECTID=<MMPM2_IMAGES>',,
      CreateCollision )

  call FillFolder '<MMPM2_IMAGES>', BootDrive'\MMOS2\IMAGES'

  rc = CreateObject( 'WPFolder',,
      'Sound Bites',,
      '<MMPM2_FOLDER>',,
      'HELPPANEL=1277;'||,
      'ICONFILE='WiseManager'\MMOS2Base\MMOS2Base\sounds.ICO;'||,
      'ICONNFILE='WiseManager'\MMOS2Base\MMOS2Base\sounds1.ICO;'||,
        'ALWAYSSORT=YES;'||,
          'OBJECTID=<MMPM2_SOUNDS>',,
      CreateCollision )

  call FillFolder '<MMPM2_SOUNDS>', BootDrive'\MMOS2\SOUNDS'

rc = CreateObject( 'WPProgram',,
    'Multimedia^Setup',,
    '<WP_CONFIG>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'EXENAME='BootDrive'\MMOS2\STPM.EXE;'||,
        'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
        'PROGTYPE=PM;'||,
        'OBJECTID=<MMPM2_SETUP>',,
    CreateCollision )

rc = CreateObject( 'WPSound',,
    'Sound',,
    '<WP_CONFIG>',,
    'NOCOPY=YES;'||,
        'NODELETE=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=SETTINGS;'||,
        'OBJECTID=<WP_SOUND>',,
    CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'Sound',,
      '<MMPM2_FOLDER>',,
      'SHADOWID=<WP_SOUND>;'||,
          'OBJECTID=<MMPM2_SNDSHAD>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Sound - ReadME',,
      '<WP_CONFIG>',,
      'EXENAME=E.EXE;'||,
      'PARAMETERS='WiseManager'\MMOS2Base\ReadMeAboutSound.txt;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\ecssystemeditor.ICO;'||,
          'OBJECTID=<MMPM2_SNDABOUT>',,
    CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'Sound - ReadME',,
      '<MMPM2_FOLDER>',,
      'SHADOWID=<MMPM2_SNDABOUT>;'||,
          'OBJECTID=<MMPM2_SNDSHADABOUT>',,
      CreateCollision )

rc = CreateObject( 'WPFolder',,
    'Multimedia Templates',,
    '<WP_TEMPS>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ICONFILE='WiseManager'\'p.DirName'\Multimedia\Multimedia Templates.ICO;'||,
        'ICONNFILE='WiseManager'\'p.DirName'\Multimedia\Multimedia Templates1.ICO;'||,
        'OBJECTID=<MMPM2_MMTEMPLATEFOLDER>',,
    CreateCollision )

  rc = CreateObject( 'MMLVDDevice',,
      'Videodisc',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMLVDDEVICETEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMTIFF',,
      'TIFImage.TIF',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMTIFFTEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMGIF',,
      'GIFImage.GIF',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMGIFTEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMTarga',,
      'TargaImage.TGA',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMTARGATEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMDIB',,
      'DIBImage.DIB',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMDIBTEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMFolder',,
      'Lighttable',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'OBJECTID=<MMPM2_MMFOLDERTEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'WPBitmap',,
      'Bitmap.BMP',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'READDATAFROM='WiseManager'\'p.DirName'\Multimedia\Bitmap.DAT;'||,
          'OBJECTID=<MMPM2_MMBITMAPTEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMCDDevice',,
      'Compact Disc',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMCDDEVICETEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMAVI',,
      'AVIVideo.AVI',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMAVITEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMWAV',,
      'WAVAudio.WAV',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMWAVETEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMPCX',,
      'PCXImage.PCX',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMPCXTEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMAVC',,
      'AVCImage._IM',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMAVCIMAGETEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMMMotion',,
      'VIDImage.VID',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMMMOTIONTEMPLATE>',,
      CreateCollision )

  rc = CreateObject( 'MMMIDI',,
      'MIDI.MID',,
      '<MMPM2_MMTEMPLATEFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'CCVIEW=NO;'||,
          'OBJECTID=<MMPM2_MMMIDITEMPLATE>',,
      CreateCollision )

/*
rc = CreateObject( 'MMMIDI',,
    'MIDI.MID',,
    '<WP_TEMPS>',,
    'TEMPLATE=YES;'||,
        'NODELETE=YES;'||,
        'CCVIEW=NO;'||,
        'OBJECTID=<MIDI_MID>',,
    CreateCollision )

rc = CreateObject( 'MMJPG',,
    'JPGImage.JPG',,
    '<WP_TEMPS>',,
    'TEMPLATE=YES;'||,
        'NODELETE=YES;'||,
        'NOPRINT=YES;'||,
        'CCVIEW=NO;'||,
        'OBJECTID=<JPGImage_JPG>',,
    CreateCollision )
*/

rc = CreateObject( 'WPMet',,
    'Metafile.MET',,
    '<WP_TEMPS>',,
    'NOTDEFAULTICON=YES;'||,
        'TEMPLATE=YES;'||,
        'NODELETE=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'ICONFILE='WiseManager'\'p.DirName'\Multimedia\Metafile.ICO;'||,
        'READDATAFROM='WiseManager'\'p.DirName'\Multimedia\Metafile.DAT;'||,
        'OBJECTID=<Metafile_MET>',,
    CreateCollision )

/*
rc = CreateObject( 'WPBitmap',,
    'Bitmap.BMP',,
    '<WP_TEMPS>',,
    'NOTDEFAULTICON=YES;'||,
        'TEMPLATE=YES;'||,
        'NODELETE=YES;'||,
        'ICONFILE='WiseManager'\'p.DirName'\Multimedia\Bitmap.ICO;'||,
        'READDATAFROM='WiseManager'\'p.DirName'\Multimedia\Bitmap1.DAT;'||,
        'OBJECTID=<Bitmap_BMP>',,
    CreateCollision )

rc = CreateObject( 'MMTIFF',,
    'TIFImage.TIF',,
    '<WP_TEMPS>',,
    'TEMPLATE=YES;'||,
        'NODELETE=YES;'||,
        'NOPRINT=YES;'||,
        'CCVIEW=NO;'||,
        'OBJECTID=<TIFImage_TIF>',,
    CreateCollision )

rc = CreateObject( 'MMWAV',,
    'WAVAudio.WAV',,
    '<WP_TEMPS>',,
    'TEMPLATE=YES;'||,
        'NODELETE=YES;'||,
        'CCVIEW=NO;'||,
        'OBJECTID=<WAVAudio_WAV>',,
    CreateCollision )
*/

      rc = CreateObject( 'WPProgram',,
          'Multimedia^With REXX',,
          '<WP_REFCMDFOLDER>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='OS2Dir'\VIEW.EXE;'||,
              'PARAMETERS='BootDrive'\MMOS2\MCIREXX.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<MCIREXX_INF>',,
          CreateCollision )

rc = CreateObject( 'WPProgram',,
    'Multimedia^Application Install',,
    '<WP_INSTREMFOLDER>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'EXENAME='BootDrive'\MMOS2\MINSTALL.EXE;'||,
        'STARTUPDIR='BootDrive'\MMOS2;'||,
        'PROGTYPE=PM;'||,
        'OBJECTID=<MMPM2_MINSTALL>',,
    CreateCollision )

if (0) then do
    szClass=""
    iRetco = WPToolsQueryObject("<WP_WARPCENTER>", "szClass", "szTitle", "szSetupString", "szLocation") 
    if (szClass<>"") then do
        parse var szSetupString pre"ADDTRAY="tname","maintray";"rest
        if (pos("<MMPM2_MMVOLUME>",translate(maintray))=0) then do
           szSetupString = pre || "ADDTRAY="tname"," || maintray || "," || "<MMPM2_MMVOLUME>;" || rest
           rc = SysSetObjectData( "<WP_WARPCENTER>", szSetupString )
           /* rc = CreateObject( szClass,szTitle,szLocation,szSetupString,"Replace" ) */
        end /* do */
    end
end
return

RegisterClasses:
  rc = MySysRegisterObjectClass( 'MM_AU', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMAIF', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMAU', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMAudio', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMAVC', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMAVI', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMBitmap', 'MMBIT', 'A' )
  rc = SysIni(, 'PM_InstallClassReplacement', 'WPBitmap', 'MMBitmap'x2c('0') )
  rc = MySysRegisterObjectClass( 'MMCDDevice', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMDataFile', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMDevice', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMDIB', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMFinder', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMFLI', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMFolder', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMGIF', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMIFF', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMImage', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMJPG', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMLVDDevice', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMMIDI', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMMMotion', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMMOV', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMMPG', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMPCX', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMPhotoCD', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMShadow', 'MMSHD', 'A' )
  rc = SysIni(, 'PM_InstallClassReplacement', 'WPShadow', 'MMShadow'x2c('0') )
  rc = MySysRegisterObjectClass( 'MMSNDF', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMSound', 'MMSND', 'A' )
  rc = MySysRegisterObjectClass( 'MMTarga', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMTIFF', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMVideo', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMVOC', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMVolume', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMWAV', 'MMPARTS', 'A' )

return

