/* */
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then parse var string "'"BootDrive" "AppServer" "Action"'"
if (string<>"" & BootDrive="") then parse var string BootDrive" "AppServer" "Action
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */

  p.Title = "Mesa2"
  p.ThisCMDFileName = "CreateMesa2.CMD"
  p.DirName = "Mesa2"
  p.Location = "<WP_APPSFOLDER>"
  p.ObjectID = "<M2_PROGRAM>"
  p.FitToCheck = BootDrive"\Apps\Mesa2\Mesa2.ini" 
  p.FileToCheck = ""  /* \OS2\bitmap\MESA2BKG.BMP" */ /* File to check to see if this is a fresh install */
  p.DirToCheck = ""   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""

  call StartUp

  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */

  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= ""
  p.ObjectIDFolder = "" /* Set to blank for no folder */

  CreateCollision = p.Flag
  Call RegisterClasses
  Call CreateObjects

    rc = CreateObject( "WPShadow",,
    'Mesa 2',,
        "<WP_DESKTOP>",,
            "SHADOWID=<M2_FOLDER>;"||,
            "OBJECTID=<M2_FOLDER_SHADOW>",,
        "REPLACE" )
 
syntax:
signal CMDExit
return 0

CreateObjects:

rc = CreateObject( 'WPFolder',,
    'Mesa 2',,
    p.Location,,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'BACKGROUND='WiseManager'mesa2\mesa2\MESA2BKG.BMP,T,,I,255 255 255;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<M2_FOLDER>',,
    CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Mesa 2^Documentation',,
      '<M2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=VIEW.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PARAMETERS=MESA2.INF;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<M2_DOC>',,
      CreateCollision )

  rc = CreateObject( 'WPPatternPalette',,
      'Pattern^Palette',,
      '<M2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'XCELLCOUNT=8;'||,
          'YCELLCOUNT=2;'||,
          'XCELLWIDTH=40;'||,
          'YCELLHEIGHT=40;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Mesa2\WPPatternPalette.ICO;'||,
          'OBJECTID=<WP_PATPAL>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'License^Agreement',,
      '<M2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=E.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PARAMETERS=LICENSE.TXT;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<M2_LICENSE>',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'Font Palette',,
      '<M2_FOLDER>',,
      'SHADOWID=<WP_FNTPAL>;'||,
          'OBJECTID=<M2_WP_FNTPAL>',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'TEMPLATE',,
      '<M2_FOLDER>',,
      'SHADOWID='BootDrive||Apps'\Mesa2\TEMPLATE;'||,
          'OBJECTID=<M2_TEMPLATES>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Read Me',,
      '<M2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=E.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PARAMETERS=README.TXT;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<M2_README>',,
      CreateCollision )

  file = "http://www.sundialsystems.com/mesahome"
  rc = CreateObject( 'WPUrl',,
      'Mesa 2^Home Page',,
      '<M2_FOLDER>',,
      'DEFAULTVIEW=CONTENTS;'||,
      'LOCATOR='file';'||,
          'READDATAFROM='WiseManager'\'p.DirName'\Mesa2\Mesa 2!Home Page.DAT;'||,
          'OBJECTID=<M2_URL>',,
      CreateCollision )

/*
  rc = CreateObject( 'WPProgram',,
      'Mesa 2^Uninstall',,
      '<M2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PARAMETERS=/C UINSTALL.CMD;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'OBJECTID=<M2_UINSTALL>',,
      CreateCollision )
*/

  rc = CreateObject( 'WPShadow',,
      'Mixed Color Palette',,
      '<M2_FOLDER>',,
      'SHADOWID=<WP_HIRESCLRPAL>;'||,
          'OBJECTID=<M2_WP_HIRESCLRPAL>',,
      CreateCollision )

  rc = CreateObject( 'WPMarkerPalette',,
      'Marker^Palette',,
      '<M2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'XCELLCOUNT=6;'||,
          'YCELLCOUNT=2;'||,
          'XCELLWIDTH=40;'||,
          'YCELLHEIGHT=32;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Mesa2\WPMarkerPalette.ICO;'||,
          'OBJECTID=<WP_MARKPAL>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Mesa 2',,
      '<M2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ASSOCFILTER=*.M2,*.M2T,*.M2B;'||,
          'ASSOCTYPE=Mesa Workbook File,Mesa Backup File,Mesa Template File;'||,
          'EXENAME='RunFrom'\MESA2\MESA2.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<M2_PROGRAM>',,
      CreateCollision )

  rc = CreateObject( 'WPLineWidthPalette',,
      'Line Width^Palette',,
      '<M2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'XCELLCOUNT=5;'||,
          'YCELLCOUNT=2;'||,
          'XCELLWIDTH=50;'||,
          'YCELLHEIGHT=40;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Mesa2\WPLineWidthPalette.ICO;'||,
          'OBJECTID=<WP_LINEWPAL>',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'EXAMPLES',,
      '<M2_FOLDER>',,
      'SHADOWID='BootDrive||Apps'\Mesa2\EXAMPLES;'||,
          'OBJECTID=<M2_EXAMPLES>',,
      CreateCollision )

  rc = CreateObject( 'WPLineStylePalette',,
      'Line Style^Palette',,
      '<M2_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'XCELLCOUNT=5;'||,
          'YCELLCOUNT=2;'||,
          'XCELLWIDTH=50;'||,
          'YCELLHEIGHT=40;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Mesa2\WPLineStylePalette.ICO;'||,
          'OBJECTID=<WP_LINEPAL>',,
      CreateCollision )

rc = CreateObject( 'WPMesaTemplateFile',,
    'Mesa Template File',,
    '<WP_TEMPS>',,
    'NOTDEFAULTICON=YES;'||,
        'TEMPLATE=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'HELPPANEL=15686;'||,
        'READDATAFROM='WiseManager'\'p.DirName'\Mesa2\Mesa Template File.DAT;'||,
        'OBJECTID=<WP_MESA_TEMPLATE_TEMPLATE>',,
    CreateCollision )

rc = CreateObject( 'WPMesaBackupFile',,
    'Mesa Backup File',,
    '<WP_TEMPS>',,
    'NOTDEFAULTICON=YES;'||,
        'TEMPLATE=YES;'||,
        'HELPPANEL=15686;'||,
        'READDATAFROM='WiseManager'\'p.DirName'\Mesa2\Mesa Backup File.DAT;'||,
        'OBJECTID=<WP_MESA_BACKUP_TEMPLATE>',,
    CreateCollision )

rc = CreateObject( 'WPMesaFile',,
    'Mesa Workbook File',,
    '<WP_TEMPS>',,
    'NOTDEFAULTICON=YES;'||,
        'TEMPLATE=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'HELPPANEL=15686;'||,
        'READDATAFROM='WiseManager'\'p.DirName'\Mesa2\Mesa Workbook File.DAT;'||,
        'OBJECTID=<WP_MESA_FILE_TEMPLATE>',,
    CreateCollision )

return

RegisterClasses:
/*

Say
Say 'Registering classes....'
Say
Say 'The following classes will be registered:'
Say
Say '  WPObjectPlus      WPMarkerPalette   WPLineWidthPalet  WPFtpObj          '
Say '  WPFtpLink         WPJavaRef         WPHtml            WPFtpDir          '
Say '  WPHost            WPSecs01          TSEnhFolder       WPHostFolder      '
Say '  WPUrlFolder       LSDataFile        WPUrl             TSEnhDataFile     '
Say '  WPSecure          MMShadow          WPSecpgm          WPLineStylePalet  '
Say '  WPPatternPalette  LSDirectory       WPJavaClass       '
Say
Say 'Press enter to register 23 classes for object creation,'
Call CharOut, 'or type any other key and enter to ignore: '
Say
Parse Pull Answer
If Answer <> '' Then return
*/
  rc = MySysRegisterObjectClass( 'WPPatternPalette', 'WPPALETS' )
  rc = MySysRegisterObjectClass( 'WPMarkerPalette', 'WPPALETS' )
  rc = MySysRegisterObjectClass( 'WPLineStylePalette', 'WPPALETS' )
  rc = MySysRegisterObjectClass( 'WPLineWidthPalette', 'WPPALETS' )
  rc = MySysRegisterObjectClass( 'WPMesaTemplateFile', 'MESAPRT' )
  rc = MySysRegisterObjectClass( 'WPMesaFile', 'MESAPRT' )
  rc = MySysRegisterObjectClass( 'WPMesaBackupFile', 'MESAPRT' )
return

