/* */
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then parse var string "'"BootDrive" "AppServer" "Action"'"
if (string<>"" & BootDrive="") then parse var string BootDrive" "AppServer" "Action
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */

  p.Title = "ObjectDesktop"
  p.ThisCMDFileName = "CreateObjectDesktop.CMD"
  p.DirName = "ObjectDesktop"
  p.Location = "<WP_APPSFOLDER>"
  p.ObjectID = "<OBJECT_ObjectDesktop>"
  p.FitToCheck = ""
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = ""   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""
  p.ClassToCheck = "TSArcFileMgr OBJDOARC"

  call StartUp

  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */

  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= ""
  p.ObjectIDFolder = "" /* Set to blank for no folder */

  CreateCollision = p.Flag
  Call RegisterClasses
  Call CreateObjects

  call MyRegisterClasses
  call MyCreateObjects

syntax:
signal CMDExit
return 0

MyRegisterClasses:
return

MyCreateObjects:
  if (p.ObjectIDFolder <> "") then do
     rc = CreateObject( "WPFolder",,
         p.Title,,
         p.Location,,
        'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='p.ObjectIDFolderICON1';'||,
        'ICONNFILE=1,'p.ObjectIDFolderICON2';'||,
        'OBJECTID='p.ObjectIDFolder,,
         p.Flag )

      if (p.ObjectIDShadow="") then do
        rc = CreateObject( 'WPShadow',,
            p.Title,,
            '<WP_DESKTOP>',,
            'SHADOWID='p.ObjectIDFolder';'||,
            'OBJECTID='p.ObjectIDFolderShadow,,
         p.Flag )
      end

      p.Location = p.ObjectIDFolder
  end

  if (p.SetupString<>"") then do
     rc = CreateObject( p.Class,,
         p.Title,,
         p.Location,,
         p.SetupString ||,
             "NOPRINT=YES;"||,
             "DEFAULTVIEW=RUNNING;"||,
             "OBJECTID="p.ObjectID";",,
         p.Flag )
  end

  if (p.ObjectIDShadow<>"") then do
     rc = CreateObject( "WPShadow",,
         p.Title,,
         "<WP_DESKTOP>",,
            "DEFAULTVIEW=UNKNOWN;"||,
            "NOPRINT=YES;"||,
            "HELPPANEL=1277;"||,
            "SHADOWID="p.ObjectID";"||,
            "OBJECTID="p.ObjectIDShadow";",,
         p.Flag )
  end

  if (p.doc<>"") then do
       rc = CreateObject( p.Class,"Read ME",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
  end

  /* Misc program files goes here */
  PgmFiles = ""     /* ABC.EXE DEF.CMD */
  do while (PgmFiles<>"")
     PgmFiles = strip(PgmFiles)
     parse var PgmFiles p.Title"."suf" "PgmFiles
     if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
     p.SetupString = "EXENAME="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
     p.ObjectID = "<ObjectDesktop_"p.Title""suf">"
     rc = CreateObject( p.Class, p.Title, p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
  end /* do */

  /* Misc text files goes here */
  TxtFiles = ""     /* ABC.TXT DEF.TXT */
  do while (TxtFiles<>"")
     TxtFiles = strip(TxtFiles)
     parse var TxtFiles p.Title"."suf" "TxtFiles
     if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
     if (translate(suf)="INF") then prog = "View"
     else if (translate(suf)="HTM" | translate(suf)="HTML") then prog = RunFrom"\NetScape\Program\NetScape"
     else prog = "E"
     p.SetupString = "EXENAME="prog".EXE;PARAMETERS="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
     p.ObjectID = "<ObjectDesktop_"p.Title""suf">"
     rc = CreateObject( p.Class, p.Title || "."suf"", p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
     end /* do */
return

CreateObjects:

rc = CreateObject( 'WPFolder',,
    'Object Desktop',,
    '<WP_APPSFOLDER>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'ICONPOS=60,28;'||,
        'ICONVIEWPOS=20 20 60 60;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='WiseManager'\'name'\Object Desktop Package\Object Desktop.ICO;'||,
        'ICONNFILE='WiseManager'\'name'\Object Desktop Package\Object Desktop1.ICO;'||,
        'OBJECTID=<OBJD_FOLDER>',,
    CreateCollision )

  rc = CreateObject( 'TSZipMgr',,
      'Empty.Zip',,
      '<OBJD_FOLDER>',,
      'TEMPLATE=YES;'||,
          'ICONPOS=3,43;'||,
          'READDATAFROM='WiseManager'\'name'\Object Desktop Package\Empty.DAT;'||,
          'OBJECTID=<OBJD_EMPTYZIP>',,
      CreateCollision )

  rc = CreateObject( 'TSEnhDrives',,
      'Object Navigator',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'ICONPOS=41,31;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||,
          'REPLACEICONS=1;'||,
          'HYPERDRIVE=1;'||,
          'READBEHIND=1;'||,
          'MINITREEICON=1;'||,
          'MINIDETAILICON=1;'||,
          'SORTFOLDERSFIRST=1;'||,
          'AUTONAVIGATE=0;'||,
          'CLICKMODE=DOUBLE;'||,
          'CONTENTSTYLE=SHORT;'||,
          'OBJECTID=<OBJD_OBJECTNAVIGATOR>',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'OBJDUSER.PDF',,
      '<OBJD_FOLDER>',,
      'ICONPOS=5,31;'||,
          'SHADOWID=<OBJD_USERSGUIDE_PDF>;'||,
          'OBJECTID=<OBJD_USERSGUIDE>',,
      CreateCollision )

  rc = CreateObject( 'TSPkgFolder',,
      'Package Folder',,
      '<OBJD_FOLDER>',,
      'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=27,19;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'IGNOREICONPOS=0;'||,
          'POPULATED=0;'||,
          'POPULATE=OUTOFDATE;'||,
          'OBJECTID=<OBJD_PACKAGEFOLDER>',,
      CreateCollision )

  rc = CreateObject( 'TSRarMgr',,
      'Empty.Rar',,
      '<OBJD_FOLDER>',,
      'TEMPLATE=YES;'||,
          'ICONPOS=52,57;'||,
          'READDATAFROM='WiseManager'\'name'\Object Desktop Package\Empty1.DAT;'||,
          'OBJECTID=<OBJD_EMPTYRAR>',,
      CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Create New',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=14,57;'||,
          'ICONVIEWPOS=14 58 81 34;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||,
          'OBJECTID=<OBJD_NEWINSTANCES>',,
      CreateCollision )

  rc = CreateObject( 'TSCPad',,
      'Control Center',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'ICONPOS=4,57;'||,
          'SELFCLOSE=1;'||,
          'BACKGROUND='BootDrive'\OS2\BITMAP\WSERVER.BMP,S,1,I,204 204 204;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ACTIVATE_AUTOHIDE=0;'||,
          'IPMETER_CPSIN=0;'||,
          'IPMETER_CPSOUT=0;'||,
          'IPMETER_CPSINMAX=0;'||,
          'IPMETER_CPSOUTMAX=0;'||,
          'IPMETER_CPSINAVG=1;'||,
          'IPMETER_CPSOUTAVG=1;'||,
          'IPMETER_BYTESINTOTAL=1;'||,
          'IPMETER_BYTESOUTTOTAL=1;'||,
          'IPMETER_GRAPHICAL=1;'||,
          'GLOBAL_SHOWTITLEBAR=0;'||,
          'GLOBAL_SNAPTOEDGE=1;'||,
          'GLOBAL_ADJUSTAVAILSPACE=1;'||,
          'CPU_NOFILL=0;'||,
          'CPU_NOGRAPH=0;'||,
          'CPU_DRAWTEXT=1;'||,
          'LAUNCH_TEXTSHOWN=1;'||,
          'LAUNCH_OBJECTDROPTARGETS=0;'||,
          'CLOCK_TYPE_DIGITAL=1;'||,
          'CLOCK_TYPE_TEXT=0;'||,
          'CLOCK_TYPE_ANALOG=0;'||,
          'CLOCK_SHOWSECONDS=0;'||,
          'CLOCK_SHOWDATE=0;'||,
          'CLOCK_BLINKING=0;'||,
          'VIRTDESK_DISPLAYICONS=1;'||,
          'VIRTDESK_DISPLAYTITLES=1;'||,
          'VIRTDESK_FOLLOWOFFSCREEN=1;'||,
          'VIRTDESK_MOVEFROMOFFSCREEN=0;'||,
          'VIRTDESK_NOTIFYOUTOFBOUNDS=1;'||,
          'GLOBAL_ACTIVATE=BOTTOMRIGHT;'||,
          'CPU_SPEED=SLOW;'||,
          'CPU_SIZE=MEDIUM;'||,
          'LAUNCH_ICONSIZE=SMALL;'||,
          'CLOCK_COLOR=GREEN;'||,
          'VIRTDESK_NUMDESKTOPS=4;'||,
          'IPMETER_INTERFACES=;'||,
          'WNDDATA_Virtual Desktop=0,0,640,18,00000000,00000000,00000000,6.Helvetica;'||,
          'SECTIONS=Virtual Desktop;'||,
          'SIZE=648,28;'||,
          'POS=-4,-5;'||,
          'REMOVELOCKEDWINDOWS=1;'||,
          'LOCKEDWINDOWS=Tab LaunchPad;'||,
          'OBJECTID=<OBJD_CONTROLCENTER>',,
      CreateCollision )

    rc = CreateObject( 'WPShadow',,
        'System Setup',,
        '<OBJD_CONTROLCENTER>',,
        'ICONPOS=35,491;'||,
            'SHADOWID=<WP_CONFIG>;'||,
            'OBJECTID=<OBJD_CONTROLCENTER_CONFIG>',,
        CreateCollision )

    rc = CreateObject( 'WPShadow',,
        'Desktop',,
        '<OBJD_CONTROLCENTER>',,
        'ICONPOS=4,491;'||,
            'SHADOWID=<WP_DESKTOP>;'||,
            'OBJECTID=<OBJD_CONTROLCENTER_DESKTOP>',,
        CreateCollision )

    rc = CreateObject( 'WPShadow',,
        'Information',,
        '<OBJD_CONTROLCENTER>',,
        'ICONPOS=46,491;'||,
            'SHADOWID=<WP_INFO>;'||,
            'OBJECTID=<OBJD_CONTROLCENTER_INFO>',,
        CreateCollision )

    rc = CreateObject( 'WPShadow',,
        'OS/2 System',,
        '<OBJD_CONTROLCENTER>',,
        'ICONPOS=14,491;'||,
            'SHADOWID=<WP_OS2SYS>;'||,
            'OBJECTID=<OBJD_CONTROLCENTER_OS2SYS>',,
        CreateCollision )

    rc = CreateObject( 'WPShadow',,
        'Drives',,
        '<OBJD_CONTROLCENTER>',,
        'ICONPOS=25,491;'||,
            'SHADOWID=<WP_DRIVES>;'||,
            'OBJECTID=<OBJD_CONTROLCENTER_DRIVES>',,
        CreateCollision )

    rc = CreateObject( 'WPShadow',,
        'Command Prompts',,
        '<OBJD_CONTROLCENTER>',,
        'ICONPOS=58,491;'||,
            'SHADOWID=<WP_PROMPTS>;'||,
            'OBJECTID=<OBJD_CONTROLCENTER_PROMPTS>',,
        CreateCollision )

  rc = CreateObject( 'TSScriptShutdown',,
      'Shutdown',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'ICONPOS=20,5;'||,
          'OBJECTID=<OBJD_SHUTDOWN>',,
      CreateCollision )

  rc = CreateObject( 'TSKeyLaunch',,
      'Keyboard LaunchPad',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'ICONPOS=41,43;'||,
          'ENABLED=1;'||,
          'ALLOWMULTIPLE=1;'||,
          'OBJECTID=<OBJD_KEYLAUNCHPAD>',,
      CreateCollision )

  rc = CreateObject( 'TSZooMgr',,
      'Empty.Zoo',,
      '<OBJD_FOLDER>',,
      'TEMPLATE=YES;'||,
          'ICONPOS=11,43;'||,
          'READDATAFROM='WiseManager'\'name'\Object Desktop Package\Empty2.DAT;'||,
          'OBJECTID=<OBJD_EMPTYZOO>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Desktop Backup^Advisor',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=16000;'||,
          'HELPLIBRARY=OBJDHELP.HLP;'||,
          'ICONPOS=24,57;'||,
          'EXENAME='RunFrom'\ObjectDeskTop\OBJDBKAD.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<OBJD_BACKUPADVISOR>',,
      CreateCollision )

  rc = CreateObject( 'TSScriptFind',,
      'Find',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'ICONPOS=18,43;'||,
          'OBJECTID=<OBJD_FIND>',,
      CreateCollision )

  rc = CreateObject( 'TSLHAMgr',,
      'Empty.Lzh',,
      '<OBJD_FOLDER>',,
      'TEMPLATE=YES;'||,
          'ICONPOS=43,57;'||,
          'READDATAFROM='WiseManager'\'name'\Object Desktop Package\Empty3.DAT;'||,
          'OBJECTID=<OBJD_EMPTYLZH>',,
      CreateCollision )

  rc = CreateObject( 'TSTabFolder',,
      'Tab LaunchPad',,
      '<OBJD_FOLDER>',,
          'ACTIVATE_AUTOHIDE=0;'||,
          'FRAME_SHOWING=1;'||,
          'TASKS_ENABLED=1;'||,
          'TASKS_MINONLY=0;'||,
          'TASKS_AUTOSWITCH=0;'||,
          'HINTS_DISABLED=0;'||,
          'ALLOW_DROP=1;'||,
          'GLOBAL_ACTIVATE=BOTTOMRIGHT;'||,
          'TAB_LOCATION=TOP;'||,
          'BUTTON_BORDER=SQUARED;'||,
          'PURGETABS=1;'||,
          'BUTTONFONT=8.Helv;'||,
          'ADDTABS=Tasks,Main,Applications,Communications,Games,Miscellaneous;'||,
          'ADDOBJECTS=1=<WP_OS2WIN>,1=<WP_WIN2WIN>,1=<OBJD_FIND>,1=<OBJD_LOCKUP>,1=<OBJD_SHUTDOWN>,1=<OBJD_OBJECTNAVIGATOR>,'||,
          '2=<WP_SYSED>,2=<WP_EPM>,3=<IAK>,3=<ADV_DIALER>,3=<IAK_SLIPPM>,4=<WP_GAMES>,4=<MAH_EXE>,4=<WP_CHESS>,4=<WP_KLDK>,'||,
          '5=<WP_SEEK>,5=<WP_FNTPAL>,5=<WP_HIRESCLRPAL>,;'||,
          'OBJECTID=<OBJD_TABLAUNCHPAD>',,
      CreateCollision )

/*
      'NOPRINT=YES;'||,
          'SELFCLOSE=1;'||,
          'SIZE=523,98;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONPOS=42,5;'||,
          'ICONVIEWPOS=8 46 81 14;'||,
*/

  rc = CreateObject( 'WPFolder',,
      'Stardock Extras!',,
      '<OBJD_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=30,5;'||,
          'ICONVIEWPOS=35 35 30 25;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||,
          'ICONFILE='WiseManager'\'name'\Object Desktop Package\Stardock Extras!.ICO;'||,
          'ICONNFILE='WiseManager'\'name'\Object Desktop Package\Stardock Extras!1.ICO;'||,
          'OBJECTID=<STARDOCK_EXTRAS>',,
      CreateCollision )

    rc = CreateObject( 'WPShadow',,
        'ICONS',,
        '<STARDOCK_EXTRAS>',,
        'SHADOWID='BootDrive||Apps'\ObjectDeskTop\EXTRAS\ICONS;'||,
            'OBJECTID=<STARDOCK_EXTRAS_ICONS>',,
        CreateCollision )

    rc = CreateObject( 'WPFolder',,
        'Archiver Documentation',,
        '<STARDOCK_EXTRAS>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'ICONVIEWPOS=30 33 40 30;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONGRID,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'ALWAYSSORT=YES;'||,
            'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS>',,
        CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'GNU COPYING^License Document',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\COPYING;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC9>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Info-Zip ZIP and Utility^Documentation',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\MANUAL;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC4>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'TAR Information',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEW.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\TAR.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC10>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Info-Zip ZipInfo^Documentation',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\zipinfo.doc;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC5>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'GTAR Information',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEW.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\GTAR.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC11>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'InfoZip Readme and^Copyright Information',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\README;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC6>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'LH/2^Release Notes',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\readme.doc;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC1>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Install RAR Archiver',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=RAR203P.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'name';'||,
              'PROGTYPE=WINDOWABLEVIO;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_RARINSTALL>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Zoo^Readme',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\README.OS2;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC7>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Info-Zip Unzip^Documentation',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\unzip.doc;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC2>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Archiver Utility^Copyright Infromation',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\COPYRGHT.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_COPYRIGHT>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'LH/2 Documentation',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='BootDrive'\OS2\VIEW.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\LH2.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC8>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Info-Zip Self Extractor^Documentation',,
          '<STARDOCK_EXTRAS_ARCHIVERS>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\BIN\unzipsfx.doc;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<STARDOCK_EXTRAS_ARCHIVERS_DOC3>',,
          CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Stardock Extras^Readme First!',,
        '<STARDOCK_EXTRAS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=E.EXE;'||,
            'PARAMETERS='RUNFROM'\ObjectDeskTop\EXTRAS\readme;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<STARDOCK_EXTRAS_README>',,
        CreateCollision )

    rc = CreateObject( 'WPShadow',,
        'Bitmaps',,
        '<STARDOCK_EXTRAS>',,
        'SHADOWID='BootDrive'\OS2\BITMAP;'||,
            'OBJECTID=<STARDOCK_EXTRAS_BITMAPS>',,
        CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Object Security^User''s Guide',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=16,19;'||,
          'EXENAME='BootDrive'\OS2\VIEW.EXE;'||,
          'PARAMETERS=WPSECUG.INF;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<OBJD_SECURITY_USERSGUIDE>',,
      CreateCollision )

  rc = CreateObject( 'TSObjAdv',,
      'Object Advisor',,
      '<OBJD_FOLDER>',,
      'ICONPOS=17,31;'||,
          'ADVISORTYPE=CLICK;'||,
          'VIEWEXTLINKSINT=0;'||,
          'READDATAFROM='WiseManager'\'name'\Object Desktop Package\Object Advisor.DAT;'||,
          'OBJECTID=<OBJD_OBJECTADVISOR>',,
      CreateCollision )

  rc = CreateObject( 'TSPackageFile',,
      'Object Package',,
      '<OBJD_FOLDER>',,
      'TEMPLATE=YES;'||,
          'ICONPOS=4,19;'||,
          'STORE_STOREIDS=1;'||,
          'STORE_SAVEICONS=1;'||,
          'STORE_STOREBITMAPS=0;'||,
          'COLLISION_PROMPT=1;'||,
          'RESTORE_AUTOEXTRACT=0;'||,
          'RESTORE_VERIFYPATHS=0;'||,
          'RESTORE_GENERATEREPORT=0;'||,
          'COLLISION=CREATE;'||,
          'READDATAFROM='WiseManager'\'name'\Object Desktop Package\Object Package.DAT;'||,
          'OBJECTID=<OBJD_OBJECTPACKAGE>',,
      CreateCollision )

  rc = CreateObject( 'WPDataFile',,
      'Sample Enhanced Data File',,
      '<OBJD_FOLDER>',,
      'ICONPOS=52,19;'||,
          'OBJECTID=<OBJD_ENHDATAFILE>',,
      CreateCollision )

  rc = CreateObject( 'TSTaskMgr',,
      'Task Manager',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=SETTINGS;'||,
          'ICONPOS=53,5;'||,
          'ALTTAB=1;'||,
          'CTRLESC=1;'||,
          'FLOWED=0;'||,
          'CENTERLOCKED=0;'||,
          'DISPLAYSTYLE=SMALL;'||,
          'OBJECTID=<OBJD_TASKMGR>',,
      CreateCollision )

  rc = CreateObject( 'TSScriptLockup',,
      'Lockup',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'ICONPOS=52,43;'||,
          'OBJECTID=<OBJD_LOCKUP>',,
      CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Sample Enhanced Folder',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=7,5;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'OBJECTID=<OBJD_ENHFOLDER>',,
      CreateCollision )

  rc = CreateObject( 'TSCPad',,
      'Object NetScan',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'ICONPOS=53,31;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ACTIVATE_AUTOHIDE=0;'||,
          'IPMETER_CPSIN=1;'||,
          'IPMETER_CPSOUT=1;'||,
          'IPMETER_CPSINMAX=1;'||,
          'IPMETER_CPSOUTMAX=1;'||,
          'IPMETER_CPSINAVG=1;'||,
          'IPMETER_CPSOUTAVG=1;'||,
          'IPMETER_BYTESINTOTAL=1;'||,
          'IPMETER_BYTESOUTTOTAL=1;'||,
          'IPMETER_GRAPHICAL=1;'||,
          'GLOBAL_SHOWTITLEBAR=0;'||,
          'GLOBAL_SNAPTOEDGE=0;'||,
          'GLOBAL_ADJUSTAVAILSPACE=0;'||,
          'CPU_NOFILL=0;'||,
          'CPU_NOGRAPH=0;'||,
          'CPU_DRAWTEXT=1;'||,
          'LAUNCH_TEXTSHOWN=1;'||,
          'LAUNCH_OBJECTDROPTARGETS=0;'||,
          'CLOCK_TYPE_DIGITAL=0;'||,
          'CLOCK_TYPE_TEXT=0;'||,
          'CLOCK_TYPE_ANALOG=1;'||,
          'CLOCK_SHOWSECONDS=0;'||,
          'CLOCK_SHOWDATE=0;'||,
          'CLOCK_BLINKING=0;'||,
          'VIRTDESK_DISPLAYICONS=1;'||,
          'VIRTDESK_DISPLAYTITLES=1;'||,
          'VIRTDESK_FOLLOWOFFSCREEN=1;'||,
          'VIRTDESK_MOVEFROMOFFSCREEN=0;'||,
          'VIRTDESK_NOTIFYOUTOFBOUNDS=1;'||,
          'GLOBAL_ACTIVATE=BOTTOMRIGHT;'||,
          'CPU_SPEED=SLOW;'||,
          'CPU_SIZE=MEDIUM;'||,
          'LAUNCH_ICONSIZE=SMALL;'||,
          'CLOCK_COLOR=GREEN;'||,
          'VIRTDESK_NUMDESKTOPS=4;'||,
          'IPMETER_INTERFACES=;'||,
          'WNDDATA_Clock=0,0,110,49,00000000,000000FF,00FFFFFF,8.Helv;'||,
          'WNDDATA_Object NetScan=0,49,110,149,00000000,00000000,00000000,7.Helvetica;'||,
          'SECTIONS=Clock,Object NetScan;'||,
          'SIZE=116,204;'||,
          'POS=45,29;'||,
          'OBJECTID=<OBJD_NETSCAN>',,
      CreateCollision )

  rc = CreateObject( 'TSTarMgr',,
      'Empty.Tar',,
      '<OBJD_FOLDER>',,
      'TEMPLATE=YES;'||,
          'ICONPOS=60,57;'||,
          'READDATAFROM='WiseManager'\'name'\Object Desktop Package\Empty4.DAT;'||,
          'OBJECTID=<OBJD_EMPTYTAR>',,
      CreateCollision )

  rc = CreateObject( 'TSMasterSetup',,
      'Master Setup',,
      '<OBJD_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=SETTINGS;'||,
          'ICONPOS=60,43;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'AUTOSTART_TASKMGR=1;'||,
          'AUTOSTART_KEYLNCH=0;'||,
          'AUTOSTART_CONTROLCENTER=1;'||,
          'AUTOSTART_TABLAUNCHPAD=0;'||,
          'AUTOSTART_OBJECTSCHEDULER=1;'||,
          'WINDOW_CLOSEBTN=1;'||,
          'WINDOW_REPLACE_FRAME_BUTTONS=1;'||,
          'WINDOW_REPLACE_SCROLL_BUTTONS=1;'||,
          'WINDOW_WINDOW_DRAG=0;'||,
          'WINDOW_ROLLUPCLICK=0;'||,
          'WINDOW_ROLLUPBUTTON=0;'||,
          'OBJECTID=<OBJD_SETUP>',,
      CreateCollision )

/*
  rc = CreateObject( 'WPProgram',,
      'Installation Utility',,
      '<OBJD_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=17000;'||,
          'HELPLIBRARY=OBJDHELP.HLP;'||,
          'ICONPOS=28,43;'||,
          'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'name';'||,
          'PARAMETERS=/C 'RunFrom'\'name'\EPFINSTS.EXE /C:'RunFrom'\'name'\OBJDESK.ICF /O:DRIVE;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='WiseManager'\'name'\Object Desktop Package\Installation Utility.ICO;'||,
          'OBJECTID=<OBJD_FOLDERNSTS>',,
      CreateCollision )
*/

  rc = CreateObject( 'TSInspect',,
      'Object Inspector',,
      '<OBJD_FOLDER>',,
      'ICONPOS=28,31;'||,
          'OBJECTID=<OBJD_OBJECTINSPECTOR>',,
      CreateCollision )

  rc = CreateObject( 'TSArcFileMgr',,
      'Empty.Arc',,
      '<OBJD_FOLDER>',,
      'TEMPLATE=YES;'||,
          'ICONPOS=35,57;'||,
          'READDATAFROM='WiseManager'\'name'\Object Desktop Package\Empty5.DAT;'||,
          'OBJECTID=<OBJD_EMPTYARC>',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'PACKAGES',,
      '<OBJD_FOLDER>',,
      'ICONPOS=38,19;'||,
          'SHADOWID=<OBJD_PACKAGESDIR>;'||,
          'OBJECTID=<OBJD_FOLDER_PACKAGES>',,
      CreateCollision )

  rc = CreateObject( 'TSClassEdit',,
      'Workplace Shell^Class Editor',,
      '<OBJD_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'ICONPOS=5,65530;'||,
          'OBJECTID=<OBJD_CLASSEDITOR>',,
      CreateCollision )

return

RegisterClasses:
/*

Say
Say 'Registering classes....'
Say
Say 'The following classes will be registered:'
Say
Say '  WPObjectPlus      TSArcFileMgr      TSZooElem         TSZipElem         '
Say '  TSRarElem         TSTarElem         TSObjAdv          TSZooMgr          '
Say '  TSZipMgr          TSTarMgr          TSScriptLockup    TSRarMgr          '
Say '  TSTaskMgr         TSScript          TSKeyDefn         TSClassEdit       '
Say '  TSInspect         WPSecs01          TSLHAElem         TSLHAMgr          '
Say '  TSKeyLaunch       TSCPad            TSEnhDrives       TSTabFolder       '
Say '  TSPkgFolder       TSEnhFolder       LSDataFile        TSScriptShutdown  '
Say '  TSFldrParent      TSPackageFile     TSEnhDataFile     WPSecure          '
Say '  TSPackageElem     TSArcElem         MMShadow          WPSecpgm          '
Say '  TSScriptFind      TSMasterSetup     TSArcMgr          TSArcFileElem     '
Say '  LSDirectory       '
Say
Say 'Press enter to register 41 classes for object creation,'
Call CharOut, 'or type any other key and enter to ignore: '
Say
Parse Pull Answer
If Answer <> '' Then return
*/

  rc = MySysRegisterObjectClass( 'TSArcFileMgr', 'OBJDOARC' )

  rc = MySysRegisterObjectClass( 'TSZooElem', 'OBJDOARC' )

  rc = MySysRegisterObjectClass( 'TSZipElem', 'OBJDOARC' )

  rc = MySysRegisterObjectClass( 'TSRarElem', 'OBJDARAR' )

  rc = MySysRegisterObjectClass( 'TSTarElem', 'OBJDATAR' )

  rc = MySysRegisterObjectClass( 'TSObjAdv', 'OBJDOADV' )

  rc = MySysRegisterObjectClass( 'TSZooMgr', 'OBJDOARC' )

  rc = MySysRegisterObjectClass( 'TSZipMgr', 'OBJDOARC' )

  rc = MySysRegisterObjectClass( 'TSTarMgr', 'OBJDATAR' )

  rc = MySysRegisterObjectClass( 'TSScriptLockup', 'OBJDSCRP' )

  rc = MySysRegisterObjectClass( 'TSRarMgr', 'OBJDARAR' )

  rc = MySysRegisterObjectClass( 'TSTaskMgr', 'OBJDTASK' )

  rc = MySysRegisterObjectClass( 'TSScript', 'OBJDSCRP' )

  rc = MySysRegisterObjectClass( 'TSKeyDefn', 'OBJDKLCH' )

  rc = MySysRegisterObjectClass( 'TSClassEdit', 'OBJDOBJU' )

  rc = MySysRegisterObjectClass( 'TSInspect', 'OBJDOBJU' )

  rc = MySysRegisterObjectClass( 'WPSecs01', 'WPSECS01' )

  rc = MySysRegisterObjectClass( 'TSLHAElem', 'OBJDOARC' )

  rc = MySysRegisterObjectClass( 'TSLHAMgr', 'OBJDOARC' )

  rc = MySysRegisterObjectClass( 'TSKeyLaunch', 'OBJDKLCH' )

  rc = MySysRegisterObjectClass( 'TSCPad', 'OBJDCCEN' )

  rc = MySysRegisterObjectClass( 'TSEnhDrives', 'OBJDONAV' )

  rc = MySysRegisterObjectClass( 'TSTabFolder', 'OBJDTLCH' )

  rc = MySysRegisterObjectClass( 'TSPkgFolder', 'OBJDPKGF' )

  rc = MySysRegisterObjectClass( 'TSEnhFolder', 'OBJDEFLD' )

  rc = MySysRegisterObjectClass( 'TSScriptShutdown', 'OBJDSCRP' )

  rc = MySysRegisterObjectClass( 'TSFldrParent', 'OBJDONAV' )

  rc = MySysRegisterObjectClass( 'TSPackageFile', 'OBJDOPKG' )

  rc = MySysRegisterObjectClass( 'TSEnhDataFile', 'OBJDEDAT' )

  rc = MySysRegisterObjectClass( 'WPSecure', 'WPSECURE' )

  rc = MySysRegisterObjectClass( 'TSPackageElem', 'OBJDOPKG' )

  rc = MySysRegisterObjectClass( 'TSArcElem', 'OBJDOARC' )

  rc = MySysRegisterObjectClass( 'WPSecpgm', 'WPSECPGM' )

  rc = MySysRegisterObjectClass( 'TSScriptFind', 'OBJDSCRP' )

  rc = MySysRegisterObjectClass( 'TSMasterSetup', 'OBJDMSET' )

  rc = MySysRegisterObjectClass( 'TSArcMgr', 'OBJDOARC' )

  rc = MySysRegisterObjectClass( 'TSArcFileElem', 'OBJDOARC' )

return


