/* */

parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then parse var string "'"BootDrive" "AppServer" "Action"'"
if (string<>"" & BootDrive="") then parse var string BootDrive" "AppServer" "Action
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */

  ProgramName = "TCPIP"
  p.Title = "PComos2"
  p.ThisCMDFileName = "CreatePComos2.CMD"
  p.DirName = "PComos2"
  p.Location = "<WP_APPSFOLDER>"
  p.ObjectID = "<PComos2>"
  p.FitToCheck = ""  /* File to check to see if this is a fresh install */
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = ""   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""

  call StartUp

  CreateCollision = 'Replace'     /* 'Fail', 'Replace', or 'Update' */

Call RegisterClasses
Call CreateObjects

syntax:
signal CMDExit
return 0

CreateObjects:

   title = "Personal Communications^3270/5250 Emulation"

rc = CreateObject( 'WPFolder',,
    title,,
    '<WP_PROGRAMSFOLDER>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'ALWAYSSORT=YES;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ICONFILE='RunFrom'\DeskTop\PComOS2\Personal Communications!3270!5250 Emulation2.ICO;'||,
        'ICONNFILE=1,'RunFrom'\DeskTop\PComOS2\Personal Communications!3270!5250 Emulation3.ICO;'||,
        'OBJECTID=<PCOMOS2>',,
    CreateCollision )

  rc = CreateObject( 'WPShadow',,
      title,,
      '<WP_DESKTOP>',,
      'NOPRINT=YES;'||,
         'DEFAULTVIEW=UNKNOWN;'||,
         'HELPPANEL=1277;'||,
         'SHADOWID=<PCOMOS2>;'||,
         'OBJECTID=<PCOMOS2Shadow>',,
      CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Administration Tools',,
      '<PCOMOS2>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'ALWAYSSORT=YES;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='RunFrom'\DeskTop\PComOS2\Administration Tools2.ICO;'||,
          'ICONNFILE=1,'RunFrom'\DeskTop\PComOS2\Administration Tools3.ICO;'||,
          'OBJECTID=<PCOMADM>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      '3270/5250 Emulator',,
      '<PCOMOS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='RunFrom'\TCPIP\PCOMOS2\PCSWS.EXE;'||,
          'STARTUPDIR='BootDrive'\TCPIP\PCOMOS2;'||,
          'PARAMETERS="'BootDrive'\TCPIP\PCOMOS2\PCOMOS2.WS";'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<346101>',,
      CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Trace-Capture Program (PCSMON)',,
        '<PCOMADM>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='RunFrom'\TCPIP\PCOMOS2\PCSMON.EXE;'||,
            'STARTUPDIR='BootDrive'\TCPIP\PCOMOS2;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<35353>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Trace-Setup Utility (PCSTRSET)',,
        '<PCOMADM>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='RunFrom'\TCPIP\PCOMOS2\PCSTRSET.EXE;'||,
            'STARTUPDIR='BootDrive'\TCPIP\PCOMOS2;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<35355>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Maintenance Aid',,
        '<PCOMADM>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='RunFrom'\TCPIP\PCOMOS2\PCSMAINT.EXE;'||,
            'STARTUPDIR='BootDrive'\TCPIP\PCOMOS2;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<35352>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Adapter-Status Reporter (TOKSTAT)',,
        '<PCOMADM>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='RunFrom'\TCPIP\PCOMOS2\TOKSTAT.EXE;'||,
            'STARTUPDIR='BootDrive'\TCPIP\PCOMOS2;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<35354>',,
        CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Start/Configure Session',,
      '<PCOMOS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='RunFrom'\TCPIP\PCOMOS2\PCSWS.EXE;'||,
          'STARTUPDIR='BootDrive'\TCPIP\PCOMOS2;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<34610>',,
      CreateCollision )

return

RegisterClasses:

Say
Say 'Registering classes....'
Say
Say 'The following classes will be registered:'
Say
Say '  Telnet            WPSecs01          AdvCust           AdvReg            '
Say '  AdvUser           LSDataFile        AdvDialer         WPSecure          '
Say '  MMShadow          WPSecpgm          Ftp               LSDirectory       '
Say
/* Say 'Press enter to register 12 classes for object creation,'  */
/* Call CharOut, 'or type any other key and enter to ignore: ' */
Say
Answer = ''
If Answer <> '' Then return
/*
  If SysRegisterObjectClass( 'Telnet', 'WPTELNET' ) <> 1 Then do
      Say 'Can''t register class Telnet with WPTELNET.'
  end
  Else
      Say 'Registered class Telnet with WPTELNET.'
*/

  If SysRegisterObjectClass( 'WPSecs01', 'WPSECS01' ) <> 1 Then do
      Say 'Can''t register class WPSecs01 with WPSECS01.'
  end
  Else
      Say 'Registered class WPSecs01 with WPSECS01.'

  If SysRegisterObjectClass( 'AdvCust', 'ADVCUST' ) <> 1 Then do
      Say 'Can''t register class AdvCust with ADVCUST.'
  end
  Else
      Say 'Registered class AdvCust with ADVCUST.'

  If SysRegisterObjectClass( 'AdvReg', 'ADVREG' ) <> 1 Then do
      Say 'Can''t register class AdvReg with ADVREG.'
  end
  Else
      Say 'Registered class AdvReg with ADVREG.'

  If SysRegisterObjectClass( 'AdvUser', 'ADVUSER' ) <> 1 Then do
      Say 'Can''t register class AdvUser with ADVUSER.'
  end
  Else
      Say 'Registered class AdvUser with ADVUSER.'

  If SysRegisterObjectClass( 'LSDataFile', 'LSGWPS' ) <> 1 Then do
      Say 'Can''t register class LSDataFile with LSGWPS.'
  end
  Else
      Say 'Registered class LSDataFile with LSGWPS.'

  If SysRegisterObjectClass( 'AdvDialer', 'ADVDIAL' ) <> 1 Then do
      Say 'Can''t register class AdvDialer with ADVDIAL.'
  end
  Else
      Say 'Registered class AdvDialer with ADVDIAL.'

/*
  If SysRegisterObjectClass( 'WPSecure', 'WPSECURE' ) <> 1 Then do
      Say 'Can''t register class WPSecure with WPSECURE.'
  end
  Else
      Say 'Registered class WPSecure with WPSECURE.'

  If SysRegisterObjectClass( 'MMShadow', 'MMSHD' ) <> 1 Then do
      Say 'Can''t register class MMShadow with MMSHD.'
  end
  Else
      Say 'Registered class MMShadow with MMSHD.'

  If SysRegisterObjectClass( 'WPSecpgm', 'WPSECPGM' ) <> 1 Then do
      Say 'Can''t register class WPSecpgm with WPSECPGM.'
  end
  Else
      Say 'Registered class WPSecpgm with WPSECPGM.'
*/

  If SysRegisterObjectClass( 'Ftp', 'FTPWPS' ) <> 1 Then do
      Say 'Can''t register class Ftp with FTPWPS.'
  end
  Else
      Say 'Registered class Ftp with FTPWPS.'

  If SysRegisterObjectClass( 'LSDirectory', 'LSGWPS' ) <> 1 Then do
      Say 'Can''t register class LSDirectory with LSGWPS.'
  end
  Else
      Say 'Registered class LSDirectory with LSGWPS.'

return


/* Copy these lines for every ap */
CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    /* Say "Creating ["Title"]" */
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say " > failed to create ["Title" | "Class"] at location ["Location"]"
    else
        call TV_DosSleep 0
return rc
 
StartUp: /* Do not make this a procedure */
  signal on Syntax name lab0
  rc = RxFuncAdd( "SysLoadFuncs", "REXXUTIL", "SYSLOADFUNCS" )
  rc = SysLoadFuncs()
lab0:
  signal on Syntax name lab1
    rc = RxFuncAdd( "TV_RegisterExtFunc", "TVoiceU", "TV_RegisterExtFunc" )
    rc = TV_RegisterExtFunc()
lab1:
  signal on Syntax
 
  CRLF = D2C(13)||D2C(10)

   Apps = "\Apps"
   rc = AppServer( AppServer, BootDrive )
   parse var rc AppServer" "RunFrom
   RunFrom = RunFrom || Apps

   if (p.FileToCheck <> "") then do
      rc = FileExists(p.FileToCheck)
      if (rc=0) then rc = FileExists(BootDrive||Apps"\"p.DirName"\"strip(p.FileToCheck,"L","\"))
      if (rc=0) then rc = FileExists(BootDrive||Apps"\"strip(p.FileToCheck,"L","\"))
   end
   else if (p.DirToCheck <> "") then do
      rc = IsDir(p.DirToCheck)
      if (rc=0) then do
         rc = IsDir(BootDrive|| Apps"\"p.DirName"\"strip(p.DirToCheck,"L","\"))
         if (rc=0) then rc = IsDir(RunFrom"\"strip(p.DirToCheck,"L","\"))
      end
   end
   else if (p.PathToCheck <> "") then do
      Path=translate(Value( "PATH", , "OS2ENVIRONMENT" ))
      rc = pos(translate(RunFrom || "\" || strip(p.PathToCheck,"L","\")),Path)
   end /* do */
   else if (p.ClassToCheck <> "") then do
      parse var p.ClassToCheck Classname" "Dll
      p.ExeDir = RunFrom"\"p.DirName
      rc = MySysRegisterObjectClass( Classname, Dll )
   end 
   else rc = IsDir(RunFrom"\"strip(p.DirName,"L","\"))

   if (rc=0) then do  
    rc = CreateObject( "WPProgram",,
      p.Title||CRLF||"(Reboot Required)",,
      "<WP_START>",,
      "NOPRINT=YES;"||,
          "DEFAULTVIEW=RUNNING;"||,
          "EXENAME="RunFrom"\DeskTop\"p.ThisCMDFileName";"||,
          "PARAMETERS="argString";"||,
          "PROGTYPE=PM;"||,
          "OBJECTID=<"p.Title"_FOLDER_CLEANUP>",,
      "REPLACE" )
 
    rc = CreateObject( "WPShadow",,
        p.Title||CRLF||"(Reboot Required)",,
        "<WP_DESKTOP>",,
            "SHADOWID=<"p.Title"_FOLDER_CLEANUP>;"||,
            "OBJECTID=<"p.Title"_FOLDER_CLEANUP_SHADOW>",,
        "REPLACE" )
 
      "@exit"
 
   end /* do */
 
/*
     Action can be blank, CLEANUP, or START 
     blank means normal create with REBOOT required title
     CLEANUP means create ICON without the REBOOT required title 
     START   means starts up the main program
  */
 
  Action = translate(Action)
  if (Action = "START") then do
     if (p.ObjectID <> "") then rc = SysOpenObject(p.ObjectID, "RUNNING", 0)
     "@exit"
     return
  end /* do */
 
  if (p.Location = "<WP_CLIENTAPPSFOLDER>") then call ClientAppsFolder

return
 
cmdExit:
   rc = SysDestroyObject( "<"p.Title"_FOLDER_CLEANUP_SHADOW>" )
   rc = SysDestroyObject( "<"p.Title"_FOLDER_CLEANUP>" )
"@exit"
return
 
IsDir: procedure
   parse arg DirName
   DirName=strip(DirName,"B","'")
   if (DirName="") then do
      /* say "IsDir: illegal file spec "DirName */
      return 0
   end
   if stream(DirName"\.","C","QUERY DATETIME")="" then rc = 0
   else rc = 1
return rc

FileExists: procedure
   parse arg FileName
   FileName=strip(FileName,"B","'")
   if (FileName="") then do
      return 0
   end
   if stream(FileName,"C","QUERY DATETIME")="" then rc = 0
   else rc = 1
return rc

/* Decide where the AppServer is */
AppServer: procedure expose Apps
  parse arg AppServer, BootDrive
  if (AppServer="") then do
     RunFrom=BootDrive
     AppServer=BootDrive
     if (IsDir(RunFrom"\Apps")=0) then Apps = ""
  end
  else do
     parse var AppServer AppServer"|"MyServer
     if (substr(AppServer,1,2)="\\") then do 
        if (MyServer<>"") then do
           parse var AppServer "\\"nam"\"rest
           if (translate(nam)=translate(MyServer)) then RunFrom = BootDrive
           else RunFrom = AppServer
        end /* do */
        else RunFrom=AppServer
     end /* do */
     else do
        parse var AppServer RunFrom"|"AppServer"|"rest
        if (IsDir(RunFrom"\Apps")=0) then Apps = ""
        if (AppServer="") then AppServer=RunFrom
     end /* do */
  end /* do */
return AppServer" "RunFrom

ClientAppsFolder:
     p.Location = "<WP_CLIENTAPPSFOLDER>"
     rc = CreateObject( "WPFolder",,
         "Client Applications",,
         "<WP_APPSFOLDER>",,
        'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID='p.Location,,
         'Update' )
return p.Location

/* End of Copy these lines for every ap */

