/* */

parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then do
   parse var string "'"BootDrive" "AppServer" "Action"'"
end
if (string<>"" & BootDrive="") then do
   parse var string BootDrive" "AppServer" "Action
end
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */

  p.Title = "PatchDeskTop"  /* Name of this application */
  p.ThisCMDFileName = "CreatePatchDeskTop.CMD"  /* Name of this command file */
  p.DirName = "PatchDeskTop"  /* Name of main dir */
  p.Location = "<WP_APPSFOLDER>"  /* Location to place main folder */
  p.ObjectID = "<OBJECT_PatchDeskTop>"  /* Object to start (usually the main exe) */
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = "{NOCHECK}"   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""   /* Class to check to see if this is a fresh install (classname dllname) */

  call StartUp

  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */

  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= ""
  p.ObjectIDFolder = "" /* Set to blank for no folder */

signal on syntax
  CreateCollision = p.Flag
  Call RegisterClasses
  Call CreateObjects

  /* Do I want to do this ? */
  /* call SysSetObjectData BootDrive"\DESKTOP","OBJECTID=<WP_DESKTOP>" */

  signal CMDExit

syntax:
/* trace ?i */
say "Syntax error.   LastObject was "LastObjectCreated
signal CMDExit
return 0


CreateObjects:

rc = SysDestroyObject( "<WP_DBOOT>")

rc = MyMyCreateObject( 'WPFolder',,
    'Problem Determination Tools',,
    '<WP_OS2SYS>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=32685;'||,
        'HELPLIBRARY='OS2Dir'\HELP\PROBDET.HLP;'||,
        'ICONPOS=34,20;'||,
        'ICONVIEWPOS=3 8 79 31;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=FLOWED,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||OtherBackground||,
        'OBJECTID=<PDP_FOLDER>',,
    CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'PM Dump Facility',,
      '<PDP_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=33050;'||,
          'HELPLIBRARY='OS2Dir'\HELP\PMDF.HLP;'||,
          'ICONPOS=32,18;'||,
          'ASSOCFILTER=DUMPDATA.*,PDUMP.*,*.DMP;'||,
          'EXENAME='OS2Dir'\PDPSI\PMDF\PMDF.EXE;'||,
          'STARTUPDIR='BootDrive';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<PDP_PMDF>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Trace Options',,
      '<PDP_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=32684;'||,
          'HELPLIBRARY='OS2Dir'\HELP\PROBDET.HLP;'||,
          'ICONPOS=3,9;'||,
          'ICONVIEWPOS=15 62 79 19;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'OBJECTID=<PDP_TRACE_FOLDER>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Trace OFF Clear Buffer',,
        '<PDP_TRACE_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=33381;'||,
            'HELPLIBRARY='OS2Dir'\HELP\TRACE.HLP;'||,
            'ICONPOS=34,5;'||,
            'EXENAME='OS2Dir'\TRACE.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=OFF /C;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Trace OFF Clear Buffer.ICO;'||,
            'OBJECTID=<PDP_TRACE_OFFCLEAR>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Resume Trace',,
        '<PDP_TRACE_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=33384;'||,
            'HELPLIBRARY='OS2Dir'\HELP\TRACE.HLP;'||,
            'ICONPOS=54,5;'||,
            'EXENAME='OS2Dir'\TRACE.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=ON /R;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Resume Trace.ICO;'||,
            'OBJECTID=<PDP_TRACE_ONRESUME>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Trace ON',,
        '<PDP_TRACE_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=33386;'||,
            'HELPLIBRARY='OS2Dir'\HELP\TRACE.HLP;'||,
            'ICONPOS=3,5;'||,
            'EXENAME='OS2Dir'\TRACE.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=ON;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Trace ON.ICO;'||,
            'OBJECTID=<PDP_TRACE_ON>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Trace ON Clear Buffer',,
        '<PDP_TRACE_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=33385;'||,
            'HELPLIBRARY='OS2Dir'\HELP\TRACE.HLP;'||,
            'ICONPOS=21,5;'||,
            'EXENAME='OS2Dir'\TRACE.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=ON /C;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Trace ON Clear Buffer.ICO;'||,
            'OBJECTID=<PDP_TRACE_ONCLEAR>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Suspend Trace',,
        '<PDP_TRACE_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=33383;'||,
            'HELPLIBRARY='OS2Dir'\HELP\TRACE.HLP;'||,
            'ICONPOS=45,5;'||,
            'EXENAME='OS2Dir'\TRACE.EXE;'||,
            'PARAMETERS=ON /S;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Suspend Trace.ICO;'||,
            'OBJECTID=<PDP_TRACE_ONSUSPEND>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Trace OFF',,
        '<PDP_TRACE_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=33382;'||,
            'HELPLIBRARY='OS2Dir'\HELP\TRACE.HLP;'||,
            'ICONPOS=11,5;'||,
            'EXENAME='OS2Dir'\TRACE.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=OFF;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Trace OFF.ICO;'||,
            'OBJECTID=<PDP_TRACE_OFF>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPUrl',,
      'Support through the Internet',,
      '<PDP_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=32682;'||,
          'HELPLIBRARY='OS2Dir'\HELP\PROBDET.HLP;'||,
          'ICONPOS=46,18;'||,
          'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\Support through the Internet.DAT;'||,
          'OBJECTID=<PDP_URL_SUPPORT>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'FFST Setup',,
      '<PDP_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=32776;'||,
          'HELPLIBRARY='OS2Dir'\HELP\FFST.HLP;'||,
          'ICONPOS=13,18;'||,
          'EXENAME='OS2Dir'\FFSTCONF.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<FFST_SETUP>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'Hard File Monitor',,
      '<PDP_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=349;'||,
          'HELPLIBRARY='OS2Dir'\HELP\HDMON.HLP;'||,
          'ICONPOS=22,18;'||,
          'EXENAME='OS2Dir'\HDMON.EXE;'||,
          'STARTUPDIR='BootDrive';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<PDP_SMARTPFA>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'Trace Formatter',,
      '<PDP_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=33026;'||,
          'HELPLIBRARY='OS2Dir'\HELP\TRACE.HLP;'||,
          'ICONPOS=69,18;'||,
          'EXENAME='OS2Dir'\TRACEFMT.EXE;'||,
          'STARTUPDIR='BootDrive';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<PDP_TRACE_FMT>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'System Error Log',,
      '<PDP_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=32744;'||,
          'HELPLIBRARY='OS2Dir'\HELP\SYSLOGPM.HLP;'||,
          'ICONPOS=59,18;'||,
          'EXENAME='OS2Dir'\SYSLOGPM.EXE;'||,
          'STARTUPDIR='BootDrive';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<PDP_SYSLOG>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'DMI MIF Browser',,
      '<PDP_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=3200;'||,
          'HELPLIBRARY='OS2Dir'\HELP\DMIPM.HLP;'||,
          'ICONPOS=4,18;'||,
          'EXENAME='OS2Dir'\DMIPM.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<DMI_MIF_BROWSER>',,
      CreateCollision )

rc = MyMyCreateObject( 'WPFolder',,
    'System Setup',,
    '<WP_OS2SYS>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=1220;'||,
        'ICONPOS=52,20;'||,
        'ICONVIEWPOS=11 8 79 56;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=FLOWED,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||OtherBackground||,
        'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\System Setup.ICO;'||,
        'OBJECTID=<WP_CONFIG>',,
    CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'Create Utility Diskettes',,
      '<WP_CONFIG>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=32163;'||,
          'ICONPOS=15,44;'||,
          'EXENAME='OS2Dir'\INSTALL\BOOTDISK.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<WP_BOOT>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPSpool',,
      'Spooler',,
      '<WP_CONFIG>',,
      'NOCOPY=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'ICONPOS=43,20;'||,
          'OBJECTID=<WP_SPOOL>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'DHCP Monitor',,
      '<WP_CONFIG>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=34,44;'||,
          'EXENAME=DHCPMON.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<WS_DHCP_MONITOR>',,
      CreateCollision )

  rc = MyMyCreateObject( 'BDview',,
      'Language Viewer',,
      '<WP_CONFIG>',,
      'NOCOPY=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=4,33;'||,
          'OBJECTID=<BDview>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPSchemePalette',,
      'Scheme Palette',,
      '<WP_CONFIG>',,
      'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'ICONPOS=19,20;'||,
          'XCELLCOUNT=3;'||,
          'YCELLCOUNT=5;'||,
          'XCELLWIDTH=146;'||,
          'YCELLHEIGHT=32;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'OBJECTID=<WP_SCHPAL96>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPStickMouse',,
      'Mouse',,
      '<WP_CONFIG>',,
      'NOCOPY=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=SETTINGS;'||,
          'ICONPOS=43,33;'||,
          'OBJECTID=<WPSTK_MOUSE>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPHwManager',,
      'Hardware Manager',,
      '<WP_CONFIG>',,
      'NOCOPY=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=DETAILS;'||,
          'ICONPOS=52,44;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'OBJECTID=<WP_HWMGR>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPColorPalette',,
      'Solid Color Palette',,
      '<WP_CONFIG>',,
      'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'ICONPOS=30,20;'||,
          'XCELLCOUNT=8;'||,
          'YCELLCOUNT=2;'||,
          'XCELLWIDTH=30;'||,
          'YCELLHEIGHT=30;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'OBJECTID=<WP_LORESCLRPAL>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Install/Remove',,
      '<WP_CONFIG>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=63,44;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Install!Remove.ICO;'||,
          'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\Install!Remove1.ICO;'||,
          'OBJECTID=<WP_INSTREMFOLDER>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Selective Uninstall',,
        '<WP_INSTREMFOLDER>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=32162;'||,
            'EXENAME='OS2Dir'\INSTALL\UNINSTAL.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_UNINST>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'File and Print Client^Install/Remove',,
        '<WP_INSTREMFOLDER>',,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=301;'||,
            'HELPLIBRARY='GetFullPathOf('NETPROG')'\LSIWOBJS.HLP;'||,
            'EXENAME='GetFullPathOf('IBMLAN')'\INSTALL\LANINST.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=/20;'||,
            'PROGTYPE=FULLSCREEN;'||,
            'MINIMIZED=YES;'||,
            'OBJECTID=<LS_INSTALL>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Remove Installation^for Networking',,
        '<WP_INSTREMFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='BootDrive'\IBMINST\NPRMINST.EXE;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Remove Installation!for Networking.ICO;'||,
            'OBJECTID=<CLTRMOVE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Device Driver Install',,
        '<WP_INSTREMFOLDER>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=12221;'||,
            'EXENAME='OS2Dir'\INSTALL\DDINSTAL.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_DDINST>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Selective Install^for Networking',,
        '<WP_INSTREMFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='BootDrive'\IBMINST\NPCONFIG.EXE;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Selective Install!for Networking.ICO;'||,
            'OBJECTID=<CLTSTART>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Selective Install',,
        '<WP_INSTREMFOLDER>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=12220;'||,
            'EXENAME='OS2Dir'\INSTALL\INSTALL.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_INST>',,
        CreateCollision )

  call SysDestroyObject "<LVMGUI>"       
  rc = MyMyCreateObject( 'WPProgram',,
      'Logical Volume Manager',,
      '<WP_CONFIG>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=22,33;'||,
          'EXENAME='BootDrive'\os2\lvmgui.cmd;'||,
          'STARTUPDIR='BootDrive';'||,
          'PARAMETERS=;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Logical Volume Manager.ICO;'||,
          'OBJECTID=<LVMGUI>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPWinConfig',,
      'WIN/eCS Setup',,
      '<WP_CONFIG>',,
      'NOCOPY=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=SETTINGS;'||,
          'ICONPOS=13,7;'||,
          'OBJECTID=<WP_WINCFG>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'Locale',,
      '<WP_CONFIG>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=12,33;'||,
          'EXENAME='OS2Dir'\GLOCALE.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<WP_LOCALE>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPColorPalette',,
      'Mixed Color Palette',,
      '<WP_CONFIG>',,
      'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'ICONPOS=35,33;'||,
          'XCELLCOUNT=16;'||,
          'YCELLCOUNT=16;'||,
          'XCELLWIDTH=15;'||,
          'YCELLHEIGHT=15;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'OBJECTID=<WP_HIRESCLRPAL>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPSystem',,
      'System',,
      '<WP_CONFIG>',,
      'NOCOPY=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=SETTINGS;'||,
          'ICONPOS=48,20;'||,
          'OBJECTID=<WP_SYSTEM>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'MPTS^Network Adapters^and Protocol Services',,
      '<WP_CONFIG>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=52,33;'||,
          'EXENAME=MPTS.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<NTS_MPTS_ICON>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'Add Programs',,
      '<WP_CONFIG>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=4508;'||,
          'ICONPOS=3,44;'||,
          'EXENAME='OS2Dir'\INSTALL\MIGRATE.EXE;'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\migrate.ICO;'||,
          'OBJECTID=<WP_MIGAPP>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPClock',,
      'System Clock',,
      '<WP_CONFIG>',,
      'NOCOPY=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'ICONPOS=55,20;'||,
          'OBJECTID=<WP_CLOCK>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'Refresh Removable Media',,
      '<WP_CONFIG>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=7,20;'||,
          'EXENAME='OS2Dir'\LVM.EXE;'||,
          'PARAMETERS=/RediscoverPRM;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Refresh Removable Media.ICO;'||,
          'OBJECTID=<LVMREFRESH>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPFontPalette',,
      'Font Palette',,
      '<WP_CONFIG>',,
      'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'ICONPOS=42,44;'||,
          'XCELLCOUNT=2;'||,
          'YCELLCOUNT=4;'||,
          'XCELLWIDTH=160;'||,
          'YCELLHEIGHT=24;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'OBJECTID=<WP_FNTPAL>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'DDNS^Configuration',,
      '<WP_CONFIG>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=26,44;'||,
          'EXENAME=DDNSCFG.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<MPTS_DDNS_OBJECT_SETUP>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPKeyboard',,
      'Keyboard',,
      '<WP_CONFIG>',,
      'NOCOPY=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=SETTINGS;'||,
          'ICONPOS=71,44;'||,
          'OBJECTID=<WP_KEYB>',,
      CreateCollision )

  /* Power must be done with a "R" flag or else the title won't come out right */
  rc = MyMyCreateObject( 'WPPower',,
      'Power',,
      '<WP_CONFIG>',,
      'NOCOPY=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'ICONPOS=68,33;'||,
          'OBJECTID=<WP_POWER>',,
      'R' )

rc = MyMyCreateObject( 'WPTemplates',,
    'Templates',,
    '<WP_OS2SYS>',,
    'NOCOPY=YES;'||,
        'NODELETE=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=15680;'||,
        'ICONPOS=60,20;'||,
        'ICONVIEWPOS=16 24 79 56;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ALWAYSSORT=YES;'||,
        'ICONVIEW=FLOWED,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<WP_TEMPS>',,
    CreateCollision )

  rc = MyMyCreateObject( 'WPDataFile',,
      'RAW.TRC',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15686;'||,
          'ICONPOS=59,33;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\RAW.ICO;'||,
          'OBJECTID=<RAW_TRC>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPIcon',,
      'Icon.ICO',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=61,43;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Icon.ICO;'||,
          'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\Icon.DAT;'||,
          'OBJECTID=<Icon_ICO>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPColorPalette',,
      'Mixed Color Palette',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'ICONPOS=13,12;'||,
          'XCELLCOUNT=16;'||,
          'YCELLCOUNT=16;'||,
          'XCELLWIDTH=15;'||,
          'YCELLHEIGHT=15;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'OBJECTID=<256Color_Template>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPPrinter',,
      'Printer',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=49,22;'||,
          'OBJECTID=<Printer>',,
      CreateCollision )

  rc = MyMyCreateObject( 'Ftp',,
      'FTP-PM',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'ICONPOS=51,12;'||,
          'OBJECTID=<FTP_PM>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPDataFile',,
      'SYSLOG Error Log',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15686;'||,
          'ICONPOS=68,33;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\SYSLOG Error Log.ICO;'||,
          'OBJECTID=<SYSLOG_Error_Log>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPDataFile',,
      'UNFORMATTED TRACE.ITF',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15686;'||,
          'ICONPOS=28,22;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\UNFORMATTED TRACE.ICO;'||,
          'OBJECTID=<UNFORMATTED_TRACE_ITF>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'Program',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15684;'||,
          'ICONPOS=66,22;'||,
          'OBJECTID=<Program>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPFontPalette',,
      'Font Palette',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'ICONPOS=3,12;'||,
          'XCELLCOUNT=2;'||,
          'YCELLCOUNT=4;'||,
          'XCELLWIDTH=160;'||,
          'YCELLHEIGHT=24;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'OBJECTID=<Font_Palette>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPSchemePalette',,
      'Scheme Palette',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'ICONPOS=34,12;'||,
          'XCELLCOUNT=3;'||,
          'YCELLCOUNT=5;'||,
          'XCELLWIDTH=146;'||,
          'YCELLHEIGHT=32;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'OBJECTID=<Scheme_Palette_96_Template>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Templates for^Internet',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=33846;'||,
          'HELPLIBRARY=WPINET.HLP;'||,
          'ICONPOS=6,22;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Templates for!Internet.ICO;'||,
          'OBJECTID=<WPINET_TEMPLATES>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPHost',,
        'FTP Host',,
        '<WPINET_TEMPLATES>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NODELETE=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'HELPPANEL=33819;'||,
            'HELPLIBRARY=WPINET.HLP;'||,
            'SELFCLOSE=1;'||,
            'BACKGROUND='OS2Dir'\BITMAP\FTPBKGRD.BMP,T,,I,255 255 255;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'SORTCLASS=WPFtpObj;'||,
            'ALWAYSSORT=YES;'||,
            'OBJECTID=<WPINET_HOSTTEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPUrl',,
        'URL',,
        '<WPINET_TEMPLATES>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NODELETE=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'HELPPANEL=33799;'||,
            'HELPLIBRARY=WPINET.HLP;'||,
            'OBJECTID=<WPINET_URLTEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPHtml',,
        'HTML.HTM',,
        '<WPINET_TEMPLATES>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NODELETE=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=33818;'||,
            'HELPLIBRARY=WPINET.HLP;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\HTML.ICO;'||,
            'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\HTML.DAT;'||,
            'OBJECTID=<WPINET_HTMLTEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPUrlFolder',,
        'URL Folder',,
        '<WPINET_TEMPLATES>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NODELETE=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=DETAILS;'||,
            'HELPPANEL=33817;'||,
            'HELPLIBRARY=WPINET.HLP;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONFLOWED,MINI;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'SORTCLASS=WPUrl;'||,
            'ALWAYSSORT=YES;'||,
            'OBJECTID=<WPINET_URLFOLDERTEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPJavaRef',,
        'Java Applet Reference',,
        '<WPINET_TEMPLATES>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NODELETE=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'OBJECTID=<WPINET_JVRTEMPLATE>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPColorPalette',,
      'Solid Color Palette',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=PALETTE;'||,
          'ICONPOS=24,12;'||,
          'XCELLCOUNT=8;'||,
          'YCELLCOUNT=2;'||,
          'XCELLWIDTH=30;'||,
          'YCELLHEIGHT=30;'||,
          'XCELLGAP=6;'||,
          'YCELLGAP=8;'||,
          'OBJECTID=<16Color_Template>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPDataFile',,
      'Data File',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15686;'||,
          'ICONPOS=24,43;'||,
          'OBJECTID=<Data_File>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPRPrinter',,
      'Network Printer',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=57,22;'||,
          'OBJECTID=<Network_Printer>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPCommandFile',,
      'eCS Command File.CMD',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15686;'||,
          'ICONPOS=31,33;'||,
          'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\OS!2 Command File.DAT;'||,
          'OBJECTID=<OS_2_Command_File_CMD>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPDataFile',,
      'FORMATTED TRACE.FTF',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15686;'||,
          'ICONPOS=50,43;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\FORMATTED TRACE.ICO;'||,
          'OBJECTID=<FORMATTED_TRACE_FTF>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Folder',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=15685;'||,
          'ICONPOS=32,43;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'OBJECTID=<Folder>',,
      CreateCollision )

/*
  rc = MyMyCreateObject( 'WPVault',,
      'Folder:1',,
      '<WP_TEMPS>',,
      'NOMOVE=YES;'||,
          'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'NODRAG=YES;'||,
          'NOTVISIBLE=YES;'||,
          'NORENAME=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=15685;'||,
          'ICONPOS=40,43;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'OBJECTID=<Folder_1>',,
      CreateCollision )
*/

  rc = MyMyCreateObject( 'WPPif',,
      'PIF file.PIF',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=43,33;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\PIF file.ICO;'||,
          'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\PIF file.DAT;'||,
          'OBJECTID=<PIF_file_PIF>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPPointer',,
      'Pointer.PTR',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=51,33;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Pointer.ICO;'||,
          'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\Pointer.DAT;'||,
          'OBJECTID=<Pointer_PTR>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPMet',,
      'Metafile.MET',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=12,33;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Metafile.ICO;'||,
          'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\Metafile.DAT;'||,
          'OBJECTID=<Metafile_MET>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPDataFile',,
      'INFERRED.ITF',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15686;'||,
          'ICONPOS=69,43;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\INFERRED.ICO;'||,
          'OBJECTID=<INFERRED_ITF>',,
      CreateCollision )

  rc = MyMyCreateObject( 'Telnet',,
      'Telnet',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=43,12;'||,
          'OBJECTID=<Telnet>',,
      CreateCollision )

rc = MyMyCreateObject( 'WPFolder',,
    'Command Prompts',,
    '<WP_OS2SYS>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=8008;'||,
        'ICONPOS=5,20;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=FLOWED,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||OtherBackground||,
        'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Command Prompts.ICO;'||,
        'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\Command Prompts1.ICO;'||,
        'OBJECTID=<WP_PROMPTS>',,
    CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'WIN-eCS Full Screen',,
      '<WP_PROMPTS>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=8022;'||,
          'EXENAME=*;'||,
          'STARTUPDIR='BootDrive';'||,
          'PROGTYPE=PROG_31_ENH;'||,
          'SET KBD_ALTHOME_BYPASS=1;'||,
          'SET KBD_CTRL_BYPASS=CTRL_ESC;'||,
          'SET VIDEO_SWITCH_NOTIFICATION=1;'||,
          'SET VIDEO_8514A_XGA_IOTRAP=0;'||,
          'SET DPMI_MEMORY_LIMIT=64;'||,
          'SET WIN_DDE=0;'||,
          'SET WIN_CLIPBOARD=1;'||,
          'OBJECTID=<WP_WINFS>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'eCS Window',,
      '<WP_PROMPTS>',,
      'NOPRINT=YES;'||,
          'CCVIEW=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=8010;'||,
          'EXENAME=*;'||,
          'STARTUPDIR='BootDrive';'||,
          'PARAMETERS=%;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'OBJECTID=<WP_OS2WIN>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'DOS Window',,
      '<WP_PROMPTS>',,
      'NOPRINT=YES;'||,
          'CCVIEW=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=8012;'||,
          'EXENAME=*;'||,
          'STARTUPDIR='BootDrive';'||,
          'PARAMETERS=%;'||,
          'PROGTYPE=WINDOWEDVDM;'||,
          'OBJECTID=<WP_DOSWIN>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'eCS Full Screen',,
      '<WP_PROMPTS>',,
      'NOPRINT=YES;'||,
          'CCVIEW=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=8009;'||,
          'EXENAME=*;'||,
          'STARTUPDIR='BootDrive';'||,
          'PARAMETERS=%;'||,
          'PROGTYPE=FULLSCREEN;'||,
          'OBJECTID=<WP_OS2FS>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'DOS from Drive A:',,
      '<WP_PROMPTS>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=8529;'||,
          'EXENAME=*;'||,
          'PROGTYPE=VDM;'||,
          'SET DOS_STARTUP_DRIVE=A:;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\DOS from Drive A!.ICO;'||,
          'OBJECTID=<WP_DOS_DRV_A>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'DOS Full Screen',,
      '<WP_PROMPTS>',,
      'NOPRINT=YES;'||,
          'CCVIEW=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=8011;'||,
          'EXENAME=*;'||,
          'STARTUPDIR='BootDrive';'||,
          'PARAMETERS=%;'||,
          'PROGTYPE=VDM;'||,
          'OBJECTID=<WP_DOSFS>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'WIN-eCS Window',,
      '<WP_PROMPTS>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=8022;'||,
          'EXENAME=PROGMAN.EXE;'||,
          'STARTUPDIR='BootDrive';'||,
          'PROGTYPE=PROG_31_ENHSEAMLESSCOMMON;'||,
          'SET KBD_ALTHOME_BYPASS=1;'||,
          'SET KBD_CTRL_BYPASS=CTRL_ESC;'||,
          'SET VIDEO_SWITCH_NOTIFICATION=1;'||,
          'SET VIDEO_8514A_XGA_IOTRAP=0;'||,
          'SET DPMI_MEMORY_LIMIT=64;'||,
          'SET WIN_DDE=0;'||,
          'SET WIN_CLIPBOARD=1;'||,
          'OBJECTID=<WP_WIN2WIN>',,
      CreateCollision )

rc = MyMyCreateObject( 'WPFolder',,
    'Programs',,
    '<WP_DESKTOP>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ICONPOS=5,65;'||,
        'ICONVIEWPOS=15 57 79 29;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=FLOWED,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||TopBackground||,
        'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Programs.ICO;'||,
        'OBJECTID=<WP_PROGRAMSFOLDER>',,
    CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'TCP/IP',,
      '<WP_PROGRAMSFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=19,16;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP.ICO;'||,
          'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP1.ICO;'||,
          'OBJECTID=<TCP/IP>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Allow Remote^Configuration',,
        '<TCP/IP>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=TCPCFG2D.CMD;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'MINIMIZED=YES;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Allow Remote!Configuration.ICO;'||,
            'OBJECTID=<TCPCFG2D>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'TCP/IP^Utilities',,
        '<TCP/IP>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'ALWAYSSORT=YES;'||OtherBackground||,
            'OBJECTID=<TCP_UTIL_FOLDER>',,
        CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'PM Ping',,
          '<TCP_UTIL_FOLDER>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=PMPING.EXE;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<TCP/IP5>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'TFTP',,
          '<TCP_UTIL_FOLDER>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=TFTP.EXE;'||,
              'PROGTYPE=WINDOWABLEVIO;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TFTP.ICO;'||,
              'OBJECTID=<TCP/IP15>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'FTP',,
          '<TCP_UTIL_FOLDER>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=FTP.EXE;'||,
              'PROGTYPE=WINDOWABLEVIO;'||,
              'OBJECTID=<TCP/IP1>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Telnet^Customization',,
          '<TCP_UTIL_FOLDER>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=SETTERM.EXE;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<TCP/SETTERM>',,
          CreateCollision )

    rc = MyMyCreateObject( 'Telnet',,
        'TelnetPM',,
        '<TCP/IP>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=TELNETPM.EXE;'||,
            'PARAMETERS= -w 80 -h 25;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<TCP_TELNET>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Create TCP/IP^Administrator Password',,
        '<TCP/IP>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=ADMIN_PW.CMD;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'MINIMIZED=YES;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Create TCP!IP!Administrator Password.ICO;'||,
            'OBJECTID=<ADMIN_PW>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'TCP/IP^Configuration^(Local)',,
        '<TCP/IP>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=TCPCFG2.CMD;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'MINIMIZED=YES;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP!Configuration!(Local).ICO;'||,
            'OBJECTID=<TCP/IP8>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'Application^Templates',,
        '<TCP/IP>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'ALWAYSSORT=YES;'||OtherBackground||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Application!Templates.ICO;'||,
            'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\Application!Templates1.ICO;'||,
            'OBJECTID=<TCP/IP_TEMP>',,
        CreateCollision )

      rc = MyMyCreateObject( 'Telnet',,
          'Telnet',,
          '<TCP/IP_TEMP>',,
          'NOMOVE=YES;'||,
              'TEMPLATE=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'OBJECTID=<TCPTELNET>',,
          CreateCollision )

      rc = MyMyCreateObject( 'Ftp',,
          'FTP-PM',,
          '<TCP/IP_TEMP>',,
          'NOMOVE=YES;'||,
              'TEMPLATE=YES;'||,
              'NOPRINT=YES;'||,
              'OBJECTID=<TCPFTP>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'How do I^use Templates?',,
          '<TCP/IP_TEMP>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEWHELP.EXE;'||,
              'PARAMETERS='GetFullPathOf('TCPIP')'\HELP\TEMPLATE.HLP;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<TCP_TEMPLATES_HELP>',,
          CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'TCP/IP^Readme',,
        '<TCP/IP>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=E.EXE;'||,
            'PARAMETERS='GetFullPathOf('TCPIP')'\HELP\README.TXT;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP!Readme.ICO;'||,
            'OBJECTID=<TCP_README_INF1>',,
        CreateCollision )

    rc = MyMyCreateObject( 'Ftp',,
        'FTP-PM',,
        '<TCP/IP>',,
        'NOPRINT=YES;'||,
            'OBJECTID=<TCP_FTP>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'DOS/Windows^TCP/IP Access',,
        '<TCP/IP>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||OtherBackground||,
            'OBJECTID=<TCP/IPDBOX>',,
        CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Ping',,
          '<TCP/IPDBOX>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='GetFullPathOf('TCPIP')'\DOS\BIN\PING.EXE;'||,
              'PARAMETERS=0.0.0.0;'||,
              'PROGTYPE=WINDOWEDVDM;'||,
              'OBJECTID=<TCP/IPDB2>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'WPing',,
          '<TCP/IPDBOX>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='GetFullPathOf('TCPIP')'\DOS\BIN\WPING.EXE;'||,
              'PROGTYPE=PROG_31_ENHSEAMLESSCOMMON;'||,
              'OBJECTID=<TCP/IPDB1>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'TCP/IP for^DOS/Windows^Read Me',,
          '<TCP/IPDBOX>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEW.EXE;'||,
              'PARAMETERS='GetFullPathOf('TCPIP')'\HELP\READDBX.INF;'||,
              'PROGTYPE=PM;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP for!DOS!Windows!Read Me.ICO;'||,
              'OBJECTID=<TCP/IP_README_DBXA>',,
          CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Configure^Remote System',,
        '<TCP/IP>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=TCPCFG2R.CMD;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'MINIMIZED=YES;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Configure!Remote System.ICO;'||,
            'OBJECTID=<TCPCFG2R>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'TCP/IP^Information',,
        '<TCP/IP>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||OtherBackground||,
            'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP!Information.ICO;'||,
            'OBJECTID=<TCP/IP_INFO>',,
        CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'TCP/IP^Guide',,
          '<TCP/IP_INFO>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEWHELP.EXE;'||,
              'PARAMETERS='GetFullPathOf('TCPIP')'\HELP\TCPGUIDE.HLP;'||,
              'PROGTYPE=PM;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP!Guide.ICO;'||,
              'OBJECTID=<TCP/IP18A>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'REXX Sockets API',,
          '<TCP/IP_INFO>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEW.EXE;'||,
              'PARAMETERS=RXSOCKET;'||,
              'PROGTYPE=PM;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\REXX Sockets API.ICO;'||,
              'OBJECTID=<TCPSORX>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'TCP/IP^Command Reference',,
          '<TCP/IP_INFO>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEWHELP.EXE;'||,
              'PARAMETERS='GetFullPathOf('TCPIP')'\HELP\TCPCR.HLP;'||,
              'PROGTYPE=PM;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP!Command Reference.ICO;'||,
              'OBJECTID=<TCP/IP17>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'REXX FTP API',,
          '<TCP/IP_INFO>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEW.EXE;'||,
              'PARAMETERS=RXFTP;'||,
              'PROGTYPE=PM;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\REXX FTP API.ICO;'||,
              'OBJECTID=<TCPFTPRX>',,
          CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Uninstall^TCP/IP 4.3',,
        '<TCP/IP>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='GetFullPathOf('TCPIP')'\BIN\UINSTALL.CMD;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Uninstall!TCP!IP 4.ICO;'||,
            'OBJECTID=<TCP_UNINST>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPProgram',,
      'New Program',,
      '<WP_PROGRAMSFOLDER>',,
      'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15684;'||,
          'ICONPOS=36,5;'||,
          'OBJECTID=<WP_NEWPROGRAM>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'FFST/2^Error Logging Services',,
      '<WP_PROGRAMSFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=31,16;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\FFST!2!Error Logging Services.ICO;'||,
          'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\FFST!2!Error Logging Services1.ICO;'||,
          'OBJECTID=<WP_FFST2>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Message Console',,
        '<WP_FFST2>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='OS2Dir'\EPWCONS.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_EPWCONS>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Dump Formatter',,
        '<WP_FFST2>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='OS2Dir'\EPWDF.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_EPWDF>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Start FFST/2',,
        '<WP_FFST2>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='OS2Dir'\EPW.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=ON;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'MINIMIZED=YES;'||,
            'OBJECTID=<WP_EPW_ON>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'System Error Log',,
        '<WP_FFST2>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='OS2Dir'\SYSLOGPM.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_SYSLOG>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Message Log Formatter',,
        '<WP_FFST2>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='OS2Dir'\MSGLOGF.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=*;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_EPWMSGF>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Stop FFST/2',,
        '<WP_FFST2>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='OS2Dir'\EPW.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=OFF;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'MINIMIZED=YES;'||,
            'OBJECTID=<WP_EPW_OFF>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Games',,
      '<WP_PROGRAMSFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=13091;'||,
          'ICONPOS=44,16;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Games.ICO;'||,
          'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\Games1.ICO;'||,
          'OBJECTID=<WP_GAMES>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'Mahjongg Solitaire',,
        '<WP_GAMES>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'MINWIN=HIDE;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'HELPPANEL=32219;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||OtherBackground||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Mahjongg Solitaire.ICO;'||,
            'OBJECTID=<MAH_FOLDER>',,
        CreateCollision )

      rc = MyMyCreateObject( 'WPShadow',,
          'CRAZYCUB.MAH',,
          '<MAH_FOLDER>',,
          'SHADOWID='OS2Dir'\APPS\CRAZYCUB.MAH;'||,
              'OBJECTID=<CRAZYCUB_MAH>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPShadow',,
          'CASTLE.MAH',,
          '<MAH_FOLDER>',,
          'SHADOWID='OS2Dir'\APPS\CASTLE.MAH;'||,
              'OBJECTID=<CASTLE_MAH>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPShadow',,
          'BRIDGE.MAH',,
          '<MAH_FOLDER>',,
          'SHADOWID='OS2Dir'\APPS\BRIDGE.MAH;'||,
              'OBJECTID=<BRIDGE_MAH>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPShadow',,
          'TOWERBRI.MAH',,
          '<MAH_FOLDER>',,
          'SHADOWID='OS2Dir'\APPS\TOWERBRI.MAH;'||,
              'OBJECTID=<TOWERBRI_MAH>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPShadow',,
          'DEFAULT.MAH',,
          '<MAH_FOLDER>',,
          'SHADOWID='OS2Dir'\APPS\DEFAULT.MAH;'||,
              'OBJECTID=<DEFAULT_MAH>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPShadow',,
          'YINYANG.MAH',,
          '<MAH_FOLDER>',,
          'SHADOWID='OS2Dir'\APPS\YINYANG.MAH;'||,
              'OBJECTID=<YINYANG_MAH>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPShadow',,
          'TAJMAHAL.MAH',,
          '<MAH_FOLDER>',,
          'SHADOWID='OS2Dir'\APPS\TAJMAHAL.MAH;'||,
              'OBJECTID=<TAJMAHAL_MAH>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPShadow',,
          'CUBE.MAH',,
          '<MAH_FOLDER>',,
          'SHADOWID='OS2Dir'\APPS\CUBE.MAH;'||,
              'OBJECTID=<CUBE_MAH>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPShadow',,
          'GIZEH.MAH',,
          '<MAH_FOLDER>',,
          'SHADOWID='OS2Dir'\APPS\GIZEH.MAH;'||,
              'OBJECTID=<GIZEH_MAH>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Mahjongg',,
          '<MAH_FOLDER>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL=32219;'||,
              'ASSOCFILTER=*.MAH;'||,
              'EXENAME='OS2Dir'\APPS\MAHJONGG.EXE;'||,
              'STARTUPDIR='BootDrive';'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<MAH_EXE>',,
          CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'OS/2 Chess',,
        '<WP_GAMES>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=20296;'||,
            'EXENAME='OS2Dir'\APPS\OS2CHESS.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_CHESS>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Klondike Solitaire',,
        '<WP_GAMES>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=20295;'||,
            'EXENAME='OS2Dir'\APPS\KLONDIKE.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_KLDK>',,
        CreateCollision )

QuietMode = 1
  rc = MyMyCreateObject( 'WPFolder',,
      'IBM Internet^Connection for eCS',,
      '<WP_INTERNET>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=58,16;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\IBM Internet!Connection for eCS.ICO;'||,
          'OBJECTID=<IAK>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'Internet^Utilities',,
        '<IAK>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
           'ALWAYSSORT=YES;'||OtherBackground||,
            'OBJECTID=<IAK_UTILITIES>',,
        CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Test Modem',,
          '<IAK_UTILITIES>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=MODEMTST.EXE;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<MODEMTST>',,
          CreateCollision )

      rc = MyMyCreateObject( 'Telnet',,
          'Telnet',,
          '<IAK_UTILITIES>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=LINKUP.EXE;'||,
              'PARAMETERS=TELNETPM.EXE -w 80 -h 25;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<IAK_TELNET>',,
          CreateCollision )

      rc = MyMyCreateObject( 'Ftp',,
          'FTP-PM',,
          '<IAK_UTILITIES>',,
          'NOPRINT=YES;'||,
              'OBJECTID=<IAK_FTP>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Dial Other^Internet Providers',,
          '<IAK_UTILITIES>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=SLIPPM.EXE;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<IAK_SLIPPM>',,
          CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'Application^Templates',,
        '<IAK>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'ALWAYSSORT=YES;'||OtherBackground||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Application!Templates2.ICO;'||,
            'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\Application!Templates3.ICO;'||,
            'OBJECTID=<IAK_TEMPLATES>',,
        CreateCollision )

      rc = MyMyCreateObject( 'Telnet',,
          'Telnet',,
          '<IAK_TEMPLATES>',,
          'NOMOVE=YES;'||,
              'TEMPLATE=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'OBJECTID=<IAK_TEMPLATES_TELNET>',,
          CreateCollision )

      rc = MyMyCreateObject( 'Ftp',,
          'FTP-PM',,
          '<IAK_TEMPLATES>',,
          'NOMOVE=YES;'||,
              'TEMPLATE=YES;'||,
              'NOPRINT=YES;'||,
              'OBJECTID=<IAK_TEMPLATES_FTPPM>',,
          CreateCollision )

    rc = MyMyCreateObject( 'AdvDialer',,
        'IBM Internet^Dialer',,
        '<IAK>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='GetFullPathOf('TCPIP')'\BIN\DIALER.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<ADV_DIALER>',,
        'R' )

    rc = MyMyCreateObject( 'WPProgram',,
        'Software Updates',,
        '<IAK>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=LINKUP.EXE;'||,
            'PARAMETERS=NETSCAPE.EXE http://service2.boulder.ibm.com/pspfixpk/;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Software Updates.ICO;'||,
            'OBJECTID=<IAK_RSU>',,
        CreateCollision )

    rc = MyMyCreateObject( 'AdvReg',,
        'IBM Internet^Customer Services',,
        '<IAK>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'ALWAYSSORT=YES;'||OtherBackground||,
            'OBJECTID=<ADV_REG>',,
        CreateCollision )

      rc = MyMyCreateObject( 'AdvCust',,
          'Registration',,
          '<ADV_REG>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='GetFullPathOf('TCPIP')'\BIN\ASSIST.EXE;'||,
              'PARAMETERS=open;'||,
              'PROGTYPE=PM;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Registration.ICO;'||,
              'OBJECTID=<ADV_ASSIST_REG>',,
          CreateCollision )

      rc = MyMyCreateObject( 'AdvCust',,
          'Customer^Assistance',,
          '<ADV_REG>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='GetFullPathOf('TCPIP')'\BIN\ASSIST.EXE;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<ADV_ASSIST>',,
          CreateCollision )
QuietMode = ""

  rc = MyMyCreateObject( 'WPFolder',,
      'Java for eCS',,
      '<WP_PROGRAMSFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=71,16;'||,
          'SELFCLOSE=1;'||,
          'BACKGROUND='GetFullPathOf('JAVA11')'\JAVACMPT.BMP,N,,I,188 188 188;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Java for eCS.ICO;'||,
          'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\Java for eCS1.ICO;'||,
          'OBJECTID=<JAVA_11>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPUrl',,
        'Running Java (Local)',,
        '<JAVA_11>',,
        'NOTDEFAULTICON=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\Running Java (Local).DAT;'||,
            'OBJECTID=<JAVA11_Running>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Editor for Java',,
        '<JAVA_11>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='OS2Dir'\APPS\EPM.EXE;'||,
            'PARAMETERS=/R;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Editor for Java.ICO;'||,
            'OBJECTID=<JAVA11_JavaEditor>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPUrl',,
        'IBM Centre for Java Technology',,
        '<JAVA_11>',,
        'NOTDEFAULTICON=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\IBM Centre for Java Technology.DAT;'||,
            'OBJECTID=<JAVA11_IBMCenterForJavaTech>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Java Applet Viewer from URL',,
        '<JAVA_11>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ASSOCTYPE=URL;'||,
            'EXENAME='GetFullPathOf('JAVA11')'\BIN\APPLET.EXE;'||,
            'PARAMETERS="-@";'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Java Applet Viewer from URL.ICO;'||,
            'OBJECTID=<JAVA11_JavaViewerURL>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Run Java Program',,
        '<JAVA_11>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ASSOCTYPE=Java Program;'||,
            'EXENAME=cmd.exe;'||,
            'PARAMETERS=/c 'GetFullPathOf('JAVA11')'\bin\java.exe %**N || pause [Command-line arguments for %**F];'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Run Java Program.ICO;'||,
            'OBJECTID=<JAVA11_RunJava>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Java Applet Viewer from HTML',,
        '<JAVA_11>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ASSOCTYPE=HTML;'||,
            'EXENAME='GetFullPathOf('JAVA11')'\BIN\APPLET.EXE;'||,
            'PARAMETERS="file:///%**P/%**F";'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<JAVA11_JavaViewerHTML>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Run Java PM Program',,
        '<JAVA_11>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ASSOCTYPE=Java Program;'||,
            'EXENAME='GetFullPathOf('JAVA11')'\BIN\JAVAPM.EXE;'||,
            'PARAMETERS=%**N;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<JAVA11_RunJavaPM>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPUrl',,
        'Configure Applet Viewer',,
        '<JAVA_11>',,
        'NOTDEFAULTICON=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\Configure Applet Viewer.DAT;'||,
            'OBJECTID=<Configure>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Netscape Communicator 4.61',,
      '<WP_PROGRAMSFOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=8,5;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'OBJECTID=<NS46_FOLDER>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Netscape^Messenger',,
        '<NS46_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='GetFullPathOf('NETSCAPE')'\PROGRAM\NETSCAPE.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=-mail -l en_US;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Netscape!Messenger.ICO;'||,
            'OBJECTID=<NS46_MESSENGER>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Netscape^Communicator',,
        '<NS46_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='GetFullPathOf('NETSCAPE')'\PROGRAM\NETSCAPE.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=-l en_US;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<NS46_COMMUNICATOR>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Netscape Communicator^Installation Utility',,
        '<NS46_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=CMD.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=/C 'GetFullPathOf('NETSCAPE')'\EPFINSTS.EXE /C:'GetFullPathOf('NETSCAPE')'\NS46.ICF /O:DRIVE;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'MINIMIZED=YES;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Netscape Communicator!Installation Utility.ICO;'||,
            'OBJECTID=<NS46_FOLDERNSTS_NS>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPShadow',,
        'READ.ME',,
        '<NS46_FOLDER>',,
        'SHADOWID='GetFullPathOf("Netscape")'\PROGRAM\READ.ME;'||,
            'OBJECTID=<NS46_README_SHADOW>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Netscape^Composer',,
        '<NS46_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='GetFullPathOf("Netscape")'\PROGRAM\NETSCAPE.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=-edit -l en_US;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Netscape!Composer.ICO;'||,
            'OBJECTID=<NS46_COMPOSER>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Netscape^User Profile^Manager',,
        '<NS46_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='GetFullPathOf("Netscape")'\PROGRAM\NETSCAPE.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=-profile_manager -l en_US;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Netscape!User Profile!Manager.ICO;'||,
            'OBJECTID=<NS46_PROFILEMGR>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Netscape^Navigator',,
        '<NS46_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ASSOCFILTER=*.HTM,*.HTML;'||,
            'ASSOCTYPE=HTML,text/html;'||,
            'EXENAME='GetFullPathOf("Netscape")'\PROGRAM\NETSCAPE.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PARAMETERS=-browser -l en_US;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Netscape!Navigator.ICO;'||,
            'OBJECTID=<NS46_NAVIGATOR>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'New Folder',,
      '<WP_PROGRAMSFOLDER>',,
      'TEMPLATE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=15685;'||,
          'ICONPOS=20,5;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'OBJECTID=<WP_NEWFOLDER>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Utilities',,
      '<WP_PROGRAMSFOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=13090;'||,
          'ICONPOS=28,5;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'OBJECTID=<WP_TOOLS>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Network DDE^and Clipboard',,
        '<WP_TOOLS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=304;'||,
            'HELPLIBRARY='GetFullPathOf("Netprog")'\LSIWOBJS.HLP;'||,
            'EXENAME='GetFullPathOf('NETPROG')'\NWDDE.EXE;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\networkddeandclipboard.ICO;'||,
            'STARTUPDIR='BootDrive';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<LS_CLIP>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'CPU Monitor',,
        '<WP_TOOLS>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=20284;'||,
            'EXENAME='OS2Dir'\MPCPUMON.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_PULSE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Picture Viewer',,
        '<WP_TOOLS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ASSOCFILTER=*.MET,*.PIF;'||,
            'ASSOCTYPE=Metafile,PIF file;'||,
            'EXENAME='OS2Dir'\APPS\PICVIEW.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_PICV>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Enhanced Editor',,
        '<WP_TOOLS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=20278;'||,
            'EXENAME='OS2Dir'\APPS\EPM.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_EPM>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'LAN Server^Error Log Utility',,
        '<WP_TOOLS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=322;'||,
            'HELPLIBRARY='GetFullPathOf('NETPROG')'\LSIWOBJS.HLP;'||,
            'EXENAME='GetFullPathOf('NETPROG')'\LSERROR.EXE;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\lanservererrorlogutility.ICO;'||,
            'STARTUPDIR='BootDrive';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<LS_ERROR>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Icon Editor',,
        '<WP_TOOLS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=20279;'||,
            'ASSOCFILTER=*.BMP,*.PTR,*.ICO;'||,
            'EXENAME='OS2Dir'\ICONEDIT.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_ICON>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Network Messaging',,
        '<WP_TOOLS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=305;'||,
            'HELPLIBRARY='GetFullPathOf('NETPROG')'\LSIWOBJS.HLP;'||,
            'EXENAME='GetFullPathOf('NETPROG')'\NETMSG.EXE;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\networkmessaging.ICO;'||,
            'STARTUPDIR='BootDrive';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<LS_NETMSG>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Clipboard Viewer',,
        '<WP_TOOLS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=20274;'||,
            'EXENAME='OS2Dir'\CLIPOS2.EXE;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\clipboardviewer.ICO;'||,
            'OBJECTID=<WP_CLIPV>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'eCS System Editor',,
        '<WP_TOOLS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=9289;'||,
            'ASSOCFILTER=*.DOC,*.TXT,*.HTM,*.HTML;'||,
            'ASSOCTYPE=Plain Text,OS/2 Command File,DOS Command File;'||,
            'EXENAME='OS2Dir'\E.EXE;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\ecssystemeditor.ICO;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_SYSED>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'LAN Server^Audit Log Utility',,
        '<WP_TOOLS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=323;'||,
            'HELPLIBRARY='GetFullPathOf('NETPROG')'\LSIWOBJS.HLP;'||,
            'EXENAME='GetFullPathOf('NETPROG')'\LSAUDIT.EXE;'||,
            'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\lanserverauditlogutility.ICO;'||,
            'STARTUPDIR='BootDrive';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<LS_AUDIT>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Seek and Scan Files',,
        '<WP_TOOLS>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=20285;'||,
            'EXENAME='OS2Dir'\APPS\PMSEEK.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_SEEK>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Applications',,
      '<WP_PROGRAMSFOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=3,16;'||,
          'ICONVIEWPOS=46 8 54 92;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'OBJECTID=<WP_APPSFOLDER>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPShadow',,
        'Netscape^Communicator',,
        '<WP_APPSFOLDER>',,
        'SHADOWID=<NS46_COMMUNICATOR>;'||,
            'OBJECTID=<NS46_COMMUNICATOR_APP_SHADOW>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'WiseMachine',,
        '<WP_APPSFOLDER>',,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='WiseManager'\WISEMACHINELOCAL.EXE;'||,
            'STARTUPDIR='BootDrive'\TVoice;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WISEMACHINELOCAL>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPShadow',,
      'TCP/IP^Configuration^(Local)',,
      '<WP_CONFIG>',,
      'ICONPOS=64,20;'||,
          'SHADOWID=<TCP/IP8>;'||,
          'OBJECTID=<TCP/IP8_SHAD>',,
      CreateCollision )

rc = MyMyCreateObject( 'WPFolder',,
    'Assistance Center',,
    '<WP_DESKTOP>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ICONPOS=5,43;'||,
        'ICONVIEWPOS=10 30 69 50;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=FLOWED,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||TopBackground||,
        'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Assistance Center.ICO;'||,
        'ICONNFILE=1,'WiseManager'\PatchDeskTop\OS2 System\Assistance Center1.ICO;'||,
        'OBJECTID=<WP_ASSISTANCE>',,
    CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Troubleshooting',,
      '<WP_ASSISTANCE>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=29,17;'||,
          'ICONVIEWPOS=15 36 79 35;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'OBJECTID=<WP_TROUBLEINFO>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPShadow',,
        'Support through the Internet',,
        '<WP_TROUBLEINFO>',,
        'ICONPOS=57,22;'||,
            'SHADOWID=<PDP_URL_SUPPORT>;'||,
            'OBJECTID=<Support_through_the_Internet>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'eCS Trace Guide',,
        '<WP_TROUBLEINFO>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=27,22;'||,
            'EXENAME='OS2Dir'\VIEW.EXE;'||,
            'PARAMETERS=OS2TRACE.INF;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_TRBLTRA>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPShadow',,
        'Problem Determination Tools',,
        '<WP_TROUBLEINFO>',,
        'ICONPOS=41,22;'||,
            'SHADOWID=<PDP_FOLDER>;'||,
            'OBJECTID=<Problem_Determination_Tools>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Serviceability and Troubleshooting Guide',,
        '<WP_TROUBLEINFO>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=11,22;'||,
            'EXENAME='OS2Dir'\VIEW.EXE;'||,
            'PARAMETERS=TROUBLE.INF;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<WP_TRBLSHT>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Trace Doc',,
        '<WP_TROUBLEINFO>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=32680;'||,
            'HELPLIBRARY='OS2Dir'\HELP\PROBDET.HLP;'||,
            'ICONPOS=3,11;'||,
            'EXENAME='OS2Dir'\VIEW.EXE;'||,
            'PARAMETERS='OS2Dir'\BOOK\TRACEREF.INF;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<PDP_TRACE_DOC>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'PMDF Doc',,
        '<WP_TROUBLEINFO>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=32681;'||,
            'HELPLIBRARY='OS2Dir'\HELP\PROBDET.HLP;'||,
            'ICONPOS=69,22;'||,
            'EXENAME='OS2Dir'\VIEW.EXE;'||,
            'PARAMETERS='OS2Dir'\BOOK\PMDF.INF;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<PDP_PMDFDOC>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Information',,
      '<WP_ASSISTANCE>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=TREE;'||,
          'HELPPANEL=13092;'||,
          'ICONPOS=3,17;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||OtherBackground||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Information.ICO;'||,
          'OBJECTID=<WP_INFO>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'Tasks',,
        '<WP_INFO>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||OtherBackground||,
            'OBJECTID=<WP_TASKSINFO>',,
        CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'TCP/IP DHCP^and Dynamic IP^Introduction',,
          '<WP_TASKSINFO>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEW.EXE;'||,
              'PARAMETERS='GetFullPathOf('TCPIP')'\HELP\DIPAMST.HLP;'||,
              'PROGTYPE=PM;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP DHCP!and Dynamic IP!Introduction.ICO;'||,
              'OBJECTID=<DIP_INTRO>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'DLS and Windows^User''s Guide',,
          '<WP_TASKSINFO>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=view.exe;'||,
              'PARAMETERS='OS2Dir'\BOOKS\a3a4hm02.inf;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WSLSA3A4H>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'LAN CID^Utility Guide',,
          '<WP_TASKSINFO>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=view.exe;'||,
              'PARAMETERS='OS2Dir'\BOOKS\a3s12m02.inf;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WSLSA3S12>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'eCS Desktop Guide',,
          '<WP_TASKSINFO>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL=33401;'||,
              'EXENAME='OS2Dir'\VIEW.EXE;'||,
              'PARAMETERS=OS2UG.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WP_OS2UGBK>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Quick Beginnings',,
          '<WP_TASKSINFO>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=view.exe;'||,
              'PARAMETERS='OS2Dir'\BOOKS\a3aa1mst.inf;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WSLSA3AA1>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'TCP/IP DHCP^and Dynamic IP Client^Administration',,
          '<WP_TASKSINFO>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEW.EXE;'||,
              'PARAMETERS='GetFullPathOf('TCPIP')'\HELP\DHCAMST.HLP;'||,
              'PROGTYPE=PM;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP DHCP!and Dynamic IP Client!Administration.ICO;'||,
              'OBJECTID=<DHCP_CADMIN>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'File and Print^Client Guide',,
          '<WP_TASKSINFO>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=view.exe;'||,
              'PARAMETERS='OS2Dir'\BOOKS\a3aa7mst.inf;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WSLSA3AA7>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'TCP/IP DHCP^Administration',,
          '<WP_TASKSINFO>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEW.EXE;'||,
              'PARAMETERS='GetFullPathOf('TCPIP')'\HELP\DHSAMST.HLP;'||,
              'PROGTYPE=PM;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP DHCP!Administration.ICO;'||,
              'OBJECTID=<DHCP_ADMIN>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'MPTS Configuration^Guide',,
          '<WP_TASKSINFO>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=view.exe;'||,
              'PARAMETERS='OS2Dir'\BOOKS\mptscfg.inf;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WSLSA3AA6>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Network Administrator^Tasks',,
          '<WP_TASKSINFO>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=view.exe;'||,
              'PARAMETERS='OS2Dir'\BOOKS\a3aa3mst.inf;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WSLSA3AA3>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Using LVM',,
          '<WP_TASKSINFO>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='OS2Dir'\VIEW.EXE;'||,
              'PARAMETERS=USINGLVM.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WP_USINGLVM>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'TCP/IP DNS^Administration',,
          '<WP_TASKSINFO>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=VIEW.EXE;'||,
              'PARAMETERS='GetFullPathOf('TCPIP')'\HELP\ddsamst.HLP;'||,
              'PROGTYPE=PM;'||,
              'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\TCP!IP DNS!Administration.ICO;'||,
              'OBJECTID=<DNS_ADMIN>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Performance Tuning',,
          '<WP_TASKSINFO>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=view.exe;'||,
              'PARAMETERS='OS2Dir'\BOOKS\a3aa2mst.inf;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WSLSA3AA2>',,
          CreateCollision )

    rc = MyMyCreateObject( 'Mindex',,
        'Help Index',,
        '<WP_INFO>',,
        'NODELETE=YES;'||,
            'NOPRINT=YES;'||,
            'OBJECTID=<WP_MINDEX>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'Read Me',,
        '<WP_INFO>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||OtherBackground||,
            'OBJECTID=<WP_READMEFOLDER>',,
        CreateCollision )

      rc = MyMyCreateObject( 'WPShadow',,
          'README.TXT',,
          '<WP_READMEFOLDER>',,
          'SHADOWID=Y:\README.TXT;'||,
              'OBJECTID=<WP_RDME>',,
          CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'Online Information Overview',,
        '<WP_INFO>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||OtherBackground||,
            'OBJECTID=<WP_INFOOVERFOLDER>',,
        CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Using Online Information',,
          '<WP_INFOOVERFOLDER>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='OS2Dir'\VIEW.EXE;'||,
              'PARAMETERS=ONLINE.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WP_ONLINE>',,
          CreateCollision )

      rc = MyMyCreateObject( 'Mindex',,
          'Glossary',,
          '<WP_INFOOVERFOLDER>',,
          'NODELETE=YES;'||,
              'NOPRINT=YES;'||,
              'OBJECTID=<WP_GLOSS>',,
          CreateCollision )

    rc = MyMyCreateObject( 'WPFolder',,
        'Reference and Commands',,
        '<WP_INFO>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||OtherBackground||,
            'OBJECTID=<WP_REFCMDFOLDER>',,
        CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'REXX Information',,
          '<WP_REFCMDFOLDER>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL=9300;'||,
              'EXENAME='OS2Dir'\VIEW.EXE;'||,
              'PARAMETERS=REXX.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WP_REXREF>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Command Reference',,
          '<WP_REFCMDFOLDER>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL=9301;'||,
              'EXENAME='OS2Dir'\VIEW.EXE;'||,
              'PARAMETERS=CMDREF.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WP_CMDREF>',,
          CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Trademarks',,
          '<WP_REFCMDFOLDER>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='OS2Dir'\VIEW.EXE;'||,
              'PARAMETERS=TRADEMBK.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<WP_TRADEMBK>',,
          CreateCollision )

   rc = MyMyCreateObject( 'WPUrl',,
      'Information from^the Internet',,
      '<WP_ASSISTANCE>',,
      'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=33933;'||,
          'ICONPOS=16,17;'||,
          'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\Information from!the Internet.DAT;'||,
          'OBJECTID=<Information_from_the_Internet>',,
      CreateCollision )

   if (VRIsDir(BootDrive'\mmos2')=1) then do
      '@call 'BootDrive'\TVoice\WiseProg\DeskTop\CreateDeskTop.EXE CreateMMOS2Base.CMD 'string
   end

return

RegisterClasses:

  rc = MySysRegisterObjectClass( 'PRDirectory', 'LSPRWPS', 'A' )
  rc = MySysRegisterObjectClass( 'WPFtpObj', 'WPINET', 'A' )
  rc = MySysRegisterObjectClass( 'WPFtpLink', 'WPINET', 'A' )
  rc = MySysRegisterObjectClass( 'WPJavaRef', 'WPINET', 'A' )
  rc = MySysRegisterObjectClass( 'Telnet', 'WPTELNET', 'A' )
  rc = MySysRegisterObjectClass( 'WPHtml', 'WPINET', 'A' )
  rc = MySysRegisterObjectClass( 'WPFtpDir', 'WPINET', 'A' )
  rc = MySysRegisterObjectClass( 'WPHost', 'WPINET', 'A' )
  rc = MySysRegisterObjectClass( 'WPHostFolder', 'WPINET', 'A' )
  rc = MySysRegisterObjectClass( 'WPUrlFolder', 'WPINET', 'A' )
  rc = MySysRegisterObjectClass( 'LSDataFile', 'LSGWPS', 'A' )
  rc = MySysRegisterObjectClass( 'BDview', 'BDview', 'A' )
  rc = MySysRegisterObjectClass( 'LSPrinter', 'LSGWPS', 'A' )
  rc = MySysRegisterObjectClass( 'Ftp', 'FTPWPS', 'A' )
  rc = MySysRegisterObjectClass( 'LSDirectory', 'LSGWPS', 'A' )
  rc = MySysRegisterObjectClass( 'WPJavaClass', 'WPINET', 'A' )
  rc = MySysRegisterObjectClass( 'PRPrinter', 'LSPRWPS', 'A' )
  rc = MySysRegisterObjectClass( 'WPUrl', 'WPINET', 'A' )
  rc = MySysRegisterObjectClass( 'WPStickMouse', 'WPSTKMOU', 'A' )

return

MMOS2:

  MMBase = value("MMBASE", ,"OS2ENVIRONMENT")
  if (MMBase="" | length(MMBase)=1) then MMBase=GetFullPathOf('MMOS2')
  else MMBase=substr(MMBase,1,2)"\MMOS2"
  if (VRIsDir(MMBase)=0) then return


  rc = MySysRegisterObjectClass( 'MMBitmap', 'MMBIT', 'A' )
  rc = MySysRegisterObjectClass( 'MMFinder', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMAudio', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMAVC', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMDIB', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMAIF', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMAVI', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMGIF', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMFLI', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMIFF', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMTIFF', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMJPG', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMMIDI', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMMPG', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMSNDF', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMVOC', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMMOV', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMPCX', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMLVDDevice', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMWAV', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMPhotoCD', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MM_AU', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMTarga', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMDataFile', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMCDDevice', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMVolume', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMImage', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMSound', 'MMSND', 'A' )
  rc = MySysRegisterObjectClass( 'MMVideo', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMShadow', 'MMSHD', 'A' )
  rc = MySysRegisterObjectClass( 'MMDevice', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMMMotion', 'MMPARTS', 'A' )
  rc = MySysRegisterObjectClass( 'MMFolder', 'MMPARTS', 'A' )

  rc = MyMyCreateObject( 'WPSound',,
      'Sound',,
      '<WP_CONFIG>',,
      'NOCOPY=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=SETTINGS;'||,
          'ICONPOS=38,20;'||,
          'OBJECTID=<WP_SOUND>',,
      CreateCollision )

  rc = MyMyCreateObject( 'MMTIFF',,
      'TIFImage.TIF',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'ICONPOS=17,22;'||,
          'OBJECTID=<TIFImage_TIF>',,
      CreateCollision )

/*
  rc = MyMyCreateObject( 'MMWAV',,
      'WAVAudio.WAV',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'CCVIEW=NO;'||,
          'ICONPOS=40,22;'||,
          'OBJECTID=<WAVAudio_WAV>',,
      CreateCollision )

  rc = MyMyCreateObject( 'WPBitmap',,
      'Bitmap.BMP',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'ICONPOS=16,43;'||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Bitmap.ICO;'||,
          'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\Bitmap.DAT;'||,
          'OBJECTID=<Bitmap_BMP>',,
      CreateCollision )

  rc = MyMyCreateObject( 'MMJPG',,
      'JPGImage.JPG',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'ICONPOS=3,33;'||,
          'OBJECTID=<JPGImage_JPG>',,
      CreateCollision )

  rc = MyMyCreateObject( 'MMMIDI',,
      'MIDI.MID',,
      '<WP_TEMPS>',,
      'TEMPLATE=YES;'||,
          'NODELETE=YES;'||,
          'CCVIEW=NO;'||,
          'ICONPOS=20,33;'||,
          'OBJECTID=<MIDI_MID>',,
      CreateCollision )
*/

  rc = MyMyCreateObject( 'WPProgram',,
      'Multimedia^Setup',,
      '<WP_CONFIG>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=62,33;'||,
          'EXENAME='MMBase'\STPM.EXE;'||,
          'STARTUPDIR='BootDrive';'||,
          'PROGTYPE=PM;'||,
          'HELPLIBRARY='MMBase'\HELP\STPMH.HLP;'||,
          'OBJECTID=<MMPM2_SETUP>',,
      CreateCollision )

      rc = MyMyCreateObject( 'WPProgram',,
          'Multimedia^With REXX',,
          '<WP_REFCMDFOLDER>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='OS2Dir'\VIEW.EXE;'||,
              'PARAMETERS='MMBase'\MCIREXX.INF;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<MCIREXX_INF>',,
          CreateCollision )

    rc = MyMyCreateObject( 'WPProgram',,
        'Multimedia^Application Install',,
        '<WP_INSTREMFOLDER>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='MMBase'\MINSTALL.EXE;'||,
            'STARTUPDIR='BootDrive';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<MMPM2_MINSTALL>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Multimedia',,
      '<WP_PROGRAMSFOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=11,16;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Multimedia.ICO;'||,
          'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\Multimedia1.ICO;'||,
          'OBJECTID=<MMPM2_FOLDER>',,
      CreateCollision )

    rc = MyMyCreateObject( 'WPShadow',,
        'Bitmaps',,
        '<MMPM2_FOLDER>',,
        'SHADOWID='OS2Dir'\BITMAP;'||,
            'OBJECTID=<MMPM2_BITMAP>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMFinder',,
        'Digital audio',,
        '<MMPM2_FOLDER>',,
        'NOPRINT=YES;'||,
            'OBJECTID=<MMPM2_AUDIOFINDER>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMCDDevice',,
        'Compact Disc',,
        '<MMPM2_FOLDER>',,
        'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMCDDEVICE01>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPShadow',,
        'Images',,
        '<MMPM2_FOLDER>',,
        'SHADOWID='MMBase'\IMAGES;'||,
            'OBJECTID=<MMPM2_IMAGES>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMFinder',,
        'Digital video',,
        '<MMPM2_FOLDER>',,
        'NOPRINT=YES;'||,
            'OBJECTID=<MMPM2_VIDEOFINDER>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMFinder',,
        'Image',,
        '<MMPM2_FOLDER>',,
        'NOPRINT=YES;'||,
            'OBJECTID=<MMPM2_IMAGEFINDER>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPShadow',,
        'Sound Bites',,
        '<MMPM2_FOLDER>',,
        'SHADOWID='MMBase'\SOUNDS;'||,
            'OBJECTID=<MMPM2_SOUNDS>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMVolume',,
        'Volume',,
        '<MMPM2_FOLDER>',,
        'NOCOPY=YES;'||,
            'NODELETE=YES;'||,
            'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMVOLUME>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMFinder',,
        'MIDI',,
        '<MMPM2_FOLDER>',,
        'NOPRINT=YES;'||,
            'OBJECTID=<MMPM2_MIDIFINDER>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPShadow',,
        'Movies',,
        '<MMPM2_FOLDER>',,
        'SHADOWID='mmbase'\MOVIES;'||,
            'OBJECTID=<MMPM2_MOVIES>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPShadow',,
        'Sound',,
        '<MMPM2_FOLDER>',,
        'SHADOWID=<WP_SOUND>;'||,
            'OBJECTID=<MMPM2_SNDSHAD>',,
        CreateCollision )

  rc = MyMyCreateObject( 'WPFolder',,
      'Multimedia Templates',,
      '<WP_TEMPS>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=6,43;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ALWAYSSORT=YES;'||OtherBackground||,
          'ICONFILE='WiseManager'\PatchDeskTop\OS2 System\Multimedia Templates.ICO;'||,
          'ICONNFILE='WiseManager'\PatchDeskTop\OS2 System\Multimedia Templates1.ICO;'||,
          'OBJECTID=<MMPM2_MMTEMPLATEFOLDER>',,
      CreateCollision )

    rc = MyMyCreateObject( 'MMFolder',,
        'Lighttable',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=FLOWED,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'ALWAYSSORT=YES;'||OtherBackground||,
            'OBJECTID=<MMPM2_MMFOLDERTEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMAVI',,
        'AVIVideo.AVI',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMAVITEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMWAV',,
        'WAVAudio.WAV',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMWAVETEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMAVC',,
        'AVCImage._IM',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMAVCIMAGETEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMMMotion',,
        'VIDImage.VID',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMMMOTIONTEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMTIFF',,
        'TIFImage.TIF',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMTIFFTEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMCDDevice',,
        'Compact Disc',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'TEMPLATE=YES;'||,
            'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMCDDEVICETEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMTarga',,
        'TargaImage.TGA',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMTARGATEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMPCX',,
        'PCXImage.PCX',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMPCXTEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMMIDI',,
        'MIDI.MID',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMMIDITEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMGIF',,
        'GIFImage.GIF',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMGIFTEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMDIB',,
        'DIBImage.DIB',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMDIBTEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'MMLVDDevice',,
        'Videodisc',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'TEMPLATE=YES;'||,
            'NOPRINT=YES;'||,
            'CCVIEW=NO;'||,
            'OBJECTID=<MMPM2_MMLVDDEVICETEMPLATE>',,
        CreateCollision )

    rc = MyMyCreateObject( 'WPBitmap',,
        'Bitmap.BMP',,
        '<MMPM2_MMTEMPLATEFOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'READDATAFROM='WiseManager'\PatchDeskTop\OS2 System\Bitmap1.DAT;'||,
            'OBJECTID=<MMPM2_MMBITMAPTEMPLATE>',,
        CreateCollision )

return

MyMyCreateObject: procedure expose QuietMode 
    Parse Arg Class, Title, Location, Setup, Collision
    mrc = MyCreateObject( Class, Title, Location, Setup, Collision )
    call TV_DosSleep 50
    /* say LastObjectCreated */
return mrc
   

