/* */
 
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then do
   parse var string "'"BootDrive" "AppServer" "Action"'"
end
if (string<>"" & BootDrive="") then do
   parse var string BootDrive" "AppServer" "Action
end
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */
 
  p.Title = "PeerWPSFixUp"  /* Name of this application */
  p.ThisCMDFileName = "CreatePeerWPSFixUp.CMD"  /* Name of this command file */
  p.DirName = "PeerWPSFixUp"  /* Name of main dir */
  p.Location = "<WP_APPSFOLDER>"  /* Location to place main folder */
  p.ObjectID = "<OBJECT_PeerWPSFixUp>"  /* Object to start (usually the main exe) */
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = "\OS2"   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""   /* Class to check to see if this is a fresh install (classname dllname) */
 
  call StartUp
 
  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "DontUpdate"     /* "Fail", "Replace", or "Update" */
 
  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= ""
  p.ObjectIDFolder = "" /* Set to blank for no folder */
 
  CreateCollision = p.Flag
  Call RegisterClasses
  Call CreateObjects
 
syntax:
signal CMDExit
return 0
 
MySysRegisterObjectClass: procedure expose p.ExeDir
   parse arg className, dllName
   code = SysRegisterObjectClass( className, dllName )
   If code <> 1 Then code = SysRegisterObjectClass( className, p.ExeDir || '\' || dllName || '.DLL' )
   If code <> 1 Then do
      Say 'Can''t register class 'className' with 'dllName'.'
   end
return code
 
CreateObjects:

szClass=""
MainObjName = '<WP_CONNECTIONSFOLDER>'
iRetco = WPToolsQueryObject(MainObjName, "szClass", "szTitle", "szSetupString", "szLocation") 
if (szClass="" | szClass="SZCLASS") then MainObjName = '<WP_NETWORK>'

Call SetIBMLAN

rc = MyCreateObject( 'WPFolder',,
    'Administration',,
    MainObjName,,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||OtherBackground||,
        'OBJECTID=<LS_FOLDER>',,
    CreateCollision )

rc = MyCreateObject( 'WPFolder',,
    'Logons',,
    MainObjName,,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||OtherBackground||,
        'ICONFILE='WiseManager'\'p.DirName'\Network Service\Logons.ICO;'||,
        'OBJECTID=<UPM_FOLDER>',,
    CreateCollision )

rc = MyCreateObject( 'WPFolder',,
    'Utilities',,
    MainObjName,,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||OtherBackground||,
        'OBJECTID=<LAN_UTILITY_FOLDER>',,
    CreateCollision )

    rc = MyCreateObject( 'WPProgram',,
        'User Account Management',,
        '<LS_FOLDER>',,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=310;'||,
            'HELPLIBRARY='GetFullPathOf('NETPROG')'\LSIWOBJS.HLP;'||,
            'ICONPOS=22,5;'||,
            'EXENAME='GetFullPathOf('MUGLIB')'\UPMACCTS.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<UPM_ACCTS>',,
        CreateCollision )

  rc = MyCreateObject( 'WPProgram',,
      'LAN Server^Administration',,
      '<LS_FOLDER>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=321;'||,
          'HELPLIBRARY='IBMLAN'\NETPROG\LSIWOBJS.HLP;'||,
          'EXENAME='IBMLAN'\NETPROG\NETGUI.EXE;'||,
          'STARTUPDIR='IBMLAN'\NETPROG;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<LS_ADMIN>',,
      CreateCollision )

    rc = MyCreateObject( 'WPProgram',,
        'LAN Server^Logon',,
        '<UPM_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=308;'||,
            'HELPLIBRARY='IBMLAN'\NETPROG\LSIWOBJS.HLP;'||,
            'ICONPOS=23,12;'||,
            'EXENAME='BootDrive'\MUGLIB\LOGON.EXE;'||,
            'STARTUPDIR='BootDrive'\MUGLIB;'||,
            'PARAMETERS=/v:domain /d;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\'p.DirName'\Network Service\LAN Server!Logon.ICO;'||,
            'OBJECTID=<UPM_LANLOGON>',,
        CreateCollision )

    rc = MyCreateObject( 'WPProgram',,
        'Logoff',,
        '<UPM_FOLDER>',,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=309;'||,
            'HELPLIBRARY='IBMLAN'\NETPROG\LSIWOBJS.HLP;'||,
            'ICONPOS=15,12;'||,
            'EXENAME='BootDrive'\MUGLIB\LOGOFF.EXE;'||,
            'STARTUPDIR='BootDrive'\MUGLIB;'||,
            'PARAMETERS=/L;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<UPM_LOGOFF>',,
        CreateCollision )

    rc = MyCreateObject( 'WPProgram',,
        'Start^File and Print Client',,
        "<LS_FOLDER>",,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=307;'||,
            'HELPLIBRARY='IBMLAN'\NETPROG\LSIWOBJS.HLP;'||,
            'ICONPOS=6,12;'||,
            'EXENAME='IBMLAN'\NETPROG\NETSTCMD.CMD;'||,
            'STARTUPDIR='IBMLAN'\NETPROG;'||,
            'PARAMETERS=START PEER;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'OBJECTID=<LS_START>',,
        CreateCollision )

    rc = MyCreateObject( 'LSPeerUser',,
        'User Account^for Current Session',,
        '<UPM_FOLDER>',,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=SETTINGS;'||,
            'HELPPANEL=7501;'||,
            'HELPLIBRARY=LSPRWPS.HLP;'||,
            'ICONPOS=50,12;'||,
            'OBJECTID=<PEER_USER>',,
        CreateCollision )

    rc = MyCreateObject( 'WPProgram',,
        'Local Logon',,
        '<UPM_FOLDER>',,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=308;'||,
            'HELPLIBRARY='IBMLAN'\NETPROG\LSIWOBJS.HLP;'||,
            'ICONPOS=35,12;'||,
            'EXENAME='BootDrive'\MUGLIB\LOGON.EXE;'||,
            'STARTUPDIR='BootDrive'\MUGLIB;'||,
            'PARAMETERS=/v:local;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<PEER_LOCALLOGON>',,
        CreateCollision )
/*
  rc = MyCreateObject( 'WPFolder',,
      'Mobile Office Services',,
      MainObjName,,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONVIEWPOS=15 66 80 33;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Network Service\Mobile Office Services.ICO;'||,
          'OBJECTID=<MARSCM1>',,
      CreateCollision )

    rc = MyCreateObject( 'WPCommandFile',,
        'MFS Status^  :None',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'ICONPOS=70,16;'||,
            'ICONFILE='WiseManager'\'p.DirName'\Network Service\MFS Status!  !None.ICO;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\Network Service\MFS Status!  !None.DAT;'||,
            'OBJECTID=<MFSOBJECT>',,
        CreateCollision )

    rc = MyCreateObject( 'WPProgram',,
        'Start^Mobile File Sync^Mobile Office Services',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=57,16;'||,
            'EXENAME='RunFrom'\MFS\BIN\MFS.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<MCMPROG>',,
        CreateCollision )

    rc = MyCreateObject( 'WPProgram',,
        'Stop^Mobile File Sync^Mobile Office Services',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=41,16;'||,
            'EXENAME='RunFrom'\MFS\BIN\STOPMFS.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<MCMSTOP>',,
        CreateCollision )

    rc = MyCreateObject( 'WPProgram',,
        'Clear Persistence',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=27,16;'||,
            'EXENAME='RunFrom'\MFS\BIN\CLEARPS.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<MFSCP>',,
        CreateCollision )

    rc = MyCreateObject( 'WPProgram',,
        'Stashing Database ',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=14,16;'||,
            'EXENAME='RunFrom'\MFS\BIN\DBSTASH.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\'p.DirName'\Network Service\Stashing Database .ICO;'||,
            'OBJECTID=<MFSST>',,
        CreateCollision )

    rc = MyCreateObject( 'WPProgram',,
        'Spy Utility',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=3,16;'||,
            'EXENAME='RunFrom'\MFS\BIN\HOARD.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<MCMSPY>',,
        CreateCollision )
*/

  rc = MyCreateObject( 'WPProgram',,
      'Install/Configure^LAN Services',,
      "<LS_FOLDER>",,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=321;'||,
          'HELPLIBRARY='IBMLAN'\NETPROG\LSIWOBJS.HLP;'||,
          'EXENAME='IBMLAN'\INSTALL\LANINST.EXE;'||,
          'STARTUPDIR='IBMLAN'\INSTALL;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<LS_INSTCFG>',,
      CreateCollision )

  rc = MyCreateObject( 'LSPeerWorkstation',,
      'Shared Resources and^Network Connections',,
      "<LS_FOLDER>",,
      'NOPRINT=YES;'||,
          'MINWIN=DESKTOP;'||,
          'DEFAULTVIEW=SETTINGS;'||,
          'HELPPANEL=8001;'||,
          'HELPLIBRARY=LSPRWPS.HLP;'||,
          'OBJECTID=<PEER_WKST>',,
      CreateCollision )

rc = SysDestroyObject("<WC_NETSERV>")
rc = SysSetObjectData("<WP_NETWORK>", "TITLE=Resource Browser;BACKGROUND="BootDrive"\OS2\BITMAP\ALTGRY01.BMP,T,,I,255 255 255;")


/* This object will only run from the original folder */
/*
rc = CreateObject( 'WPNetgrp',,
    'File and Print Client^Resource Browser',,
    '<LS_FOLDER>',,
    'NOMOVE=YES;'||,
        'NOCOPY=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ICONPOS=26,11;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'NETID=LS;'||,
        'OBJECTID=<File_and_Print_Client_Resource_Browser>',,
    CreateCollision )
*/

  rc = CreateObject( 'WPProgram',,
      'LAN Server^Error Log Utility',,
      '<LAN_UTILITY_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=322;'||,
          'HELPLIBRARY='IBMLAN'\NETPROG\LSIWOBJS.HLP;'||,
          'ICONPOS=35,1;'||,
          'EXENAME='IBMLAN'\NETPROG\LSERROR.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\'p.DirName'\LAN Server!Error Log Utility1.ICO;'||,
          'OBJECTID=<LS_ERROR>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Network Messaging',,
      '<LAN_UTILITY_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=305;'||,
          'HELPLIBRARY='IBMLAN'\NETPROG\LSIWOBJS.HLP;'||,
          'ICONPOS=7,65527;'||,
          'EXENAME='IBMLAN'\NETPROG\NETMSG.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Network Messaging1.ICO;'||,
          'OBJECTID=<LS_NETMSG>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'LAN Server^Audit Log Utility',,
      '<LAN_UTILITY_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=323;'||,
          'HELPLIBRARY='IBMLAN'\NETPROG\LSIWOBJS.HLP;'||,
          'ICONPOS=11,1;'||,
          'EXENAME='IBMLAN'\NETPROG\LSAUDIT.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\'p.DirName'\LAN Server!Audit Log Utility1.ICO;'||,
          'OBJECTID=<LS_AUDIT>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Network DDE^and Clipboard',,
      '<LAN_UTILITY_FOLDER>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=304;'||,
          'HELPLIBRARY='IBMLAN'\NETPROG\LSIWOBJS.HLP;'||,
          'ICONPOS=59,1;'||,
          'EXENAME='IBMLAN'\NETPROG\NWDDE.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Network DDE!and Clipboard1.ICO;'||,
          'OBJECTID=<LS_CLIP>',,
      CreateCollision )
return

RegisterClasses:
/*

Say
Say 'Registering classes....'
Say
Say 'The following classes will be registered:'
Say
Say '  LSPeerWorkstatio  XFldObject        PRDirectory       LSPeerUser        '
Say '  XFldDataFile      XFolder           SpeechObject      XFldProgramFile   '
Say
Say 'Press enter to register 8 classes for object creation,'
Call CharOut, 'or type any other key and enter to ignore: '
Say
Parse Pull Answer
If Answer <> '' Then return
*/
  rc = MySysRegisterObjectClass( 'LSPeerWorkstation', 'LSPRWPS' )

  rc = MySysRegisterObjectClass( 'PRDirectory', 'LSPRWPS' )

  rc = MySysRegisterObjectClass( 'LSPeerUser', 'LSPRWPS' )

  rc = MySysRegisterObjectClass( 'LSDirectory', 'LSGWPS' )
 
return

SetIBMLAN:
   if (translate(word(Action,1))="LOCALINSTALL") then do
      Path = value("PATH",,"OS2ENVIRONMENT")
      if (Path<>"") then do
         ipos = pos("\IBMLAN",translate(Path))
         if (ipos>2) then do
            if (substr(path,ipos-1,1)=":") then do
               IBMLAN = substr(path,ipos-2,2+7)
               return
            end
         end
   end
   IBMLAN = BootDrive'\IBMLAN'
end