/* */

parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then parse var string "'"BootDrive" "AppServer" "Action"'"
if (string<>"" & BootDrive="") then parse var string BootDrive" "AppServer" "Action
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */

  ProgramName = "SysSet"
  p.Title = "SysSet"
  p.ThisCMDFileName = "CreateSysSet.CMD"
  p.DirName = "SysSet"
  p.ObjectID = "<OBJECT_SysSet>"
  p.Location = "<WP_CLIENTAPPSFOLDER>"
  p.FitToCheck = ""
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = "\OS2"   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""
 
  call StartUp
 
  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
  p.Doc= "" /* "OBJECTID="p.ObjectIDPre"_DOC>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\README;STARTUPDIR="p.StartDir";" */  /* Set to blank for no readme */

  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */ /* Set to blank for no desktop shadow */
  p.ObjectIDFolder = p.ObjectIDPre || "_FOLDER>" /* Set to blank for no folder */
  if (p.ObjectIDShadow="") then
     p.ObjectIDFolderShadow = p.ObjectIDPre || "_FOLDER_SHODOW>"
  else
     p.ObjectIDFolderShadow = ""
  p.ObjectIDFolderCleanUp = p.ObjectIDPre || "_FOLDER_CLEANUP>"
  p.ObjectIDFolderICON1 = WiseManager"\..\DeskTop\"p.DirName"\"p.DirName".ICO"
  p.ObjectIDFolderICON2 = WiseManager"\..\DeskTop\"p.DirName"\"p.DirName"1.ICO"

/**/
dll = 'SYSSET'
UnlockModule = 'syssetUnlockModule'
class.0 = 1
class.1 = 'WPSysset'
/**/
signal on syntax name lab5
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs
lab5:
signal on syntax name CMDExit
if RxFuncQuery('UnlockModule') = 0 then
  call RxFuncDrop 'UnlockModule'
call RxFuncAdd 'UnlockModule', dll, UnlockModule
dll = BootDrive||Apps"\sysset\"dll'.DLL'
/* arg opt */
opt = "I"
select
  when opt = 'I' then do
    call SysFileTree dll, 'stem', 'O'
    if stem.0 = 0 then do
      say 'Unable to locate' dll
      call RxFuncDrop 'UnlockModule'
      signal cmdExit
    end
    do i = 1 to class.0
      call register class.i
    end
    call createobj
  end
  when opt = 'U' then do
    call deleteobj
    do i = 1 to class.0
      call deregister class.i
    end
    call charout , 'Unlocking' dll': '
    rc = UnlockModule(dll)
    if rc = 0 | rc = 296 then do
      say 'Success'
      call RxFuncDrop 'UnlockModule'
      signal cmdExit
    end
    else
      say 'Failure'
  end
  otherwise
    parse upper source . . me
    me = filespec('N', me)
    say
    say 'Usage:' left(me, lastpos('.', me) - 1) '<option>'
    say
    say 'Option is: I - Install'
    say '           U - Uninstall'
end
call RxFuncDrop 'UnlockModule'
signal cmdExit
'@exit'

register:
  parse arg newclass
  /* call charout , 'Registering class' newclass': ' */
  if SysRegisterObjectClass(newclass, stem.1) \= 0 then do
    /* say 'Success' */
  end
  else
    say 'Failure'
  return

deregister:
  parse arg newclass
  /* call charout , 'Deregistering class' newclass': ' */
  if SysDeregisterObjectClass(newclass) \= 0 then do
    /* say 'Success' */
  end
  else
    say 'Failure'
  return

createFolder: 
  if (p.ObjectIDFolder <> "") then do
     rc = CreateObject( "WPFolder",,
         p.Title,,
         p.Location,,
        'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='p.ObjectIDFolderICON1';'||,
        'ICONNFILE=1,'p.ObjectIDFolderICON2';'||,
        'OBJECTID='p.ObjectIDFolder,,
         p.Flag )

      if (p.ObjectIDShadow<>"") then do
        rc = CreateObject( 'WPShadow',,
            p.Title,,
            '<WP_DESKTOP>',,
            'SHADOWID='p.ObjectIDFolder';'||,
            'OBJECTID='p.ObjectIDFolderShadow,,
         p.Flag )
      end

      p.Location = p.ObjectIDFolder

/*
       p.Doc= "OBJECTID="p.ObjectIDPre"_REG>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\Register.TXT;STARTUPDIR="p.StartDir";"
       rc = CreateObject( p.Class,"Registration",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
 
       p.Doc= "OBJECTID="p.ObjectIDPre"_LIC>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\License.TXT;STARTUPDIR="p.StartDir";"
       rc = CreateObject( p.Class,"License",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
  
       p.Doc= "OBJECTID="p.ObjectIDPre"_NOT>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\Notice.TXT;STARTUPDIR="p.StartDir";"
       rc = CreateObject( p.Class,"Notice",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
  
       p.Doc= "OBJECTID="p.ObjectIDPre"_VER>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\Version.TXT;STARTUPDIR="p.StartDir";"
       rc = CreateObject( p.Class,"Version",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
  
       p.Doc= "OBJECTID="p.ObjectIDPre"_NEW>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\WhatsNew.TXT;STARTUPDIR="p.StartDir";"
       rc = CreateObject( p.Class,"What's new",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
*/  

       p.Doc= "OBJECTID="p.ObjectIDPre"_DOC>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\SysSET.DOC;STARTUPDIR="p.StartDir";"
       rc = CreateObject( p.Class,"Documentation",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
 
  programs = "SysSET.CMD Printscr.CMD"
  do while (programs<>"")
     programs = strip(programs)
     parse var programs p.Title".CMD"programs
     p.SetupString = "EXENAME="p.ExeDir"\"p.Title".CMD;STARTUPDIR="p.StartDir";"
     p.ObjectID = "<SYSSET_"p.Title">"
     rc = CreateObject( p.Class, p.Title, p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
  end /* do */
 
return

createobj:
  call charout , 'Creating Sysset object: '
  if SysCreateObject('WPSysset', 'Sysset', '<WP_NOWHERE>',,
      'OBJECTID=<SYSSET>', 'Replace') \= 0 then do
         call createFolder
      end /* do */
    /* say 'Success' */
  end
  else
    say 'Failure'
  return

deleteobj:
  call charout , 'Deleting Sysset object: '
  if SysDestroyObject('<SYSSET>') \= 0 then do
    /* say 'Success' */
  end
  else
    say 'Failure'
  return

