/* */
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then parse var string "'"BootDrive" "AppServer" "Action"'"
if (string<>"" & BootDrive="") then parse var string BootDrive" "AppServer" "Action
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */

  ProgramName = "WatcomC"
  p.Title = "WatcomC"
  p.ThisCMDFileName = "CreateWatcomC.CMD"
  p.DirName = "WatcomC"
  p.ObjectID = "<OBJECT_WatcomC>"
  p.Location = "<WP_CLIENTAPPSFOLDER>"
  p.FitToCheck = ""
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = "\OS2"   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""

  call StartUp

  CreateCollision = 'Replace'     /* 'Fail', 'Replace', or 'Update' */

  title = "Watcom C/C++"

rc = CreateObject( 'WPFolder',,
    title,,
    p.Location,,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='RunFrom'\DeskTop\WatcomC\WATCOM C!C++.ICO;'||,
        'OBJECTID=<wcpp32.grp>',,
    CreateCollision )

  rc = CreateObject( 'WPShadow',,
      title,,
      '<WP_DESKTOP>',,
      'NOPRINT=YES;'||,
         'DEFAULTVIEW=UNKNOWN;'||,
         'HELPPANEL=1277;'||,
         'SHADOWID=<wcpp32.grp>;'||,
         'OBJECTID=<wcpp32.grpShadow>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Dialog Editor',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=48,28;'||,
          'EXENAME='RunFrom'\WatcomC\BINP\DLGEDIT.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Dialog_Editor>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'IDE Help',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=22,18;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\ide.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<IDE_Help>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Linker Guide',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=15,62814;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\lguide.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Linker_Guide>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'C++ Library Reference',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=52,18;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\cpplib.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<C___Library_Reference>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Windowed Debugger',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=29,28;'||,
          'EXENAME='BootDrive||Apps'\WatcomC\BINP\WDW.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Windowed_Debugger>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Source Browser Help',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=5,18;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\wbrw.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Source_Browser_Help>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'User''s Guide',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=62,18;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\cguide.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<User_s_Guide>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'IPFC Reference',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=39,62814;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\ipfc20.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<IPFC_Reference>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'PM Reference',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=67,62814;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS=PMREF;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<PM_Reference>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Source Browser',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=11,28;'||,
          'EXENAME='RunFrom'\WatcomC\BINP\WBRW.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Source_Browser>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Font Editor',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=57,28;'||,
          'EXENAME='RunFrom'\WatcomC\BINP\FONTEDIT.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Font_Editor>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Debugger Help',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=30,18;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\wd.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Debugger_Help>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Tools Guide',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=22,62814;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\tools.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Tools_Guide>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'SOM Reference',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=48,62814;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\som.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<SOM_Reference>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'IDE',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=3,28;'||,
          'ASSOCFILTER=*.WPJ;'||,
          'EXENAME='RunFrom'\WatcomC\BINP\IDE.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<IDE_000>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Debugger',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=40,28;'||,
          'EXENAME='RunFrom'\WatcomC\BINP\WD.EXE;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'OBJECTID=<Debugger>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Profiler Help',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=15,18;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\wprof.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Profiler_Help>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Programmer''s Guide',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=5,62814;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\pguide.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Programmer_s_Guide>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'CP Reference',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=3,62804;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS=PROGREF20;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<CP_Reference>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Profiler',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=20,28;'||,
          'EXENAME='RunFrom'\WatcomC\BINP\WPROF.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Profiler>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Icon Editor',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=65,28;'||,
          'EXENAME='RunFrom'\WatcomC\BINP\ICONEDIT.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Icon_Editor>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'C Library Reference',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=40,18;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\clib.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<C_Library_Reference>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'REXX Reference',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=30,62814;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\rexxapi.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<REXX_Reference>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Tools Reference',,
      '<wcpp32.grp>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=58,62814;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='BootDrive||Apps'\WatcomC\binp\help\toolinfo.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<Tools_Reference>',,
      CreateCollision )

syntax:
signal CMDExit
return 0

/* Copy these lines for every ap */
CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    /* Say "Creating ["Title"]" */
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say " > failed to create ["Title" | "Class"] at location ["Location"]"
    else
        call TV_DosSleep 0
return rc
 
StartUp: /* Do not make this a procedure */
  signal on Syntax name lab0
  rc = RxFuncAdd( "SysLoadFuncs", "REXXUTIL", "SYSLOADFUNCS" )
  rc = SysLoadFuncs()
lab0:
  signal on Syntax name lab1
    rc = RxFuncAdd( "TV_RegisterExtFunc", "TVoiceU", "TV_RegisterExtFunc" )
    rc = TV_RegisterExtFunc()
lab1:
  signal on Syntax
 
  CRLF = D2C(13)||D2C(10)

   Apps = "\Apps"
   rc = AppServer( AppServer, BootDrive )
   parse var rc AppServer" "RunFrom
   RunFrom = RunFrom || Apps

   if (p.FileToCheck <> "") then do
      rc = FileExists(p.FileToCheck)
      if (rc=0) then rc = FileExists(BootDrive||Apps"\"p.DirName"\"strip(p.FileToCheck,"L","\"))
      if (rc=0) then rc = FileExists(BootDrive||Apps"\"strip(p.FileToCheck,"L","\"))
   end
   else if (p.DirToCheck <> "") then do
      rc = IsDir(p.DirToCheck)
      if (rc=0) then do
         rc = IsDir(BootDrive|| Apps"\"p.DirName"\"strip(p.DirToCheck,"L","\"))
         if (rc=0) then rc = IsDir(RunFrom"\"strip(p.DirToCheck,"L","\"))
      end
   end
   else if (p.PathToCheck <> "") then do
      Path=translate(Value( "PATH", , "OS2ENVIRONMENT" ))
      rc = pos(translate(RunFrom || "\" || strip(p.PathToCheck,"L","\")),Path)
   end /* do */
   else rc = IsDir(RunFrom"\"strip(p.DirName,"L","\"))

   if (rc=0) then do  
    rc = CreateObject( "WPProgram",,
      p.Title||CRLF||"(Reboot Required)",,
      "<WP_START>",,
      "NOPRINT=YES;"||,
          "DEFAULTVIEW=RUNNING;"||,
          "EXENAME="RunFrom"\DeskTop\"p.ThisCMDFileName";"||,
          "PARAMETERS="argString";"||,
          "PROGTYPE=PM;"||,
          "OBJECTID=<"p.Title"_FOLDER_CLEANUP>",,
      "REPLACE" )
 
    rc = CreateObject( "WPShadow",,
        p.Title||CRLF||"(Reboot Required)",,
        "<WP_DESKTOP>",,
            "SHADOWID=<"p.Title"_FOLDER_CLEANUP>;"||,
            "OBJECTID=<"p.Title"_FOLDER_CLEANUP_SHADOW>",,
        "REPLACE" )
 
      "@exit"
 
   end /* do */
 
/*
     Action can be blank, CLEANUP, or START 
     blank means normal create with REBOOT required title
     CLEANUP means create ICON without the REBOOT required title 
     START   means starts up the main program
  */
 
  Action = translate(Action)
  if (Action = "START") then do
     /* if (p.ObjectID <> "") then rc = SysOpenObject("p.ObjectID", "RUNNING", 0) */
     "@exit"
     return
  end /* do */
 
  if (p.Location = "<WP_CLIENTAPPSFOLDER>") then call ClientAppsFolder

return
 
cmdExit:
   rc = SysDestroyObject( "<"p.Title"_FOLDER_CLEANUP_SHADOW>" )
   rc = SysDestroyObject( "<"p.Title"_FOLDER_CLEANUP>" )
"@exit"
return
 
IsDir: procedure
   parse arg DirName
   DirName=strip(DirName,"B","'")
   if (DirName="") then do
      /* say "IsDir: illegal file spec "DirName */
      return 0
   end
   if stream(DirName"\.","C","QUERY DATETIME")="" then rc = 0
   else rc = 1
return rc

FileExists: procedure
   parse arg FileName
   FileName=strip(FileName,"B","'")
   if (FileName="") then do
      return 0
   end
   if stream(FileName,"C","QUERY DATETIME")="" then rc = 0
   else rc = 1
return rc

/* Decide where the AppServer is */
AppServer: procedure expose Apps
  parse arg AppServer, BootDrive
  if (AppServer="") then do
     RunFrom=BootDrive
     AppServer=BootDrive
     if (IsDir(RunFrom"\Apps")=0) then Apps = ""
  end
  else do
     parse var AppServer AppServer"|"MyServer
     if (substr(AppServer,1,2)="\\") then do 
        if (MyServer<>"") then do
           parse var AppServer "\\"nam"\"rest
           if (translate(nam)=translate(MyServer)) then RunFrom = BootDrive
           else RunFrom = AppServer
        end /* do */
        else RunFrom=AppServer
     end /* do */
     else do
        parse var AppServer RunFrom"|"AppServer"|"rest
        if (IsDir(RunFrom"\Apps")=0) then Apps = ""
        if (AppServer="") then AppServer=RunFrom
     end /* do */
  end /* do */
return AppServer" "RunFrom

ClientAppsFolder:
     p.Location = "<WP_CLIENTAPPSFOLDER>"
     rc = CreateObject( "WPFolder",,
         "Client Applications",,
         "<WP_APPSFOLDER>",,
        'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID='p.Location,,
         'Update' )
return p.Location

/* End of Copy these lines for every ap */
