/* */
 
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then do
   parse var string "'"BootDrive" "AppServer" "Action"'"
end
if (string<>"" & BootDrive="") then do
   parse var string BootDrive" "AppServer" "Action
end
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */
parse var Action Action" "NoShadow" "Quiet
 
  p.Title = "XFolder"  /* Name of this application */
  p.ThisCMDFileName = "CreateXFolder.CMD"  /* Name of this command file */
  p.DirName = "XFolder"  /* Name of main dir */
  p.Location = "<WP_APPSFOLDER>"  /* Location to place main folder */
  p.ObjectID = "<OBJECT_XFolder>"  /* Object to start (usually the main exe) */
  p.FitToCheck = ""
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = ""   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = "XFolder bin\xfldr"   /* Class to check to see if this is a fresh install (classname dllname) */

  call StartUp
 
  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
 
  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= ""
  p.ObjectIDFolder = "" /* Set to blank for no folder */
 
  CreateCollision = p.Flag
  Call RegisterClasses
  Call CreateObjects
 
syntax:
/* signal CMDExit */
   rc = SysDestroyObject( "<"p.Title"_FOLDER_CLEANUP_SHADOW>" )
   rc = SysDestroyObject( "<"p.Title"_FOLDER_CLEANUP>" )

  call SysSleep 10
  if (p.StartDir="P.STARTDIR") then p.StartDir = "\Apps\XFolder"
  interpret "'@call "p.StartDir"\bin\wpsreset -D'"

"@exit"
return 0
 
crobj001: procedure expose p.StartDir
   parse arg Dir, LanguageCode

   /* REGISTER */

   /* delete all INI keys of previous XFolder versions
      because the XFolder INI data changes with every
      release */
   rc = SysINI('USER', "XFolder_0_40", "DELETE:");
   rc = SysINI('USER', "XFolder_0_41", "DELETE:");
   rc = SysINI('USER', "XFolder_0_42", "DELETE:");
   rc = SysINI('USER', "XFolder 0.5x", "DELETE:");
   rc = SysINI('USER', "XFolder07", "DELETE:");
   rc = SysINI('USER', "XFolder7", "DELETE:");

   /* set INI data for this version */
   rc = SysINI('USER', IniKey, "XFolderPath", Dir||'0'x);
   rc = SysINI('USER', IniKey, "Language", LanguageCode||'0'x);
   rc = SysINI('USER', IniKey, "JustInstalled", '1'||'0'x);
   rc = SysINI('USER', IniKey, "Version", XFolderVersion||'0'x);

   /* remove WPS classes that might already be registered */

   rc = SysDeregisterObjectClass("XFldWPS")
   rc = SysDeregisterObjectClass("XFldStartup")
   rc = SysDeregisterObjectClass("XFldShutdown")

   if (Quiet<>"") then Quiet = " >nul:"
   "@call "Dir"\bin\repclass.exe WPSystem XFldSystem"Quiet
   "@call "Dir"\bin\repclass.exe WPProgram XFldProgram"Quiet
   "@call "Dir"\bin\repclass.exe WPDisk XFldDisk"Quiet
   "@call "Dir"\bin\repclass.exe WPDataFile XFldDataFile"Quiet
   "@call "Dir"\bin\repclass.exe WPDesktop XFldDesktop"Quiet
   "@call "Dir"\bin\repclass.exe WPFolder XFolder"Quiet
   "@call "Dir"\bin\repclass.exe WPFileSystem XFldFileSystem"Quiet
   "@call "Dir"\bin\repclass.exe WPObject XFldObject"Quiet
   "@call "Dir"\bin\repclass.exe WPProgramFile XFldProgramFile"Quiet

   /* install classes for this version */
   "@call "Dir"\bin\repclass.exe WPFolder XFolder" Dir||"\bin\xfldr.dll"Quiet;
   "@call "Dir"\bin\repclass.exe WPObject XFldObject" Dir||"\bin\xfldr.dll"Quiet;
   /* "@call "Dir"\bin\repclass.exe WPFileSystem XFldFileSystem" Dir||"\bin\xfldr.dll"Quiet; */
   "@call "Dir"\bin\repclass.exe WPDataFile XFldDataFile" Dir||"\bin\xfldr.dll"Quiet;
   "@call "Dir"\bin\repclass.exe WPDisk XFldDisk" Dir||"\bin\xfldr.dll"Quiet;
   "@call "Dir"\bin\repclass.exe WPDesktop XFldDesktop" Dir||"\bin\xfldr.dll"Quiet;
   "@call "Dir"\bin\repclass.exe WPProgramFile XFldProgramFile" Dir||"\bin\xfldr.dll"Quiet;

   rc = SysRegisterObjectClass("XFldSystem", Dir||"\bin\xfldr.dll")
   rc = SysRegisterObjectClass("XFldWPS", Dir||"\bin\xfldr.dll")
   rc = SysRegisterObjectClass("XFldStartup", Dir||"\bin\xfldr.dll")
   rc = SysRegisterObjectClass("XFldShutdown", Dir||"\bin\xfldr.dll")

   /* check for Object Desktop TSEnhFolder */
   ClassList.0 = 0;
   call SysQueryClassList "ClassList.";
   if (ClassList.0 > 0) then
      do i = 1 to ClassList.0
         parse var ClassList.i Class DLL
         if (Class = "TSEnhFolder") then do
            /* remove TSEnhFolder and undo replacement */
            "@call "Dir"\bin\repclass.exe WPFolder TSEnhFolder"Quiet
            /* and register and replace again;
            OBJDEFLD.DLL should be on the LIBPATH */
            "@call "Dir"\bin\repclass.exe WPFolder TSEnhFolder OBJDEFLD"Quiet
            leave
         end
      end
return 0

CreateObjects:

call crobj001 p.StartDir, "001"

rc = CreateObject( 'XFldSystem',,
    'OS/2 Kernel',,
    '<WP_CONFIG>',,
    'NOCOPY=YES;'||,
        'NODELETE=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=SETTINGS;'||,
        'ICONPOS=27,56;'||,
        'OBJECTID=<XFOLDER_KERNEL>',,
    CreateCollision )

rc = CreateObject( 'XFldWPS',,
    'Workplace Shell',,
    '<WP_CONFIG>',,
    'NOCOPY=YES;'||,
        'NODELETE=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=SETTINGS;'||,
        'ICONPOS=18,21;'||,
        'OBJECTID=<XFOLDER_WPS>',,
    CreateCollision )

rc = CreateObject( 'WPFolder',,
    'XFolder',,
    '<WP_APPSFOLDER>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ICONPOS=5,87;'||,
        'ICONVIEWPOS=4 10 81 29;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'ALWAYSSORT=Yes;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<XFOLDER_MAIN>',,
    CreateCollision )

rc = CreateObject( 'WPFolder',,
    'XFolder Configuration Folder',,
    '<XFOLDER_MAIN>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=3;'||,
        'HELPLIBRARY='p.ExeDir'\help\xfldr001.hlp;'||,
        'ICONPOS=53,20;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONFLOWED,MINI;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<XFOLDER_CONFIG>',,
    CreateCollision )

rc = CreateObject( 'XFldShutdown',,
    'XFolder Shutdown',,
    '<XFOLDER_MAIN>',,
    'NOCOPY=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=25;'||,
        'HELPLIBRARY='p.ExeDir'\help\xfldr001.hlp;'||,
        'ICONPOS=18,87;'||,
        'ICONVIEWPOS=15 62 80 20;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONFLOWED,MINI;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<XFOLDER_SHUTDOWN2>',,
    CreateCollision )

rc = CreateObject( 'WPProgram',,
    'WiseClient Shutdown',,
    '<XFOLDER_SHUTDOWN2>',,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        ';'||,
        'EXENAME='WiseManager'\ShutDownWiseClient.CMD;'||,
        'PROGTYPE=WINDOWABLEVIO;'||,
        'MINIMIZED=YES;'||,
        'OBJECTID=<WISECLIENT_SHUTDOWN>',,
    CreateCollision )

rc = CreateObject( 'XFldStartup',,
    'XFolder Startup',,
    '<XFOLDER_MAIN>',,
    'NOCOPY=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=25;'||,
        'HELPLIBRARY='p.ExeDir'\help\xfldr001.hlp;'||,
        'ICONPOS=29,89;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONFLOWED,MINI;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<XFOLDER_STARTUP2>',,
    CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'XFolder Configuration Folder',,
      '<XFOLDER_MAIN>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=3;'||,
          'HELPLIBRARY='p.ExeDir'\help\xfldr001.hlp;'||,
          'ICONPOS=53,20;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=FLOWED,MINI;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'OBJECTID=<XFOLDER_CONFIG>',,
      CreateCollision )

    rc = CreateObject( 'WPProgram',,
        '---',,
        '<XFOLDER_CONFIG>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'OBJECTID=<XFOLDER_SEP1>',,
        CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Netscape (DDE)',,
      '<XFOLDER_CONFIG>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='p.ExeDir'\BIN\NETSCDDE.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<XFOLDER_NETSCAPE>',,
      CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Treesize',,
        '<XFOLDER_CONFIG>',,
        'NOPRINT=YES;'||,
            'CCVIEW=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='p.ExeDir'\BIN\TREESIZE.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<XFOLDER_TREESIZE>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        '---',,
        '<XFOLDER_CONFIG>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'OBJECTID=<XFOLDER_SEP2>',,
        CreateCollision )

    rc = CreateObject( 'WPFolder',,
        '~Command lines',,
        '<XFOLDER_CONFIG>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'HELPPANEL=3;'||,
            'HELPLIBRARY='p.ExeDir'\help\xfldr001.hlp;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONFLOWED,MINI;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'OBJECTID=<XFOLDER_CFG1>',,
        CreateCollision )

      rc = CreateObject( 'WPProgram',,
          '~DOS window',,
          '<XFOLDER_CFG1>',,
          'NOPRINT=YES;'||,
              'CCVIEW=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL=8012;'||,
              'EXENAME=*;'||,
              'PARAMETERS=%;'||,
              'PROGTYPE=WINDOWEDVDM;'||,
              'OBJECTID=<XFOLDER_DOSWIN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'DOS f~ullscreen',,
          '<XFOLDER_CFG1>',,
          'NOPRINT=YES;'||,
              'CCVIEW=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL=8011;'||,
              'EXENAME=*;'||,
              'PARAMETERS=%;'||,
              'PROGTYPE=VDM;'||,
              'OBJECTID=<XFOLDER_DOSFULL>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'OS/2 ~fullscreen',,
          '<XFOLDER_CFG1>',,
          'NOPRINT=YES;'||,
              'CCVIEW=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL=8009;'||,
              'EXENAME=*;'||,
              'PARAMETERS=%;'||,
              'PROGTYPE=FULLSCREEN;'||,
              'OBJECTID=<XFOLDER_OS2FULL>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          '~OS/2 window',,
          '<XFOLDER_CFG1>',,
          'NOPRINT=YES;'||,
              'CCVIEW=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL=8010;'||,
              'EXENAME=*;'||,
              'PARAMETERS=%;'||,
              'PROGTYPE=WINDOWABLEVIO;'||,
              'OBJECTID=<XFOLDER_OS2WIN>',,
          CreateCollision )

    rc = CreateObject( 'WPFolder',,
        'Create a~nother',,
        '<XFOLDER_CONFIG>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'HELPPANEL=3;'||,
            'HELPLIBRARY='p.ExeDir'\help\xfldr001.hlp;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONFLOWED,MINI;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'OBJECTID=<XFOLDER_CFG2>',,
        CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Program object',,
          '<XFOLDER_CFG2>',,
          'TEMPLATE=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL=15684;'||,
              'OBJECTID=<XFOLDER_PROGRAMTEMPLATE>',,
          CreateCollision )

      rc = CreateObject( 'WPFolder',,
          'Folder',,
          '<XFOLDER_CFG2>',,
          'TEMPLATE=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=CONTENTS;'||,
              'HELPPANEL=3;'||,
              'HELPLIBRARY='p.ExeDir'\help\xfldr001.hlp;'||,
              'SELFCLOSE=1;'||,
              'ICONFONT=9.WarpSans;'||,
              'DETAILSFONT=9.WarpSans;'||,
              'TREEFONT=9.WarpSans;'||,
              'ICONVIEW=NONGRID,NORMAL;'||,
              'DETAILSVIEW=MINI;'||,
              'TREEVIEW=LINES,MINI;'||,
              'OBJECTID=<XFOLDER_FOLDERTEMPLATE>',,
          CreateCollision )

    rc = CreateObject( 'WPFolder',,
        '~Quick Settings',,
        '<XFOLDER_CONFIG>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'HELPPANEL=3;'||,
            'HELPLIBRARY='p.ExeDir'\help\xfldr001.hlp;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONFLOWED,MINI;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'OBJECTID=<XFOLDER_CFG3>',,
        CreateCollision )

      rc = CreateObject( 'WPFolder',,
          '~Default view for this folder',,
          '<XFOLDER_CFG3>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=CONTENTS;'||,
              'HELPPANEL=3;'||,
              'HELPLIBRARY='p.ExeDir'\help\xfldr001.hlp;'||,
              'SELFCLOSE=1;'||,
              'ICONFONT=9.WarpSans;'||,
              'DETAILSFONT=9.WarpSans;'||,
              'TREEFONT=9.WarpSans;'||,
              'ICONVIEW=NONFLOWED,MINI;'||,
              'DETAILSVIEW=MINI;'||,
              'TREEVIEW=LINES,MINI;'||,
              'OBJECTID=<XFOLDER_CFG3_1>',,
          CreateCollision )

        rc = CreateObject( 'WPProgram',,
            'Details view',,
            '<XFOLDER_CFG3_1>',,
            'NOPRINT=YES;'||,
                'CCVIEW=YES;'||,
                'DEFAULTVIEW=RUNNING;'||,
                'EXENAME='p.ExeDir'\BIN\DEFDETLS.CMD;'||,
                'PROGTYPE=WINDOWABLEVIO;'||,
                'MINIMIZED=YES;'||,
                'OBJECTID=<XFOLDER_DEFDETLS>',,
            CreateCollision )

        rc = CreateObject( 'WPProgram',,
            'Tree view',,
            '<XFOLDER_CFG3_1>',,
            'NOPRINT=YES;'||,
                'CCVIEW=YES;'||,
                'DEFAULTVIEW=RUNNING;'||,
                'EXENAME='p.ExeDir'\BIN\DEFTREE.CMD;'||,
                'PROGTYPE=WINDOWABLEVIO;'||,
                'MINIMIZED=YES;'||,
                'OBJECTID=<XFOLDER_DEFTREE>',,
            CreateCollision )

        rc = CreateObject( 'WPProgram',,
            'Icon view',,
            '<XFOLDER_CFG3_1>',,
            'NOPRINT=YES;'||,
                'CCVIEW=YES;'||,
                'DEFAULTVIEW=RUNNING;'||,
                'EXENAME='p.ExeDir'\BIN\DEFICON.CMD;'||,
                'PROGTYPE=WINDOWABLEVIO;'||,
                'MINIMIZED=YES;'||,
                'OBJECTID=<XFOLDER_DEFICON>',,
            CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Normal icons for Icon and Tree views',,
          '<XFOLDER_CFG3>',,
          'NOPRINT=YES;'||,
              'CCVIEW=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='p.ExeDir'\BIN\ICONORM.CMD;'||,
              'PROGTYPE=WINDOWABLEVIO;'||,
              'MINIMIZED=YES;'||,
              'OBJECTID=<XFOLDER_ICONORM>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Small icons for Icon and Tree views',,
          '<XFOLDER_CFG3>',,
          'NOPRINT=YES;'||,
              'CCVIEW=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='p.ExeDir'\BIN\ICOSMALL.CMD;'||,
              'PROGTYPE=WINDOWABLEVIO;'||,
              'MINIMIZED=YES;'||,
              'OBJECTID=<XFOLDER_ICOSMALL>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Show all objects in Tree view',,
          '<XFOLDER_CFG3>',,
          'NOPRINT=YES;'||,
              'CCVIEW=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='p.ExeDir'\BIN\SHOWALL.CMD;'||,
              'PROGTYPE=WINDOWABLEVIO;'||,
              'MINIMIZED=YES;'||,
              'OBJECTID=<XFOLDER_SHOWALL>',,
          CreateCollision )

    rc = CreateObject( 'WPFolder',,
        '~XFolder',,
        '<XFOLDER_CONFIG>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'HELPPANEL=3;'||,
            'HELPLIBRARY='p.ExeDir'\help\xfldr001.hlp;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONFLOWED,MINI;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'OBJECTID=<XFOLDER_CFG4>',,
        CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'XFolder Online Reference',,
      '<XFOLDER_MAIN>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=7,20;'||,
          'EXENAME=view.exe;'||,
          'PARAMETERS='p.ExeDir'\xfldr001.inf;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<XFOLDER_REF>',,
      CreateCollision )

      rc = CreateObject( 'WPShadow',,
          'XFolder Configuration Folder',,
          '<XFOLDER_CFG4>',,
          'SHADOWID=<XFOLDER_CONFIG>;'||,
              'OBJECTID=<XFOLDER_CONFIGSHADOW>',,
          CreateCollision )

      rc = CreateObject( 'WPShadow',,
          'XFolder Online Reference',,
          '<XFOLDER_CFG4>',,
          'SHADOWID=<XFOLDER_REF>;'||,
              'OBJECTID=<XFOLDER_REFSHADOW>',,
          CreateCollision )

      rc = CreateObject( 'WPShadow',,
          'OS/2 Kernel',,
          '<XFOLDER_CFG4>',,
          'SHADOWID=<XFOLDER_KERNEL>;'||,
              'OBJECTID=<XFOLDER_KERNELCFGSHADOW>',,
          CreateCollision )

      rc = CreateObject( 'WPShadow',,
          'Workplace Shell',,
          '<XFOLDER_CFG4>',,
          'SHADOWID=<XFOLDER_WPS>;'||,
              'OBJECTID=<XFOLDER_WPSCFGSHADOW>',,
          CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'eXtended Shutdown...',,
      '<XFOLDER_MAIN>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=20,20;'||,
          'EXENAME='p.ExeDir'\BIN\XSHUTDWN.EXE;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<XFOLDER_XSHUTDOWN>',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'Workplace Shell',,
      '<XFOLDER_MAIN>',,
      'ICONPOS=40,20;'||,
          'SHADOWID=<XFOLDER_WPS>;'||,
          'OBJECTID=<XFOLDER_WPSSHADOW>',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'OS/2 Kernel',,
      '<XFOLDER_MAIN>',,
      'ICONPOS=31,20;'||,
          'SHADOWID=<XFOLDER_KERNEL>;'||,
          'OBJECTID=<XFOLDER_KERNELSHADOW>',,
      CreateCollision )

      if (NoShadow="") then 
      rc = CreateObject( 'WPShadow',,
          'XFolder',,
          '<WP_DESKTOP>',,
          'SHADOWID=<XFOLDER_MAIN>;'||,
              'OBJECTID=<XFOLDER_MAINSHADOW>',,
          CreateCollision )

return

RegisterClasses:
return

