/* */
  parse arg Action
  signal on Syntax name lab0
  rc = RxFuncAdd( "SysLoadFuncs", "REXXUTIL", "SYSLOADFUNCS" )
  rc = SysLoadFuncs()
lab0:
  signal on Syntax
  if (Action = "CLEANUP") then signal CleanUp

    p.Title = "Removing Object Desktop"
    say p.Title

    call DeRegisterClass

    CRLF = D2C(13)||D2C(10)
    parse source . . p.ThisCMDFileName

    rc = SysCreateObject( "WPProgram",,
      p.Title||CRLF||"(Reboot Required)",,
      "<WP_START>",,
      "NOPRINT=YES;"||,
          "DEFAULTVIEW=RUNNING;"||,
          "EXENAME="p.ThisCMDFileName";"||,
          "PARAMETERS=CLEANUP;"||,
          "PROGTYPE=PM;"||,
          "OBJECTID=<OBJD_FOLDER_CLEANUP>",,
      "REPLACE" )

    rc = SysCreateObject( "WPShadow",,
        p.Title||CRLF||"(Reboot Required)",,
        "<WP_DESKTOP>",,
            "SHADOWID=<OBJD_FOLDER_CLEANUP>;"||,
            "OBJECTID=<OBJD_FOLDER_CLEANUP_SHADOW>",,
        "REPLACE" )

    signal Syntax
 
CleanUp:
  rc = SysDestroyObject( "<OBJD_FOLDER>" )
  if (rc<>1) then say "Unable to remove Object Desktop"

  rc = SysDestroyObject( "<OBJD_FOLDER_CLEANUP>" )

Syntax:
"@exit"
return 0

MySysDeregisterObjectClass:
   parse arg ClassName
   If SysDeRegisterObjectClass( ClassName ) <> 1 Then
       Say 'Can''t deregister class 'ClassName'.'
   Else
       Say 'Deregistered class 'ClassName'.'
return rc

DeRegisterClass:
  rc = 0
  rc = MySysDeregisterObjectClass( 'TSArcFileMgr' )
  rc = MySysDeregisterObjectClass( 'TSZooElem' )
  rc = MySysDeregisterObjectClass( 'TSZipElem' )
  rc = MySysDeregisterObjectClass( 'TSRarElem' )
  rc = MySysDeregisterObjectClass( 'TSTarElem' )
  rc = MySysDeregisterObjectClass( 'TSObjAdv' )
  rc = MySysDeregisterObjectClass( 'TSZooMgr' )
  rc = MySysDeregisterObjectClass( 'TSZipMgr' )
  rc = MySysDeregisterObjectClass( 'TSTarMgr' )
  rc = MySysDeregisterObjectClass( 'TSScriptLockup' )
  rc = MySysDeregisterObjectClass( 'TSRarMgr' )
  rc = MySysDeregisterObjectClass( 'TSTaskMgr' )
  rc = MySysDeregisterObjectClass( 'TSScript' )
  rc = MySysDeregisterObjectClass( 'TSKeyDefn' )
  rc = MySysDeregisterObjectClass( 'TSClassEdit' )
  rc = MySysDeregisterObjectClass( 'TSInspect' )
  rc = MySysDeregisterObjectClass( 'WPSecs01' )
  rc = MySysDeregisterObjectClass( 'TSLHAElem' )
  rc = MySysDeregisterObjectClass( 'TSLHAMgr' )
  rc = MySysDeregisterObjectClass( 'TSKeyLaunch' )
  rc = MySysDeregisterObjectClass( 'TSCPad' )
  rc = MySysDeregisterObjectClass( 'TSEnhDrives' )
  rc = MySysDeregisterObjectClass( 'TSTabFolder' )
  rc = MySysDeregisterObjectClass( 'TSPkgFolder' )
  rc = MySysDeregisterObjectClass( 'TSEnhFolder' )
  rc = MySysDeregisterObjectClass( 'TSScriptShutdown' )
  rc = MySysDeregisterObjectClass( 'TSFldrParent' )
  rc = MySysDeregisterObjectClass( 'TSPackageFile' )
  rc = MySysDeregisterObjectClass( 'TSEnhDataFile' )
  rc = MySysDeregisterObjectClass( 'WPSecure' )
  rc = MySysDeregisterObjectClass( 'TSPackageElem' )
  rc = MySysDeregisterObjectClass( 'TSArcElem' )
  rc = MySysDeregisterObjectClass( 'WPSecpgm' )
  rc = MySysDeregisterObjectClass( 'TSScriptFind' )
  rc = MySysDeregisterObjectClass( 'TSMasterSetup' )
  rc = MySysDeregisterObjectClass( 'TSArcMgr' )
  rc = MySysDeregisterObjectClass( 'TSArcFileElem' )
return 0

