/*
    Converts a Object Desktop generated REXX cmd file FileName into two temporary files for display in two MLE controls.
    TmpFile1 is the temp file for displaying the unmodified code.
    TmpFile2 is the temp file for displaying the modified code.
*/
    /* parse arg FileName" "TmpFile1" "TmpFile2 */
    parse arg string
    string = strip(string)
    if (substr(string,1,1)="'") then do
       parse var string "'"FileName"' "TmpFile1" "TmpFile2
    end
    else do
       parse var string FileName" "TmpFile1" "TmpFile2
    end
    iunit=stream(FileName,"Command","OPEN READ")
    if (iunit<>"READY:") then do
       say "Can't open "FileName
       return 1
    end
    tunit1=stream(TmpFile1,"Command","OPEN WRITE")
    if (tunit1<>"READY:") then do
       say "Can't open "TmpFile1
       iunit=stream(FileName,"Command","Close")
       return 1
    end
    tunit2=stream(TmpFile2,"Command","OPEN WRITE")
    if (tunit2<>"READY:") then do
       say "Can't open "TmpFile2
       iunit=stream(FileName,"Command","Close")
       tunit1=stream(TmpFile1,"Command","Close")
       return 1
    end
    do while lines(FileName)
       ibuf = linein(FileName)
       if (translate(ibuf)="CREATEOBJECTS:") then do
          call SW_ODRexx_Create_CreateObj
       end
       else if (translate(ibuf)="REGISTERCLASSES:") then do
          call SW_ODRexx_Create_RegClasses
       end
    end
    iunit=stream(FileName,"Command","Close")
    tunit1=stream(TmpFile1,"Command","Close")
    tunit2=stream(TmpFile2,"Command","Close")
return 0

SW_ODRexx_Create_CreateObj: procedure expose FileName ibuf TmpFile1 TmpFile2
    ok = SW_ODRexx_Create_WriteIBUF()
    fTime = 1
    lLookForFolderID = 0
    lLookForProgramID = 0
    do while lines( FileName )
        ibuf = linein( FileName )
        ok = SW_ODRexx_Create_WriteIBUF()
        jbuf = translate(ibuf)
        position  = Pos( "CREATEOBJECT", jbuf )
        if (position > 0) then do
           if (fTime) then do
              fTime = 0
              lLookForFolderID = Pos( "'WPFOLDER'", jbuf )>0
              lLookForProgramID = Pos( "'WPPROGRAM'", jbuf )>0
           end
           HasEXE = ""
           do while lines( FileName)
              ibuf = linein( FileName )
              jbuf = translate(ibuf)
              select
                 /* 'OBJECTID=<OE2_MAIN_FOLDER>',, */
                 when Pos( "OBJECTID=", jbuf ) > 0 then do
                    ok = SW_ODRexx_Create_WriteIBUF()
                    parse var ibuf pre"OBJECTID="objectID"',,"
                    if (lLookForFolderID = 1) then do
                       lLookForFolderID = 0
                       lLookForProgramID = 0
                       if (substr(objectID,1,1)="<" & substr(objectID,length(objectID),1)=">") then call VRSet "EF_MainFolder", "Value", objectID
                    end
                    else if (lLookForProgramID = 1) then do
                       lLookForFolderID = 0
                       lLookForProgramID = 0
                       if (substr(objectID,1,1)="<" & substr(objectID,length(objectID),1)=">") then call VRSet "EF_MainProgram", "Value", objectID
                    end
                 end
                 /* CreateCollision ) */
                 when Pos( "CREATECOLLISION", jbuf ) > 0 then do
                    ok = SW_ODRexx_Create_WriteIBUF()
                    leave
                 end
                 /* 'EXENAME=CMD.EXE;'||, */
                 when Pos( "EXENAME=CMD.EXE", jbuf ) > 0 then do
                    ok = SW_ODRexx_Create_WriteIBUF()
                 end
                 /* 'SET DOS_AUTOEXEC=z:\AUTO.BAT;'||, */
                 when Pos( "SET DOS_AUTOEXEC=", jbuf ) > 0 then do
                    call lineout tmpFile1, ibuf
                    parse var ibuf pre":\"rest
                    ibuf = substr(pre,1,length(pre)-1) || "'BootDrive'\" || rest
                    call lineout tmpFile2, ibuf
                 end /* do */
                 /* 'EXENAME=G:\SDSOE2\SDSBENCH\SDSBENCH.EXE;'||, */
                 when Pos( "EXENAME=", jbuf ) > 0 then do
                    call lineout tmpFile1, ibuf
                    parse var ibuf pre"="nam";"rest
                    parse var nam drive":\"mdir"\"mrest
                    if (translate(mdir)="OS2") then do
                       ibuf = pre || "='OS2Dir'\" || mrest || ";" || rest
                    end
                    else if (mdir="") then do    /* No directory name */
                    end
                    else do
                       ibuf = pre || "='RunFrom'\'p.DirName'" || "\" || mrest || ";" || rest
                       HasEXE = drive || ":\" || mdir
                    end
                    call lineout tmpFile2, ibuf
                 end
                 /* 'PARAMETERS=g:\OBJDESK\EXTRAS\BIN\COPYING;'||, */
                 /* 'PARAMETERS=/C G:\SDSOE2\EPFINSTS.EXE /C:G:\SDSOE2\OS2ESS.ICF /O:DRIVE;'||, */
                 when Pos( "PARAMETERS=", jbuf ) > 0 then do
                    call lineout tmpFile1, ibuf
                    ibuf = PatchFName(ibuf, HasEXE)
                    call lineout tmpFile2, ibuf
                 end
                 /* 'STARTUPDIR=G:\SDSOE2;'||, */
                 when Pos( "STARTUPDIR=", jbuf ) > 0 then do
                    call lineout tmpFile1, ibuf
                    if (HasEXE="") then do
                       parse var ibuf pre"="Drive":"HasEXE";"rest
                    end
                    else do
                       parse var ibuf pre"="HasEXE";"rest
                    end
                    ibuf = pre"='BootDrive||Apps'\'p.DirName';"rest
                    call lineout tmpFile2, ibuf
                 end
                 /* 'BACKGROUND=?:\OS2\BITMAP\WSERVER.BMP,S,1,I,204 204 204;'||, */
                 when Pos( "BACKGROUND=", jbuf ) > 0 then do
                    call lineout tmpFile1, ibuf
                    parse var ibuf item1'BACKGROUND='item2':\'item3'\'rest
                    if (item3<>"") then do
                       if (translate(item3)="OS2") then do
                          ibuf = item1"BACKGROUND='OS2Dir'\"rest
                       end /* do */
                       else ibuf = item1"BACKGROUND='OS2Dir'\"rest
                    end
                    call lineout tmpFile2, ibuf
                 end
                 /* 'HELPLIBRARY=Z:\VT\SPCH_RO\HELP\WWUS.HLP;'||, */
                 when Pos( "HELPLIBRARY=", jbuf ) > 0 then do
                    call lineout tmpFile1, ibuf
                    parse var ibuf item1'HELPLIBRARY='item2':\'item3'\'rest
                    if (item3<>"") then do
                       if (translate(item3)="OS2") then ibuf = item1"HELPLIBRARY='OS2Dir'\"rest
                       else ibuf = item1"HELPLIBRARY='OS2Dir'\"rest
                    end
                    call lineout tmpFile2, ibuf
                 end
                 /* 'ICONFILE=G:\SDSOS2EssentialsV2_0\Installation Utility1.ICO;'||, */
                 when Pos( "ICONFILE=", jbuf ) > 0 then do
                    call lineout tmpFile1, ibuf
                    parse var ibuf item1'ICONFILE='item2':\'item3'\'rest
                    if (item3<>"") then do
                       ibuf = item1"ICONFILE='WiseManager'\'p.DirName'\"rest
                    end
                    call lineout tmpFile2, ibuf
                 end
                 /* 'SHADOWID=Z:\OS2\BITMAP;'||, */
                 when Pos( "SHADOWID=", jbuf ) > 0 & Pos( "SHADOWID=<", jbuf ) = 0 then do
                    call lineout tmpFile1, ibuf
                    parse var ibuf item1'SHADOWID='item2':\'item3'\'rest
                    if (item3<>"") then do
                       if (translate(item3)="OS2") then ibuf = item1"SHADOWID='OS2Dir'\"rest
                       else ibuf = item1"SHADOWID='OS2Dir'\"rest
                    end
                    call lineout tmpFile2, ibuf
                 end
                 /* 'ICONFILE1=G:\SDSOS2EssentialsV2_0\Installation Utility1.ICO;'||, */
                 when Pos( "ICONFILE1=", jbuf ) > 0 then do
                    call lineout tmpFile1, ibuf
                    parse var ibuf item1'ICONFILE1='item2':\'item3'\'rest
                    if (item3<>"") then ibuf = item1"ICONFILE1='WiseManager'\'p.DirName'\"rest
                    call lineout tmpFile2, ibuf
                 end
                 /* 'ICONNFILE=1,Z:\MMOS2\INSTALL\MMPMFLD2.ICO;'||, */
                 when Pos( "ICONNFILE=", jbuf ) > 0 then do
                    call lineout tmpFile1, ibuf
                    parse var ibuf item1'ICONNFILE='item2':\'item3'\'rest
                    if (item3<>"") then ibuf = item1"ICONNFILE='WiseManager'\'p.DirName'\"rest
                    call lineout tmpFile2, ibuf
                 end
                 /* 'READDATAFROM=G:\SDSOS2EssentialsV2_0\OS!2 Essentials Additional Programs Guide1.DAT;'||, */
                 when Pos( "READDATAFROM=", jbuf ) > 0 then do
                    call lineout tmpFile1, ibuf
                    parse var ibuf item1'READDATAFROM='item2':\'item3'\'rest
                    if (item3<>"") then ibuf = item1"READDATAFROM='WiseManager'\'p.DirName'\"rest
                    call lineout tmpFile2, ibuf
                 end
                 otherwise do
                    ok = SW_ODRexx_Create_WriteIBUF()
                 end
              end
           end
        end
        else do
           if (translate(word(ibuf,1))="RETURN") then leave
        end
    end
    ibuf = ""
    ok = SW_ODRexx_Create_WriteIBUF()
return 0

SW_ODRexx_Create_RegClasses: procedure expose FileName ibuf tmpFile1 tmpFile2 
    ok = SW_ODRexx_Create_WriteIBUF()
    call lineout tmpFile2, "/*"
    do while lines( FileName )
        ibuf = linein( FileName )
        ok = SW_ODRexx_Create_WriteIBUF()
        jbuf = translate(ibuf)
        if (jbuf = "IF ANSWER <> '' THEN RETURN") then leave
    end
    call lineout tmpFile2, "*/"
    do while lines( FileName )
        ibuf = linein( FileName )
        call lineout tmpFile1, ibuf
        /* If SysRegisterObjectClass( 'WPJavaClass', 'WPINET' ) <> 1 Then */
        ipos = Pos("SysRegisterObjectClass(",ibuf)
        if (ipos>0) then do
           parse var ibuf item1'If SysRegisterObjectClass( 'ObjectName', 'DLLName' 'rest
           /* Skip the next 3 lines */
           do i = 1 to 3
              ibuf = linein( FileName )
              call lineout tmpFile1, ibuf
           end
           ibuf = item1'rc = MySysRegisterObjectClass( 'ObjectName', 'DLLName' )'
        end
        call lineout tmpFile2, ibuf
        if (translate(word(ibuf,1))="RETURN") then leave
    end
    ibuf = ""
    ok = SW_ODRexx_Create_WriteIBUF()
return 0

/* Scan a string for either EXEDIR name or OS/2 */
PatchFName: procedure
   parse arg ibuf, HasEXE
   /* If HasEXE is blank, that means I don't know what the exe directory is.   Just look for anything begin with a drive letter, a colon and so forth */
   if (HasEXE = "") then do
      do forever
         parse var ibuf pre":\"path"\"rest
         if (path="") then do
            return ibuf
         end
         ll = length(pre)
         if (ll>1) then do
            ibuf = substr(pre,1,ll-1) || "'RunFrom'\'p.DirName'\" || rest
         end
         else ibuf = "RunFrom'\'p.DirName'\" || rest
      end
   end
   else do
      jHasEXE = translate(HasEXE)
      jHasEXELength = length(jHasEXE)
      do forever
         jbuf = translate(ibuf)
         position = Pos(jHasEXE, jbuf)
         if (position = 0) then leave
         if (position=1) then do
            ibuf = "'RunFrom'\'p.DirName'" || substr(ibuf,position+jHasEXELength)
         end
         else do
            if (substr(ibuf,position-1,1)=":") then 
               ibuf = substr(ibuf,1,position-3) || "'RunFrom'\'p.DirName'" || substr(ibuf,position+jHasEXELength)
            else 
               ibuf = substr(ibuf,1,position-1) || "'RunFrom'\'p.DirName'" || substr(ibuf,position+jHasEXELength)
         end
      end
      do forever
         jbuf = translate(ibuf)
         position = Pos(":\OS2", jbuf)
         if (position = 0) then leave
         position = position - 1
         if (position=1) then do
            ibuf = "'OS2Dir'" || substr(ibuf,position+1+4)
         end
         else do
            ibuf = substr(ibuf,1,position-1) || "'OS2Dir'" || substr(ibuf,position+1+4)
         end
      end
   end
return ibuf

SW_ODRexx_Create_WriteIBUF:
    call lineout tmpFile1, ibuf
    call lineout tmpFile2, ibuf
return 0



