/* PassDown looks like F:\IBMLAN\RPL*RTLR8019_PCI*MNOTEBOOK*Z:*SERVER*FitFile*ClientSwapper*OSVersion */
   parse arg ibuf
   parse var ibuf "'"RplDir"*"MachineName"*"ServerName"*"BootDrive"*"SystemDrive"*"FitFile"*"ClientSwapper"*"OSVersion"'"
   signal on halt

   if (OSVersion="") then OSVersion = "OS2.40"
   else if (substr(OSVersion,1,1)="2") then OSVersion = "OS" || OSVersion

   ounit = stream( FitFile, "Command", "OPEN WRITE")
   if (ounit<>"READY:") then do
      say FitFile" didn't open"
      exit 1
   end

   SrvName = ServerName(ServerName)
   BootDrive = strip(BootDrive,"T",":")
   call lineout FitFile, SrvName"\RPLFILES"
   call lineout FitFile, " "
   call lineout FitFile, "; The first line of this file MUST be UNC name"
   call lineout FitFile, " "
   call lineout FitFile, "; Per-workstation read-only configuration files."
   call lineout FitFile, BootDrive":\CONFIG.SYS             "SrvName"\WRKFILES\"MachineName"\CONFIG.SYS"
   call lineout FitFile, BootDrive":\IBMLAN\IBMLAN.INI      MACHINES\"MachineName"\IBMLAN\IBMLAN.INI"
   call lineout FitFile, " "
   call lineout FitFile, "; These OS/2 files must be writeable."
/*
   call lineout FitFile, BootDrive":\OS2\NSCP.*              "NetScape
   call lineout FitFile, BootDrive":\OS2\NETSCAPE.*              "NetScape
*/
   call lineout FitFile, BootDrive":\OS2\*.INI              "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\*.!!!              "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\*.###              "SrvName"\WRKFILES\"MachineName"\OS2"
/*
   call lineout FitFile, BootDrive":\OS2\INSTALL\REINSTAL.* "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\INSTALL\WPINSTAL.* "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\INSTALL\*.LOG      "SrvName"\WRKFILES\"MachineName"\OS2"
*/
   call lineout FitFile, BootDrive":\OS2\SVGADATA.*         "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\SVGATMP.BAT        "SrvName"\WRKFILES\"MachineName"\OS2\SVGATMP.BAT"
   if (ClientSwapper="") then 
      call lineout FitFile, BootDrive":\OS2\SYSTEM\SWAPPER.DAT "SrvName"\WRKFILES\"MachineName"\OS2\SYSTEM\SWAPPER.DAT"
   else do
      call lineout FitFile, BootDrive":\OS2\SYSTEM\SWAPPER.DAT "SrvName"\WISESWAP\"MachineName".DAT"
   end
   call lineout FitFile, BootDrive":\SPOOL                  "SrvName"\WRKFILES\"MachineName"\SPOOL"
   call lineout FitFile, BootDrive":\OS2\WP*.ICO            "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\APPS\*.INI         "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\APPS\*.!!!         "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\APPS\*.###         "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\APPS\*.TMP         "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\ARCHIVES           "SrvName"\WRKFILES\"MachineName"\OS2\ARCHIVES"
   call lineout FitFile, BootDrive":\OS2\BOOT\ARCHBASE.*    "SrvName"\WRKFILES\"MachineName"\OS2"
   call lineout FitFile, BootDrive":\OS2\DLL\*.CFG          "SrvName"\WRKFILES\"MachineName"\OS2\DLL"
   call lineout FitFile, BootDrive":\OS2\DLL\*.CFI          "SrvName"\WRKFILES\"MachineName"\OS2\DLL"
   call lineout FitFile, BootDrive":\OS2\POINTERS           "SrvName"\WRKFILES\"MachineName"\OS2\POINTERS"
   call lineout FitFile, BootDrive":\AUTOEXEC.BAT           "SrvName"\WRKFILES\"MachineName"\AUTOEXEC.BAT"
   call lineout FitFile, " "
   if (translate(SystemDrive)="SERVER") then do
      call lineout FitFile, "; Shared OS2 and network files are read-only."
      call lineout FitFile, BootDrive":\OS2                   "OSVersion"\OS2"
      call lineout FitFile, BootDrive":\OS2\DLL\IBMNULL.DRV   "OSVersion"\OS2\DLL\IBMNULL\IBMNULL.DRV"
      call lineout FitFile, BootDrive":\XGA$DMQS              "OSVersion"\XGA$DMQS"
      call lineout FitFile, BootDrive":\PSFONTS               "OSVersion"\PSFONTS"
      call lineout FitFile, BootDrive":\IBMVESA               "OSVersion"\IBMVESA"
      call lineout FitFile, BootDrive":\LANGUAGE              "OSVersion"\LANGUAGE"
      call lineout FitFile, BootDrive":\OS2INST               OS2INST"
      call lineout FitFile, " "
      call lineout FitFile, "; Font support"
      call lineout FitFile, BootDrive":\OS2\DLL\HELV.FON      "OSVersion"\OS2\DLL\HELV.BGA"
      call lineout FitFile, BootDrive":\OS2\DLL\COURIER.FON   "OSVersion"\OS2\DLL\COURIER.BGA"
      call lineout FitFile, BootDrive":\OS2\DLL\TIMES.FON     "OSVersion"\OS2\DLL\TIMES.BGA"
      call lineout FitFile, " "
      call lineout FitFile, "; XGA-2 ISO font support"
      call lineout FitFile, BootDrive":\OS2\DLL\HELVI.FON     "OSVersion"\OS2\DLL\HELVI.XGA"
      call lineout FitFile, BootDrive":\OS2\DLL\COURIERI.FON  "OSVersion"\OS2\DLL\COURIERI.XGA"
      call lineout FitFile, BootDrive":\OS2\DLL\TIMESI.FON    "OSVersion"\OS2\DLL\TIMESI.XGA"
      call lineout FitFile, " "
      call lineout FitFile, "; DMA support"
      call lineout FitFile, BootDrive":\OS2\MDOS\VDMA.SYS     "OSVersion"\OS2\MDOS\VDMAAT.SYS"
      call lineout FitFile, " "
      call lineout FitFile, "; IBMLAN, MPTS, and MUGLIB references"
      call lineout FitFile, BootDrive":\IBMLAN                IBMLAN"
      call lineout FitFile, BootDrive":\MPTN                  MPTN"
      call lineout FitFile, BootDrive":\IBMCOM                IBMCOM"
      call lineout FitFile, BootDrive":\PRO.MSG               IBMCOM\PRO.MSG"
      call lineout FitFile, BootDrive":\MUGLIB                MUGLIB"
      call lineout FitFile, BootDrive":\IBMI18N               IBMI18N"
      call lineout FitFile, BootDrive":\IBMXPGL               IBMXPGL"
   end
   else do
      call lineout FitFile, "; Shared OS2 and network files are read-only."
      call lineout FitFile, BootDrive":\OS2                   "SystemDrive"\OS2"
      call lineout FitFile, BootDrive":\OS2\DLL\IBMNULL.DRV   "SystemDrive"\OS2\DLL\IBMNULL\IBMNULL.DRV"
      call lineout FitFile, BootDrive":\XGA$DMQS              "SystemDrive"\XGA$DMQS"
      call lineout FitFile, BootDrive":\PSFONTS               "SystemDrive"\PSFONTS"
      call lineout FitFile, BootDrive":\IBMVESA               "SystemDrive"\IBMVESA"
      call lineout FitFile, BootDrive":\LANGUAGE              "SystemDrive"\LANGUAGE"
      call lineout FitFile, BootDrive":\OS2INST               OS2INST"
      call lineout FitFile, " "
      call lineout FitFile, "; Font support"
      call lineout FitFile, BootDrive":\OS2\DLL\HELV.FON      "SystemDrive"\OS2\DLL\HELV.BGA"
      call lineout FitFile, BootDrive":\OS2\DLL\COURIER.FON   "SystemDrive"\OS2\DLL\COURIER.BGA"
      call lineout FitFile, BootDrive":\OS2\DLL\TIMES.FON     "SystemDrive"\OS2\DLL\TIMES.BGA"
      call lineout FitFile, " "
      call lineout FitFile, "; XGA-2 ISO font support"
      call lineout FitFile, BootDrive":\OS2\DLL\HELVI.FON     "SystemDrive"\OS2\DLL\HELVI.XGA"
      call lineout FitFile, BootDrive":\OS2\DLL\COURIERI.FON  "SystemDrive"\OS2\DLL\COURIERI.XGA"
      call lineout FitFile, BootDrive":\OS2\DLL\TIMESI.FON    "SystemDrive"\OS2\DLL\TIMESI.XGA"
      call lineout FitFile, " "
      call lineout FitFile, "; IBMLAN, MPTS, and MUGLIB references"
      call lineout FitFile, BootDrive":\IBMLAN                IBMLAN"
      call lineout FitFile, BootDrive":\MPTN                  MPTN"
      call lineout FitFile, BootDrive":\IBMCOM                IBMCOM"
      call lineout FitFile, BootDrive":\PRO.MSG               IBMCOM\PRO.MSG"
      call lineout FitFile, BootDrive":\MUGLIB                MUGLIB"
      call lineout FitFile, BootDrive":\IBMI18N               IBMI18N"
      call lineout FitFile, BootDrive":\IBMXPGL               IBMXPGL"
   end
   call lineout FitFile, " "
   call lineout FitFile, "; Shared OS2 and network files are read-only loaded from server."
   call lineout FitFile, BootDrive":\OS2KRNL               "OSVersion"\OS2KRNL"
/*
   if (translate(OSVersion)="OS2.45") then 
      call lineout FitFile, BootDrive":\OS2LOGO               "SrvName"\WiseProg\System\Aurora-OS2LOGO.lgo"
   else
      call lineout FitFile, BootDrive":\OS2LOGO               "SrvName"\WiseProg\System\ManagedClient.lgo"
*/
      call lineout FitFile, BootDrive":\OS2LOGO               "SrvName"\WiseProg\System\MCVGA.lgo"
   call lineout FitFile, BootDrive":\OS2VER                "OSVersion"\OS2VER"
   call lineout FitFile, BootDrive":\*.BIO                 "OSVersion"\OS2"
   call lineout FitFile, BootDrive":\OS2LDR.MSG            "OSVersion"\OS2LDR.MSG"
   call lineout FitFile, BootDrive":\OSO001.MSG            "OSVersion"\OS2\SYSTEM\OSO001.MSG"
   call lineout FitFile, BootDrive":\IBMCOM\PROTOCOL.INI   "SrvName"\WRKFILES\"MachineName"\IBMCOM\PROTOCOL.INI"
   call lineout FitFile, " "

   call lineout FitFile, "; Per-workstation writeable network files."
   call lineout FitFile, BootDrive":\IBMCOM\LANTRAN.LOG   "SrvName"\WRKFILES\"MachineName"\IBMCOM\LANTRAN.LOG"
   call lineout FitFile, BootDrive":\IBMLAN\LOGS          "SrvName"\WRKFILES\"MachineName"\IBMLAN\LOGS"
   call lineout FitFile, BootDrive":\IBMLAN\ACCOUNTS      "SrvName"\WRKFILES\"MachineName"\IBMLAN\ACCOUNTS"
   call lineout FitFile, BootDrive":\IBMLAN\NWDDE         "SrvName"\WRKFILES\"MachineName"\IBMLAN\NWDDE"
   call lineout FitFile, BootDrive":\IBMLAN\NETPROG\*.INI "SrvName"\WRKFILES\"MachineName"\IBMLAN\NETPROG"
   call lineout FitFile, BootDrive":\IBMLAN\NETPROG\*.!!! "SrvName"\WRKFILES\"MachineName"\IBMLAN\NETPROG"
   call lineout FitFile, BootDrive":\IBMLAN\NETPROG\NETGUI.PDB   "SrvName"\WRKFILES\"MachineName"\IBMLAN\NETPROG\NETGUI.PDB"
   call lineout FitFile, BootDrive":\IBMLAN\NETPROG\UIFWTRC.CFG  "SrvName"\WRKFILES\"MachineName"\IBMLAN\NETPROG\UIFWTRC.CFG"
   call lineout FitFile, " "
   call lineout FitFile, "; Touch Display support (delete next line for Touch Display support)"
   call lineout FitFile, BootDrive":\OS2\DLL\TOUCALLS.DLL  "SrvName"\WRKFILES\"MachineName"\OS2\TOUCALLS.DLL"
   call lineout FitFile, " "
   call lineout FitFile, "; Other references go to the per-workstation root."
   call lineout FitFile, BootDrive":\                    "SrvName"\WRKFILES\"MachineName
   call lineout FitFile, " "

   ounit = stream(FitFile, "Command", "CLOSE")
   if (ounit<>"READY:") then do
      say FitFile" didn't close"
      exit 2
   end

exit 0

ServerName: procedure
   parse arg name
   if (length(name)>2) then do
      if (substr(name,1,2)<>"\\") then name = "\\" || name
   end
return name
