/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public final class receiv
implements Runnable {
    private final String copyright = "Licensed Materials - Property of IBM   26L4430 (C) Copyright IBM Corp. 1997, 1998   All rights reserved.   US Government Users Restricted Rights Use, duplication or disclosure   restricted by GSA ADP Schedule Contract with IBM Corp.";
    private InputStream is;
    private Thread runner;
    private byte[] buffer = new byte[262144];
    private int head;
    private int tail;
    private boolean fWaitFill;
    private boolean fWaitRoom;
    private byte[] tmpbuf = new byte[4096];
    private int count;
    private int pos;
    private boolean fValid = false;

    public void initialize(InputStream inputStream) {
        if (this.runner == null) {
            this.is = inputStream;
            this.count = 0;
            this.pos = 0;
            this.tail = 0;
            this.head = 0;
            this.fWaitFill = false;
            this.fWaitRoom = false;
            this.fValid = true;
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    public void terminate() {
        if (this.runner != null) {
            if (this.runner.isAlive()) {
                this.runner.stop();
            }
            this.runner = null;
            try {
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (IOException iOException) {}
            this.is = null;
            this.fValid = false;
        }
    }

    public void run() {
        try {
            while (this.fValid) {
                int n;
                byte[] byArray = this.buffer;
                synchronized (byArray) {
                    while ((this.tail + 1) % this.buffer.length == this.head) {
                        this.fWaitRoom = true;
                        this.buffer.wait();
                    }
                    n = this.head;
                }
                int n2 = n <= this.tail ? (n == 0 ? this.buffer.length - this.tail - 1 : this.buffer.length - this.tail) : n - this.tail - 1;
                int n3 = this.is.read(this.buffer, this.tail, n2);
                if (n3 != -1) {
                    byArray = this.buffer;
                    synchronized (byArray) {
                        this.tail = (this.tail + n3) % this.buffer.length;
                        if (this.fWaitFill) {
                            this.fWaitFill = false;
                            this.buffer.notify();
                        }
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {}
        this.fValid = false;
    }

    private void fill() {
        byte[] byArray = this.buffer;
        synchronized (byArray) {
            try {
                while (this.head == this.tail) {
                    this.fWaitFill = true;
                    this.buffer.wait();
                }
                int n = this.head < this.tail ? (this.tail - this.head > this.tmpbuf.length ? this.tmpbuf.length : this.tail - this.head) : (this.buffer.length - this.head > this.tmpbuf.length ? this.tmpbuf.length : this.buffer.length - this.head);
                System.arraycopy(this.buffer, this.head, this.tmpbuf, 0, n);
                this.head = (this.head + n) % this.buffer.length;
                this.count = n;
                this.pos = 0;
                if (this.fWaitRoom) {
                    this.fWaitRoom = false;
                    this.buffer.notify();
                }
            }
            catch (InterruptedException interruptedException) {
                this.fValid = false;
            }
            return;
        }
    }

    public void getShorts(short[] sArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = (short)(this.getByte() & 0xFF);
            ++n2;
        }
    }

    public void getBytes(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.getByte();
            ++n2;
        }
    }

    public byte getByte() {
        if (this.count == 0) {
            this.fill();
        }
        byte by = this.tmpbuf[this.pos];
        ++this.pos;
        --this.count;
        return by;
    }

    public boolean isValid() {
        return this.fValid;
    }

    public boolean isAvailable() {
        return this.count != 0 || this.head != this.tail;
    }
}

