/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;

public final class interp10
implements Runnable,
ImageObserver {
    private final String copyright = "Licensed Materials - Property of IBM   26L4430 (C) Copyright IBM Corp. 1997, 1998   All rights reserved.   US Government Users Restricted Rights Use, duplication or disclosure   restricted by GSA ADP Schedule Contract with IBM Corp.";
    public Thread runner;
    master10 painter;
    decode unpack;
    receiv input;
    sender output;
    Component component;
    Graphics screen;
    int screenWidth;
    int screenHeight;
    Rectangle drawRect;
    int colorDepth;
    int cacheCount;
    final int flushCount = 256;
    final int maxImageSize = 16384;
    int[] screenArray = new int[16640];
    int drawImageSize;
    final byte[] redPaletteNS;
    final byte[] greenPaletteNS;
    final byte[] bluePaletteNS;
    int[] vgaColorRGBNS;
    int[] vgaColorGrayNS;
    final byte[] redPaletteIE;
    final byte[] greenPaletteIE;
    final byte[] bluePaletteIE;
    int[] vgaColorRGBIE;
    int[] vgaColorGrayIE;
    final byte[] redPaletteOther;
    final byte[] greenPaletteOther;
    final byte[] bluePaletteOther;
    int[] vgaColorRGBOther;
    int[] vgaColorGrayOther;
    int[] vgaToGray;
    byte[] redPalette;
    byte[] greenPalette;
    byte[] bluePalette;
    Color[] grayColor;
    Color[] vgaColor;
    Color[] svgaColor;
    int[] vgaColorRGB;
    int[] vgaColorGray;
    int[] svgaColorRGB;
    byte[] patternBuffer;
    short[] param;
    short[] pSizePos;
    boolean fTerminate;
    public boolean fAvailable;
    public Boolean fDrawn;
    public int left;
    public int right;
    public int top;
    public int bottom;
    int currentLeft;
    int currentRight;
    int currentTop;
    int currentBottom;
    Rectangle mouseRect;
    boolean fMouseSave;
    boolean fMouseHide;
    int[] mouseShapeBaseX;
    int[] mouseShapeBaseY;
    int[] mouseShapeX;
    int[] mouseShapeY;

    public void initialize(receiv receiv2, sender sender2, decode decode2, master10 master102, int n, int n2) {
        this.runner = null;
        this.input = receiv2;
        this.output = sender2;
        this.unpack = decode2;
        this.painter = master102;
        this.component = master102;
        this.screen = this.painter.bufferedScreen;
        this.screenWidth = n;
        this.screenHeight = n2;
        this.fTerminate = false;
        this.fAvailable = false;
        this.drawImageSize = 16384;
        this.drawRect = new Rectangle();
        this.colorDepth = 1;
        this.mouseRect = new Rectangle(0, 0, 11, 17);
        int n3 = 0;
        int n4 = 0;
        while (n4 <= 255) {
            int n5 = 0;
            while (n5 <= 255) {
                int n6 = 0;
                while (n6 <= 255) {
                    this.svgaColorRGB[n3] = 0xFF000000 | n4 << 16 | n5 << 8 | n6;
                    this.svgaColor[n3++] = new Color(n4, n5, n6);
                    n6 += 51;
                }
                n5 += 51;
            }
            n4 += 51;
        }
        while (n3 < 256) {
            this.svgaColorRGB[n3] = -16777216;
            this.svgaColor[n3++] = new Color(0, 0, 0);
        }
        switch (this.painter.nBrowser) {
            case 0: {
                n3 = 0;
                while (n3 < 16) {
                    this.redPalette[n3] = this.redPaletteNS[n3];
                    this.greenPalette[n3] = this.greenPaletteNS[n3];
                    this.bluePalette[n3] = this.bluePaletteNS[n3];
                    this.vgaColorRGB[n3] = this.vgaColorRGBNS[n3];
                    ++n3;
                }
                n3 = 0;
                while (n3 < 4) {
                    this.vgaColorGray[n3] = this.vgaColorGrayNS[n3];
                    ++n3;
                }
                break;
            }
            case 1: {
                n3 = 0;
                while (n3 < 16) {
                    this.redPalette[n3] = this.redPaletteIE[n3];
                    this.greenPalette[n3] = this.greenPaletteIE[n3];
                    this.bluePalette[n3] = this.bluePaletteIE[n3];
                    this.vgaColorRGB[n3] = this.vgaColorRGBIE[n3];
                    ++n3;
                }
                n3 = 0;
                while (n3 < 4) {
                    this.vgaColorGray[n3] = this.vgaColorGrayIE[n3];
                    ++n3;
                }
                break;
            }
            default: {
                n3 = 0;
                while (n3 < 16) {
                    this.redPalette[n3] = this.redPaletteOther[n3];
                    this.greenPalette[n3] = this.greenPaletteOther[n3];
                    this.bluePalette[n3] = this.bluePaletteOther[n3];
                    this.vgaColorRGB[n3] = this.vgaColorRGBOther[n3];
                    ++n3;
                }
                n3 = 0;
                while (n3 < 4) {
                    this.vgaColorGray[n3] = this.vgaColorGrayOther[n3];
                    ++n3;
                }
                break block0;
            }
        }
        n3 = 0;
        while (n3 < 16) {
            this.vgaColor[n3] = new Color(this.redPalette[n3] & 0xFF, this.greenPalette[n3] & 0xFF, this.bluePalette[n3] & 0xFF);
            ++n3;
        }
        n3 = 0;
        while (n3 < 4) {
            this.grayColor[n3] = this.vgaColor[this.vgaToGray[n3]];
            ++n3;
        }
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    public void terminate() {
        if (this.runner != null) {
            this.runner.stop();
            this.runner = null;
        }
    }

    public void run() {
        while (!this.input.isAvailable()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.screenWidth == 0 && this.screenHeight == 0) {
            this.painter.stop();
            return;
        }
        this.top = 0;
        this.left = 0;
        this.right = this.screenWidth - 1;
        this.bottom = this.screenHeight - 1;
        this.screen.setColor(new Color(0, 0, 0));
        this.screen.fillRect(0, 0, this.screenWidth, this.screenHeight);
        this.fMouseSave = false;
        this.fMouseHide = false;
        while (!this.fTerminate) {
            this.bottom = 0;
            this.right = 0;
            this.left = this.screenWidth;
            this.top = this.screenHeight;
            while (!this.input.isAvailable()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.cacheCount = 256;
            while (this.cacheCount > 0 && this.input.isAvailable()) {
                this.update();
                if (!this.combineArea()) break;
                --this.cacheCount;
            }
            Boolean bl = this.fDrawn;
            synchronized (bl) {
                this.fAvailable = true;
                this.painter.repaint();
                try {
                    this.fDrawn.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.currentLeft == this.screenWidth) continue;
            this.left = this.currentLeft;
            this.right = this.currentRight;
            this.top = this.currentTop;
            this.bottom = this.currentBottom;
            bl = this.fDrawn;
            synchronized (bl) {
                this.fAvailable = true;
                this.painter.repaint();
                try {
                    this.fDrawn.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void update() {
        if (!this.fTerminate) {
            byte by = this.input.getByte();
            int n = by >> 4 & 3;
            int n2 = by >> 6 & 3;
            switch (by & 0xF) {
                case 1: {
                    switch (by >> 4 & 3) {
                        case 0: {
                            this.painter.disconnect(true);
                            return;
                        }
                        case 1: {
                            this.painter.reload();
                            return;
                        }
                        case 2: {
                            this.colorDepth = by >> 6 & 3;
                            return;
                        }
                        case 3: {
                            switch (by >> 6 & 3) {
                                case 0: {
                                    this.getPosition(2);
                                    return;
                                }
                                case 1: {
                                    this.cmdSetMousePos();
                                    return;
                                }
                                case 2: {
                                    this.cmdSetMouseShape();
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 2: {
                    this.cmdPlotPixel(n);
                    return;
                }
                case 3: {
                    this.cmdFillRect(n, n2);
                    return;
                }
                case 4: {
                    this.cmdDrawMono(n, n2);
                    return;
                }
                case 5: {
                    this.cmdDrawCompMono(n, n2);
                    return;
                }
                case 6: {
                    this.cmdDrawImage(n, n2);
                    return;
                }
                case 7: {
                    this.cmdDrawCompImage(n, n2);
                    return;
                }
            }
            this.output.debugOut((byte)15);
            this.output.debugOut((byte)(by & 0xF));
            this.output.debugOut((byte)(by >> 4));
            this.painter.disconnect(true);
            return;
        }
    }

    void getPosition(int n) {
        this.input.getShorts(this.pSizePos, n + 1);
        switch (n) {
            case 0: {
                int n2 = this.pSizePos[0] & 0xF;
                int n3 = this.pSizePos[0] >> 4 & 0xF;
                this.drawRect.x = n2 < 8 ? (this.drawRect.x += n2) : (this.drawRect.x -= 16 - n2);
                if (n3 < 8) {
                    this.drawRect.y += n3;
                    return;
                }
                this.drawRect.y -= 16 - n3;
                return;
            }
            case 1: {
                short s = this.pSizePos[0];
                short s2 = this.pSizePos[1];
                this.drawRect.x = s < 128 ? (this.drawRect.x += s) : (this.drawRect.x -= 256 - s);
                if (s2 < 128) {
                    this.drawRect.y += s2;
                    return;
                }
                this.drawRect.y -= 256 - s2;
                return;
            }
            case 2: {
                this.drawRect.x = this.pSizePos[0] + ((this.pSizePos[2] & 0xF) << 8);
                this.drawRect.y = this.pSizePos[1] + ((this.pSizePos[2] & 0xF0) << 4);
                return;
            }
        }
    }

    void getSize(int n) {
        this.input.getShorts(this.pSizePos, n + 1);
        switch (n) {
            case 0: {
                this.drawRect.width = (this.pSizePos[0] & 0xF) + 1;
                this.drawRect.height = (this.pSizePos[0] >> 4 & 0xF) + 1;
                return;
            }
            case 1: {
                this.drawRect.width = this.pSizePos[0] + 1;
                this.drawRect.height = this.pSizePos[1] + 1;
                return;
            }
            case 2: {
                this.drawRect.width = this.pSizePos[0] + ((this.pSizePos[2] & 0xF) << 8) + 1;
                this.drawRect.height = this.pSizePos[1] + ((this.pSizePos[2] & 0xF0) << 4) + 1;
                return;
            }
        }
    }

    void cmdSetMousePos() {
        this.input.getShorts(this.pSizePos, 3);
        int n = this.pSizePos[0] + ((this.pSizePos[2] & 0xF) << 8) + 1;
        int n2 = this.pSizePos[1] + ((this.pSizePos[2] & 0xF0) << 4) + 1;
        this.restoreMouse();
        this.mouseRect.x = n;
        this.mouseRect.y = n2;
        this.saveAndDrawMouse();
    }

    void saveAndDrawMouse() {
        this.painter.mouseSaveScreen.drawImage(this.painter.bufferedImage, -this.mouseRect.x, -this.mouseRect.y, this);
        this.fMouseSave = true;
        int n = this.mouseShapeBaseX.length - 1;
        while (n >= 0) {
            this.mouseShapeX[n] = this.mouseShapeBaseX[n] + this.mouseRect.x;
            this.mouseShapeY[n] = this.mouseShapeBaseY[n] + this.mouseRect.y;
            --n;
        }
        this.screen.setColor(new Color(255, 255, 255));
        this.screen.fillPolygon(this.mouseShapeX, this.mouseShapeY, this.mouseShapeX.length);
        this.screen.setColor(new Color(0, 0, 0));
        this.screen.drawPolygon(this.mouseShapeX, this.mouseShapeY, this.mouseShapeX.length);
        this.repaintMouseArea();
    }

    void restoreMouse() {
        if (this.fMouseSave) {
            if (!this.fMouseHide) {
                this.screen.drawImage(this.painter.mouseSaveImage, this.mouseRect.x, this.mouseRect.y, this);
                this.repaintMouseArea();
                this.fMouseSave = false;
                return;
            }
            this.fMouseHide = false;
        }
    }

    void repaintMouseArea() {
        if (this.left != this.screenWidth) {
            this.fAvailable = true;
            this.painter.repaint();
            while (this.fAvailable) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.left = this.mouseRect.x;
        this.top = this.mouseRect.y;
        this.right = this.mouseRect.x + this.mouseRect.width - 1;
        this.bottom = this.mouseRect.y + this.mouseRect.height - 1;
        this.fAvailable = true;
        this.painter.repaint();
        while (this.fAvailable) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.bottom = 0;
        this.right = 0;
        this.left = this.screenWidth;
        this.top = this.screenHeight;
    }

    void hideMouse() {
        if (this.fMouseSave && !this.fMouseHide && this.mouseRect.intersects(this.drawRect)) {
            this.restoreMouse();
            this.fMouseHide = true;
        }
    }

    void showMouse() {
        if (this.fMouseHide) {
            this.saveAndDrawMouse();
            this.fMouseHide = false;
        }
    }

    void cmdSetMouseShape() {
        byte by = this.input.getByte();
    }

    void cmdPlotPixel(int n) {
        this.getPosition(n);
        this.input.getShorts(this.param, 1);
        this.drawRect.height = 1;
        this.drawRect.width = 1;
        this.hideMouse();
        switch (this.colorDepth) {
            case 0: {
                this.plotPixelGray(this.drawRect.x, this.drawRect.y, this.param[0] & 3);
                break;
            }
            case 1: {
                this.plotPixelColor16(this.drawRect.x, this.drawRect.y, this.param[0] & 0xF);
                break;
            }
            case 2: {
                this.plotPixelColor256(this.drawRect.x, this.drawRect.y, this.param[0]);
                break;
            }
        }
        this.showMouse();
    }

    void cmdFillRect(int n, int n2) {
        this.getPosition(n);
        this.getSize(n2);
        this.hideMouse();
        this.input.getShorts(this.param, 1);
        switch (this.colorDepth) {
            case 0: {
                this.fillRectGray(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height, this.param[0] & 3);
                break;
            }
            case 1: {
                this.fillRectColor16(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height, this.param[0] & 0xF);
                break;
            }
            case 2: {
                this.fillRectColor256(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height, this.param[0]);
                break;
            }
        }
        this.showMouse();
    }

    void cmdDrawMono(int n, int n2) {
        this.getPosition(n);
        this.getSize(n2);
        this.hideMouse();
        this.input.getShorts(this.param, this.colorDepth < 2 ? 1 : 2);
        switch (this.colorDepth) {
            case 0: {
                this.drawMonoGray(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height, this.param[0] & 3, this.param[0] >> 4 & 3);
                break;
            }
            case 1: {
                this.drawMonoColor16(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height, this.param[0] & 0xF, this.param[0] >> 4 & 0xF);
                break;
            }
            case 2: {
                this.drawMonoColor256(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height, this.param[0], this.param[1]);
                break;
            }
        }
        this.showMouse();
    }

    void cmdDrawCompMono(int n, int n2) {
        this.getPosition(n);
        this.getSize(n2);
        this.hideMouse();
        this.input.getShorts(this.param, this.colorDepth < 2 ? 1 : 2);
        switch (this.colorDepth) {
            case 0: {
                this.drawCompMonoGray(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height, this.param[0] & 3, this.param[0] >> 4 & 3);
                break;
            }
            case 1: {
                this.drawCompMonoColor16(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height, this.param[0] & 0xF, this.param[0] >> 4 & 0xF);
                break;
            }
            case 2: {
                this.drawCompMonoColor256(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height, this.param[0], this.param[1]);
                break;
            }
        }
        this.showMouse();
    }

    void cmdDrawImage(int n, int n2) {
        this.getPosition(n);
        this.getSize(n2);
        this.hideMouse();
        switch (this.colorDepth) {
            case 0: {
                this.drawImageGray(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height);
                break;
            }
            case 1: {
                this.drawImageColor16(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height);
                break;
            }
            case 2: {
                this.drawImageColor256(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height);
                break;
            }
        }
        this.showMouse();
    }

    void cmdDrawCompImage(int n, int n2) {
        this.getPosition(n);
        this.getSize(n2);
        this.hideMouse();
        switch (this.colorDepth) {
            case 0: {
                this.drawCompImageGray(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height);
                break;
            }
            case 1: {
                this.drawCompImageColor16(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height);
                break;
            }
            case 2: {
                this.drawCompImageColor256(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height);
                break;
            }
        }
        this.showMouse();
    }

    void invertLine(int n, int n2, int n3, int n4, int n5) {
        this.screen.setXORMode(this.vgaColor[0]);
        this.screen.setColor(this.vgaColor[n5 & 0xF]);
        this.screen.drawLine(n, n2, n3, n4);
        this.screen.setPaintMode();
    }

    void plotPixelGray(int n, int n2, int n3) {
    }

    void plotPixelColor16(int n, int n2, int n3) {
        this.screen.setColor(this.vgaColor[n3 & 0xF]);
        this.screen.drawLine(n, n2, n, n2);
        this.updateArea(n, n2, 1, 1);
    }

    void plotPixelColor256(int n, int n2, int n3) {
        this.screen.setColor(this.svgaColor[n3 & 0xFF]);
        this.screen.drawLine(n, n2, n, n2);
        this.updateArea(n, n2, 1, 1);
    }

    void fillRectGray(int n, int n2, int n3, int n4, int n5) {
        this.screen.setColor(this.grayColor[n5 & 3]);
        this.screen.fillRect(n, n2, n3, n4);
        this.updateArea(n, n2, n3, n4);
    }

    void fillRectColor16(int n, int n2, int n3, int n4, int n5) {
        this.screen.setColor(this.vgaColor[n5 & 0xF]);
        this.screen.fillRect(n, n2, n3, n4);
        this.updateArea(n, n2, n3, n4);
    }

    void fillRectColor256(int n, int n2, int n3, int n4, int n5) {
        this.screen.setColor(this.svgaColor[n5 & 0xFF]);
        this.screen.fillRect(n, n2, n3, n4);
        this.updateArea(n, n2, n3, n4);
    }

    void drawMonoGray(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    void drawMonoColor16(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRectColor16(n, n2, n3, n4, n6);
        this.plotMonoForeground(n, n2, n3, n4, n5, this.vgaColor);
    }

    void drawMonoColor256(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRectColor256(n, n2, n3, n4, n6);
        this.plotMonoForeground(n, n2, n3, n4, n5, this.svgaColor);
    }

    void drawCompMonoGray(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    void drawCompMonoColor16(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRectColor16(n, n2, n3, n4, n6);
        this.plotCompMonoForeground(n, n2, n3, n4, n5, this.vgaColor);
    }

    void drawCompMonoColor256(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    void drawImageGray(int n, int n2, int n3, int n4) {
    }

    void drawImageColor16(int n, int n2, int n3, int n4) {
        byte by = 0;
        if (n3 * n4 <= 16384) {
            int n5 = 0;
            boolean bl = false;
            int n6 = n4;
            while (n6 != 0) {
                bl = false;
                int n7 = n3;
                while (n7 != 0) {
                    if (bl) {
                        this.screenArray[n5++] = this.vgaColorRGB[by >> 4 & 0xF];
                        bl = false;
                    } else {
                        by = this.input.getByte();
                        this.screenArray[n5++] = this.vgaColorRGB[by & 0xF];
                        bl = true;
                    }
                    --n7;
                }
                --n6;
            }
            Image image = this.component.createImage(new MemoryImageSource(n3, n4, this.screenArray, 0, n3));
            this.screen.drawImage(image, n, n2, this);
            this.updateArea(n, n2, n3, n4);
        }
    }

    void drawImageColor256(int n, int n2, int n3, int n4) {
        if (n3 * n4 <= 16384) {
            int n5 = 0;
            int n6 = n4;
            while (n6 != 0) {
                int n7 = n3;
                while (n7 != 0) {
                    this.screenArray[n5++] = this.svgaColorRGB[this.input.getByte() & 0xFF];
                    --n7;
                }
                --n6;
            }
            Image image = this.component.createImage(new MemoryImageSource(n3, n4, this.screenArray, 0, n3));
            this.screen.drawImage(image, n, n2, this);
            this.updateArea(n, n2, n3, n4);
            this.cacheCount = 1;
        }
    }

    void drawCompImageGray(int n, int n2, int n3, int n4) {
        if (n3 * n4 <= 16384) {
            this.unpack.resetDecoder();
            int n5 = 0;
            int n6 = n4;
            while (n6 != 0) {
                int n7 = n3;
                while (n7 != 0) {
                    int n8 = this.unpack.decodePair();
                    if (n8 < 0) {
                        return;
                    }
                    this.screenArray[n5++] = this.vgaColorGray[n8];
                    --n7;
                }
                --n6;
            }
            Image image = this.component.createImage(new MemoryImageSource(n3, n4, this.screenArray, 0, n3));
            this.screen.drawImage(image, n, n2, this);
            this.updateArea(n, n2, n3, n4);
        }
    }

    void drawCompImageColor16(int n, int n2, int n3, int n4) {
        if (n3 * n4 <= 16384) {
            this.unpack.resetDecoder();
            int n5 = 0;
            int n6 = n4;
            while (n6 != 0) {
                int n7 = n3;
                while (n7 != 0) {
                    int n8 = this.unpack.decodeNibble();
                    if (n8 < 0) {
                        return;
                    }
                    this.screenArray[n5++] = this.vgaColorRGB[n8];
                    --n7;
                }
                --n6;
            }
            Image image = this.component.createImage(new MemoryImageSource(n3, n4, this.screenArray, 0, n3));
            this.screen.drawImage(image, n, n2, this);
            this.updateArea(n, n2, n3, n4);
        }
    }

    void drawCompImageColor256(int n, int n2, int n3, int n4) {
        if (n3 * n4 <= 16384) {
            this.unpack.resetDecoder();
            int n5 = 0;
            int n6 = n4;
            while (n6 != 0) {
                int n7 = n3;
                while (n7 != 0) {
                    int n8 = this.unpack.decodeByte();
                    if (n8 < 0) {
                        return;
                    }
                    this.screenArray[n5++] = this.svgaColorRGB[n8];
                    --n7;
                }
                --n6;
            }
            Image image = this.component.createImage(new MemoryImageSource(n3, n4, this.screenArray, 0, n3));
            this.screen.drawImage(image, n, n2, this);
            this.invertRect(n, n2, n3, n4, 15);
            this.updateArea(n, n2, n3, n4);
            this.cacheCount = 1;
        }
    }

    void invertRect(int n, int n2, int n3, int n4, int n5) {
        this.screen.setXORMode(this.vgaColor[0]);
        this.screen.setColor(this.vgaColor[n5 & 0xF]);
        this.screen.fillRect(n, n2, n3, n4);
        this.screen.setPaintMode();
        this.updateArea(n, n2, n3, n4);
    }

    void areaCopy(int n, int n2, int n3, int n4, int n5, int n6) {
        this.screen.copyArea(n, n2, n5, n6, n3 - n, n4 - n2);
        this.updateArea(n3, n4, n5, n6);
    }

    void opaquePattern(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRectColor16(n, n2, n3, n4, n6);
        this.transPattern(n, n2, n3, n4, n5);
    }

    void transPattern(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        byte by = 0;
        int n7 = 0;
        while (n7 < 8) {
            this.patternBuffer[n7] = this.input.getByte();
            ++n7;
        }
        int n8 = n + n3 - 1;
        int n9 = n2 + n4 - 1;
        this.screen.setColor(this.vgaColor[n5 & 0xF]);
        n7 = n2;
        while (n7 <= n9) {
            by = this.patternBuffer[n7 & 7];
            boolean bl = false;
            int n10 = n;
            while (n10 <= n8) {
                if ((by & 128 >> (n10 & 7)) == 0) {
                    if (bl) {
                        this.screen.drawLine(n6, n7, n10 - 1, n7);
                        bl = false;
                    }
                } else if (!bl) {
                    bl = true;
                    n6 = n10;
                }
                ++n10;
            }
            if (bl) {
                this.screen.drawLine(n6, n7, n8, n7);
            }
            ++n7;
        }
        this.updateArea(n, n2, n3, n4);
    }

    void invertPattern(int n, int n2, int n3, int n4) {
        this.screen.setXORMode(this.vgaColor[0]);
        this.transPattern(n, n2, n3, n4, 15);
        this.screen.setPaintMode();
    }

    void monoMask(int n, int n2, int n3, int n4) {
        int n5 = 0;
        byte by = 0;
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        this.screen.setColor(this.vgaColor[0]);
        int n8 = 0;
        int n9 = n2;
        while (n9 <= n7) {
            boolean bl = false;
            int n10 = n;
            while (n10 <= n6) {
                if ((n8++ & 7) == 0) {
                    by = this.input.getByte();
                }
                if (by & true) {
                    if (bl) {
                        this.screen.drawLine(n5, n9, n10 - 1, n9);
                        bl = false;
                    }
                } else if (!bl) {
                    bl = true;
                    n5 = n10;
                }
                by = (byte)(by >> 1);
                ++n10;
            }
            if (bl) {
                this.screen.drawLine(n5, n9, n6, n9);
            }
            ++n9;
        }
        this.updateArea(n, n2, n3, n4);
    }

    void plotMonoForeground(int n, int n2, int n3, int n4, int n5, Color[] colorArray) {
        int n6 = 0;
        byte by = 0;
        int n7 = n + n3 - 1;
        int n8 = n2 + n4 - 1;
        this.screen.setColor(colorArray[n5]);
        int n9 = 0;
        int n10 = n2;
        while (n10 <= n8) {
            boolean bl = false;
            int n11 = n;
            while (n11 <= n7) {
                if ((n9++ & 7) == 0) {
                    by = this.input.getByte();
                }
                if (!(by & true)) {
                    if (bl) {
                        this.screen.drawLine(n6, n10, n11 - 1, n10);
                        bl = false;
                    }
                } else if (!bl) {
                    bl = true;
                    n6 = n11;
                }
                by = (byte)(by >> 1);
                ++n11;
            }
            if (bl) {
                this.screen.drawLine(n6, n10, n7, n10);
            }
            ++n10;
        }
        this.updateArea(n, n2, n3, n4);
    }

    void plotCompMonoForeground(int n, int n2, int n3, int n4, int n5, Color[] colorArray) {
        byte by = 0;
        int n6 = n;
        int n7 = n2;
        int n8 = n + n3 - 1;
        int n9 = n2 + n4 - 1;
        this.screen.setColor(colorArray[n5]);
        int n10 = n3 * n4;
        int n11 = 2;
        by = this.input.getByte();
        boolean bl = (by & 1) != 0;
        while (n10 > 0) {
            int n12;
            int n13;
            if (n11 == 1) {
                by = this.input.getByte();
            }
            if (bl) {
                n13 = 0;
                while ((by & n11) == 0) {
                    ++n13;
                    if ((n11 = (int)((byte)(n11 << 1))) != 0) continue;
                    n11 = 1;
                    by = this.input.getByte();
                }
                if ((n11 = (int)((byte)(n11 << 1))) == 0) {
                    n11 = 1;
                }
                n10 -= ++n13;
                while (n8 - n6 + 1 <= n13) {
                    this.screen.drawLine(n6, n7, n8, n7);
                    n13 -= n8 - n6 + 1;
                    ++n7;
                    n6 = n;
                }
                if (n13 > 0) {
                    this.screen.drawLine(n6, n7, n6 + n13 - 1, n7);
                    n6 += n13;
                }
                bl = false;
                continue;
            }
            n13 = 0;
            while (true) {
                n12 = 0;
                if ((by & n11) != 0) {
                    n12 |= 1;
                }
                if ((n11 = (int)((byte)(n11 << 1))) == 0) {
                    n11 = 1;
                    by = this.input.getByte();
                }
                if ((by & n11) != 0) {
                    n12 |= 2;
                }
                if ((n11 = (int)((byte)(n11 << 1))) == 0) {
                    n11 = 1;
                    by = this.input.getByte();
                }
                if ((by & n11) != 0) {
                    n12 |= 4;
                }
                if ((n11 = (int)((byte)(n11 << 1))) == 0) {
                    n11 = 1;
                }
                if (n12 != 0) break;
                n13 += 7;
                if (n11 != 1) continue;
                by = this.input.getByte();
            }
            n10 -= (n13 += n12);
            if (n8 - n6 + 1 <= n13) {
                n13 -= n8 - n6 + 1;
                ++n7;
                n6 = n;
            }
            n7 += n13 / n3;
            n6 += n13 % n3;
            bl = true;
        }
        this.updateArea(n, n2, n3, n4);
    }

    void opaqueColorSmall(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = n + n3 - 1;
        int n8 = n2 + n4 - 1;
        boolean bl = false;
        int n9 = n2;
        while (n9 <= n8) {
            int n10;
            bl = false;
            if (bl) {
                n10 = n6 >> 4 & 0xF;
                bl = false;
            } else {
                n6 = this.input.getByte();
                n10 = n6 & 0xF;
                bl = true;
            }
            n5 = n;
            int n11 = n + 1;
            while (n11 <= n7) {
                int n12;
                if (bl) {
                    n12 = n6 >> 4 & 0xF;
                    if (n12 != n10) {
                        this.screen.setColor(this.vgaColor[n10 & 0xF]);
                        this.screen.drawLine(n5, n9, n11 - 1, n9);
                        n10 = n12;
                        n5 = n11;
                    }
                    bl = false;
                } else {
                    n6 = this.input.getByte();
                    n12 = n6 & 0xF;
                    if (n12 != n10) {
                        this.screen.setColor(this.vgaColor[n10 & 0xF]);
                        this.screen.drawLine(n5, n9, n11 - 1, n9);
                        n10 = n12;
                        n5 = n11;
                    }
                    bl = true;
                }
                ++n11;
            }
            this.screen.setColor(this.vgaColor[n10 & 0xF]);
            this.screen.drawLine(n5, n9, n11 - 1, n9);
            ++n9;
        }
        this.updateArea(n, n2, n3, n4);
    }

    void transColor(int n, int n2, int n3, int n4) {
        int n5 = 0;
        byte by = 0;
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        int n8 = n2;
        while (n8 <= n7) {
            by = this.input.getByte();
            int n9 = by & 0xF;
            n5 = n;
            boolean bl = true;
            int n10 = n + 1;
            while (n10 <= n6) {
                int n11;
                if (bl) {
                    n11 = by >> 4 & 0xF;
                    if (n11 != n9) {
                        if (n9 != 0) {
                            this.screen.setColor(this.vgaColor[n9 & 0xF]);
                            this.screen.drawLine(n5, n8, n10 - 1, n8);
                        }
                        n9 = n11;
                        n5 = n10;
                    }
                    bl = false;
                } else {
                    by = this.input.getByte();
                    n11 = by & 0xF;
                    if (n11 != n9) {
                        if (n9 != 0) {
                            this.screen.setColor(this.vgaColor[n9 & 0xF]);
                            this.screen.drawLine(n5, n8, n10 - 1, n8);
                        }
                        n9 = n11;
                        n5 = n10;
                    }
                    bl = true;
                }
                ++n10;
            }
            if (n9 != 0) {
                this.screen.setColor(this.vgaColor[n9 & 0xF]);
                this.screen.drawLine(n5, n8, n10 - 1, n8);
            }
            ++n8;
        }
        this.updateArea(n, n2, n3, n4);
    }

    void updateArea(int n, int n2, int n3, int n4) {
        this.currentLeft = n;
        this.currentRight = n + n3 - 1;
        this.currentTop = n2;
        this.currentBottom = n2 + n4 - 1;
    }

    boolean combineArea() {
        int n;
        if (this.left == this.screenWidth) {
            this.left = this.currentLeft;
            this.right = this.currentRight;
            this.top = this.currentTop;
            this.bottom = this.currentBottom;
            this.currentBottom = 0;
            this.currentRight = 0;
            this.currentLeft = this.screenWidth;
            this.currentTop = this.screenHeight;
            return true;
        }
        int n2 = this.currentLeft < this.left ? this.currentLeft : this.left;
        int n3 = this.currentRight > this.right ? this.currentRight : this.right;
        int n4 = this.currentTop < this.top ? this.currentTop : this.top;
        int n5 = n = this.currentBottom > this.bottom ? this.currentBottom : this.bottom;
        if ((n3 - n2 + 1) * (n - n4 + 1) > this.drawImageSize) {
            this.left = n2;
            this.right = n3;
            this.top = n4;
            this.bottom = n;
            this.currentBottom = 0;
            this.currentRight = 0;
            this.currentLeft = this.screenWidth;
            this.currentTop = this.screenHeight;
            return false;
        }
        this.left = n2;
        this.right = n3;
        this.top = n4;
        this.bottom = n;
        this.currentBottom = 0;
        this.currentRight = 0;
        this.currentLeft = this.screenWidth;
        this.currentTop = this.screenHeight;
        return true;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0;
    }

    public interp10() {
        byte[] byArray = new byte[16];
        byArray[1] = -96;
        byArray[3] = -96;
        byArray[5] = -96;
        byArray[7] = -50;
        byArray[8] = -96;
        byArray[9] = -1;
        byArray[11] = -1;
        byArray[13] = -1;
        byArray[15] = -1;
        this.redPaletteNS = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[2] = -96;
        byArray2[3] = -96;
        byArray2[6] = -96;
        byArray2[7] = -50;
        byArray2[8] = -96;
        byArray2[10] = -1;
        byArray2[11] = -1;
        byArray2[14] = -1;
        byArray2[15] = -1;
        this.greenPaletteNS = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[4] = -96;
        byArray3[5] = -96;
        byArray3[6] = -96;
        byArray3[7] = -50;
        byArray3[8] = -96;
        byArray3[12] = -1;
        byArray3[13] = -1;
        byArray3[14] = -1;
        byArray3[15] = -1;
        this.bluePaletteNS = byArray3;
        this.vgaColorRGBNS = new int[]{-16777216, -6750208, -16738048, -6711040, -16777063, -6750055, -16737895, -3355444, -6710887, -65536, -16711936, -256, -16776961, -65281, -16711681, -1};
        this.vgaColorGrayNS = new int[]{-16777216, -6710887, -3355444, -1};
        byte[] byArray4 = new byte[16];
        byArray4[1] = -121;
        byArray4[3] = -121;
        byArray4[5] = -121;
        byArray4[7] = -64;
        byArray4[8] = -121;
        byArray4[9] = -1;
        byArray4[11] = -1;
        byArray4[13] = -1;
        byArray4[15] = -1;
        this.redPaletteIE = byArray4;
        byte[] byArray5 = new byte[16];
        byArray5[2] = -121;
        byArray5[3] = -121;
        byArray5[6] = -121;
        byArray5[7] = -64;
        byArray5[8] = -121;
        byArray5[10] = -1;
        byArray5[11] = -1;
        byArray5[14] = -1;
        byArray5[15] = -1;
        this.greenPaletteIE = byArray5;
        byte[] byArray6 = new byte[16];
        byArray6[4] = -121;
        byArray6[5] = -121;
        byArray6[6] = -121;
        byArray6[7] = -64;
        byArray6[8] = -121;
        byArray6[12] = -1;
        byArray6[13] = -1;
        byArray6[14] = -1;
        byArray6[15] = -1;
        this.bluePaletteIE = byArray6;
        this.vgaColorRGBIE = new int[]{-16777216, -7929856, -16742656, -7895296, -16777081, -7929721, -16742521, -4144960, -7895161, -65536, -16711936, -256, -16776961, -65281, -16711681, -1};
        this.vgaColorGrayIE = new int[]{-16777216, -7895161, -4144960, -1};
        byte[] byArray7 = new byte[16];
        byArray7[1] = -128;
        byArray7[3] = -128;
        byArray7[5] = -128;
        byArray7[7] = -64;
        byArray7[8] = -128;
        byArray7[9] = -1;
        byArray7[11] = -1;
        byArray7[13] = -1;
        byArray7[15] = -1;
        this.redPaletteOther = byArray7;
        byte[] byArray8 = new byte[16];
        byArray8[2] = -128;
        byArray8[3] = -128;
        byArray8[6] = -128;
        byArray8[7] = -64;
        byArray8[8] = -128;
        byArray8[10] = -1;
        byArray8[11] = -1;
        byArray8[14] = -1;
        byArray8[15] = -1;
        this.greenPaletteOther = byArray8;
        byte[] byArray9 = new byte[16];
        byArray9[4] = -128;
        byArray9[5] = -128;
        byArray9[6] = -128;
        byArray9[7] = -64;
        byArray9[8] = -128;
        byArray9[12] = -1;
        byArray9[13] = -1;
        byArray9[14] = -1;
        byArray9[15] = -1;
        this.bluePaletteOther = byArray9;
        this.vgaColorRGBOther = new int[]{-16777216, -8388608, -16744448, -8355840, -16777088, -8388480, -16744320, -4144960, -8355712, -65536, -16711936, -256, -16776961, -65281, -16711681, -1};
        this.vgaColorGrayOther = new int[]{-16777216, -8355712, -4144960, -1};
        int[] nArray = new int[4];
        nArray[1] = 8;
        nArray[2] = 7;
        nArray[3] = 15;
        this.vgaToGray = nArray;
        this.redPalette = new byte[16];
        this.greenPalette = new byte[16];
        this.bluePalette = new byte[16];
        this.grayColor = new Color[4];
        this.vgaColor = new Color[16];
        this.svgaColor = new Color[256];
        this.vgaColorRGB = new int[16];
        this.vgaColorGray = new int[4];
        this.svgaColorRGB = new int[256];
        this.patternBuffer = new byte[8];
        this.param = new short[16];
        this.pSizePos = new short[3];
        this.fDrawn = new Boolean(false);
        int[] nArray2 = new int[9];
        nArray2[2] = 3;
        nArray2[3] = 6;
        nArray2[4] = 8;
        nArray2[5] = 8;
        nArray2[6] = 6;
        nArray2[7] = 10;
        this.mouseShapeBaseX = nArray2;
        int[] nArray3 = new int[9];
        nArray3[1] = 14;
        nArray3[2] = 11;
        nArray3[3] = 16;
        nArray3[4] = 16;
        nArray3[5] = 14;
        nArray3[6] = 10;
        nArray3[7] = 10;
        this.mouseShapeBaseY = nArray3;
        this.mouseShapeX = new int[9];
        this.mouseShapeY = new int[9];
    }
}

