/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import com.ibm.sslight.SSLException;
import com.ibm.sslight.Util;
import java.math.BigInteger;
import java.util.Date;

public class SSLCert {
    static final String JSKREL = new String("src/com/ibm/sslight/src/SSLCert.java, Java_SSL.SSLight, jsk4c, jsk4c000503");
    static final String FILEVER = new String("1.16");
    static final String BUILDDATE = new String("00/05/13 13:48:05");
    public static final int ISSUER = 0;
    public static final int SUBJECT = 1;
    public static final int CN = 3;
    public static final int C = 6;
    public static final int L = 7;
    public static final int O = 10;
    public static final int OU = 11;
    byte[] x509;
    int[] key;
    BigInteger[] BigIntegerKey;
    int sigAlg;
    int alg;
    int con;
    int conL;
    int sig;
    int sigL;
    int iss;
    int issL;
    int sub;
    int subL;
    int val;
    int valL;
    int keyL;
    int ser;
    int serL;
    boolean stepUpApproval;
    int ver;
    int sigAlgIDBER;
    int sigAlgIDBERL;
    int subPubKeyInfoBER;
    int subPubKeyInfoBERL;
    String serNum;
    static final String hexChar = "0123456789ABCDEF";
    static final String RSAAlgOIDPfx = "1.2.840.113549.1.1.";
    static final String[] RSAAlgName = new String[]{"", "RSA", "MD2withRSA", "", "MD5withRSA", "SHA1withRSA"};

    private void ckTL(int n, int[] nArray) throws SSLException {
        try {
            int n2;
            nArray[0] = this.x509[n] & 0xFF;
            nArray[2] = n + 2;
            nArray[1] = n2 = this.x509[n + 1] & 0xFF;
            if (n2 > 128) {
                nArray[1] = Util.msbf(this.x509, n + 2, n2 &= 0x7F);
                nArray[2] = nArray[2] + n2;
            }
            if (nArray[2] + nArray[1] > this.x509.length) {
                throw new SSLException(5, 1010, this.x509, 0, this.x509.length, n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SSLException(5, 1010, this.x509, 0, this.x509.length, n);
        }
    }

    private int ckAlg(int n, int n2) {
        if (this.x509[n++] == 6) {
            byte by;
            if (n2 >= 11 && this.x509[n] == 9 && this.x509[n + 1] == 42 && this.x509[n + 2] == -122 && this.x509[n + 3] == 72 && this.x509[n + 4] == -122 && this.x509[n + 5] == -9 && this.x509[n + 6] == 13 && this.x509[n + 7] == 1 && this.x509[n + 8] == 1 && ((by = this.x509[n + 9]) == 1 || by == 2 || by == 4 || by == 5)) {
                return by;
            }
            if (n2 >= 9 && this.x509[n] == 7 && this.x509[n + 1] == 42 && this.x509[n + 2] == -122 && this.x509[n + 3] == 72 && this.x509[n + 4] == -50 && this.x509[n + 5] == 56 && this.x509[n + 6] == 4) {
                by = this.x509[n + 7];
                if (by == 1) {
                    return 12;
                }
                if (by == 3) {
                    return 27;
                }
            }
            if (n2 >= 7 && this.x509[n] == 5 && this.x509[n + 1] == 43 && this.x509[n + 2] == 14 && this.x509[n + 3] == 3 && this.x509[n + 4] == 2) {
                by = this.x509[n + 5];
                if (by == 13 || by == 27) {
                    return 27;
                }
                if (by == 29) {
                    return 5;
                }
                if (by == 12) {
                    return 12;
                }
            }
        }
        return -1;
    }

    private int[] ckParam(int n, int[] nArray) throws SSLException {
        this.ckTL(n, nArray);
        if (nArray[0] == 48) {
            int[] nArray2 = new int[8];
            int n2 = 0;
            n = 0;
            while (n2 < 6) {
                this.ckTL(n + nArray[2], nArray);
                if (nArray[0] != 2) break;
                nArray2[n2++] = nArray[2];
                nArray2[n2++] = n = nArray[1];
            }
            if (n2 == 6) {
                return nArray2;
            }
        }
        return null;
    }

    public SSLCert(byte[] byArray) throws SSLException {
        block16: {
            int[] nArray = new int[3];
            this.x509 = byArray;
            try {
                this.ckTL(0, nArray);
                this.con = nArray[2];
                this.ckTL(this.con, nArray);
                int n = nArray[2];
                this.conL = n + nArray[1] - this.con;
                this.ckTL(nArray[1] + n, nArray);
                this.ckTL(nArray[1] + nArray[2], nArray);
                this.sig = nArray[2] + 1;
                this.sigL = nArray[1] - 1;
                if (this.x509[n] == -96) {
                    this.ckTL(n, nArray);
                    this.ver = this.x509[nArray[2] + 2] + 1;
                    n = nArray[1] + nArray[2];
                } else {
                    this.ver = 1;
                }
                this.ckTL(n, nArray);
                this.ser = nArray[2];
                this.serL = nArray[1];
                char[] cArray = new char[2 * nArray[1]];
                int n2 = 0;
                while (n2 < cArray.length) {
                    cArray[n2] = hexChar.charAt(this.x509[nArray[2] + n2 / 2] >> 4 & 0xF);
                    cArray[n2 + 1] = hexChar.charAt(this.x509[nArray[2] + n2 / 2] & 0xF);
                    n2 += 2;
                }
                this.serNum = new String(cArray);
                this.ckTL(nArray[1] + nArray[2], nArray);
                this.sigAlgIDBER = nArray[2];
                this.sigAlgIDBERL = nArray[1];
                this.sigAlg = this.ckAlg(nArray[2], nArray[1]);
                if (this.sigAlg != 2 && this.sigAlg != 4 && this.sigAlg != 5) {
                    if (this.sigAlg == 27 && byArray[this.sig] == 48) {
                        this.key = this.ckParam(nArray[2] + this.x509[nArray[2] + 1] + 2, nArray);
                    } else {
                        throw new SSLException(5, 1028, this.x509, this.ser, this.serL);
                    }
                }
                this.iss = nArray[1] + nArray[2];
                this.ckTL(this.iss, nArray);
                this.issL = nArray[1] + nArray[2] - this.iss;
                this.val = nArray[1] + nArray[2];
                this.ckTL(this.val, nArray);
                this.valL = nArray[1] + nArray[2] - this.val;
                this.sub = nArray[1] + nArray[2];
                this.ckTL(this.sub, nArray);
                this.subL = nArray[1] + nArray[2] - this.sub;
                this.ckTL(nArray[1] + nArray[2], nArray);
                this.subPubKeyInfoBER = nArray[2];
                this.subPubKeyInfoBERL = nArray[1];
                this.checkV2V3();
                this.ckTL(nArray[2], nArray);
                this.alg = this.ckAlg(nArray[2], nArray[1]);
                if (this.alg == 1) {
                    this.key = new int[4];
                    this.ckTL(nArray[1] + nArray[2], nArray);
                    this.ckTL(nArray[2] + 1, nArray);
                    n = 0;
                    while (n < 4) {
                        this.ckTL(nArray[2], nArray);
                        this.key[n++] = nArray[2];
                        this.key[n++] = nArray[1];
                        nArray[2] = nArray[2] + nArray[1];
                    }
                    this.keyL = this.key[1] - (this.x509[this.key[0]] == 0 ? 1 : 0);
                    if (n == 4) {
                        return;
                    }
                    break block16;
                }
                if (this.alg == 12) {
                    int[] nArray2 = this.ckParam(nArray[2] + this.x509[nArray[2] + 1] + 2, nArray);
                    if (nArray2 != null) {
                        this.key = nArray2;
                    }
                    if (this.key != null) {
                        this.ckTL(nArray[2] + nArray[1], nArray);
                        this.ckTL(nArray[2] + 1, nArray);
                        this.key[6] = nArray[2];
                        this.key[7] = nArray[1];
                        this.keyL = this.key[1] - (this.x509[this.key[0]] == 0 ? 1 : 0);
                        return;
                    }
                    throw new SSLException(5, 1010, this.x509, 0, this.x509.length, nArray[2]);
                }
                throw new SSLException(5, 1027, this.x509, this.ser, this.serL);
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SSLException(5, 1010, this.x509, 0, this.x509.length, nArray[2]);
            }
            catch (Exception exception) {
                throw new SSLException(5, 1009, exception);
            }
        }
        throw new SSLException(5, 1010, this.x509, 0, this.x509.length);
    }

    void checkV2V3() throws SSLException {
        int[] nArray = new int[3];
        boolean bl = true;
        nArray[1] = this.subPubKeyInfoBERL;
        nArray[2] = this.subPubKeyInfoBER;
        while (bl) {
            this.ckTL(nArray[1] + nArray[2], nArray);
            switch (nArray[0]) {
                case 163: {
                    this.checkExtensions(nArray[1], nArray[2]);
                    break;
                }
                default: {
                    bl = false;
                }
                case 161: 
                case 162: 
            }
        }
    }

    void checkExtensions(int n, int n2) throws SSLException {
        int[] nArray = new int[]{0, 0, 0};
        this.ckTL(n2, nArray);
        int n3 = nArray[2];
        int n4 = nArray[1];
        nArray[1] = 0;
        while (nArray[1] + nArray[2] < n3 + n4) {
            this.ckTL(nArray[1] + nArray[2], nArray);
            this.checkExtension(nArray[1], nArray[2]);
        }
    }

    void checkExtension(int n, int n2) throws SSLException {
        byte[] byArray = new byte[]{85, 29, 37};
        boolean bl = false;
        int[] nArray = new int[]{0, 0, 0};
        this.ckTL(n2, nArray);
        int n3 = nArray[2];
        int n4 = nArray[1];
        this.ckTL(nArray[1] + nArray[2], nArray);
        if (nArray[0] == 1) {
            bl = this.x509[nArray[2]] != 0;
            this.ckTL(nArray[1] + nArray[2], nArray);
        }
        int n5 = nArray[2];
        int n6 = nArray[1];
        if (n4 == byArray.length) {
            boolean bl2;
            block4: {
                byte[] byArray2 = this.x509;
                int n7 = n3;
                int n8 = 0;
                int n9 = n4;
                while (--n9 >= 0) {
                    if (byArray2[n7++] == byArray[n8++]) continue;
                    bl2 = false;
                    break block4;
                }
                bl2 = true;
            }
            if (bl2) {
                this.handleExtKeyUsageSyntax(n6, n5);
            }
        }
    }

    void handleExtKeyUsageSyntax(int n, int n2) throws SSLException {
        int[] nArray = new int[]{0, 0, 0};
        this.ckTL(n2, nArray);
        int n3 = nArray[2];
        int n4 = nArray[1];
        nArray[1] = 0;
        while (nArray[1] + nArray[2] < n3 + n4) {
            this.ckTL(nArray[1] + nArray[2], nArray);
            this.handleKeyPurposeId(nArray[1], nArray[2]);
        }
    }

    void handleKeyPurposeId(int n, int n2) {
        byte[] byArray = new byte[]{96, -122, 72, 1, -122, -8, 66, 4, 1};
        if (n == byArray.length) {
            boolean bl;
            block3: {
                byte[] byArray2 = this.x509;
                int n3 = n2;
                int n4 = 0;
                int n5 = n;
                while (--n5 >= 0) {
                    if (byArray2[n3++] == byArray[n4++]) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (bl) {
                this.stepUpApproval = true;
            }
        }
    }

    public byte[][] key() {
        int n = 0;
        byte[][] byArray = new byte[this.key.length / 2][];
        do {
            int n2 = this.x509[this.key[n]] == 0 ? 0 : 1;
            byArray[n / 2] = new byte[this.key[n + 1] + n2];
            System.arraycopy(this.x509, this.key[n], byArray[n / 2], n2, this.key[n + 1]);
        } while ((n += 2) < this.key.length);
        return byArray;
    }

    BigInteger[] BigIntegerKey() {
        int n = 0;
        if (this.BigIntegerKey == null) {
            byte[][] byArray = this.key();
            this.BigIntegerKey = new BigInteger[byArray.length];
            n = 0;
            while (n < byArray.length) {
                this.BigIntegerKey[n] = new BigInteger(byArray[n]);
                ++n;
            }
        }
        return this.BigIntegerKey;
    }

    public boolean equals(SSLCert sSLCert) {
        if (this.x509.length == sSLCert.x509.length) {
            boolean bl;
            block3: {
                byte[] byArray = this.x509;
                int n = 0;
                byte[] byArray2 = sSLCert.x509;
                int n2 = 0;
                int n3 = this.x509.length;
                while (--n3 >= 0) {
                    if (byArray[n++] == byArray2[n2++]) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public byte[] encode() {
        byte[] byArray = new byte[this.x509.length];
        System.arraycopy(this.x509, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int verify(SSLCert sSLCert) throws SSLException {
        try {
            if (sSLCert == null) {
                Date[] dateArray = this.getValidity();
                long l = System.currentTimeMillis();
                if (l < dateArray[0].getTime()) {
                    return 1003;
                }
                if (l > dateArray[1].getTime()) {
                    return 1001;
                }
                return 0;
            }
            if (this.issL == sSLCert.subL) {
                boolean bl;
                int n;
                int n2;
                byte[] byArray;
                block20: {
                    byte[] byArray2 = this.x509;
                    int n3 = this.iss;
                    byArray = sSLCert.x509;
                    n2 = sSLCert.sub;
                    n = this.issL;
                    while (--n >= 0) {
                        if (byArray2[n3++] == byArray[n2++]) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
                if (bl) {
                    int n4 = 0;
                    if (sSLCert.alg == 1) {
                        if (this.sigAlg <= 5) {
                            if (this.sigL == sSLCert.keyL) {
                                byte[] byArray3 = Util.util23(false, 1, sSLCert.BigIntegerKey(), this.x509, this.sig, this.sigL);
                                if (byArray3 != null) {
                                    boolean bl2;
                                    block21: {
                                        byArray = new byte[byArray3.length];
                                        if (this.sigAlg == 4 && byArray3.length == 34) {
                                            byArray[0] = 48;
                                            byArray[1] = 32;
                                            byArray[2] = 48;
                                            byArray[3] = 12;
                                            byArray[4] = 6;
                                            byArray[5] = 8;
                                            byArray[6] = 42;
                                            byArray[7] = -122;
                                            byArray[8] = 72;
                                            byArray[9] = -122;
                                            byArray[10] = -9;
                                            byArray[11] = 13;
                                            byArray[12] = 2;
                                            byArray[13] = 5;
                                            byArray[14] = 5;
                                            byArray[15] = 0;
                                            byArray[16] = 4;
                                            byArray[17] = 16;
                                            Util.util11(null, this.x509, this.con, this.conL, byArray, 18);
                                        } else if (this.sigAlg == 5 && byArray3.length == 35) {
                                            byArray[0] = 48;
                                            byArray[1] = 33;
                                            byArray[2] = 48;
                                            byArray[3] = 9;
                                            byArray[4] = 6;
                                            byArray[5] = 5;
                                            byArray[6] = 43;
                                            byArray[7] = 14;
                                            byArray[8] = 3;
                                            byArray[9] = 2;
                                            byArray[10] = 26;
                                            byArray[11] = 5;
                                            byArray[12] = 0;
                                            byArray[13] = 4;
                                            byArray[14] = 20;
                                            Util.util06(null, this.x509, this.con, this.conL, byArray, 15);
                                        } else if (this.sigAlg == 2 && byArray3.length == 34) {
                                            n4 = 18;
                                            Util.util12(null, this.x509, this.con, this.conL, byArray, 18);
                                        } else {
                                            return 1022;
                                        }
                                        n2 = n4;
                                        n = n4;
                                        int n5 = byArray3.length - n4;
                                        while (--n5 >= 0) {
                                            if (byArray[n2++] == byArray3[n++]) continue;
                                            bl2 = false;
                                            break block21;
                                        }
                                        bl2 = true;
                                    }
                                    if (bl2) {
                                        return 0;
                                    }
                                    return 1024;
                                }
                                return 1021;
                            }
                            return 1024;
                        }
                        return 1028;
                    }
                    return 1027;
                }
            }
            return 1013;
        }
        catch (Exception exception) {
            throw new SSLException(5, 1009, exception);
        }
    }

    public String getKeyInfo() {
        int n = this.x509[this.key[0] + (this.key[1] - this.keyL)] & 0xFF;
        int n2 = 0;
        while (n2 < 8 && (n & 1 << 7 - n2) == 0) {
            ++n2;
        }
        return String.valueOf(this.alg == 1 ? "RSA/" : "DSA/") + Integer.toString(this.keyL * 8 - n2);
    }

    public String getNameComponent(int n, int n2) {
        int[] nArray = new int[3];
        try {
            int n3;
            int n4;
            if (n == 0) {
                n4 = this.iss;
                n3 = this.issL;
            } else if (n == 1) {
                n4 = this.sub;
                n3 = this.subL;
            } else {
                return null;
            }
            if (this.x509[n4] == 48) {
                this.ckTL(n4, nArray);
                n3 = nArray[1];
                n4 = nArray[2];
                int n5 = n4 + nArray[1];
                while (n4 < n5 && this.x509[n4] == 49) {
                    this.ckTL(n4, nArray);
                    n4 = nArray[2];
                    int n6 = nArray[1] + n4;
                    while (n4 < n6) {
                        byte by;
                        this.ckTL(n4, nArray);
                        n4 = nArray[2];
                        int n7 = nArray[1];
                        if ((byte)(nArray[0] & 0xFF) == 48 && this.x509[n4] == 6 && this.x509[n4 + 1] == 3 && this.x509[n4 + 2] == 85 && this.x509[n4 + 3] == 4 && this.x509[n4 + 4] == n2 && ((by = this.x509[n4 + 5]) == 19 || by == 20 || by == 22) && (by = this.x509[n4 + 6]) > 0) {
                            return new String(this.x509, 0, n4 + 7, (int)by);
                        }
                        n4 += n7;
                    }
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public Date[] getValidity() {
        block9: {
            int[] nArray = new int[3];
            Date[] dateArray = new Date[2];
            int n = this.val;
            try {
                if (this.x509[n] != 48) break block9;
                this.ckTL(n, nArray);
                n = nArray[2];
                int n2 = 0;
                while (n2 < 2) {
                    int[] nArray2 = new int[9];
                    this.ckTL(n, nArray);
                    if (nArray[0] == 23 || nArray[0] == 24) {
                        nArray2[8] = 1;
                        n = nArray[2];
                        int n3 = 0;
                        int n4 = 6;
                        while (n < nArray[2] + nArray[1] && n3 < 8) {
                            byte by;
                            if ((by = this.x509[n++]) == 90) break;
                            if (by == 43) {
                                nArray2[8] = -1;
                                n4 = 8;
                                continue;
                            }
                            if (by == 45) {
                                n4 = 8;
                                continue;
                            }
                            if (n3 >= n4) continue;
                            nArray2[n3++] = (by & 0xF) * 10 + (this.x509[n++] & 0xF);
                            if (n3 != 2) continue;
                            if (nArray[0] == 24) {
                                nArray2[0] = nArray2[0] * 100 + nArray2[1] - 1900;
                                n3 = 1;
                                continue;
                            }
                            if (nArray2[0] >= 50) continue;
                            nArray2[0] = nArray2[0] + 100;
                        }
                        dateArray[n2] = new Date(Date.UTC(nArray2[0], nArray2[1] - 1, nArray2[2], nArray2[3] + nArray2[6] * nArray2[8], nArray2[4] + nArray2[7] * nArray2[8], nArray2[5]));
                        if (n2 == 1) {
                            return dateArray;
                        }
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public byte[] fingerprint() {
        byte[] byArray = new byte[16];
        Util.util11(null, this.x509, 0, this.x509.length, byArray, 0);
        return byArray;
    }

    public int getVersion() {
        return this.ver;
    }

    public String getSerialNumber() {
        return this.serNum;
    }

    public byte[] getSigAlgIDBER() {
        byte[] byArray = new byte[this.sigAlgIDBERL];
        System.arraycopy(this.x509, this.sigAlgIDBER, byArray, 0, this.sigAlgIDBERL);
        return byArray;
    }

    public byte[] getSubPubKeyInfoBER() {
        byte[] byArray = new byte[this.subPubKeyInfoBERL];
        System.arraycopy(this.x509, this.subPubKeyInfoBER, byArray, 0, this.subPubKeyInfoBERL);
        return byArray;
    }

    public byte[] getSignature() {
        byte[] byArray = new byte[this.sigL];
        System.arraycopy(this.x509, this.sig, byArray, 0, this.sigL);
        return byArray;
    }

    public byte[] getEncoding() {
        byte[] byArray = new byte[this.x509.length];
        System.arraycopy(this.x509, 0, byArray, 0, this.x509.length);
        return byArray;
    }

    public String getSigAlgOID() {
        switch (this.sigAlg) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return RSAAlgOIDPfx + this.sigAlg;
            }
            case 12: {
                return "1.2.840.10040.4.1";
            }
            case 27: {
                return "1.2.840.10040.4.3";
            }
        }
        return null;
    }

    public String getSigAlgName() {
        switch (this.sigAlg) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return RSAAlgName[this.sigAlg];
            }
            case 12: {
                return "DSA";
            }
            case 27: {
                return "SHA1withDSA";
            }
        }
        return null;
    }

    public int getKeySize() {
        int n = this.x509[this.key[0] + (this.key[1] - this.keyL)] & 0xFF;
        int n2 = 0;
        while (n2 < 8 && (n & 1 << 7 - n2) == 0) {
            ++n2;
        }
        return this.keyL * 8 - n2;
    }

    boolean hasStepUpApproval() {
        return this.stepUpApproval;
    }
}

