/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import com.ibm.sslight.SSLCert;
import com.ibm.sslight.SSLContext;
import com.ibm.sslight.SSLException;
import com.ibm.sslight.SSLGenSock;
import com.ibm.sslight.SSLInputStream;
import com.ibm.sslight.SSLOutputStream;
import com.ibm.sslight.SSLRecordLayer;
import com.ibm.sslight.SSLSession;
import com.ibm.sslight.Util;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigInteger;

abstract class SSLConnection
implements Runnable {
    static final String JSKREL = new String("src/com/ibm/sslight/src/SSLConnection.java, Java_SSL.SSLight, jsk4c, jsk4c000503");
    static final String FILEVER = new String("1.21");
    static final String BUILDDATE = new String("00/05/13 13:48:06");
    static final byte[] Pad1 = new byte[48];
    static final byte[] Pad2 = new byte[48];
    static final byte[][] senderMagic;
    static final int[] cipherSuite;
    static final int OPENING = 0;
    static final int OPEN = 1;
    static final int CLOSING = 2;
    static final int CLOSED = 3;
    static final int CHANGE_CS = 1;
    static final int HELLO = 2;
    static final int CERT = 4;
    static final int KEY_EXCHANGE = 8;
    static final int FINISHED = 16;
    private Thread thread;
    long reopen_time;
    BigInteger[] key_exchange;
    boolean sync_mode;
    boolean session_ref;
    SSLGenSock sock;
    SSLContext context;
    SSLSession session;
    SSLRecordLayer in;
    SSLRecordLayer out;
    SSLCert[] conn_cert;
    BigInteger[] conn_key;
    int state;
    int error;
    SSLException ssl_e;
    private int role;
    private boolean keep_sock;
    boolean fail_handshake = false;
    int handshake_state;
    byte[] handshake;
    private int handshake_off;
    private boolean finished_done;
    boolean step_up_handshake;
    Object correlator;
    final byte[][] random = new byte[2][];
    private final byte[][] mac = new byte[2][];
    private final byte[][] key = new byte[2][];
    private final byte[][] iv = new byte[2][];
    private byte[] message;
    private int message_length;
    private int message_done;
    private byte[] control = new byte[2];
    private SSLCert[] bug_cert;
    static final byte[] VERISIGN;
    static final byte[] THAWTE;
    static final byte[] VERISIGN2;

    synchronized void install(SSLGenSock sSLGenSock, boolean bl, int n, SSLContext sSLContext, boolean bl2, Object object) throws IOException, SSLException {
        this.sock = sSLGenSock;
        this.keep_sock = bl;
        this.role = n;
        this.context = sSLContext;
        this.sync_mode = bl2;
        this.correlator = object;
        this.fail_handshake = false;
        this.out = new SSLRecordLayer(this, sSLGenSock.getRawOutputStream(), null, bl2);
        this.in = new SSLRecordLayer(this, null, sSLGenSock.getRawInputStream(), bl2);
        if (this.install(false) == -1) {
            throw new IOException();
        }
        int n2 = sSLContext.timeout[2];
        try {
            if (!bl2) {
                if (n2 == 0) {
                    this.wait();
                } else {
                    this.wait(n2);
                    if (this.state != 1 && this.ssl_e == null) {
                        this.ssl_e = new SSLException(6, 1006);
                    }
                }
            } else {
                int n3;
                while ((n3 = this.in.receiveRecord(n2)) == 0 && this.state == 0) {
                }
                if (n3 == -3) {
                    this.ssl_e = new SSLException(6, 1006);
                }
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.state != 1) {
            if (this.state == 0) {
                bl = false;
                this.close();
                this.error = 40;
            }
            if (this.error < 0) {
                throw new IOException();
            }
            if (this.ssl_e != null) {
                throw this.ssl_e;
            }
            throw new SSLException();
        }
        this.ssl_e = null;
        this.reopen_time = System.currentTimeMillis() + (long)sSLContext.timeout[0];
        if (!bl2 && sSLContext.timeout[0] != 0) {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }
        sSLContext.handleConnection(object, this.session.master_secret);
    }

    int reopen() {
        this.reopen_time = 0L;
        if (this.thread == null) {
            this.state = 0;
            return this.install(true);
        }
        this.notifyAll();
        return 0;
    }

    public synchronized void run() {
        try {
            while (this.state == 1) {
                long l = System.currentTimeMillis();
                if (this.reopen_time <= l) {
                    this.state = 0;
                    if (this.install(true) == -1) break;
                    if (this.context.timeout[2] == 0) {
                        this.wait();
                        continue;
                    }
                    this.wait(this.context.timeout[2]);
                    continue;
                }
                int n = (int)(this.reopen_time - l);
                this.wait(n);
            }
            if (this.state == 0) {
                this.keep_sock = false;
                this.close();
                return;
            }
        }
        catch (Exception exception) {}
    }

    private void terminate(boolean bl, int n) {
        if (this.session != null) {
            this.uninstall(bl);
        }
        this.out.close();
        if (this.error == 0) {
            this.error = n;
        }
        this.state = 3;
        if (this.sock != null) {
            try {
                this.sock.uninstall(this.keep_sock && this.error == 0);
                this.sock = null;
            }
            catch (IOException iOException) {}
        }
        if (!this.sync_mode || this.thread != null) {
            this.notifyAll();
        }
    }

    protected void finalize() {
        if (this.state != 3) {
            try {
                this.keep_sock = false;
                this.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    final int register(byte[] byArray, int n, int n2) {
        int n3 = this.handshake == null ? 0 : this.handshake.length;
        if (n3 - this.handshake_off < n2) {
            byte[] byArray2 = new byte[n3 + n2 + 4096];
            if (n3 != 0) {
                System.arraycopy(this.handshake, 0, byArray2, 0, this.handshake_off);
            }
            this.handshake = byArray2;
        }
        if (byArray != null) {
            System.arraycopy(byArray, n, this.handshake, this.handshake_off, n2);
        }
        n3 = this.handshake_off;
        this.handshake_off += n2;
        return n3;
    }

    final void reset() {
        int n = 0;
        do {
            this.iv[n] = null;
            this.key[n] = null;
            this.mac[n] = null;
            this.random[n] = null;
        } while (++n < 2);
        this.handshake = null;
        this.handshake_off = 0;
        this.finished_done = false;
    }

    final void helloRandom() {
        this.random[this.role] = new byte[32];
        byte[] byArray = this.random[this.role];
        int n = (int)(System.currentTimeMillis() / 1000L);
        int n2 = 0;
        int n3 = 4;
        do {
            byArray[n2++] = (byte)(n >>> --n3 * 8);
        } while (n3 > 0);
        Util.random(byArray, 4, 28);
    }

    final void peerRandom(byte[] byArray, int n, int n2) {
        if (n2 > 32) {
            n += n2 - 32;
            n2 = 32;
        }
        byte[] byArray2 = new byte[32];
        this.random[this.role ^ 1] = byArray2;
        System.arraycopy(byArray, n, byArray2, 32 - n2, n2);
    }

    final void blockHash(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length;
        int n3 = byArray2.length / 16;
        int n4 = n3 + n2 + 64;
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[n2 + 20];
        System.arraycopy(byArray, 0, byArray3, n3, n2);
        System.arraycopy(this.random[n], 0, byArray3, n3 + n2, 32);
        System.arraycopy(this.random[n ^ 1], 0, byArray3, n3 + n2 + 32, 32);
        System.arraycopy(byArray, 0, byArray4, 0, n2);
        int n5 = 0;
        do {
            int n6 = 0;
            do {
                byArray3[n3 - 1 - n6] = (byte)(65 + n5);
            } while (++n6 <= n5);
            n6 = n3 - 1 - n5;
            Util.util06(null, byArray3, n6, n4 - n6, byArray4, n2);
            Util.util11(null, byArray4, 0, n2 + 20, byArray2, n5 * 16);
        } while (++n5 < n3);
    }

    final void handshakeHash(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = this.handshake_off;
        byte[] byArray3 = new byte[116];
        System.arraycopy(this.session.master_secret, 0, byArray3, 0, 48);
        if (byArray != null) {
            this.register(byArray, 0, 4);
        }
        this.register(this.session.master_secret, 0, 48);
        if (n2 == 1) {
            int n4 = this.handshake_off;
            this.register(Pad1, 0, 48);
            System.arraycopy(Pad2, 0, byArray3, 48, 48);
            Util.util11(null, this.handshake, 0, this.handshake_off, byArray3, 96);
            Util.util11(null, byArray3, 0, 112, byArray2, n);
            this.handshake_off = n4;
        }
        this.register(Pad1, 0, 40);
        System.arraycopy(Pad2, 0, byArray3, 48, 40);
        Util.util06(null, this.handshake, 0, this.handshake_off, byArray3, 88);
        Util.util06(null, byArray3, 0, 108, byArray2, n + 16 * n2);
        this.handshake_off = n3;
    }

    final void paramHash(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = new byte[64 + n2];
        System.arraycopy(this.random[0], 0, byArray3, 0, 32);
        System.arraycopy(this.random[1], 0, byArray3, 32, 32);
        System.arraycopy(byArray, n, byArray3, 64, n2);
        if (n4 == 1) {
            Util.util11(null, byArray3, 0, byArray3.length, byArray2, n3);
        }
        Util.util06(null, byArray3, 0, byArray3.length, byArray2, n3 + 16 * n4);
    }

    final void update() {
        int n;
        short s;
        if (this.session == null || (s = this.session.cipher_suite) == 0) {
            return;
        }
        int n2 = cipherSuite[s & 0xFF];
        boolean bl = (n2 & 0xF000) == 4096;
        int n3 = (n2 & 0xF) == 1 ? 16 : 20;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 & 0xF0;
        if (n7 != 0) {
            if (n7 != 16) {
                n6 = 8;
            }
            if (n7 == 16 || n7 == 32) {
                n5 = bl ? 5 : 16;
                n4 = 16;
            } else if (n7 == 48) {
                n5 = bl ? 5 : 8;
                n4 = 8;
            } else if (n7 == 80) {
                n4 = 24;
                n5 = 24;
            } else {
                n4 = 16;
                n5 = 16;
            }
        }
        int n8 = 2 * (n3 + n5);
        int n9 = bl ? n8 : n8 + 2 * n6;
        byte[] byArray = new byte[(n9 + 15) / 16 * 16];
        this.blockHash(this.session.master_secret, byArray, 1);
        int n10 = 0;
        if (n3 != 0) {
            n = 0;
            while (n < 2) {
                this.mac[n] = new byte[n3];
                System.arraycopy(byArray, n10, this.mac[n], 0, n3);
                n10 += n3;
                ++n;
            }
        }
        if (n5 != 0) {
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            if (bl) {
                byArray2 = new byte[n5 + 64];
                byArray3 = new byte[16];
            }
            n = 0;
            do {
                this.key[n] = new byte[n4];
                if (bl) {
                    System.arraycopy(byArray, n10, byArray2, 0, n5);
                    System.arraycopy(this.random[n], 0, byArray2, n5, 32);
                    System.arraycopy(this.random[n ^ 1], 0, byArray2, n5 + 32, 32);
                    Util.util11(null, byArray2, 0, byArray2.length, byArray3, 0);
                    System.arraycopy(byArray3, 0, this.key[n], 0, n4);
                } else {
                    System.arraycopy(byArray, n10, this.key[n], 0, n5);
                }
                n10 += n5;
                if (n6 == 0) continue;
                this.iv[n] = new byte[n6];
                if (bl) {
                    Util.util11(null, byArray2, n5, 64, byArray3, 0);
                    System.arraycopy(byArray3, 0, this.iv[n], 0, n6);
                    continue;
                }
                System.arraycopy(byArray, n8, this.iv[n], 0, n6);
                n8 += n6;
            } while (++n < 2);
        }
    }

    private void update(int n) {
        int n2 = this.role == 0 ^ n == 0 ? 0 : 1;
        (n == 0 ? this.in : this.out).update(this.mac[n2], this.key[n2], this.iv[n2]);
    }

    final synchronized int handleHandshakeV2(byte[] byArray, int n) {
        if (this.role != 0 && this.state == 0) {
            if (this.handshake(byArray, byArray[0], 0, n, 2) == 0) {
                return 0;
            }
        } else {
            this.sendAlert((byte)2, (byte)10);
            this.ssl_e = new SSLException(2, 1018, byArray, 0, n);
        }
        this.terminate(false, 10);
        return -1;
    }

    final synchronized boolean handleV2ClientHello() {
        return this.role == 1;
    }

    final synchronized int handleData(byte by, byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            if (this.message == null) {
                this.message = byArray;
                if (by == 20) {
                    this.message_length = 1;
                } else if (by == 21) {
                    this.message_length = 2;
                } else if (by == 22) {
                    this.message_length = 4;
                    if (n2 >= 4) {
                        this.message_length += Util.msbf(byArray, n + 1, 3);
                    }
                }
                if (this.message_length > n2) {
                    this.message = new byte[this.message_length];
                    System.arraycopy(byArray, n, this.message, 0, n2);
                    this.message_done = n2;
                    return by;
                }
                n4 = n;
                n2 -= this.message_length;
                n += this.message_length;
            } else {
                if (by == 22 && this.message_done < 4) {
                    n4 = 4 - this.message_done;
                    if (n4 > n2) {
                        n4 = n2;
                    }
                    System.arraycopy(byArray, n, this.message, this.message_done, n4);
                    if ((this.message_done += n4) < 4) {
                        return by;
                    }
                    n2 -= n4;
                    n += n4;
                    this.message_length += Util.msbf(this.message, 1, 3);
                    byte[] byArray2 = new byte[this.message_length];
                    System.arraycopy(this.message, 0, byArray2, 0, this.message_done);
                    this.message = byArray2;
                }
                if ((n4 = this.message_length - this.message_done) > n2) {
                    n4 = n2;
                }
                System.arraycopy(byArray, n, this.message, this.message_done, n4);
                if ((this.message_done += n4) < this.message_length) {
                    return by;
                }
                n2 -= n4;
                n += n4;
                n4 = 0;
            }
            n3 = 0;
            switch (by) {
                case 20: {
                    if (this.state == 1 || this.state == 0) {
                        if (this.message[n4] == 1 && (1 & this.handshake_state) != 0) {
                            this.update(0);
                            this.handshake_state = 16;
                            break;
                        }
                        this.sendAlert((byte)2, (byte)10);
                    }
                    this.ssl_e = new SSLException(2, 1018, this.message, n4, this.message_length);
                    this.terminate(false, 10);
                    n3 = -1;
                    break;
                }
                case 21: {
                    byte by2 = this.message[n4];
                    byte by3 = this.message[n4 + 1];
                    n3 = -1;
                    if (this.state == 3) break;
                    if (this.step_up_handshake) {
                        this.ssl_e = new SSLException(0, 1032);
                    }
                    if (by3 == 0) {
                        if (by2 == 2 && this.state != 2) {
                            this.sendAlert((byte)1, (byte)0);
                        }
                        this.terminate(true, 0);
                        n3 = -2;
                        break;
                    }
                    if (this.state != 2) {
                        if (!this.step_up_handshake) {
                            this.ssl_e = new SSLException(0, by3);
                        }
                        switch (by3) {
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: {
                                if (by2 != 1) break;
                                n3 = this.alert(by2, by3);
                                break;
                            }
                            case 10: 
                            case 20: 
                            case 30: 
                            case 40: 
                            case 47: {
                                if (by2 == 2) break;
                            }
                            default: {
                                this.sendAlert((byte)2, (byte)10);
                            }
                        }
                        if (n3 == 0) break;
                    }
                    this.terminate(false, 10);
                    break;
                }
                case 22: {
                    if ((this.state == 1 || this.state == 0) && this.handshake(this.message, this.message[n4], n4, this.message_length, 3) == 0) break;
                    this.terminate(false, 10);
                    n3 = -1;
                }
            }
            this.message = null;
            if (n3 < 0) break;
        }
        return n3;
    }

    final synchronized int handleException(int n, SSLException sSLException) {
        if (this.state == 3) {
            return -1;
        }
        if (this.state != 2) {
            if (n == -2) {
                if (this.state == 1) {
                    this.terminate(true, 0);
                    return -2;
                }
            } else if (n > 0) {
                this.sendAlert((byte)2, (byte)n);
                this.ssl_e = sSLException;
            }
        }
        this.terminate(false, n);
        return -1;
    }

    abstract int alert(byte var1, byte var2);

    abstract int handshake(byte[] var1, byte var2, int var3, int var4, int var5);

    abstract int install(boolean var1);

    abstract boolean uninstall(boolean var1);

    abstract boolean shouldUseStepup(SSLCert[] var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean isStepUpRoot(SSLCert sSLCert) {
        boolean bl;
        block10: {
            int n;
            int n2;
            byte[] byArray;
            int n3;
            byte[] byArray2 = null;
            bl = false;
            if (sSLCert != null) {
                byArray2 = sSLCert.getSignature();
            }
            if (byArray2 == null) return bl;
            if (byArray2.length == VERISIGN.length) {
                block8: {
                    n3 = 0;
                    byArray = VERISIGN;
                    n2 = 0;
                    n = VERISIGN.length;
                    while (--n >= 0) {
                        if (byArray2[n3++] == byArray[n2++]) continue;
                        break block8;
                    }
                    return true;
                }
                boolean bl2 = false;
                if (bl2) {
                    return true;
                }
            }
            if (byArray2.length == THAWTE.length) {
                block9: {
                    n3 = 0;
                    byArray = THAWTE;
                    n2 = 0;
                    n = THAWTE.length;
                    while (--n >= 0) {
                        if (byArray2[n3++] == byArray[n2++]) continue;
                        break block9;
                    }
                    return true;
                }
                boolean bl3 = false;
                if (bl3) {
                    return true;
                }
            }
            if (byArray2.length != VERISIGN2.length) return bl;
            n3 = 0;
            byArray = VERISIGN2;
            n2 = 0;
            n = VERISIGN2.length;
            while (--n >= 0) {
                if (byArray2[n3++] == byArray[n2++]) continue;
                break block10;
            }
            return true;
        }
        boolean bl4 = false;
        if (!bl4) return bl;
        return true;
    }

    final int certificate(byte[] byArray, int n, int n2) {
        int n3 = n2 - 4;
        int n4 = n + 4;
        int n5 = 0;
        this.control[0] = 47;
        if (n3 >= 3 && (n3 -= 3) <= 0xFFFFFF && Util.msbf(byArray, n4, 3) == n3) {
            n4 += 3;
            try {
                while (n3 >= 3) {
                    boolean bl;
                    int n6 = Util.msbf(byArray, n4, 3);
                    n4 += 3;
                    if (n6 <= 0 || (n3 -= 3) < n6) break;
                    if (this.bug_cert != null) {
                        byte[] byArray2 = new byte[n6];
                        System.arraycopy(byArray, n4, byArray2, 0, n6);
                        this.bug_cert[n5] = new SSLCert(byArray2);
                    }
                    n4 += n6;
                    ++n5;
                    if ((n3 -= n6) != 0) continue;
                    if (this.bug_cert == null) {
                        n3 = n2 - 4 - 3;
                        n4 = n + 4 + 3;
                        this.bug_cert = new SSLCert[n5];
                        n5 = 0;
                        continue;
                    }
                    boolean bl2 = bl = (this.session.allow_temp_strong || (this.session.cipher_suite & 0xF000) == 0) && this.shouldUseStepup(this.bug_cert);
                    if (this.context.verify(this.bug_cert, this.session, bl, this.correlator) < 0) break;
                    this.control[0] = 0;
                    if (this.session.allow_temp_strong) {
                        if (!bl || !this.isStepUpRoot(this.session.peer_root_cert)) {
                            SSLSession.uninstall(this.session, this, false);
                            throw new SSLException(2, 1025);
                        }
                    } else {
                        this.session.step_up_cryptography = bl && this.isStepUpRoot(this.session.peer_root_cert);
                    }
                    this.session.peer_cert = this.bug_cert;
                    this.bug_cert = null;
                    return 0;
                }
                this.ssl_e = new SSLException(4, 1017);
            }
            catch (SSLException sSLException) {
                int n7;
                int n8 = sSLException.getCategory();
                if (n8 == 5) {
                    this.control[0] = 42;
                    sSLException.setCategory(3);
                }
                if ((n7 = sSLException.getError()) == 1003) {
                    this.control[0] = 45;
                } else if (n7 == 1001) {
                    this.control[0] = 45;
                }
                this.ssl_e = sSLException;
            }
            catch (Exception exception) {}
        }
        this.bug_cert = null;
        this.sendAlert((byte)2, this.control[0]);
        return -1;
    }

    final int finished(byte[] byArray, int n, int n2) {
        int n3 = n2 - 4;
        if (n3 == 36) {
            boolean bl;
            block11: {
                byte[] byArray2 = new byte[36];
                this.handshakeHash(senderMagic[this.role ^ 1], byArray2, 0, 1);
                if (this.fail_handshake) {
                    this.sendAlert((byte)2, (byte)20);
                    return -1;
                }
                int n4 = n + 4;
                int n5 = 0;
                int n6 = 36;
                while (--n6 >= 0) {
                    if (byArray[n4++] == byArray2[n5++]) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
            if (!bl) {
                this.ssl_e = new SSLException(2, 1031);
                this.sendAlert((byte)2, (byte)20);
                return -1;
            }
            if (!this.finished_done) {
                this.register(byArray, n, n2);
                if (this.sendFinished(false) == -1) {
                    return -1;
                }
            }
            if (!this.context.allow_step_up_cryptography || !this.session.step_up_cryptography) {
                this.out.enable(true);
                this.in.enable(true);
                this.state = 1;
                this.reopen_time = System.currentTimeMillis() + (long)this.context.timeout[0];
                if (!this.sync_mode || this.thread != null) {
                    this.notifyAll();
                }
            }
            return 0;
        }
        if (n3 < 36) {
            this.ssl_e = new SSLException(1, 1015, byArray, n, n2);
        } else if (n3 > 36) {
            this.ssl_e = new SSLException(1, 1014, byArray, n, n2);
        }
        this.sendAlert((byte)2, (byte)47);
        return -1;
    }

    final int sendAlert(byte by, byte by2) {
        this.control[0] = by;
        this.control[1] = by2;
        if (by == 2) {
            this.error = by2;
        }
        try {
            this.out.write((byte)21, this.control, 0, 2, true);
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    final int sendHandshake(byte by, byte[] byArray, int n, int n2, boolean bl) {
        byArray[n] = by;
        int n3 = n + 1;
        int n4 = 3;
        do {
            byArray[n3++] = (byte)(n2 >>> --n4 * 8);
        } while (n4 > 0);
        while (true) {
            try {
                this.out.write((byte)22, byArray, n, n2 + 4, bl);
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            catch (IOException iOException) {
                this.error = -1;
                return -1;
            }
            break;
        }
        return 0;
    }

    final int sendFinished(boolean bl) {
        this.control[0] = 1;
        try {
            this.out.write((byte)20, this.control, 0, 1, true);
        }
        catch (IOException iOException) {
            this.error = -1;
            return -1;
        }
        this.update(1);
        byte[] byArray = new byte[40];
        this.handshakeHash(senderMagic[this.role], byArray, 4, 1);
        if (this.sendHandshake((byte)20, byArray, 0, 36, true) == 0) {
            if (bl) {
                this.register(byArray, 0, byArray.length);
            }
            this.finished_done = true;
            return 0;
        }
        return -1;
    }

    final int sendCertificate() {
        try {
            int n = 0;
            int n2 = 0;
            do {
                n2 += 3 + this.conn_cert[n].x509.length;
            } while (++n < this.conn_cert.length);
            int n3 = this.register(null, 0, 7 + n2);
            int n4 = n3 + 4;
            byte[] byArray = this.handshake;
            int n5 = n4;
            int n6 = 3;
            do {
                byArray[n5++] = (byte)(n2 >>> --n6 * 8);
            } while (n6 > 0);
            n4 += 3;
            n = 0;
            do {
                n5 = this.conn_cert[n].x509.length;
                n6 = n4;
                int n7 = 3;
                do {
                    byArray[n6++] = (byte)(n5 >>> --n7 * 8);
                } while (n7 > 0);
                System.arraycopy(this.conn_cert[n].x509, 0, byArray, n4 + 3, this.conn_cert[n].x509.length);
                n4 += 3 + this.conn_cert[n].x509.length;
            } while (++n < this.conn_cert.length);
            return this.sendHandshake((byte)11, byArray, n3, n2 + 3, false);
        }
        catch (Exception exception) {
            this.ssl_e = new SSLException(8, 1009, exception);
            return -1;
        }
    }

    void close() throws IOException {
        boolean bl = true;
        this.in.close();
        SSLConnection sSLConnection = this;
        synchronized (sSLConnection) {
            switch (this.state) {
                case 3: {
                    if (this.error == 0) {
                        this.error = -1;
                        Object var3_3 = null;
                        return;
                    }
                    throw new IOException();
                }
                case 0: {
                    bl = false;
                    this.sendAlert((byte)2, (byte)0);
                    break;
                }
                case 1: {
                    this.sendAlert((byte)1, (byte)0);
                }
            }
            if (this.state != 2) {
                if (!this.sync_mode || this.thread != null) {
                    this.notifyAll();
                }
                this.state = 2;
            }
            this.out.close();
            while (this.state == 2 && this.keep_sock && this.error == 0) {
                try {
                    if (!this.sync_mode) {
                        this.wait(3000L);
                        this.error = -1;
                        continue;
                    }
                    if (this.in.receiveRecord(3000) == 0) continue;
                    this.error = -1;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            if (this.state != 3) {
                this.in.terminate();
                this.terminate(bl, this.error);
            }
            if (this.error != 0) {
                throw new IOException();
            }
            this.error = -1;
            return;
        }
    }

    synchronized SSLOutputStream getOutputStream() throws IOException {
        if (this.state == 3) {
            throw new IOException();
        }
        return this.out.getSSLOutputStream();
    }

    synchronized SSLInputStream getInputStream() throws IOException {
        if (this.state == 3) {
            throw new IOException();
        }
        return this.in.getSSLInputStream();
    }

    SSLConnection() {
    }

    static {
        int n = 0;
        do {
            SSLConnection.Pad1[n] = 54;
            SSLConnection.Pad2[n] = 92;
        } while (++n < 48);
        senderMagic = new byte[][]{{67, 76, 78, 84}, {83, 82, 86, 82}};
        cipherSuite = new int[]{4096, -2105474815, -2105474814, -2105470703, -2105474799, -2105474798, -2105470687, -2105474750, -2105470670, -2105474766, -2105474734, 266802, 262706, 262738, 201266, 197170, 197202, 135986, 131890, 131922, 70450, 66354, 66386, 4881, 785, 4914, 818, 850};
        VERISIGN = new byte[]{97, 112, -20, 47, 63, -98, -3, 43, -26, 104, 84, 33, -80, 103, 121, 8, 12, 32, -106, 49, -118, 13, 122, -66, -74, 38, -33, 121, 44, 34, 105, 73, 54, -29, -105, 119, 98, 97, -94, 50, -41, 122, 84, 33, 54, -70, 2, -55, 52, -25, 37, -38, 68, 53, -80, -46, 92, -128, 93, -77, -108, -8, -7, -84, -18, -92, 96, 117, 42, 31, -107, 73, 35, -79, 74, 124, -12, -77, 71, 114, 33, 91, 126, -105, -85, 84, -84, 98, -25, 93, -20, -82, -101, -46, -55, -78, 36, -5, -126, -83, -23, 103, 21, 75, -70, -86, -90, -16, -105, -96, -10, -80, -105, 87, 0, -56, 12, 60, 9, -96, -126, 4, -70, 65, -38, -9, -103, -92};
        THAWTE = new byte[]{7, -6, 76, 105, 92, -5, -107, -52, 70, -18, -123, -125, 77, 33, 48, -114, -54, -39, -88, 111, 73, 26, -26, -38, 81, -29, 96, 112, 108, -124, 97, 17, -95, 26, -56, 72, 62, 89, 67, 125, 79, -107, 61, -95, -117, -73, 11, 98, -104, 122, 117, -118, -35, -120, 78, 78, -98, 64, -37, -88, -52, 50, 116, -71, 111, 13, -58, -29, -77, 68, 11, -39, -118, 111, -102, 41, -101, -103, 24, 40, 59, -47, -29, 64, 40, -102, 90, 60, -43, -75, -25, 32, 27, -117, -54, -92, -85, -115, -23, 81, -39, -30, 76, 44, 89, -87, -38, -71, -78, 117, 27, -10, 66, -14, -17, -57, -14, 24, -7, -119, -68, -93, -1, -118, 35, 46, 112, 71};
        VERISIGN2 = new byte[]{-69, 76, 18, 43, -49, 44, 38, 0, 79, 20, 19, -35, -90, -5, -4, 10, 17, -124, -116, -13, 40, 28, 103, -110, 47, 124, -74, -59, -6, -33, -16, -24, -107, -68, 29, -113, 108, 44, -88, 81, -52, 115, -40, -92, -64, 83, -16, 78, -42, 38, -64, 118, 1, 87, -127, -110, 94, 33, -15, -47, -79, -1, -25, -48, 33, 88, -51, 105, 23, -29, 68, 28, -100, 25, 68, 57, -119, 92, -36, -100, 0, 15, 86, -115, 2, -103, -19, -94, -112, 69, 76, -28, -69, 16, -92, 61, -16, 50, 3, 14, -15, -50, -8, -24, -55, 81, -116, -26, 98, -97, -26, -97, -64, 125, -73, 114, -100, -55, 54, 58, 107, -97, 78, -88, -1, 100, 13, 100};
    }
}

