/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import com.ibm.sslight.SSLClient;
import com.ibm.sslight.SSLConnection;
import com.ibm.sslight.SSLContext;
import com.ibm.sslight.SSLException;
import com.ibm.sslight.SSLServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SSLGenSock
extends Socket {
    static final String JSKREL = new String("src/com/ibm/sslight/src/SSLGenSock.java, Java_SSL.SSLight, jsk4c, jsk4c000503");
    static final String FILEVER = new String("1.4");
    static final String BUILDDATE = new String("00/05/13 13:57:49");
    static final boolean CLIENT = false;
    static final boolean SERVER = true;
    protected Socket sock;
    protected SSLContext cont;
    protected SSLConnection conn;
    protected boolean role;
    protected boolean async;
    private int sock_timeout;
    private int sock_linger;
    int timeout;

    protected SSLGenSock() {
    }

    protected SSLGenSock(String string, int n) throws IOException, UnknownHostException {
        super(string, n);
    }

    protected SSLGenSock(InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
    }

    protected void install(Socket socket, boolean bl, SSLContext sSLContext, boolean bl2, int n, Object object) throws IOException, SSLException {
        this.cont = sSLContext;
        if (this.cont == null) {
            throw new SSLException(7, 1012, 3);
        }
        this.sock = socket;
        this.role = bl2;
        this.async = sSLContext.asyncConnections;
        if (bl) {
            this.sock_timeout = socket == this ? super.getSoTimeout() : socket.getSoTimeout();
            try {
                this.sock_linger = socket == this ? super.getSoLinger() : socket.getSoLinger();
            }
            catch (Throwable throwable) {}
        }
        if (socket == this) {
            super.setSoTimeout(100);
        } else {
            socket.setSoTimeout(100);
        }
        try {
            socket.setSoLinger(true, 100);
        }
        catch (Throwable throwable) {}
        this.conn = !bl2 ? new SSLClient(this, bl, sSLContext, n, !this.async, object) : new SSLServer(this, bl, sSLContext, !this.async, object);
    }

    final void uninstall(boolean bl) throws IOException {
        if (bl) {
            boolean bl2 = this.sock_linger != -1;
            int n = this.sock_linger = bl2 ? this.sock_linger : 0;
            if (this.sock == this) {
                try {
                    super.setSoLinger(bl2, this.sock_linger);
                }
                catch (Throwable throwable) {}
                super.setSoTimeout(this.sock_timeout);
                return;
            }
            try {
                this.sock.setSoLinger(bl2, this.sock_linger);
            }
            catch (Throwable throwable) {}
            this.sock.setSoTimeout(this.sock_timeout);
            return;
        }
        if (this == this.sock) {
            super.close();
            return;
        }
        this.sock.close();
    }

    final OutputStream getRawOutputStream() throws IOException {
        if (this == this.sock) {
            return super.getOutputStream();
        }
        return this.sock.getOutputStream();
    }

    final InputStream getRawInputStream() throws IOException {
        if (this == this.sock) {
            return super.getInputStream();
        }
        return this.sock.getInputStream();
    }

    public void close() throws IOException {
        this.conn.close();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.conn.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        return this.conn.getInputStream();
    }

    public InetAddress getInetAddress() {
        if (this.sock == this) {
            return super.getInetAddress();
        }
        return this.sock.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        if (this.sock == this) {
            return super.getLocalAddress();
        }
        return this.sock.getLocalAddress();
    }

    public int getPort() {
        if (this.sock == this) {
            return super.getPort();
        }
        return this.sock.getPort();
    }

    public int getLocalPort() {
        if (this.sock == this) {
            return super.getLocalPort();
        }
        return this.sock.getLocalPort();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (this.cont.asyncConnections) {
            this.timeout = n;
        }
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
    }

    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    public String toString() {
        return "SSLGenSock[" + (this.sock == this ? super.toString() : this.sock.toString()) + "]";
    }
}

