/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import com.ibm.sslight.SSLCert;
import com.ibm.sslight.SSLConnection;
import com.ibm.sslight.SSLContext;
import com.ibm.sslight.SSLException;
import com.ibm.sslight.SSLGenSock;
import com.ibm.sslight.SSLSession;
import com.ibm.sslight.Util;
import java.io.IOException;
import java.math.BigInteger;

class SSLServer
extends SSLConnection {
    static final String JSKREL = new String("src/com/ibm/sslight/src/SSLServer.java, Java_SSL.SSLight, jsk4c, jsk4c000503");
    static final String FILEVER = new String("1.21");
    static final String BUILDDATE = new String("00/05/13 13:48:10");
    static final int CERT_VERIFY = 32;
    static BigInteger[] RSAKey64;
    static BigInteger[] RSAKey128;

    private static synchronized BigInteger[] getEphemeralRSAKey(boolean bl) {
        if (bl) {
            if (RSAKey64 == null) {
                RSAKey64 = Util.util28(64, true, true);
            }
            return RSAKey64;
        }
        if (RSAKey128 == null) {
            RSAKey128 = Util.util28(128, true, true);
        }
        return RSAKey128;
    }

    int install(boolean bl) {
        if (!bl || this.handshake_state == 2) {
            this.handshake_state = 2;
            if (bl) {
                return this.sendHelloRequest();
            }
        }
        return 0;
    }

    boolean uninstall(boolean bl) {
        return SSLSession.uninstall(this.session, this, bl);
    }

    int alert(byte by, byte by2) {
        if (by2 == 41 && this.context.handleNoPeerCertificate(this.correlator)) {
            return 0;
        }
        this.sendAlert((byte)2, (byte)40);
        return -1;
    }

    int handshake(byte[] byArray, byte by, int n, int n2, int n3) {
        switch (by) {
            case 1: {
                if ((2 & this.handshake_state) == 0) break;
                return this.clientHello(byArray, n, n2, n3);
            }
            case 11: {
                if ((4 & this.handshake_state) == 0) break;
                return this.clientCertificate(byArray, n, n2);
            }
            case 15: {
                if ((0x20 & this.handshake_state) == 0) break;
                return this.clientCertificateVerify(byArray, n, n2);
            }
            case 16: {
                if ((8 & this.handshake_state) == 0) break;
                return this.clientKeyExchange(byArray, n, n2);
            }
            case 20: {
                if ((0x10 & this.handshake_state) == 0) break;
                if (this.finished(byArray, n, n2) == 0) {
                    SSLSession.install(this.session, this);
                    this.reset();
                    this.handshake_state = 2;
                    return 0;
                }
                return -1;
            }
        }
        this.ssl_e = new SSLException(2, 1018, byArray, n, n2);
        this.sendAlert((byte)2, (byte)10);
        return -1;
    }

    private int clientCertificateVerify(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        SSLCert sSLCert = this.session.peer_cert[0];
        int n3 = n2 - 4;
        int n4 = n + 4;
        int n5 = sSLCert.alg == 1 ? 1 : 0;
        int n6 = 47;
        byte[] byArray3 = new byte[20 + n5 * 16];
        this.handshakeHash(null, byArray3, 0, n5);
        if ((n5 == 1 ? sSLCert.keyL : 40) == n3 - 2) {
            n3 = Util.msbf(byArray, n4, 2);
            n4 += 2;
        }
        if (n5 == 1 && n3 == sSLCert.keyL && (byArray2 = Util.util23(false, 1, sSLCert.BigIntegerKey(), byArray, n4, n3)) != null && byArray2.length == 36) {
            boolean bl;
            block4: {
                int n7 = 0;
                int n8 = 0;
                int n9 = 36;
                while (--n9 >= 0) {
                    if (byArray2[n7++] == byArray3[n8++]) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            int n10 = n6 = bl ? 0 : 40;
        }
        if (n6 == 0) {
            this.handshake_state = 1;
            this.update();
            this.register(byArray, n, n2);
            return 0;
        }
        this.ssl_e = new SSLException(2, 1008);
        this.sendAlert((byte)2, (byte)n6);
        return -1;
    }

    private int clientCertificate(byte[] byArray, int n, int n2) {
        if (this.certificate(byArray, n, n2) == -1) {
            return -1;
        }
        if ((SSLConnection.cipherSuite[this.session.cipher_suite & 0xFF] & 0xF00) != 256 && this.conn_cert[0].alg == 1 ^ this.session.peer_cert[0].alg == 1) {
            this.ssl_e = new SSLException(2, 1004);
            this.sendAlert((byte)2, (byte)40);
            return -1;
        }
        this.handshake_state = 8;
        this.register(byArray, n, n2);
        return 0;
    }

    private int clientKeyExchange(byte[] byArray, int n, int n2) {
        BigInteger[] bigIntegerArray;
        byte[] byArray2 = null;
        if ((SSLConnection.cipherSuite[this.session.cipher_suite & 0xFF] & 0xF00) == 256) {
            bigIntegerArray = this.key_exchange != null ? this.key_exchange : this.conn_key;
            int n3 = (bigIntegerArray[0].bitLength() + 7) / 8;
            if (n2 - 4 == n3) {
                byArray2 = Util.util23(false, 2, bigIntegerArray, byArray, n + 4, n3);
                if (byArray2 == null) {
                    this.ssl_e = new SSLException(1, 1021, byArray, n, n2);
                    this.fail_handshake = true;
                    byArray2 = new byte[48];
                } else if (byArray2.length != 48) {
                    this.ssl_e = new SSLException(1, 1015, byArray2, 0, byArray2.length);
                    this.fail_handshake = true;
                    int n4 = byArray2.length > 48 ? 48 : byArray2.length;
                    byte[] byArray3 = new byte[48];
                    System.arraycopy(byArray2, 0, byArray3, 0, n4);
                    byArray2 = byArray3;
                } else if (byArray2[0] != 3 || byArray2[1] != 0) {
                    this.ssl_e = new SSLException(1, 1030, byArray2, 0, 2);
                    this.fail_handshake = true;
                }
            } else {
                this.ssl_e = new SSLException(2, 1022, byArray, n, n2);
            }
        }
        this.key_exchange = null;
        if (byArray2 != null) {
            bigIntegerArray = (BigInteger[])new byte[48];
            this.blockHash(byArray2, (byte[])bigIntegerArray, 0);
            this.session.master_secret = (byte[])bigIntegerArray;
            if (this.session.peer_cert != null) {
                this.handshake_state = 32;
            } else {
                this.handshake_state = 1;
                this.update();
            }
            this.register(byArray, n, n2);
            return 0;
        }
        this.sendAlert((byte)2, (byte)47);
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private int clientHello(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        short[] sArray = null;
        if (n3 == 3) {
            n7 = n2 - 4;
            n6 = n + 4;
            if (n7 >= 35) {
                if (byArray[n6] != 3 || byArray[n6 + 1] != 0) {
                    this.ssl_e = new SSLException(1, 1030, byArray, n, n2, n6 - n);
                    this.sendAlert((byte)2, (byte)40);
                    return -1;
                }
                this.peerRandom(byArray, n6 += 2, 32);
                n6 += 32;
                n7 -= 34;
                n5 = byArray[n6++];
                if (n5 >= 0 && n5 <= 32 && --n7 >= n5) {
                    if (n5 > 0) {
                        byArray2 = new byte[n5];
                        System.arraycopy(byArray, n6, byArray2, 0, n5);
                        n6 += n5;
                        n7 -= n5;
                    }
                    if (n7 >= 2) {
                        n5 = Util.msbf(byArray, n6, 2);
                        n6 += 2;
                        if (n5 % 2 == 0 && n5 >= 2 && n5 <= 65535 && (n7 -= 2) >= n5) {
                            sArray = new short[n5 / 2];
                            int n8 = 0;
                            while (n8 < n5 / 2) {
                                sArray[n8] = (short)Util.msbf(byArray, n6, 2);
                                ++n8;
                                n6 += 2;
                            }
                            if ((n7 -= n5) >= 1 && (n5 = byArray[n6++]) >= 1 && n5 <= 255 && --n7 >= n5 && byArray[n6] != 0) {
                                byArray3 = new byte[n5];
                                System.arraycopy(byArray, n6, byArray3, 0, n5);
                            }
                        } else {
                            this.ssl_e = new SSLException(1, 1015, byArray, n, n2, n6 - n);
                        }
                    } else {
                        this.ssl_e = new SSLException(2, 1016);
                    }
                } else {
                    this.ssl_e = new SSLException(1, 1015, byArray, n, n2, n6 - n);
                }
            } else {
                this.ssl_e = new SSLException(1, 1015, byArray, n, n2);
            }
        } else {
            n6 = 1;
            if (byArray[n6] != 3 || byArray[n6 + 1] != 0) {
                this.ssl_e = new SSLException(1, 1030, byArray, 0, n2, n6);
                this.sendAlert((byte)2, (byte)40);
                return -1;
            }
            n6 += 2;
            int n9 = 0;
            n7 = n2 - 3;
            if (n7 >= 6) {
                int n10 = Util.msbf(byArray, n6, 2);
                int by = Util.msbf(byArray, n6 + 2, 2);
                int n8 = Util.msbf(byArray, n6 + 4, 2);
                n6 += 6;
                if ((n7 -= 6) == n10 + by + n8) {
                    if (n10 != 0 && n10 % 3 == 0 && (by == 0 || by == 16) && n8 >= 16) {
                        n5 = 0;
                        while (n5 < n10) {
                            n4 = Util.msbf(byArray, n6 + n5, 3);
                            if ((n4 & 0xFF0000) == 0) {
                                ++n9;
                            }
                            n5 += 3;
                        }
                        if (n9 != 0) {
                            sArray = new short[n9];
                            n9 = 0;
                            n5 = 0;
                            while (n5 < n10) {
                                n4 = Util.msbf(byArray, n6 + n5, 3);
                                if ((n4 & 0xFF0000) == 0) {
                                    sArray[n9++] = (short)(n4 & 0xFFFF);
                                }
                                n5 += 3;
                            }
                            n6 += n10;
                            n7 -= n10;
                            if (by != 0) {
                                byArray2 = new byte[by];
                                System.arraycopy(byArray, n6, byArray2, 0, by);
                                n6 += by;
                                n7 -= by;
                            }
                            this.peerRandom(byArray, n6, n8);
                        } else {
                            this.ssl_e = new SSLException(2, 1025, byArray, n, n2, n6);
                        }
                    } else {
                        this.ssl_e = new SSLException(1, 1011, byArray, n, n2);
                    }
                } else if (n7 < n10 + by + n8) {
                    this.ssl_e = new SSLException(1, 1015, byArray, n, n2);
                } else if (n7 > n10 + by + n8) {
                    this.ssl_e = new SSLException(1, 1014, byArray, n, n2);
                }
            } else {
                this.ssl_e = new SSLException(1, 1015, byArray, n, n2);
            }
        }
        if (sArray == null) {
            this.sendAlert((byte)2, (byte)47);
            return -1;
        }
        this.register(byArray, n, n2);
        try {
            short s;
            void var13_21;
            SSLSession sSLSession = null;
            boolean bl = false;
            boolean bl2 = false;
            n4 = 0;
            byte[] byArray4 = null;
            if (byArray2 != null) {
                sSLSession = SSLSession.resume(byArray2, this.context.context_id, byArray3, sArray);
                if (sSLSession != null) {
                    if (this.session != null && this.session != sSLSession) {
                        SSLSession.uninstall(this.session, this, true);
                    }
                    this.session = sSLSession;
                    byte by = this.session.compression_method;
                    short s2 = this.session.cipher_suite;
                }
            } else if (this.session != null) {
                SSLSession.uninstall(this.session, this, false);
                this.session = null;
            }
            if (this.session == null) {
                if (byArray3 != null) {
                    n5 = 0;
                    while (this.context.cm_list != null && n5 < byArray3.length) {
                        n6 = 0;
                        while (n6 < this.context.cm_list.length && byArray3[n5] != this.context.cm_list[n6]) {
                            ++n6;
                        }
                        if (n6 != this.context.cm_list.length) {
                            var13_21 = byArray3[n5];
                            break;
                        }
                        ++n5;
                    }
                    if (n5 == byArray3.length) {
                        throw new SSLException(2, 1026, byArray, n, n2);
                    }
                }
                int n9 = -1;
                if (sArray != null && this.context.cs_list != null) {
                    n5 = 0;
                    while (n5 < sArray.length) {
                        n6 = 0;
                        while (n6 < this.context.cs_list.length && sArray[n5] != this.context.cs_list[n6]) {
                            ++n6;
                        }
                        if (n6 != this.context.cs_list.length) {
                            s = sArray[n5];
                            break;
                        }
                        ++n5;
                    }
                }
                if (s == -1) {
                    throw new SSLException(2, 1025, byArray, n, n2);
                }
                n4 = SSLConnection.cipherSuite[s & 0xFF];
                if ((n4 & 0xFFFF0000) != 0) {
                    Object[] objectArray = null;
                    Object object = this.context.getCert(n4, null, 0, 0, this.correlator);
                    if (object instanceof Boolean) {
                        throw new SSLException(2, 1007);
                    }
                    objectArray = (Object[])object;
                    this.conn_cert = (SSLCert[])objectArray[0];
                    this.conn_key = (BigInteger[])objectArray[1];
                }
                this.session = new SSLSession(this.context.context_id, (byte)var13_21, s, this.context.timeout[1]);
                if (this.conn_cert != null && this.context.clientAuthentication && (byArray4 = this.context.getAuth(n4)) == null) {
                    throw new SSLException(2, 1005);
                }
            }
            if (this.sendServerHello((byte)var13_21, s) == -1) {
                return -1;
            }
            if (sSLSession != null) {
                this.update();
                this.handshake_state = 1;
                return this.sendFinished(true);
            }
            if (this.conn_cert != null && this.sendCertificate() == -1) {
                return -1;
            }
            if ((n4 & 0xF00) == 256 && (this.conn_cert[0].alg != 1 || (n4 & 0xF000) != 0 && this.conn_cert[0].keyL > 64)) {
                this.key_exchange = SSLServer.getEphemeralRSAKey((n4 & 0xF000) != 0);
            }
            if (this.key_exchange != null && this.sendServerKeyExchange() == -1) {
                return -1;
            }
            this.handshake_state = 8;
            if (byArray4 != null) {
                if (this.sendCertificateRequest(byArray4) == -1) {
                    return -1;
                }
                this.handshake_state |= 4;
            }
            return this.sendServerHelloDone();
        }
        catch (SSLException sSLException) {
            this.ssl_e = sSLException;
        }
        catch (Exception exception) {
            this.ssl_e = new SSLException(8, 1009, exception);
        }
        this.sendAlert((byte)2, (byte)40);
        return -1;
    }

    private int sendServerKeyExchange() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = SSLConnection.cipherSuite[this.session.cipher_suite & 0xFF];
        SSLCert sSLCert = null;
        if (this.conn_cert != null && this.conn_cert[0] != null) {
            sSLCert = this.conn_cert[0];
            n3 = sSLCert.alg == 12 ? 40 : this.conn_cert[0].keyL;
        }
        int n5 = n3 + 2;
        do {
            if (n2 == 1 && (n4 & 0xF00) == 256) continue;
            n5 += 3 + this.key_exchange[n2].bitLength() / 8;
        } while (++n2 < 3);
        int n6 = this.register(null, 0, 4 + n5);
        int n7 = n6 + 4;
        byte[] byArray = this.handshake;
        n2 = 0;
        do {
            int n8;
            if (n2 == 1 && (n4 & 0xF00) == 256) continue;
            byte[] byArray2 = this.key_exchange[n2].toByteArray();
            n = n8 = byArray2.length;
            int n9 = n7;
            int n10 = 2;
            do {
                byArray[n9++] = (byte)(n >>> --n10 * 8);
            } while (n10 > 0);
            System.arraycopy(byArray2, 0, byArray, n7 += 2, n8);
            n7 += n8;
        } while (++n2 < 3);
        int n11 = n7;
        n = 2;
        do {
            byArray[n11++] = (byte)(n3 >>> --n * 8);
        } while (n > 0);
        n7 += 2;
        if (this.conn_cert != null) {
            this.paramHash(byArray, n6 + 4, n5 - (2 + n3), byArray, n7, sSLCert.alg == 1 ? 1 : 0);
            if (sSLCert.alg == 1) {
                byte[] byArray3 = Util.util23(true, 1, this.conn_key, byArray, n7, 36);
                System.arraycopy(byArray3, 0, byArray, n7, n3);
            }
        }
        return this.sendHandshake((byte)12, byArray, n6, n5, false);
    }

    private int sendHelloRequest() {
        byte[] byArray = new byte[4];
        return this.sendHandshake((byte)0, byArray, 0, 0, true);
    }

    private int sendServerHello(byte by, short s) {
        this.out.enable(false);
        int n = this.session.session_id != null ? (int)this.session.session_id.length : 0;
        this.helloRandom();
        int n2 = 35 + n + 2 + 1;
        int n3 = this.register(null, 0, 4 + n2);
        int n4 = n3 + 4;
        byte[] byArray = this.handshake;
        byArray[n4] = 3;
        byArray[n4 + 1] = 0;
        System.arraycopy(this.random[1], 0, byArray, n4 + 2, 32);
        n4 += 34;
        byArray[n4++] = n;
        if (byArray[n4++] != 0) {
            System.arraycopy(this.session.session_id, 0, byArray, n4, n);
            n4 += n;
        }
        short s2 = s;
        int n5 = n4;
        int n6 = 2;
        do {
            byArray[n5++] = (byte)(s2 >>> --n6 * 8);
        } while (n6 > 0);
        byArray[n4 += 2] = by;
        return this.sendHandshake((byte)2, byArray, n3, n2, false);
    }

    private int sendServerHelloDone() {
        int n = this.register(null, 0, 4);
        return this.sendHandshake((byte)14, this.handshake, n, 0, true);
    }

    private int sendCertificateRequest(byte[] byArray) {
        int n = 1;
        int n2 = Util.msbf(byArray, 3, 2) + 5 - n;
        int n3 = this.register(null, 0, 4 + n2);
        System.arraycopy(byArray, n, this.handshake, n3 + 4, n2);
        if (n != 0) {
            this.handshake[n3 + 5] = (byte)(this.conn_cert[0].alg == 1 ? 1 : 2);
        }
        return this.sendHandshake((byte)13, this.handshake, n3, n2, false);
    }

    final boolean shouldUseStepup(SSLCert[] sSLCertArray) {
        return false;
    }

    SSLServer(SSLGenSock sSLGenSock, boolean bl, SSLContext sSLContext, boolean bl2, Object object) throws IOException, SSLException {
        this.install(sSLGenSock, bl, 1, sSLContext, bl2, object);
    }
}

