/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import java.math.BigInteger;
import java.util.Random;

final class Util {
    static final String JSKREL;
    static final String FILEVER;
    static final String BUILDDATE;
    static final String Opts;
    private static final BigInteger P64;
    private static final int[] syms;
    private static final byte[] sbuf;
    private static long accu;
    private static int bits;
    private static int nsam;
    private static byte[] seed;
    private static int ri;
    static int trMix;
    private static final byte[] Pmd2;
    private static final byte[] Prc2;
    private static final int[] PC;
    private static final int[] SP0;
    private static final int[] SP1;

    static boolean cmp(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (--n3 >= 0) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    static int msbf(byte[] byArray, int n, int n2) {
        int n3 = 0;
        do {
            n3 |= (byArray[n++] & 0xFF) << --n2 * 8;
        } while (n2 > 0);
        return n3;
    }

    static int msbf2(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    static void msbf(int n, byte[] byArray, int n2, int n3) {
        do {
            byArray[n2++] = (byte)(n >>> --n3 * 8);
        } while (n3 > 0);
    }

    static void msbf4(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    static void msbf2(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
    }

    public static void msbf(long l, byte[] byArray, int n, int n2) {
        do {
            byArray[n++] = (byte)(l >>> --n2 * 8);
        } while (n2 > 0);
    }

    static int lsbf(byte[] byArray, int n, int n2) {
        int n3 = 0;
        do {
            n3 |= (byArray[n + --n2] & 0xFF) << n2 * 8;
        } while (n2 > 0);
        return n3;
    }

    static int lsbf4(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    static void lsbf4(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >>> 8);
        byArray[n2 + 2] = (byte)(n >>> 16);
        byArray[n2 + 3] = (byte)(n >>> 24);
    }

    static void lsbf2(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >>> 8);
    }

    static void trng(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            BigInteger bigInteger;
            long l;
            if (bits >= 8) {
                byArray[--n2 + n] = (byte)(accu >>> (bits -= 8));
                continue;
            }
            double d = -Math.log(2.0);
            accu = 0L;
            int n3 = 0;
            do {
                Util.syms[n3] = 0;
            } while (++n3 < 16);
            int n4 = sbuf.length - 1;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (true) {
                int n9 = 0;
                do {
                    l = System.currentTimeMillis();
                    while (l == System.currentTimeMillis()) {
                        ++n9;
                    }
                } while (n9 == 0);
                Util.sbuf[n4] = (byte)(sbuf[n4] << 4 | n9 % 16);
                n4 -= n8;
                n8 ^= 1;
                if ((n5 - n9) * (n5 - n9) != 1) {
                    n5 = n9;
                }
                int n10 = n5 % 16;
                syms[n10] = syms[n10] + n7;
                n7 |= 1;
                if (n4 < 0) {
                    bigInteger = new BigInteger(1, sbuf);
                    accu ^= bigInteger.multiply(bigInteger).remainder(P64).longValue();
                    n4 += sbuf.length;
                    n7 = 0;
                }
                if (++n6 < nsam) continue;
                n3 = 0;
                double d2 = 0;
                do {
                    double d3;
                    double d4 = (double)syms[n3] / (double)n6;
                    if (!(d3 > 0.0)) continue;
                    d2 += d4 * Math.log(d4);
                } while (++n3 < 16);
                nsam = (int)(96.0 / (d2 /= d));
                if (nsam <= n6) break;
                nsam = d2 > 1.0 ? nsam + 3 : n6 + 32;
                n7 = 0;
            }
            bigInteger = new BigInteger(1, sbuf);
            accu ^= bigInteger.multiply(bigInteger).remainder(P64).longValue() ^ l;
            bits = 64;
        }
    }

    static void updateRandom(byte[] byArray, int n, int n2) {
        byte[] byArray2 = seed;
        synchronized (byArray2) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 % 32;
                seed[n4] = (byte)(seed[n4] ^ byArray[n++]);
                ++n3;
            }
            return;
        }
    }

    static void random(byte[] byArray, int n, int n2) {
        byte[] byArray2 = seed;
        synchronized (byArray2) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = ++ri % 8;
                if (ri % trMix == 0) {
                    byte by = seed[n4];
                    Util.trng(seed, n4, 1);
                    int n5 = n4;
                    seed[n5] = (byte)(seed[n5] ^ by);
                }
                if (n4 == 0) {
                    Util.util11(null, seed, 0, 32, seed, 0);
                }
                byArray[n++] = seed[n4];
                ++n3;
            }
            return;
        }
    }

    static void util06(int[] nArray, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 1732584193;
        int n5 = -271733879;
        int n6 = -1732584194;
        int n7 = 271733878;
        int n8 = -1009589776;
        int[] nArray2 = new int[80];
        int n9 = n2 / 4;
        boolean bl = false;
        boolean bl2 = false;
        do {
            int n10;
            int n11 = 0;
            while (n11 < 16 && n9 > 0) {
                nArray2[n11] = byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | byArray[n] << 24;
                --n9;
                n += 4;
                ++n11;
            }
            if (n11 < 16) {
                if (!bl2) {
                    n10 = n2 % 4;
                    int n12 = nArray2[n11++] = n10 != 0 ? Util.msbf(byArray, n, n10) << (4 - n10) * 8 | 1 << 31 - n10 * 8 : Integer.MIN_VALUE;
                    if (n11 == 15) {
                        nArray2[15] = 0;
                    }
                    bl2 = true;
                }
                if (n11 <= 14) {
                    while (n11 < 14) {
                        nArray2[n11++] = 0;
                    }
                    if (nArray != null) {
                        n2 += nArray[5];
                    }
                    nArray2[14] = n2 >>> 29;
                    nArray2[15] = n2 << 3;
                    bl = true;
                }
                n11 = 16;
            }
            do {
                n10 = nArray2[n11 - 3] ^ nArray2[n11 - 8] ^ nArray2[n11 - 14] ^ nArray2[n11 - 16];
                nArray2[n11] = n10 << 1 | n10 >>> 31;
            } while (++n11 < 80);
            int n13 = n4;
            int n14 = n5;
            int n15 = n6;
            int n16 = n7;
            int n17 = n8;
            n11 = 0;
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 & n6 | ~n5 & n7) + n8 + nArray2[n11] + 1518500249;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 20);
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 ^ n6 ^ n7) + n8 + nArray2[n11] + 1859775393;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 40);
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 & n6 | (n5 | n6) & n7) + n8 + nArray2[n11] + -1894007588;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 60);
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 ^ n6 ^ n7) + n8 + nArray2[n11] + -899497514;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 80);
            n4 += n13;
            n5 += n14;
            n6 += n15;
            n7 += n16;
            n8 += n17;
        } while (!bl);
        Util.msbf4(n4, byArray2, n3);
        Util.msbf4(n5, byArray2, n3 + 4);
        Util.msbf4(n6, byArray2, n3 + 8);
        Util.msbf4(n7, byArray2, n3 + 12);
        Util.msbf4(n8, byArray2, n3 + 16);
    }

    private static int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n += (n2 & n3 | ~n2 & n4) + n5 + n8) << n6 | n >>> n7) + n2;
    }

    private static int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n += (n2 & n4 | n3 & ~n4) + n5 + n8) << n6 | n >>> n7) + n2;
    }

    private static int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n += (n2 ^ n3 ^ n4) + n5 + n8) << n6 | n >>> n7) + n2;
    }

    private static int II(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n += (n3 ^ (n2 | ~n4)) + n5 + n8) << n6 | n >>> n7) + n2;
    }

    static void util11(int[] nArray, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 1732584193;
        int n5 = -271733879;
        int n6 = -1732584194;
        int n7 = 271733878;
        int n8 = n2 / 4;
        int[] nArray2 = new int[16];
        boolean bl = false;
        boolean bl2 = false;
        do {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            int n29 = 0;
            while (n29 < 16 && n8 > 0) {
                nArray2[n29++] = Util.lsbf4(byArray, n);
                --n8;
                n += 4;
            }
            if (n29 < 16) {
                if (!bl2) {
                    n28 = n2 % 4;
                    int n30 = nArray2[n29++] = n28 != 0 ? Util.lsbf(byArray, n, n28) | 128 << n28 * 8 : 128;
                    if (n29 == 15) {
                        nArray2[15] = 0;
                    }
                    bl2 = true;
                }
                if (n29 <= 14) {
                    while (n29 < 14) {
                        nArray2[n29++] = 0;
                    }
                    if (nArray != null) {
                        n2 += nArray[4];
                    }
                    nArray2[14] = n2 << 3;
                    nArray2[15] = n2 >>> 29;
                    bl = true;
                }
            }
            int n31 = n28 = n4;
            int n32 = n27 = nArray2[0];
            n4 = ((n31 += (n5 & n6 | ~n5 & n7) + n32 + -680876936) << 7 | n31 >>> 25) + n5;
            n31 = n26 = n7;
            n32 = n25 = nArray2[1];
            n7 = ((n31 += (n4 & n5 | ~n4 & n6) + n32 + -389564586) << 12 | n31 >>> 20) + n4;
            n31 = n24 = n6;
            n32 = n23 = nArray2[2];
            n6 = ((n31 += (n7 & n4 | ~n7 & n5) + n32 + 606105819) << 17 | n31 >>> 15) + n7;
            n31 = n22 = n5;
            n32 = n21 = nArray2[3];
            n5 = ((n31 += (n6 & n7 | ~n6 & n4) + n32 + -1044525330) << 22 | n31 >>> 10) + n6;
            n31 = n4;
            n32 = n20 = nArray2[4];
            n4 = ((n31 += (n5 & n6 | ~n5 & n7) + n32 + -176418897) << 7 | n31 >>> 25) + n5;
            n31 = n7;
            n32 = n19 = nArray2[5];
            n7 = ((n31 += (n4 & n5 | ~n4 & n6) + n32 + 1200080426) << 12 | n31 >>> 20) + n4;
            n31 = n6;
            n32 = n18 = nArray2[6];
            n6 = ((n31 += (n7 & n4 | ~n7 & n5) + n32 + -1473231341) << 17 | n31 >>> 15) + n7;
            n31 = n5;
            n32 = n17 = nArray2[7];
            n5 = ((n31 += (n6 & n7 | ~n6 & n4) + n32 + -45705983) << 22 | n31 >>> 10) + n6;
            n31 = n4;
            n32 = n16 = nArray2[8];
            n4 = ((n31 += (n5 & n6 | ~n5 & n7) + n32 + 1770035416) << 7 | n31 >>> 25) + n5;
            n31 = n7;
            n32 = n15 = nArray2[9];
            n7 = ((n31 += (n4 & n5 | ~n4 & n6) + n32 + -1958414417) << 12 | n31 >>> 20) + n4;
            n31 = n6;
            n32 = n14 = nArray2[10];
            n6 = ((n31 += (n7 & n4 | ~n7 & n5) + n32 + -42063) << 17 | n31 >>> 15) + n7;
            n31 = n5;
            n32 = n13 = nArray2[11];
            n5 = ((n31 += (n6 & n7 | ~n6 & n4) + n32 + -1990404162) << 22 | n31 >>> 10) + n6;
            n31 = n4;
            n32 = n12 = nArray2[12];
            n4 = ((n31 += (n5 & n6 | ~n5 & n7) + n32 + 1804603682) << 7 | n31 >>> 25) + n5;
            n31 = n7;
            n32 = n11 = nArray2[13];
            n7 = ((n31 += (n4 & n5 | ~n4 & n6) + n32 + -40341101) << 12 | n31 >>> 20) + n4;
            n31 = n6;
            n32 = n10 = nArray2[14];
            n6 = ((n31 += (n7 & n4 | ~n7 & n5) + n32 + -1502002290) << 17 | n31 >>> 15) + n7;
            n31 = n5;
            n32 = n9 = nArray2[15];
            n5 = ((n31 += (n6 & n7 | ~n6 & n4) + n32 + 1236535329) << 22 | n31 >>> 10) + n6;
            n31 = n4;
            n4 = ((n31 += (n5 & n7 | n6 & ~n7) + n25 + -165796510) << 5 | n31 >>> 27) + n5;
            n31 = n7;
            n7 = ((n31 += (n4 & n6 | n5 & ~n6) + n18 + -1069501632) << 9 | n31 >>> 23) + n4;
            n31 = n6;
            n6 = ((n31 += (n7 & n5 | n4 & ~n5) + n13 + 643717713) << 14 | n31 >>> 18) + n7;
            n31 = n5;
            n5 = ((n31 += (n6 & n4 | n7 & ~n4) + n27 + -373897302) << 20 | n31 >>> 12) + n6;
            n31 = n4;
            n4 = ((n31 += (n5 & n7 | n6 & ~n7) + n19 + -701558691) << 5 | n31 >>> 27) + n5;
            n31 = n7;
            n7 = ((n31 += (n4 & n6 | n5 & ~n6) + n14 + 38016083) << 9 | n31 >>> 23) + n4;
            n31 = n6;
            n6 = ((n31 += (n7 & n5 | n4 & ~n5) + n9 + -660478335) << 14 | n31 >>> 18) + n7;
            n31 = n5;
            n5 = ((n31 += (n6 & n4 | n7 & ~n4) + n20 + -405537848) << 20 | n31 >>> 12) + n6;
            n31 = n4;
            n4 = ((n31 += (n5 & n7 | n6 & ~n7) + n15 + 568446438) << 5 | n31 >>> 27) + n5;
            n31 = n7;
            n7 = ((n31 += (n4 & n6 | n5 & ~n6) + n10 + -1019803690) << 9 | n31 >>> 23) + n4;
            n31 = n6;
            n6 = ((n31 += (n7 & n5 | n4 & ~n5) + n21 + -187363961) << 14 | n31 >>> 18) + n7;
            n31 = n5;
            n5 = ((n31 += (n6 & n4 | n7 & ~n4) + n16 + 1163531501) << 20 | n31 >>> 12) + n6;
            n31 = n4;
            n4 = ((n31 += (n5 & n7 | n6 & ~n7) + n11 + -1444681467) << 5 | n31 >>> 27) + n5;
            n31 = n7;
            n7 = ((n31 += (n4 & n6 | n5 & ~n6) + n23 + -51403784) << 9 | n31 >>> 23) + n4;
            n31 = n6;
            n6 = ((n31 += (n7 & n5 | n4 & ~n5) + n17 + 1735328473) << 14 | n31 >>> 18) + n7;
            n31 = n5;
            n5 = ((n31 += (n6 & n4 | n7 & ~n4) + n12 + -1926607734) << 20 | n31 >>> 12) + n6;
            n31 = n4;
            n4 = ((n31 += (n5 ^ n6 ^ n7) + n19 + -378558) << 4 | n31 >>> 28) + n5;
            n31 = n7;
            n7 = ((n31 += (n4 ^ n5 ^ n6) + n16 + -2022574463) << 11 | n31 >>> 21) + n4;
            n31 = n6;
            n6 = ((n31 += (n7 ^ n4 ^ n5) + n13 + 1839030562) << 16 | n31 >>> 16) + n7;
            n31 = n5;
            n5 = ((n31 += (n6 ^ n7 ^ n4) + n10 + -35309556) << 23 | n31 >>> 9) + n6;
            n31 = n4;
            n4 = ((n31 += (n5 ^ n6 ^ n7) + n25 + -1530992060) << 4 | n31 >>> 28) + n5;
            n31 = n7;
            n7 = ((n31 += (n4 ^ n5 ^ n6) + n20 + 1272893353) << 11 | n31 >>> 21) + n4;
            n31 = n6;
            n6 = ((n31 += (n7 ^ n4 ^ n5) + n17 + -155497632) << 16 | n31 >>> 16) + n7;
            n31 = n5;
            n5 = ((n31 += (n6 ^ n7 ^ n4) + n14 + -1094730640) << 23 | n31 >>> 9) + n6;
            n31 = n4;
            n4 = ((n31 += (n5 ^ n6 ^ n7) + n11 + 681279174) << 4 | n31 >>> 28) + n5;
            n31 = n7;
            n7 = ((n31 += (n4 ^ n5 ^ n6) + n27 + -358537222) << 11 | n31 >>> 21) + n4;
            n31 = n6;
            n6 = ((n31 += (n7 ^ n4 ^ n5) + n21 + -722521979) << 16 | n31 >>> 16) + n7;
            n31 = n5;
            n5 = ((n31 += (n6 ^ n7 ^ n4) + n18 + 76029189) << 23 | n31 >>> 9) + n6;
            n31 = n4;
            n4 = ((n31 += (n5 ^ n6 ^ n7) + n15 + -640364487) << 4 | n31 >>> 28) + n5;
            n31 = n7;
            n7 = ((n31 += (n4 ^ n5 ^ n6) + n12 + -421815835) << 11 | n31 >>> 21) + n4;
            n31 = n6;
            n6 = ((n31 += (n7 ^ n4 ^ n5) + n9 + 530742520) << 16 | n31 >>> 16) + n7;
            n31 = n5;
            n5 = ((n31 += (n6 ^ n7 ^ n4) + n23 + -995338651) << 23 | n31 >>> 9) + n6;
            n31 = n4;
            n4 = ((n31 += (n6 ^ (n5 | ~n7)) + n27 + -198630844) << 6 | n31 >>> 26) + n5;
            n31 = n7;
            n7 = ((n31 += (n5 ^ (n4 | ~n6)) + n17 + 1126891415) << 10 | n31 >>> 22) + n4;
            n31 = n6;
            n6 = ((n31 += (n4 ^ (n7 | ~n5)) + n10 + -1416354905) << 15 | n31 >>> 17) + n7;
            n31 = n5;
            n5 = ((n31 += (n7 ^ (n6 | ~n4)) + n19 + -57434055) << 21 | n31 >>> 11) + n6;
            n31 = n4;
            n4 = ((n31 += (n6 ^ (n5 | ~n7)) + n12 + 1700485571) << 6 | n31 >>> 26) + n5;
            n31 = n7;
            n7 = ((n31 += (n5 ^ (n4 | ~n6)) + n21 + -1894986606) << 10 | n31 >>> 22) + n4;
            n31 = n6;
            n6 = ((n31 += (n4 ^ (n7 | ~n5)) + n14 + -1051523) << 15 | n31 >>> 17) + n7;
            n31 = n5;
            n5 = ((n31 += (n7 ^ (n6 | ~n4)) + n25 + -2054922799) << 21 | n31 >>> 11) + n6;
            n31 = n4;
            n4 = ((n31 += (n6 ^ (n5 | ~n7)) + n16 + 1873313359) << 6 | n31 >>> 26) + n5;
            n31 = n7;
            n7 = ((n31 += (n5 ^ (n4 | ~n6)) + n9 + -30611744) << 10 | n31 >>> 22) + n4;
            n31 = n6;
            n6 = ((n31 += (n4 ^ (n7 | ~n5)) + n18 + -1560198380) << 15 | n31 >>> 17) + n7;
            n31 = n5;
            n5 = ((n31 += (n7 ^ (n6 | ~n4)) + n11 + 1309151649) << 21 | n31 >>> 11) + n6;
            n31 = n4;
            n4 = ((n31 += (n6 ^ (n5 | ~n7)) + n20 + -145523070) << 6 | n31 >>> 26) + n5;
            n31 = n7;
            n7 = ((n31 += (n5 ^ (n4 | ~n6)) + n13 + -1120210379) << 10 | n31 >>> 22) + n4;
            n31 = n6;
            n6 = ((n31 += (n4 ^ (n7 | ~n5)) + n23 + 718787259) << 15 | n31 >>> 17) + n7;
            n31 = n5;
            n5 = ((n31 += (n7 ^ (n6 | ~n4)) + n15 + -343485551) << 21 | n31 >>> 11) + n6 + n22;
            n4 += n28;
            n6 += n24;
            n7 += n26;
        } while (!bl);
        Util.lsbf4(n4, byArray2, n3);
        Util.lsbf4(n5, byArray2, n3 + 4);
        Util.lsbf4(n6, byArray2, n3 + 8);
        Util.lsbf4(n7, byArray2, n3 + 12);
    }

    static void util12(byte[][] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) {
        byte[] byArray4 = Pmd2;
        byte by = 0;
        byte[] byArray5 = new byte[16];
        byte[] byArray6 = new byte[48];
        do {
            byte by2 = byArray5[15];
            int n4 = 0;
            do {
                if (n2 > 0) {
                    by = byArray2[n++];
                    --n2;
                } else if (n2 == 0) {
                    by = (byte)(16 - n4);
                    --n2;
                } else if (n2 == -2) {
                    by = byArray5[n4];
                }
                byte by3 = by;
                byArray6[n4 + 16] = by3;
                byArray6[n4 + 32] = (byte)(byArray6[n4] ^ by3);
                int n5 = n4++;
                byte by4 = (byte)(byArray5[n5] ^ byArray4[(by ^ by2) & 0xFF]);
                byArray5[n5] = by4;
                by2 = by4;
            } while (n4 < 16);
            if (n2 <= 0) {
                --n2;
            }
            by2 = 0;
            n4 = 0;
            do {
                int n6 = 0;
                do {
                    int n7 = n6++;
                    byte by5 = (byte)(byArray6[n7] ^ byArray4[by2 & 0xFF]);
                    byArray6[n7] = by5;
                    by2 = by5;
                } while (n6 < 48);
                by2 = (byte)(by2 + n4);
            } while (++n4 < 18);
        } while (n2 > -3);
        System.arraycopy(byArray6, 0, byArray3, n3, 16);
    }

    static byte[] util13(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[258];
        int n3 = 0;
        int n4 = 0;
        do {
            byArray2[n3] = (byte)n3;
        } while (++n3 < 256);
        n3 = 0;
        do {
            n4 = n4 + byArray2[n3] + byArray[(n3 + n) % n2] & 0xFF;
            byte by = byArray2[n3];
            byArray2[n3] = byArray2[n4];
            byArray2[n4] = by;
        } while (++n3 < 256);
        return byArray2;
    }

    static void util14(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) {
        if ((n2 += n) == n) {
            return;
        }
        int n4 = byArray[256] & 0xFF;
        int n5 = byArray[257] & 0xFF;
        if (n == n3) {
            do {
                n4 = n4 + 1 & 0xFF;
                byte by = byArray[n4];
                n5 = n5 + by & 0xFF;
                byte by2 = byArray[n5];
                byArray[n5] = by;
                byArray[n4] = by2;
                byArray3[n] = (byte)(byArray2[n] ^ byArray[byArray[n5] + byArray[n4] & 0xFF]);
            } while (++n < n2);
        } else {
            do {
                n4 = n4 + 1 & 0xFF;
                byte by = byArray[n4];
                n5 = n5 + by & 0xFF;
                byte by3 = byArray[n5];
                int n6 = n3++;
                byArray[n5] = by;
                byArray[n4] = by3;
                byArray3[n6] = (byte)(byArray2[n] ^ byArray[byArray[n5] + byArray[n4] & 0xFF]);
            } while (++n < n2);
        }
        byArray[256] = (byte)n4;
        byArray[257] = (byte)n5;
    }

    static int[] util15(boolean bl, byte[] byArray, int n, int n2) {
        int[] nArray = new int[64];
        byte[] byArray2 = new byte[128];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        int n3 = n2;
        do {
            byArray2[n3] = Prc2[byArray2[n3 - 1] + byArray2[n3 - n2] & 0xFF];
        } while (++n3 < 128);
        byArray2[128 - n2] = Prc2[byArray2[128 - n2] & 0xFF];
        n3 = 127 - n2;
        do {
            byArray2[n3] = Prc2[(byArray2[n3 + 1] ^ byArray2[n3 + n2]) & 0xFF];
        } while (--n3 >= 0);
        n3 = 0;
        do {
            nArray[n3 / 2] = (byArray2[n3] & 0xFF) + 256 * (byArray2[n3 + 1] & 0xFF);
        } while ((n3 += 2) < 128);
        return nArray;
    }

    static void util16(boolean bl, int[] nArray, byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (byArray != null) {
            n4 = Util.lsbf(byArray, 0, 2);
            n5 = Util.lsbf(byArray, 2, 2);
            n6 = Util.lsbf(byArray, 4, 2);
            n7 = Util.lsbf(byArray, 6, 2);
        }
        n2 += n;
        while (n < n2) {
            int n12;
            int n13;
            int n14;
            int n15 = byArray2[n] & 0xFF | (byArray2[n + 1] & 0xFF) << 8;
            int n16 = byArray2[n + 2] & 0xFF | (byArray2[n + 3] & 0xFF) << 8;
            int n17 = byArray2[n + 4] & 0xFF | (byArray2[n + 5] & 0xFF) << 8;
            int n18 = byArray2[n + 6] & 0xFF | (byArray2[n + 7] & 0xFF) << 8;
            n += 8;
            if (bl) {
                if (byArray != null) {
                    n15 ^= n4;
                    n16 ^= n5;
                    n17 ^= n6;
                    n18 ^= n7;
                }
                n14 = 0;
                n13 = 0;
                n12 = 0;
                while (true) {
                    n15 += nArray[n14] + (n18 & n17) + (~n18 & n16);
                    n15 = n15 << 1 | (n15 & 0xFFFF) >>> 15;
                    n16 += nArray[n14 + 1] + (n15 & n18) + (~n15 & n17);
                    n16 = n16 << 2 | (n16 & 0xFFFF) >>> 14;
                    n17 += nArray[n14 + 2] + (n16 & n15) + (~n16 & n18);
                    n17 = n17 << 3 | (n17 & 0xFFFF) >>> 13;
                    n18 += nArray[n14 + 3] + (n17 & n16) + (~n17 & n15);
                    n18 = n18 << 5 | (n18 & 0xFFFF) >>> 11;
                    n14 += 4;
                    if (++n12 < 5) continue;
                    if (n14 == 64) break;
                    n17 += nArray[(n16 += nArray[(n15 += nArray[n18 & 0x3F]) & 0x3F]) & 0x3F];
                    n18 += nArray[n17 & 0x3F];
                    n12 = n13 ^= 0xFFFFFFFF;
                }
                if (byArray != null) {
                    n4 = n15;
                    n5 = n16;
                    n6 = n17;
                    n7 = n18;
                }
            } else {
                if (byArray != null) {
                    n8 = n15;
                    n9 = n16;
                    n10 = n17;
                    n11 = n18;
                }
                n14 = 63;
                n13 = 0;
                n12 = 0;
                while (true) {
                    n18 = (n18 << 11 | (n18 & 0xFFFF) >>> 5) - nArray[n14] - ((n17 & n16) + (~n17 & n15));
                    n17 = (n17 << 13 | (n17 & 0xFFFF) >>> 3) - nArray[n14 - 1] - ((n16 & n15) + (~n16 & n18));
                    n16 = (n16 << 14 | (n16 & 0xFFFF) >>> 2) - nArray[n14 - 2] - ((n15 & n18) + (~n15 & n17));
                    n15 = (n15 << 15 | (n15 & 0xFFFF) >>> 1) - nArray[n14 - 3] - ((n18 & n17) + (~n18 & n16));
                    n14 -= 4;
                    if (++n12 < 5) continue;
                    if (n14 < 0) break;
                    n18 -= nArray[n17 & 0x3F];
                    n17 -= nArray[n16 & 0x3F];
                    n16 -= nArray[n15 & 0x3F];
                    n15 -= nArray[n18 & 0x3F];
                    n12 = n13 ^= 0xFFFFFFFF;
                }
                if (byArray != null) {
                    n15 ^= n4;
                    n16 ^= n5;
                    n17 ^= n6;
                    n18 ^= n7;
                    n4 = n8;
                    n5 = n9;
                    n6 = n10;
                    n7 = n11;
                }
            }
            byArray3[n3] = (byte)n15;
            byArray3[n3 + 1] = (byte)(n15 >>> 8);
            int n19 = n3 + 2;
            byArray3[n19] = (byte)n16;
            byArray3[n19 + 1] = (byte)(n16 >>> 8);
            n19 = n3 + 4;
            byArray3[n19] = (byte)n17;
            byArray3[n19 + 1] = (byte)(n17 >>> 8);
            n19 = n3 + 6;
            byArray3[n19] = (byte)n18;
            byArray3[n19 + 1] = (byte)(n18 >>> 8);
            n3 += 8;
        }
        if (byArray != null) {
            byArray[0] = (byte)n4;
            byArray[1] = (byte)(n4 >>> 8);
            byArray[2] = (byte)n5;
            byArray[3] = (byte)(n5 >>> 8);
            byArray[4] = (byte)n6;
            byArray[5] = (byte)(n6 >>> 8);
            byArray[6] = (byte)n7;
            byArray[7] = (byte)(n7 >>> 8);
        }
    }

    static int[] util17(boolean bl, byte[] byArray, int n, int n2) {
        int[] nArray = PC;
        int[] nArray2 = new int[n2 * 4];
        int n3 = 0;
        boolean bl2 = bl;
        do {
            int n4 = Util.lsbf4(byArray, n + n3);
            int n5 = Util.lsbf4(byArray, n + n3 + 4);
            int n6 = (n5 >>> 4 ^ n4) & 0xF0F0F0F;
            n4 ^= n6;
            n5 ^= n6 << 4;
            n6 = (n4 << 18 ^ n4) & 0xCCCC0000;
            n4 ^= n6 ^ n6 >>> 18;
            n6 = (n5 << 18 ^ n5) & 0xCCCC0000;
            n5 ^= n6 ^ n6 >>> 18;
            n6 = (n5 >>> 1 ^ n4) & 0x55555555;
            n4 ^= n6;
            n5 ^= n6 << 1;
            n6 = (n4 >>> 8 ^ n5) & 0xFF00FF;
            n5 ^= n6;
            n4 ^= n6 << 8;
            n6 = (n5 >>> 1 ^ n4) & 0x55555555;
            n5 ^= n6 << 1;
            n5 = n5 << 16 & 0xFF0000 | n5 & 0xFF00 | n5 >> 16 & 0xFF | (n4 ^= n6) >> 4 & 0xF000000;
            n4 &= 0xFFFFFFF;
            int n7 = 0;
            do {
                int n8 = (32508 >> n7 & 1) == 1 ? 2 : 1;
                n4 = (n4 >>> n8 | n4 << 28 - n8) & 0xFFFFFFF;
                int n9 = nArray[n4 & 0x3F] | nArray[0x40 | n4 >> 6 & 3 | n4 >> 7 & 0x3C] | nArray[0x80 | n4 >> 13 & 0xF | n4 >> 14 & 0x30] | nArray[0xC0 | n4 >> 20 & 1 | n4 >> 21 & 6 | n4 >> 22 & 0x38];
                n5 = (n5 >>> n8 | n5 << 28 - n8) & 0xFFFFFFF;
                n6 = nArray[0x100 | n5 & 0x3F] | nArray[0x140 | n5 >> 7 & 3 | n5 >> 8 & 0x3C] | nArray[0x180 | n5 >> 15 & 0x3F] | nArray[0x1C0 | n5 >> 21 & 0xF | n5 >> 22 & 0x30];
                int n10 = (bl ? n3 : n2 - n3 - 8) * 4 + (bl2 ? n7 : 15 - n7) * 2;
                nArray2[n10] = n6 << 16 | n9 & 0xFFFF;
                n9 = n9 >>> 16 | n6 & 0xFFFF0000;
                nArray2[n10 + 1] = n9 << 4 | n9 >>> 28;
            } while (++n7 < 16);
            bl2 ^= true;
        } while ((n3 += 8) < n2);
        return nArray2;
    }

    static void util18(boolean bl, int[] nArray, byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) {
        int[] nArray2 = SP0;
        int[] nArray3 = SP1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = nArray.length;
        if (byArray != null) {
            n4 = Util.lsbf4(byArray, 0);
            n5 = Util.lsbf4(byArray, 4);
        }
        n2 += n;
        while (n < n2) {
            int n9 = Util.lsbf4(byArray2, n);
            int n10 = Util.lsbf4(byArray2, n + 4);
            n += 8;
            if (byArray != null) {
                if (bl) {
                    n9 ^= n4;
                    n10 ^= n5;
                } else {
                    n6 = n9;
                    n7 = n10;
                }
            }
            int n11 = (n10 >>> 4 ^ n9) & 0xF0F0F0F;
            n9 ^= n11;
            n10 ^= n11 << 4;
            n11 = (n9 >>> 16 ^ n10) & 0xFFFF;
            n10 ^= n11;
            n9 ^= n11 << 16;
            n11 = (n10 >>> 2 ^ n9) & 0x33333333;
            n9 ^= n11;
            n10 ^= n11 << 2;
            n11 = (n9 >>> 8 ^ n10) & 0xFF00FF;
            n10 ^= n11;
            n9 ^= n11 << 8;
            n11 = (n10 >>> 1 ^ n9) & 0x55555555;
            int n12 = (n10 ^= n11 << 1) << 1 | n10 >>> 31;
            n10 = (n9 ^= n11) << 1 | n9 >>> 31;
            int n13 = 32;
            while (true) {
                n9 = n12;
                int n14 = n13 - 32;
                do {
                    n12 = n10 ^ nArray[n14 + 1];
                    n11 = n12 >>> 4 | n12 << 28 | 0xC040C040;
                    n12 = n10 ^ nArray[n14] | 0x80008000;
                    n9 ^= nArray2[n11 & 0x7F] | nArray2[n11 >>> 8 & 0xFF] | nArray3[n11 >>> 16 & 0x7F] | nArray3[n11 >>> 24] | nArray2[n12 & 0x3F] | nArray2[n12 >>> 8 & 0xBF] | nArray3[n12 >>> 16 & 0x3F] | nArray3[n12 >>> 24 & 0xBF];
                    n12 = n9 ^ nArray[n14 + 3];
                    n11 = n12 >>> 4 | n12 << 28 | 0xC040C040;
                    n12 = n9 ^ nArray[n14 + 2] | 0x80008000;
                    n10 ^= nArray2[n11 & 0x7F] | nArray2[n11 >>> 8 & 0xFF] | nArray3[n11 >>> 16 & 0x7F] | nArray3[n11 >>> 24] | nArray2[n12 & 0x3F] | nArray2[n12 >>> 8 & 0xBF] | nArray3[n12 >>> 16 & 0x3F] | nArray3[n12 >>> 24 & 0xBF];
                } while ((n14 += 4) < n13);
                if ((n13 += 32) > n8) break;
                n12 = n10;
                n10 = n9;
            }
            n9 = n9 >>> 1 | n9 << 31;
            n10 = n10 >>> 1 | n10 << 31;
            n11 = (n10 >>> 1 ^ n9) & 0x55555555;
            n9 ^= n11;
            n10 ^= n11 << 1;
            n11 = (n9 >>> 8 ^ n10) & 0xFF00FF;
            n10 ^= n11;
            n9 ^= n11 << 8;
            n11 = (n10 >>> 2 ^ n9) & 0x33333333;
            n9 ^= n11;
            n10 ^= n11 << 2;
            n11 = (n9 >>> 16 ^ n10) & 0xFFFF;
            n10 ^= n11;
            n9 ^= n11 << 16;
            n11 = (n10 >>> 4 ^ n9) & 0xF0F0F0F;
            n9 ^= n11;
            n10 ^= n11 << 4;
            if (byArray != null) {
                if (bl) {
                    n4 = n9;
                    n5 = n10;
                } else {
                    n9 ^= n4;
                    n10 ^= n5;
                    n4 = n6;
                    n5 = n7;
                }
            }
            if (byArray3 == null) continue;
            Util.lsbf4(n9, byArray3, n3);
            Util.lsbf4(n10, byArray3, n3 + 4);
            n3 += 8;
        }
        if (byArray != null) {
            Util.lsbf4(n4, byArray, 0);
            Util.lsbf4(n5, byArray, 4);
        }
    }

    static byte[] util23(boolean bl, int n, BigInteger[] bigIntegerArray, byte[] byArray, int n2, int n3) {
        int n4;
        Object object;
        int n5;
        int n6 = bigIntegerArray.length;
        int n7 = n6 < 4 ? bigIntegerArray[0].bitLength() : bigIntegerArray[3].bitLength() + bigIntegerArray[4].bitLength();
        int n8 = (n7 + 7) / 8;
        byte[] byArray2 = new byte[n8 + 1];
        System.arraycopy(byArray, n2, byArray2, n8 + 1 - n3, n3);
        if (bl && n != 0) {
            n5 = n8 - n3 - 3;
            object = null;
            byArray2[2] = (byte)n;
            if (byArray2[2] == 2) {
                object = new Random(System.currentTimeMillis() ^ (long)byArray.hashCode() ^ (long)n5);
            }
            int n9 = -1;
            n4 = 3;
            while (n5-- > 0) {
                if (n == 2) {
                    byte by;
                    do {
                        by = (byte)((Random)object).nextInt();
                        n9 = by;
                    } while (by == 0);
                }
                byArray2[n4++] = n9;
            }
        }
        BigInteger bigInteger = new BigInteger(byArray2);
        if (n6 > 3) {
            object = bigInteger.remainder(bigIntegerArray[3]).modPow(bigIntegerArray[5], bigIntegerArray[3]);
            BigInteger bigInteger2 = bigInteger.remainder(bigIntegerArray[4]).modPow(bigIntegerArray[6], bigIntegerArray[4]);
            bigInteger = ((BigInteger)object).add(bigIntegerArray[3]).subtract(bigInteger2).multiply(bigIntegerArray[7]).remainder(bigIntegerArray[3]).multiply(bigIntegerArray[4]).add(bigInteger2);
        } else {
            bigInteger = bigInteger.modPow(bigIntegerArray[1], bigIntegerArray[0]);
        }
        byArray2 = bigInteger.toByteArray();
        n6 = 0;
        if (bl || n == 3) {
            n5 = n8;
            n4 = byArray2.length - n5;
            if (n4 == 0) {
                return byArray2;
            }
            if (n4 < 0) {
                n6 = -n4;
                n4 = 0;
            }
        } else if (n == 0) {
            n4 = byArray2[0] == 0 && byArray2.length > 1 ? 1 : 0;
            n5 = byArray2.length - n4;
        } else if (byArray2[0] == n) {
            n4 = 1;
            while (n4 < byArray2.length && byArray2[n4++] != 0) {
            }
            n5 = byArray2.length - n4;
            if (n5 == 0) {
                return null;
            }
        } else {
            return null;
        }
        byte[] byArray3 = new byte[n5];
        object = byArray3;
        System.arraycopy(byArray2, n4, byArray3, n6, n5 - n6);
        return object;
    }

    static BigInteger[] util28(int n, boolean bl, boolean bl2) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4 = BigInteger.valueOf(bl2 ? 65537 : 3);
        BigInteger bigInteger5 = BigInteger.valueOf(1L);
        BigInteger bigInteger6 = BigInteger.valueOf(2L);
        byte[] byArray = new byte[(n /= 2) + 1];
        BigInteger bigInteger7 = null;
        while (true) {
            bigInteger3 = null;
            while (true) {
                if (bigInteger3 == null) {
                    Util.random(byArray, 1, n);
                    byArray[1] = (byte)(byArray[1] | 0xC0);
                    int n2 = n;
                    byArray[n2] = (byte)(byArray[n2] | 1);
                    bigInteger3 = new BigInteger(byArray);
                } else if ((bigInteger3 = bigInteger3.add(bigInteger6)).bitLength() > n * 8) {
                    bigInteger3 = null;
                    continue;
                }
                if (bigInteger3.isProbablePrime(32) && bigInteger4.gcd(bigInteger3.subtract(bigInteger5)).equals(bigInteger5)) break;
            }
            if (bigInteger7 == null) {
                bigInteger7 = bigInteger3;
                continue;
            }
            bigInteger2 = bigInteger7.multiply(bigInteger3);
            if (bigInteger2.bitLength() != n * 2 * 8) continue;
            bigInteger = bigInteger4.modInverse(bigInteger7.subtract(bigInteger5).multiply(bigInteger3.subtract(bigInteger5)));
            if (bigInteger7.modPow(bigInteger4, bigInteger2).modPow(bigInteger, bigInteger2).equals(bigInteger7)) break;
            bigInteger7 = null;
        }
        BigInteger[] bigIntegerArray = new BigInteger[bl ? 8 : 3];
        bigIntegerArray[0] = bigInteger2;
        bigIntegerArray[1] = bl ? null : bigInteger;
        bigIntegerArray[2] = bigInteger4;
        if (bl) {
            if (bigInteger7.compareTo(bigInteger3) < 0) {
                bigInteger4 = bigInteger7;
                bigInteger7 = bigInteger3;
                bigInteger3 = bigInteger4;
            }
            bigIntegerArray[3] = bigInteger7;
            bigIntegerArray[4] = bigInteger3;
            bigIntegerArray[5] = bigInteger.remainder(bigInteger7.subtract(bigInteger5));
            bigIntegerArray[6] = bigInteger.remainder(bigInteger3.subtract(bigInteger5));
            bigIntegerArray[7] = bigInteger3.modInverse(bigInteger7);
        }
        return bigIntegerArray;
    }

    static final byte getBits(String string, int n, int n2) {
        int n3 = n / 7;
        byte by = (byte)string.charAt(n3);
        int n4 = n % 7;
        by = (byte)(by & 127 >>> n4);
        if ((n4 = n2 - (7 - n4)) > 0) {
            return (byte)(by << n4 | (byte)string.charAt(n3 + 1) >>> 7 - n4);
        }
        if (n4 < 0) {
            return (byte)(by >>> -n4);
        }
        return by;
    }

    Util() {
    }

    static {
        int n;
        JSKREL = new String("src/com/ibm/sslight/src/Util.java, Java_SSL.SSLight, jsk4c, jsk4c000503");
        FILEVER = new String("1.9");
        BUILDDATE = new String("00/05/13 13:56:19");
        Opts = new String("Build Options = DES J11 LINGER LOCAL RC2 RC4 RSA ");
        P64 = new BigInteger("1000000000000000d", 16);
        syms = new int[16];
        sbuf = new byte[256];
        nsam = 64;
        seed = new byte[32];
        Util.trng(seed, 0, 32);
        Util.util11(null, seed, 0, 32, seed, 0);
        trMix = 128;
        Pmd2 = new byte[256];
        int n2 = 0;
        do {
            Util.Pmd2[n2] = Util.getBits("\u0014KH<M\u000b0|\u0000O&e%\u0007Yp\u0003\u0004l*8\u0017g@c\\qIDLWY^\u0013\u0010,Pz6W\u001e?:N\u0000YNB7F\u0011!?\u0014%>'1\u001amT{<IP>~Xul_n=*-\u0007LD+2\u0003OrL\u0010B\u0012\u000b\u0011\u0017d\u0018\u0003};\u001a-$\u0006\"9T}Lso~y8\u000f~\u0019\u0018,i\n-W#W/$E*bZUF'n\u0007\r\u0014ZH}[\u001d_F_\n8t\u0002<(YkA2d8ad\b2o\u001ees\u000b5\u0000\u0010m@%VkV\u000bOX8F0Z&D\u0003x\u001eU#hd=jF^:aW\u001f\u001cuk\u000bj\u0013\u000b\n0k:\n(B\u0002:=~7hA@S*&VpoH605?Q\u0013B{\u0004\u0003\u0017[\n)q\bJb|6\u001f![ieu?cX\u0000:9y;vps\u00191Pr)Nw\u0017cVu%BF\u0014\"Bi\u000fvGc-\\f\u001a3OD01 ", n2 * 8, 8);
        } while (++n2 < 256);
        Prc2 = new byte[256];
        n2 = 0;
        do {
            Util.Prc2[n2] = Util.getBits("l^\u001f\u001c g;5vJ\u001d\u001fke\u0015 l'8gq^\u0006+;\u0014qf\u00121I\b\"\"\u007f:\u0010^4Yzav4xMBE6c!\u0018\u000bte=GP\u001d85]v\u000bx%$\u0012\u0012qVNA\u0015\u001af,O\u001c`Y\u0007\u000e56\u0000)'F<;A\u0013W\u0014\u001f\u001do\\M\n\b{T\u0018(gK1\u0019_?\u00076HfH\u001d.'y\u00073;dQ\u0006\u0003|\u00048\u007f4C^>sAX=)?\u0010f\u000f5a\u000eG+=\u0000);^x%)e,\u001aS-\"TX5R8VBTKQ\u0017\u001fh\u0017@AE\u0013YBp\u0010-`zG\u0017L\u0012$5u\u0005\u0007hp\u001cf/CT\u0014G8Z\u001e_@\u0011Y6%*ef\u0012jwu\u0018qbR*p\u0017>)\b\u0019mKV'&\u0000s3|\u0019u Xc\u000b\u0000'uG\n\u0013)\u0006N\u0006A],g\u007fX.i\u0000b~s1fKX_\u001em\u000feRg\u000epU\u0018@h\u007f\u001fx\u001ah", n2 * 8, 8);
        } while (++n2 < 256);
        PC = new int[512];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        do {
            byte by = Util.getBits("\bu\u00011)Y\u001b\u0001(\"N\u0000$`\f\u0002-T@ \u001c\u0003\r\u00118@\u0013U\u0006 6\u000e\u0001$ \u0019@!\u001b\u0001\nI4H\tX\u0002K", n5 * 6, 6);
            n2 = by;
            if (by == 32) continue;
            n = 0;
            do {
                if ((1 << n3 & n) == 0) continue;
                int n6 = n4 + n;
                PC[n6] = PC[n6] | 1 << n2;
            } while (++n < 64);
            if ((n3 = (n3 + 1) % 6) != 0) continue;
            n4 += 64;
        } while (++n5 < 56);
        SP0 = new int[256];
        SP1 = new int[256];
        String string = "@\rs\u0014TY%\u001eK\u000b\"\tRYI95%2YW}\u0003\u0012\u0004A0\u0000\bI$(\u0000Q\u0014\u0002\u0002J\u0004D\u0012 (\u0000@Y\u0010!\u0016\u00020\u0001 \u0011-iC\u0007RX6(o\u007fA$\f\u0000`I\u0011\u0001P\u0005\u0000$4\u0006  \n\n\b(\f\u0000R\f\u0010A\u0004\u0011\u0010a@\u0004XSU\u0016.pe\u0007a@)\u0016K\u001as\u0016=&$Q\u0004V\rJ\u001bj\"gO\u0004\u0005\u0014l\u000emF[#(3\u0010)rEG\rpKc\u000e \u0000&J(mM\u0013\u00146Zd\u0000\u0004F\u001a-\u001d\u001cy&\u001cV\u0010\u000e8aqSI1%r`\u0015M9\u0014S4RFlh";
        int[] nArray = SP0;
        while (true) {
            n4 = 0;
            int n7 = 63;
            int n8 = 0;
            int n9 = 0;
            long l = 0L;
            n5 = 3;
            do {
                n = 0;
                do {
                    if (l == 0L) {
                        n9 = Util.getBits(string, n4, 8) & 0xFF;
                        if (n9 == 0) {
                            n4 += 8;
                            n += 64;
                            continue;
                        }
                        n4 += 8;
                        if (n9 == 255) {
                            n8 = 2;
                            continue;
                        }
                        l = 0L;
                        int n10 = 0;
                        do {
                            l <<= 8;
                            l |= (long)(Util.getBits(string, n4, 8) & 0xFF);
                            n4 += 8;
                        } while (++n10 < 8);
                    }
                    if ((l & 1L << n7) != 0L) {
                        int n11 = n;
                        nArray[n11] = nArray[n11] | n9 << n5 * 8;
                    }
                    ++n;
                    if (--n7 >= 0) continue;
                    n7 = 63;
                    l = 0L;
                    if (n8 <= 0) continue;
                    --n8;
                    n -= 64;
                } while (n < 256);
            } while (--n5 >= 0);
            if (nArray != SP0) break;
            nArray = SP1;
            string = "\u0001'%dK''$N\u0018d\t\u0012yGa4i\u0013GH\u0000\u0011K#G\u0016#'&fL\u0000\u0002\u000b\u0016\u001d\u000f\f\u001c\u001f9C\u0014\u0001c-\u0016RXpV\u001cxAG\u0014Z+)\fkRe\u007fP\t\u0018!\u000008\u0000B( \t\u0010\u0010\u0018#\u0010 ,\u0011A\u0002\u0012\t!\u0004\u0018\u0003 )\u0004\u0004\u0005]\u0014T^rFi-\u0002\bpYcltX\u0002k<\u0001R<lIK\u0016L9F\b\r\u001b\u0006_\u0013\u0018S\u001a.D\u0019,+\u00165\u0014\u0016fL\u007f|\u0001D\u0004\u0002H@BIB\b\u0001\n\u0002\u0004)!\u0004\f\u00004`!\u0006\fA\u0011\u0010`\u0012B\u0002\u0005\u0016<l\u0018N\u001ai5\u0014";
        }
    }
}

