/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SystemEventQueueUtilities;

public class RepaintManager {
    Hashtable dirtyComponents = new Hashtable();
    Hashtable tmpDirtyComponents = new Hashtable();
    Vector invalidComponents;
    boolean doubleBufferingEnabled = true;
    Image doubleBuffer;
    Dimension doubleBufferSize;
    private Dimension doubleBufferMaxSize;
    private static final Object repaintManagerKey = class$javax$swing$RepaintManager != null ? class$javax$swing$RepaintManager : (class$javax$swing$RepaintManager = RepaintManager.class$("javax.swing.RepaintManager"));
    Rectangle tmp = new Rectangle();
    static /* synthetic */ Class class$javax$swing$RepaintManager;

    public synchronized void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0 || jComponent == null) {
            return;
        }
        if (jComponent.getWidth() <= 0 || jComponent.getHeight() <= 0) {
            return;
        }
        JComponent jComponent2 = null;
        Container container = jComponent;
        while (container != null) {
            if (!container.isVisible() || container.getPeer() == null) {
                return;
            }
            if (container instanceof Window || container instanceof Applet) {
                jComponent2 = container;
                break;
            }
            container = container.getParent();
        }
        Rectangle rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        if (rectangle == null) {
            this.dirtyComponents.put(jComponent, new Rectangle(n, n2, n3, n4));
        } else {
            SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
        }
        SystemEventQueueUtilities.queueComponentWorkRequest(jComponent2);
    }

    public synchronized void addInvalidComponent(JComponent jComponent) {
        Component component = null;
        Container container = jComponent;
        while (container != null) {
            if (container instanceof CellRendererPane || container.getPeer() == null) {
                return;
            }
            if (container instanceof JComponent && container.isValidateRoot()) {
                component = container;
                break;
            }
            container = container.getParent();
        }
        if (component == null) {
            return;
        }
        Component component2 = null;
        Component component3 = component;
        while (component3 != null) {
            if (!component3.isVisible() || component3.getPeer() == null) {
                return;
            }
            if (component3 instanceof Window || component3 instanceof Applet) {
                component2 = component3;
                break;
            }
            component3 = component3.getParent();
        }
        if (component2 == null) {
            return;
        }
        if (this.invalidComponents == null) {
            this.invalidComponents = new Vector();
        } else {
            int n = this.invalidComponents.size();
            int n2 = 0;
            while (n2 < n) {
                if (component == (Component)this.invalidComponents.elementAt(n2)) {
                    return;
                }
                ++n2;
            }
        }
        this.invalidComponents.addElement(component);
        SystemEventQueueUtilities.queueComponentWorkRequest(component2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void collectDirtyComponents(Hashtable hashtable, JComponent jComponent, Vector vector) {
        Container container;
        boolean bl = false;
        Container container2 = jComponent;
        Container container3 = container2;
        Rectangle rectangle = jComponent._bounds;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.tmp = new Rectangle((Rectangle)hashtable.get(jComponent));
        SwingUtilities.computeIntersection(0, 0, rectangle.width, rectangle.height, this.tmp);
        if (this.tmp.isEmpty()) {
            return;
        }
        if (jComponent.isOpaque()) {
            bl = true;
        }
        while ((container = container3.getParent()) != null && container instanceof JComponent) {
            container3 = container;
            if (((JComponent)container3).isOpaque()) {
                bl = true;
            }
            n2 += rectangle.x;
            n4 += rectangle.y;
            this.tmp.setLocation(this.tmp.x + rectangle.x, this.tmp.y + rectangle.y);
            rectangle = ((JComponent)container3)._bounds;
            this.tmp = SwingUtilities.computeIntersection(0, 0, rectangle.width, rectangle.height, this.tmp);
            if (this.tmp.isEmpty()) {
                return;
            }
            if (hashtable.get(container3) == null) continue;
            container2 = container3;
            n = n2;
            n3 = n4;
        }
        if (jComponent != container2) {
            this.tmp.setLocation(this.tmp.x + n - n2, this.tmp.y + n3 - n4);
            Rectangle rectangle2 = (Rectangle)hashtable.get(container2);
            SwingUtilities.computeUnion(this.tmp.x, this.tmp.y, this.tmp.width, this.tmp.height, rectangle2);
        }
        if (!vector.contains(container2)) {
            vector.addElement(container2);
        }
    }

    public static RepaintManager currentManager(Component component) {
        RepaintManager repaintManager = (RepaintManager)SwingUtilities.appContextGet(repaintManagerKey);
        if (repaintManager == null) {
            repaintManager = new RepaintManager();
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
        }
        return repaintManager;
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager((Component)jComponent);
    }

    public Rectangle getDirtyRegion(JComponent jComponent) {
        Rectangle rectangle = null;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        }
        if (rectangle == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(rectangle);
    }

    public Dimension getDoubleBufferMaximumSize() {
        if (this.doubleBufferMaxSize == null) {
            this.doubleBufferMaxSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        return this.doubleBufferMaxSize;
    }

    public Image getOffscreenBuffer(Component component, int n, int n2) {
        Dimension dimension = this.getDoubleBufferMaximumSize();
        int n3 = n > dimension.width ? dimension.width : n;
        int n4 = n2 > dimension.height ? dimension.height : n2;
        if (this.doubleBuffer != null && (this.doubleBuffer.getWidth(null) < n3 || this.doubleBuffer.getHeight(null) < n4)) {
            this.doubleBuffer = null;
        }
        int n5 = n3;
        int n6 = n4;
        if (this.doubleBuffer != null) {
            n5 = this.doubleBufferSize.width;
            n6 = this.doubleBufferSize.height;
            if (this.doubleBufferSize.width < n3) {
                n5 = n3;
                this.doubleBuffer = null;
            }
            if (this.doubleBufferSize.height < n4) {
                n6 = n4;
                this.doubleBuffer = null;
            }
        }
        if (this.doubleBuffer == null) {
            this.doubleBuffer = component.createImage(n5, n6);
            this.doubleBufferSize = new Dimension(n5, n6);
        }
        return this.doubleBuffer;
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        Rectangle rectangle = this.getDirtyRegion(jComponent);
        return rectangle.width == Integer.MAX_VALUE && rectangle.height == Integer.MAX_VALUE;
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    public void markCompletelyClean(JComponent jComponent) {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            this.dirtyComponents.remove(jComponent);
        }
    }

    public void markCompletelyDirty(JComponent jComponent) {
        this.addDirtyRegion(jComponent, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void paintDirtyRegions() {
        JComponent jComponent;
        Object object = this;
        synchronized (object) {
            Hashtable hashtable = this.tmpDirtyComponents;
            this.tmpDirtyComponents = this.dirtyComponents;
            this.dirtyComponents = hashtable;
            this.dirtyComponents.clear();
        }
        int n = this.tmpDirtyComponents.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Vector vector = new Vector(n);
        Enumeration enumeration = this.tmpDirtyComponents.keys();
        while (enumeration.hasMoreElements()) {
            jComponent = (JComponent)enumeration.nextElement();
            this.collectDirtyComponents(this.tmpDirtyComponents, jComponent, vector);
        }
        n = vector.size();
        int n6 = 0;
        while (n6 < n) {
            jComponent = (JComponent)vector.elementAt(n6);
            object = (Rectangle)this.tmpDirtyComponents.get(jComponent);
            n4 = jComponent.getHeight();
            n5 = jComponent.getWidth();
            SwingUtilities.computeIntersection(n2, n3, n5, n4, (Rectangle)object);
            jComponent.paintImmediately(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            ++n6;
        }
        this.tmpDirtyComponents.clear();
    }

    public synchronized void removeInvalidComponent(JComponent jComponent) {
        int n;
        if (this.invalidComponents != null && (n = this.invalidComponents.indexOf(jComponent)) != -1) {
            this.invalidComponents.removeElementAt(n);
        }
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        if (repaintManager != null) {
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
        } else {
            SwingUtilities.appContextRemove(repaintManagerKey);
        }
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.doubleBufferMaxSize = dimension;
        if (this.doubleBuffer != null && (this.doubleBuffer.getWidth(null) > dimension.width || this.doubleBuffer.getHeight(null) > dimension.height)) {
            this.doubleBuffer = null;
        }
    }

    public void setDoubleBufferingEnabled(boolean bl) {
        this.doubleBufferingEnabled = bl;
        if (!this.doubleBufferingEnabled) {
            this.doubleBuffer = null;
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dirtyComponents != null) {
            stringBuffer.append(String.valueOf(String.valueOf(this.dirtyComponents)));
        }
        return stringBuffer.toString();
    }

    public void validateInvalidComponents() {
        Vector vector;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            if (this.invalidComponents == null) {
                Object var3_3 = null;
                return;
            }
            vector = this.invalidComponents;
            this.invalidComponents = null;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((Component)vector.elementAt(n2)).validate();
            ++n2;
        }
    }
}

