/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SystemEventQueueUtilities;
import javax.swing.text.View;

public class SwingUtilities
implements SwingConstants {
    private static boolean canAccessEventQueue = false;
    private static boolean eventQueueTested = false;
    static boolean is1dot2 = true;
    private static Class eventDispatchThreadClass;
    private static final Object sharedOwnerFrameKey;
    private static final Object dialogsKey;
    static Hashtable appContextTable;
    static /* synthetic */ Class class$java$lang$Class;

    static {
        try {
            Method method = (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = SwingUtilities.class$("java.lang.Class"))).getMethod("getProtectionDomain", null);
            is1dot2 = method != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            is1dot2 = false;
        }
        if (is1dot2) {
            System.err.println("warning: running 1.1 version of SwingUtilities");
        }
        eventDispatchThreadClass = null;
        sharedOwnerFrameKey = new StringBuffer("SwingUtilities.sharedOwnerFrame");
        dialogsKey = new StringBuffer("SwingUtilities.dialogs");
        appContextTable = new Hashtable(2);
    }

    private SwingUtilities() {
        throw new Error("SwingUtilities is just a container for static methods");
    }

    static Object appContextGet(Object object) {
        return appContextTable.get(object);
    }

    static void appContextPut(Object object, Object object2) {
        appContextTable.put(object, object2);
    }

    static void appContextRemove(Object object) {
        appContextTable.remove(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Rectangle[] computeDifference(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2 == null || !rectangle.intersects(rectangle2) || SwingUtilities.isRectangleContainingRectangle(rectangle2, rectangle)) {
            return new Rectangle[0];
        }
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = null;
        Rectangle rectangle5 = null;
        Rectangle rectangle6 = null;
        Rectangle rectangle7 = null;
        int n = 0;
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            rectangle3.x = rectangle.x;
            rectangle3.y = rectangle.y;
            rectangle3.width = rectangle2.x - rectangle.x;
            rectangle3.height = rectangle.height;
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle4 = new Rectangle(rectangle3);
                ++n;
            }
            rectangle3.x = rectangle2.x;
            rectangle3.y = rectangle.y;
            rectangle3.width = rectangle2.width;
            rectangle3.height = rectangle2.y - rectangle.y;
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle5 = new Rectangle(rectangle3);
                ++n;
            }
            rectangle3.x = rectangle2.x;
            rectangle3.y = rectangle2.y + rectangle2.height;
            rectangle3.width = rectangle2.width;
            rectangle3.height = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle6 = new Rectangle(rectangle3);
                ++n;
            }
            rectangle3.x = rectangle2.x + rectangle2.width;
            rectangle3.y = rectangle.y;
            rectangle3.width = rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width);
            rectangle3.height = rectangle.height;
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle7 = new Rectangle(rectangle3);
                ++n;
            }
        } else if (rectangle2.x <= rectangle.x && rectangle2.y <= rectangle.y) {
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                rectangle3.x = rectangle.x;
                rectangle3.y = rectangle2.y + rectangle2.height;
                rectangle3.width = rectangle.width;
                rectangle3.height = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n;
                }
            } else if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n;
                }
            } else {
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle2.y + rectangle2.height - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            }
        } else if (rectangle2.x <= rectangle.x && rectangle2.y + rectangle2.height >= rectangle.y + rectangle.height) {
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.y + rectangle.height - rectangle2.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            }
        } else if (rectangle2.x <= rectangle.x) {
            if (rectangle2.x + rectangle2.width >= rectangle.x + rectangle.width) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle2.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n;
                }
            }
        } else if (rectangle2.x <= rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
            if (rectangle2.y <= rectangle.y && rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n;
                }
            } else if (rectangle2.y <= rectangle.y) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle2.y + rectangle2.height - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            } else if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y, rectangle2.x - rectangle.x, rectangle.y + rectangle.height - rectangle2.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y, rectangle2.x - rectangle.x, rectangle2.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n;
                }
            }
        } else if (rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) {
            if (rectangle2.y <= rectangle.y && rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            } else if (rectangle2.y <= rectangle.y) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x, rectangle2.y + rectangle2.height, rectangle2.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x, rectangle.y, rectangle2.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n;
                }
            }
        }
        Rectangle[] rectangleArray = new Rectangle[n];
        n = 0;
        if (rectangle4 != null) {
            rectangleArray[n++] = rectangle4;
        }
        if (rectangle5 != null) {
            rectangleArray[n++] = rectangle5;
        }
        if (rectangle6 != null) {
            rectangleArray[n++] = rectangle6;
        }
        if (rectangle7 != null) {
            rectangleArray[n++] = rectangle7;
        }
        return rectangleArray;
    }

    public static Rectangle computeIntersection(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5 = n > rectangle.x ? n : rectangle.x;
        int n6 = n + n3 < rectangle.x + rectangle.width ? n + n3 : rectangle.x + rectangle.width;
        int n7 = n2 > rectangle.y ? n2 : rectangle.y;
        int n8 = n2 + n4 < rectangle.y + rectangle.height ? n2 + n4 : rectangle.y + rectangle.height;
        rectangle.x = n5;
        rectangle.y = n7;
        rectangle.width = n6 - n5;
        rectangle.height = n8 - n7;
        if (rectangle.width < 0 || rectangle.height < 0) {
            rectangle.height = 0;
            rectangle.width = 0;
            rectangle.y = 0;
            rectangle.x = 0;
        }
        return rectangle;
    }

    public static int computeStringWidth(FontMetrics fontMetrics, String string) {
        if (is1dot2) {
            return fontMetrics.stringWidth(string);
        }
        int[] nArray = fontMetrics.getWidths();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c > '\u00ff') {
                return fontMetrics.stringWidth(string);
            }
            n += nArray[c];
            ++n2;
        }
        return n;
    }

    public static Rectangle computeUnion(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5 = n < rectangle.x ? n : rectangle.x;
        int n6 = n + n3 > rectangle.x + rectangle.width ? n + n3 : rectangle.x + rectangle.width;
        int n7 = n2 < rectangle.y ? n2 : rectangle.y;
        int n8 = n2 + n4 > rectangle.y + rectangle.height ? n2 + n4 : rectangle.y + rectangle.height;
        rectangle.x = n5;
        rectangle.y = n7;
        rectangle.width = n6 - n5;
        rectangle.height = n8 - n7;
        return rectangle;
    }

    public static MouseEvent convertMouseEvent(Component component, MouseEvent mouseEvent, Component component2) {
        Point point = SwingUtilities.convertPoint(component, new Point(mouseEvent.getX(), mouseEvent.getY()), component2);
        Component component3 = component2 != null ? component2 : component;
        return new MouseEvent(component3, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    public static Point convertPoint(Component component, int n, int n2, Component component2) {
        Point point = new Point(n, n2);
        return SwingUtilities.convertPoint(component, point, component2);
    }

    public static Point convertPoint(Component component, Point point, Component component2) {
        if (component == null && component2 == null) {
            return point;
        }
        if (component == null && (component = SwingUtilities.getWindowAncestor(component2)) == null) {
            throw new Error("Source component not connected to component tree hierarchy");
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointToScreen(point2, component);
        if (component2 == null && (component2 = SwingUtilities.getWindowAncestor(component)) == null) {
            throw new Error("Destination component not connected to component tree hierarchy");
        }
        SwingUtilities.convertPointFromScreen(point2, component2);
        return point2;
    }

    public static void convertPointFromScreen(Point point, Component component) {
        do {
            int n;
            int n2;
            if (component instanceof JComponent) {
                n2 = ((JComponent)component).getX();
                n = ((JComponent)component).getY();
            } else if (component instanceof Applet) {
                Point point2 = component.getLocationOnScreen();
                n2 = point2.x;
                n = point2.y;
            } else {
                Rectangle rectangle = component.getBounds();
                n2 = rectangle.x;
                n = rectangle.y;
            }
            point.x -= n2;
            point.y -= n;
        } while (!(component instanceof Window) && !(component instanceof Applet) && (component = component.getParent()) != null);
    }

    public static void convertPointToScreen(Point point, Component component) {
        do {
            int n;
            int n2;
            if (component instanceof JComponent) {
                n2 = ((JComponent)component).getX();
                n = ((JComponent)component).getY();
            } else if (component instanceof Applet) {
                Point point2 = component.getLocationOnScreen();
                n2 = point2.x;
                n = point2.y;
            } else {
                Rectangle rectangle = component.getBounds();
                n2 = rectangle.x;
                n = rectangle.y;
            }
            point.x += n2;
            point.y += n;
        } while (!(component instanceof Window) && !(component instanceof Applet) && (component = component.getParent()) != null);
    }

    public static Rectangle convertRectangle(Component component, Rectangle rectangle, Component component2) {
        Point point = new Point(rectangle.x, rectangle.y);
        point = SwingUtilities.convertPoint(component, point, component2);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    static final void doPrivileged(Runnable runnable) {
        runnable.run();
    }

    public static Component findFocusOwner(Component component) {
        if (component instanceof Window) {
            return ((Window)component).getFocusOwner();
        }
        if (component instanceof JComponent && ((JComponent)component).hasFocus()) {
            return component;
        }
        if (component instanceof Container) {
            int n = ((Container)component).countComponents();
            int n2 = 0;
            while (n2 < n) {
                Component component2 = SwingUtilities.findFocusOwner(((Container)component).getComponent(n2));
                if (component2 != null) {
                    return component2;
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    public static Accessible getAccessibleAt(Component component, Point point) {
        if (component instanceof Accessible) {
            AccessibleContext accessibleContext;
            Accessible accessible = (Accessible)((Object)component);
            if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
                int n = accessibleContext.getAccessibleChildrenCount();
                int n2 = 0;
                while (n2 < n) {
                    AccessibleComponent accessibleComponent;
                    accessible = accessibleContext.getAccessibleChild(n2);
                    if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null && (accessibleComponent = accessibleContext.getAccessibleComponent()) != null && accessibleComponent.isShowing()) {
                        Point point2 = accessibleComponent.getLocation();
                        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                        if (accessibleComponent.contains(point3)) {
                            return accessible;
                        }
                    }
                    ++n2;
                }
            }
            return (Accessible)((Object)component);
        }
        Component component2 = component;
        if (!component.contains(point.x, point.y)) {
            component2 = null;
        } else if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n3 = 0;
            while (n3 < n) {
                Component component3 = container.getComponent(n3);
                if (component3 != null && component3.isShowing()) {
                    Point point4 = component3.getLocation();
                    if (component3.contains(point.x - point4.x, point.y - point4.y)) {
                        component2 = component3;
                    }
                }
                ++n3;
            }
        }
        if (component2 instanceof Accessible) {
            return (Accessible)((Object)component2);
        }
        return null;
    }

    public static Accessible getAccessibleChild(Component component, int n) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = 0;
            int n3 = 0;
            while (n3 < componentArray.length) {
                if (componentArray[n3] instanceof Accessible) {
                    if (n2 == n) {
                        return (Accessible)((Object)componentArray[n3]);
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        return null;
    }

    public static int getAccessibleChildrenCount(Component component) {
        int n = 0;
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof Accessible) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public static int getAccessibleIndexInParent(Component component) {
        int n = -1;
        Container container = component.getParent();
        if (container != null && container instanceof Accessible) {
            Component[] componentArray = container.getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof Accessible) {
                    ++n;
                }
                if (component.equals(componentArray[n2])) {
                    return n;
                }
                ++n2;
            }
        }
        return -1;
    }

    public static AccessibleStateSet getAccessibleStateSet(Component component) {
        AccessibleSelection accessibleSelection;
        AccessibleContext accessibleContext;
        Accessible accessible;
        AccessibleContext accessibleContext2;
        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
        if (component.isEnabled()) {
            accessibleStateSet.add(AccessibleState.ENABLED);
        }
        if (component.isFocusTraversable()) {
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
        }
        if (component.isVisible()) {
            accessibleStateSet.add(AccessibleState.VISIBLE);
        }
        if (component.isShowing()) {
            accessibleStateSet.add(AccessibleState.SHOWING);
        }
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Window && ((Window)container).getFocusOwner() == component) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            container = container.getParent();
        }
        if (component instanceof Accessible && (accessibleContext2 = ((Accessible)((Object)component)).getAccessibleContext()) != null && (accessible = accessibleContext2.getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            int n = accessibleContext2.getAccessibleIndexInParent();
            if (n >= 0 && accessibleSelection.isAccessibleChildSelected(n)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
        }
        if (component instanceof JComponent && ((JComponent)component).isOpaque()) {
            accessibleStateSet.add(AccessibleState.OPAQUE);
        }
        return accessibleStateSet;
    }

    public static Container getAncestorNamed(String string, Component component) {
        if (component == null || string == null) {
            return null;
        }
        Container container = component.getParent();
        while (container != null && !string.equals(container.getName())) {
            container = container.getParent();
        }
        return container;
    }

    public static Container getAncestorOfClass(Class clazz, Component component) {
        if (component == null || clazz == null) {
            return null;
        }
        Container container = component.getParent();
        while (container != null && !clazz.isInstance(container)) {
            container = container.getParent();
        }
        return container;
    }

    private static CellRendererPane getCellRendererPane(Component component, Container container) {
        Container container2 = component.getParent();
        if (container2 instanceof CellRendererPane) {
            if (container2.getParent() != container) {
                container.add(container2);
            }
        } else {
            container2 = new CellRendererPane();
            container2.add(component);
            container.add(container2);
        }
        return (CellRendererPane)container2;
    }

    public static Component getDeepestComponentAt(Component component, int n, int n2) {
        if (!component.contains(n, n2)) {
            return null;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n3 = 0;
            while (n3 < componentArray.length) {
                Component component2 = componentArray[n3];
                if (component2 != null) {
                    Point point = component2.getLocation();
                    if ((component2 = component2 instanceof Container ? SwingUtilities.getDeepestComponentAt(component2, n - point.x, n2 - point.y) : component2.getComponentAt(n - point.x, n2 - point.y)) != null && component2.isVisible()) {
                        return component2;
                    }
                }
                ++n3;
            }
        }
        return component;
    }

    public static Rectangle getLocalBounds(Component component) {
        Rectangle rectangle = new Rectangle(component.getBounds());
        rectangle.y = 0;
        rectangle.x = 0;
        return rectangle;
    }

    static JDialog getRecycledModalDialog(Frame frame, String string) {
        Vector vector = (Vector)SwingUtilities.appContextGet(dialogsKey);
        if (vector == null) {
            vector = new Vector();
            SwingUtilities.appContextPut(dialogsKey, vector);
        }
        JDialog jDialog = null;
        Vector vector2 = vector;
        synchronized (vector2) {
            int n = 0;
            while (n < vector.size()) {
                jDialog = (JDialog)vector.elementAt(n);
                if (jDialog.getParent() == frame) {
                    vector.removeElement(jDialog);
                    jDialog.setTitle(string);
                    JDialog jDialog2 = jDialog;
                    Object var6_7 = null;
                    return jDialog2;
                }
                ++n;
            }
            jDialog = new JDialog(frame, string, true);
        }
        return jDialog;
    }

    public static Component getRoot(Component component) {
        Component component2 = null;
        Component component3 = component;
        while (component3 != null) {
            if (component3 instanceof Window) {
                return component3;
            }
            if (component3 instanceof Applet) {
                component2 = component3;
            }
            component3 = component3.getParent();
        }
        return component2;
    }

    /*
     * Unable to fully structure code
     */
    public static JRootPane getRootPane(Component var0) {
        if (!(var0 instanceof RootPaneContainer)) ** GOTO lbl6
        return ((RootPaneContainer)var0).getRootPane();
lbl-1000:
        // 1 sources

        {
            if (var0 instanceof JRootPane) {
                return (JRootPane)var0;
            }
            var0 = var0.getParent();
lbl6:
            // 2 sources

            ** while (var0 != null)
        }
lbl7:
        // 1 sources

        return null;
    }

    static Frame getSharedOwnerFrame() {
        Frame frame = (Frame)SwingUtilities.appContextGet(sharedOwnerFrameKey);
        if (frame == null) {
            frame = new Frame(){

                public synchronized void dispose() {
                    try {
                        this.getToolkit().getSystemEventQueue();
                        super.dispose();
                    }
                    catch (Exception exception) {}
                }

                public void show() {
                }
            };
            SwingUtilities.appContextPut(sharedOwnerFrameKey, frame);
        }
        return frame;
    }

    private static Window getWindowAncestor(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public static void invokeAndWait(final Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        Object object = new Object(){

            public String toString() {
                return "SwingUtilities.invokeAndWait() lock for " + runnable;
            }
        };
        Exception exception = null;
        Object object2 = object;
        synchronized (object2) {
            exception = SystemEventQueueUtilities.postRunnable(runnable, object);
            object.wait();
        }
        if (exception != null) {
            throw new InvocationTargetException(exception);
        }
    }

    public static void invokeLater(Runnable runnable) {
        SystemEventQueueUtilities.postRunnable(runnable, null);
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        if (component == component2) {
            return true;
        }
        Container container = component.getParent();
        while (container != null) {
            if (container == component2) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    public static boolean isEventDispatchThread() {
        Thread thread = Thread.currentThread();
        if (eventDispatchThreadClass == null) {
            Class<?> clazz = thread.getClass();
            if (clazz.getName().indexOf("EventDispatchThread") >= 0 || clazz.getName().indexOf("JMEventQueue") >= 0) {
                eventDispatchThreadClass = clazz;
                return true;
            }
            return false;
        }
        return eventDispatchThreadClass.isInstance(thread);
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        if (is1dot2) {
            return (mouseEvent.getModifiers() & 0x10) != 0;
        }
        return (mouseEvent.getModifiers() & 0x10) != 0 || (mouseEvent.getModifiers() & 0xC) == 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 8) == 8;
    }

    public static final boolean isRectangleContainingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) == 4;
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        return SwingUtilities.layoutCompoundLabelImpl(null, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        boolean bl = true;
        int n6 = n2;
        int n7 = n4;
        switch (n2) {
            case 10: {
                n6 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n6 = bl ? 4 : 2;
                break;
            }
        }
        switch (n4) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
                break;
            }
        }
        return SwingUtilities.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, n, n6, n3, n7, rectangle, rectangle2, rectangle3, n5);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        View view = null;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = (int)view.getPreferredSpan(0);
                rectangle3.height = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle3.height = fontMetrics.getHeight();
            }
        }
        int n10 = n9 = bl || icon == null ? 0 : n5;
        if (!bl && rectangle3.width > (n8 = n4 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n9))) {
            if (view != null) {
                rectangle3.width = n8;
            } else {
                String string2 = "...";
                n7 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                n6 = 0;
                while (n6 < string.length()) {
                    if ((n7 += fontMetrics.charWidth(string.charAt(n6))) > n8) break;
                    ++n6;
                }
                string = String.valueOf(string.substring(0, n6)) + string2;
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
            }
        }
        rectangle3.y = n3 == 1 ? (n4 != 0 ? 0 : -(rectangle3.height + n9)) : (n3 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n4 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n9));
        rectangle3.x = n4 == 2 ? -(rectangle3.width + n9) : (n4 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n9);
        n8 = Math.min(rectangle2.x, rectangle3.x);
        int n11 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n8;
        n7 = Math.min(rectangle2.y, rectangle3.y);
        n6 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n7;
        int n12 = n == 1 ? rectangle.y - n7 : (n == 0 ? rectangle.y + rectangle.height / 2 - (n7 + n6 / 2) : rectangle.y + rectangle.height - (n7 + n6));
        int n13 = n2 == 2 ? rectangle.x - n8 : (n2 == 4 ? rectangle.x + rectangle.width - (n8 + n11) : rectangle.x + rectangle.width / 2 - (n8 + n11 / 2));
        rectangle3.x += n13;
        rectangle3.y += n12;
        rectangle2.x += n13;
        rectangle2.y += n12;
        return string;
    }

    static Class loadSystemClass(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4) {
        SwingUtilities.getCellRendererPane(component, container).paintComponent(graphics, component, container, n, n2, n3, n4, false);
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, Rectangle rectangle) {
        SwingUtilities.paintComponent(graphics, component, container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static void recycleModalDialog(JDialog jDialog) {
        Vector vector;
        Vector vector2 = vector = (Vector)SwingUtilities.appContextGet(dialogsKey);
        synchronized (vector2) {
            jDialog.getContentPane().removeAll();
            vector.addElement(jDialog);
        }
    }

    public static void updateComponentTreeUI(Component component) {
        SwingUtilities.updateComponentTreeUI0(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void updateComponentTreeUI0(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                SwingUtilities.updateComponentTreeUI0(componentArray[n]);
                ++n;
            }
        }
    }

    public static Window windowForComponent(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }
}

