/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class CompositeView
extends View {
    private static View[] ZERO = new View[0];
    private View[] children = new View[1];
    private int nchildren = 0;
    private short left;
    private short right;
    private short top;
    private short bottom;
    private Rectangle childAlloc = new Rectangle();

    public CompositeView(Element element) {
        super(element);
    }

    public void append(View view) {
        View[] viewArray = new View[]{view};
        this.replace(this.nchildren, 0, viewArray);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
            elementChange = null;
        }
        this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        this.updateLayout(elementChange, documentEvent, shape);
    }

    protected abstract void childAllocation(int var1, Rectangle var2);

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        return false;
    }

    void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element[] elementArray;
        int n;
        View view;
        int n2;
        Element element = this.getElement();
        int n3 = documentEvent.getOffset();
        int n4 = n2 = this.getViewIndexAtPosition(n3);
        View view2 = view = n2 >= 0 ? this.getView(n2) : null;
        if (view != null && view.getStartOffset() == n3 && n3 > 0) {
            n2 = Math.max(n2 - 1, 0);
        }
        if (documentEvent.getType() != DocumentEvent.EventType.REMOVE && (n4 = this.getViewIndexAtPosition(n3 + documentEvent.getLength())) < 0) {
            n4 = this.getViewCount() - 1;
        }
        int n5 = n = n4 + 1;
        Element[] elementArray2 = elementArray = elementChange != null ? elementChange.getChildrenAdded() : null;
        if (elementArray != null && elementArray.length > 0) {
            n = elementChange.getIndex();
            n5 = n + elementArray.length - 1;
        }
        int n6 = n2;
        while (n6 <= n4) {
            if ((n6 < n || n6 > n5) && (view = this.getView(n6)) != null) {
                Shape shape2 = this.getChildAllocation(n6, shape);
                this.forwardUpdateToView(view, documentEvent, shape2, viewFactory);
            }
            ++n6;
        }
    }

    void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        DocumentEvent.EventType eventType = documentEvent.getType();
        if (eventType == DocumentEvent.EventType.INSERT) {
            view.insertUpdate(documentEvent, shape, viewFactory);
        } else if (eventType == DocumentEvent.EventType.REMOVE) {
            view.removeUpdate(documentEvent, shape, viewFactory);
        } else {
            view.changedUpdate(documentEvent, shape, viewFactory);
        }
    }

    protected final short getBottomInset() {
        return this.bottom;
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        this.childAllocation(n, rectangle);
        return rectangle;
    }

    protected Rectangle getInsideAllocation(Shape shape) {
        if (shape != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.childAlloc.setBounds(rectangle);
            this.childAlloc.x += this.left;
            this.childAlloc.y += this.top;
            this.childAlloc.width -= this.left + this.right;
            this.childAlloc.height -= this.top + this.bottom;
            return this.childAlloc;
        }
        return null;
    }

    protected final short getLeftInset() {
        return this.left;
    }

    protected int getNextEastWestVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3;
        int n4;
        boolean bl = n2 == 3;
        Rectangle rectangle = this.getInsideAllocation(shape);
        int n5 = n4 = bl ? 1 : -1;
        if (n == -1) {
            View view = bl ? this.getView(0) : this.getView(this.getViewCount() - 1);
            this.childAllocation(0, rectangle);
            n3 = view.getNextVisualPositionFrom(n, bias, rectangle, n2, biasArray);
            if (n3 == -1 && bl && this.getViewCount() > 1) {
                view = this.getView(1);
                rectangle = this.getInsideAllocation(shape);
                this.childAllocation(1, rectangle);
                n3 = view.getNextVisualPositionFrom(-1, biasArray[0], rectangle, n2, biasArray);
            }
        } else {
            int n6 = bias == Position.Bias.Backward ? this.getViewIndexAtPosition(Math.max(this.getStartOffset(), n - 1)) : this.getViewIndexAtPosition(n);
            View view = this.getView(n6);
            this.childAllocation(n6, rectangle);
            n3 = view.getNextVisualPositionFrom(n, bias, rectangle, n2, biasArray);
            if (n3 == -1) {
                if (this.flipEastAndWestAtEnds(n, bias)) {
                    n4 *= -1;
                }
                if ((n6 += n4) >= 0 && n6 < this.getViewCount()) {
                    view = this.getView(n6);
                    rectangle = this.getInsideAllocation(shape);
                    this.childAllocation(n6, rectangle);
                    n3 = view.getNextVisualPositionFrom(-1, bias, rectangle, n2, biasArray);
                    if (n3 == n && n3 != -1 && biasArray[0] != bias) {
                        rectangle = this.getInsideAllocation(shape);
                        this.childAllocation(n6, rectangle);
                        n3 = view.getNextVisualPositionFrom(n3, biasArray[0], rectangle, n2, biasArray);
                    }
                }
            } else {
                if (this.flipEastAndWestAtEnds(n, bias)) {
                    n4 *= -1;
                }
                if (biasArray[0] != bias && (n4 == 1 && view.getEndOffset() == n3 || n4 == -1 && view.getStartOffset() == n3) && (n6 += n4) >= 0 && n6 < this.getViewCount()) {
                    view = this.getView(n6);
                    rectangle = this.getInsideAllocation(shape);
                    this.childAllocation(n6, rectangle);
                    Position.Bias bias2 = biasArray[0];
                    int n7 = view.getNextVisualPositionFrom(-1, bias, rectangle, n2, biasArray);
                    if (biasArray[0] == bias) {
                        n3 = n7;
                    } else {
                        biasArray[0] = bias2;
                    }
                }
            }
        }
        return n3;
    }

    protected int getNextNorthSouthVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3;
        if (this.getViewCount() == 0) {
            return n;
        }
        boolean bl = n2 == 1;
        Rectangle rectangle = this.getInsideAllocation(shape);
        if (n == -1) {
            View view = bl ? this.getView(this.getViewCount() - 1) : this.getView(0);
            this.childAllocation(0, rectangle);
            n3 = view.getNextVisualPositionFrom(n, bias, rectangle, n2, biasArray);
        } else {
            int n4 = bias == Position.Bias.Backward && n > 0 ? this.getViewIndexAtPosition(n - 1) : this.getViewIndexAtPosition(n);
            View view = this.getView(n4);
            this.childAllocation(n4, rectangle);
            n3 = view.getNextVisualPositionFrom(n, bias, rectangle, n2, biasArray);
            if (n3 == -1 && (bl && --n4 >= 0 || !bl && ++n4 < this.getViewCount())) {
                view = this.getView(n4);
                rectangle = this.getInsideAllocation(shape);
                this.childAllocation(n4, rectangle);
                n3 = view.getNextVisualPositionFrom(-1, bias, rectangle, n2, biasArray);
            }
        }
        return n3;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Rectangle rectangle = this.getInsideAllocation(shape);
        switch (n2) {
            case 1: {
                return this.getNextNorthSouthVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
            case 5: {
                return this.getNextNorthSouthVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
            case 3: {
                return this.getNextEastWestVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
            case 7: {
                return this.getNextEastWestVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
        }
        throw new IllegalArgumentException("Bad direction: " + n2);
    }

    protected final short getRightInset() {
        return this.right;
    }

    protected final short getTopInset() {
        return this.top;
    }

    public View getView(int n) {
        return this.children[n];
    }

    protected abstract View getViewAtPoint(int var1, int var2, Rectangle var3);

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        View view;
        int n2;
        Element element = this.getElement();
        Element element2 = element.getElement(n2 = element.getElementIndex(n));
        if (element2 != null && n2 < this.getViewCount() && (view = this.getView(n2)).getElement() == element2) {
            if (rectangle != null) {
                this.childAllocation(n2, rectangle);
            }
            return view;
        }
        return null;
    }

    public int getViewCount() {
        return this.nchildren;
    }

    protected int getViewIndexAtPosition(int n) {
        Element element = this.getElement();
        return element.getElementIndex(n);
    }

    public void insert(int n, View view) {
        View[] viewArray = new View[]{view};
        this.replace(n, 0, viewArray);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
            elementChange = null;
        }
        this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        this.updateLayout(elementChange, documentEvent, shape);
    }

    protected abstract boolean isAfter(int var1, int var2, Rectangle var3);

    protected abstract boolean isBefore(int var1, int var2, Rectangle var3);

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            int n2 = 0;
            while (n2 < n) {
                viewArray[n2] = viewFactory.create(element.getElement(n2));
                ++n2;
            }
            this.replace(0, 0, viewArray);
        }
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        View view;
        int n2;
        boolean bl = bias == Position.Bias.Backward;
        int n3 = n2 = bl ? Math.max(0, n - 1) : n;
        if (bl && n2 < this.getStartOffset()) {
            return null;
        }
        int n4 = this.getViewIndexAtPosition(n2);
        if (n4 != -1 && n4 < this.getViewCount() && (view = this.getView(n4)) != null && n2 >= view.getStartOffset() && n2 < view.getEndOffset()) {
            Shape shape2 = view.modelToView(n, this.getChildAllocation(n4, shape), bias);
            if (shape2 == null && view.getEndOffset() == n && ++n4 < this.getViewCount()) {
                view = this.getView(n4);
                shape2 = view.modelToView(n, this.getChildAllocation(n4, shape), bias);
            }
            return shape2;
        }
        throw new BadLocationException("Position not represented by view", n);
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        View view;
        if (n == this.getStartOffset() && n2 == this.getEndOffset()) {
            return shape;
        }
        Rectangle rectangle2 = this.getInsideAllocation(shape);
        Rectangle rectangle3 = new Rectangle(rectangle2);
        View view2 = this.getViewAtPosition(n, rectangle3);
        if (view2 == (view = this.getViewAtPosition(n2, rectangle = new Rectangle(rectangle2)))) {
            if (view2 == null) {
                return shape;
            }
            return view2.modelToView(n, bias, n2, bias2, rectangle3);
        }
        int n3 = this.getViewCount();
        int n4 = 0;
        while (n4 < n3) {
            View view3 = this.getView(n4);
            if (view3 == view2 || view3 == view) {
                View view4;
                Rectangle rectangle4;
                Rectangle rectangle5 = new Rectangle();
                if (view3 == view2) {
                    rectangle4 = view2.modelToView(n, bias, view2.getEndOffset(), Position.Bias.Backward, rectangle3).getBounds();
                    view4 = view;
                } else {
                    rectangle4 = view.modelToView(view.getStartOffset(), Position.Bias.Forward, n2, bias2, rectangle).getBounds();
                    view4 = view2;
                }
                while (++n4 < n3 && (view3 = this.getView(n4)) != view4) {
                    rectangle5.setBounds(rectangle2);
                    this.childAllocation(n4, rectangle5);
                    rectangle4.add(rectangle5);
                }
                if (view4 != null) {
                    Shape shape2 = view4 == view ? view.modelToView(view.getStartOffset(), Position.Bias.Forward, n2, bias2, rectangle) : view2.modelToView(n, bias, view2.getEndOffset(), Position.Bias.Backward, rectangle3);
                    if (shape2 instanceof Rectangle) {
                        rectangle4.add((Rectangle)shape2);
                    } else {
                        rectangle4.add(shape2.getBounds());
                    }
                }
                return rectangle4;
            }
            ++n4;
        }
        throw new BadLocationException("Position not represented by view", n);
    }

    void remove(int n) {
        this.replace(n, 1, ZERO);
    }

    public void removeAll() {
        this.replace(0, this.nchildren, ZERO);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
            elementChange = null;
        }
        this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        this.updateLayout(elementChange, documentEvent, shape);
    }

    public void replace(int n, int n2, View[] viewArray) {
        int n3;
        int n4 = n;
        while (n4 < n + n2) {
            this.children[n4].setParent(null);
            this.children[n4] = null;
            ++n4;
        }
        int n5 = viewArray.length - n2;
        int n6 = n + n2;
        int n7 = this.nchildren - n6;
        int n8 = n6 + n5;
        if (this.nchildren + n5 >= this.children.length) {
            n3 = Math.max(2 * this.children.length, this.nchildren + n5);
            View[] viewArray2 = new View[n3];
            System.arraycopy(this.children, 0, viewArray2, 0, n);
            System.arraycopy(viewArray, 0, viewArray2, n, viewArray.length);
            System.arraycopy(this.children, n6, viewArray2, n8, n7);
            this.children = viewArray2;
        } else {
            System.arraycopy(this.children, n6, this.children, n8, n7);
            System.arraycopy(viewArray, 0, this.children, n, viewArray.length);
        }
        this.nchildren += n5;
        n3 = 0;
        while (n3 < viewArray.length) {
            viewArray[n3].setParent(this);
            ++n3;
        }
    }

    protected final void setInsets(short s, short s2, short s3, short s4) {
        this.top = s;
        this.left = s2;
        this.right = s4;
        this.bottom = s3;
    }

    protected final void setParagraphInsets(AttributeSet attributeSet) {
        this.top = (short)StyleConstants.getSpaceAbove(attributeSet);
        this.left = (short)StyleConstants.getLeftIndent(attributeSet);
        this.bottom = (short)StyleConstants.getSpaceBelow(attributeSet);
        this.right = (short)StyleConstants.getRightIndent(attributeSet);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null && this.nchildren == 0) {
            ViewFactory viewFactory = this.getViewFactory();
            this.loadChildren(viewFactory);
        }
    }

    boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        Element[] elementArray = elementChange.getChildrenRemoved();
        Element[] elementArray2 = elementChange.getChildrenAdded();
        View[] viewArray = new View[elementArray2.length];
        int n = 0;
        while (n < elementArray2.length) {
            viewArray[n] = viewFactory.create(elementArray2[n]);
            ++n;
        }
        int n2 = elementChange.getIndex();
        this.replace(n2, elementArray.length, viewArray);
        return true;
    }

    void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        if (elementChange != null && shape != null) {
            this.preferenceChanged(null, true, true);
            this.getContainer().repaint();
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        if (this.isBefore((int)f, (int)f2, rectangle)) {
            int n = -1;
            try {
                n = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, shape, 3, biasArray);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (n == -1) {
                n = this.getStartOffset();
                biasArray[0] = Position.Bias.Forward;
            }
            return n;
        }
        if (this.isAfter((int)f, (int)f2, rectangle)) {
            int n = -1;
            try {
                n = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, shape, 7, biasArray);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (n == -1) {
                n = this.getEndOffset() - 1;
                biasArray[0] = Position.Bias.Forward;
            }
            return n;
        }
        View view = this.getViewAtPoint((int)f, (int)f2, rectangle);
        if (view != null) {
            return view.viewToModel(f, f2, rectangle, biasArray);
        }
        return -1;
    }
}

