/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;

public final class sender
implements Runnable {
    private final String copyright = "Licensed Materials - Property of IBM   26L4430 (C) Copyright IBM Corp. 1997, 1998   All rights reserved.   US Government Users Restricted Rights Use, duplication or disclosure   restricted by GSA ADP Schedule Contract with IBM Corp.";
    private OutputStream os;
    private Thread runner;
    private byte[] buffer = new byte[4096];
    private int head;
    private int tail;
    private boolean fWait;
    private boolean fValid = false;
    private byte[] special = new byte[2];
    private byte[] control = new byte[1];
    private byte[] input = new byte[4];
    public static final byte SE_INIT_MAJOR = 4;
    public static final byte SE_INIT_MINOR = 0;
    public static final byte SE_TERMINATE = 1;
    public static final byte SE_WATCHDOGTIMER = 15;
    public static final byte CE_DEBUGOUT = 6;
    public static final byte CE_CONTROL = 7;
    public static final byte KE_PRESS = 8;
    public static final byte KE_RELEASE = 9;
    public static final byte ME_DOWN1 = 2;
    public static final byte ME_UP1 = 3;
    public static final byte ME_DOWN2 = 10;
    public static final byte ME_UP2 = 11;
    public static final byte ME_DOWN3 = 12;
    public static final byte ME_UP3 = 13;
    public static final byte MME_MOVE = 4;
    public static final byte MME_DRAG = 5;

    public void initialize(OutputStream outputStream) {
        if (this.runner == null) {
            this.os = outputStream;
            this.tail = 0;
            this.head = 0;
            this.fWait = false;
            this.fValid = true;
            this.runner = new Thread(this);
            this.runner.start();
            byte[] byArray = this.special;
            synchronized (byArray) {
                this.special[0] = 4;
                this.special[1] = 0;
                this.writeBytes(this.special, 0, 2);
                return;
            }
        }
    }

    public void terminate() {
        if (this.runner != null) {
            this.sendSpecialEvent((byte)1, (byte)0);
            if (this.runner.isAlive()) {
                this.runner.stop();
            }
            this.runner = null;
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (IOException iOException) {}
            this.os = null;
            this.fValid = false;
        }
    }

    public void run() {
        block8: while (true) {
            try {
                while (this.fValid) {
                    int n;
                    byte[] byArray = this.buffer;
                    synchronized (byArray) {
                        while (this.tail == this.head) {
                            this.fWait = true;
                            this.buffer.wait();
                        }
                        n = this.tail;
                    }
                    if (n > this.head) {
                        this.writeBytes(this.buffer, this.head, n - this.head);
                    } else {
                        if (n >= this.head) continue;
                        this.writeBytes(this.buffer, this.head, this.buffer.length - this.head);
                        if (n != 0) {
                            this.writeBytes(this.buffer, 0, n);
                        }
                    }
                    byArray = this.buffer;
                    synchronized (byArray) {
                        this.head = n;
                        continue block8;
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
            break;
        }
        this.fValid = false;
    }

    private synchronized void putBytes(byte[] byArray, int n) {
        int n2;
        byte[] byArray2 = this.buffer;
        synchronized (byArray2) {
            n2 = this.head;
        }
        if (this.tail >= n2) {
            int n3 = this.buffer.length - this.tail;
            if (n >= n3 + n2) {
                return;
            }
            if (n <= n3) {
                System.arraycopy(byArray, 0, this.buffer, this.tail, n);
            } else {
                System.arraycopy(byArray, 0, this.buffer, this.tail, n3);
                System.arraycopy(byArray, n3, this.buffer, 0, n - n3);
            }
        } else {
            if (n >= n2 - this.tail) {
                return;
            }
            System.arraycopy(byArray, 0, this.buffer, this.tail, n);
        }
        byte[] byArray3 = this.buffer;
        synchronized (byArray3) {
            this.tail = (this.tail + n) % this.buffer.length;
            if (this.fWait) {
                this.fWait = false;
                this.buffer.notify();
            }
            return;
        }
    }

    void writeBytes(byte[] byArray, int n, int n2) {
        try {
            OutputStream outputStream = this.os;
            synchronized (outputStream) {
                this.os.write(byArray, n, n2);
                this.os.flush();
                return;
            }
        }
        catch (IOException iOException) {
            this.fValid = false;
            return;
        }
    }

    public boolean isValid() {
        return this.fValid;
    }

    public void sendSpecialEvent(byte by, byte by2) {
        byte[] byArray = this.special;
        synchronized (byArray) {
            this.special[0] = (byte)(by | by2 << 4);
            this.writeBytes(this.special, 0, 1);
            return;
        }
    }

    public void watchDogTimer() {
        this.sendSpecialEvent((byte)15, (byte)0);
    }

    public void sendControlEvent(byte by, byte by2) {
        byte[] byArray = this.control;
        synchronized (byArray) {
            this.control[0] = (byte)(by | by2 << 4);
            this.putBytes(this.control, 1);
            return;
        }
    }

    public void control(byte by) {
        this.sendControlEvent((byte)7, by);
    }

    public void debugOut(byte by) {
        this.sendControlEvent((byte)6, by);
    }

    public void sendKeyEvent(byte by, byte by2, byte by3) {
        this.input[0] = by;
        this.input[1] = by3;
        this.input[2] = (byte)(by2 & 0x7F);
        this.putBytes(this.input, 3);
    }

    public void keyPress(byte by, byte by2) {
        this.sendKeyEvent((byte)8, by, by2);
    }

    public void keyRelease(byte by, byte by2) {
        this.sendKeyEvent((byte)9, by, by2);
    }

    public void sendMouseEvent(byte by, byte by2) {
        this.input[0] = by;
        this.input[1] = by2;
        this.putBytes(this.input, 2);
    }

    public void mouseDown1(byte by) {
        this.sendMouseEvent((byte)2, by);
    }

    public void mouseUp1(byte by) {
        this.sendMouseEvent((byte)3, by);
    }

    public void mouseDown2(byte by) {
        this.sendMouseEvent((byte)10, by);
    }

    public void mouseUp2(byte by) {
        this.sendMouseEvent((byte)11, by);
    }

    public void mouseDown3(byte by) {
        this.sendMouseEvent((byte)12, by);
    }

    public void mouseUp3(byte by) {
        this.sendMouseEvent((byte)13, by);
    }

    public void sendMouseMotionEvent(byte by, short s, short s2) {
        this.input[0] = by;
        this.input[1] = (byte)(s & 0xFF);
        this.input[2] = (byte)(s2 & 0xFF);
        this.input[3] = (byte)((s & 0xF00) >> 8 | (s2 & 0xF00) >> 4);
        this.putBytes(this.input, 4);
    }

    public void mouseMove(short s, short s2) {
        this.sendMouseMotionEvent((byte)4, s, s2);
    }

    public void mouseDrag(short s, short s2) {
        this.sendMouseMotionEvent((byte)5, s, s2);
    }

    public void mouseEnter() {
    }

    public void mouseExit() {
    }
}

