/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Label;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import netscape.javascript.JSObject;

public class chat10
extends Applet
implements Runnable {
    final String Copyright = "Licensed Materials - Property of IBM   11P5595 (C) Copyright IBM Corp. 1997, 2000   All rights reserved.   US Government Users Restricted Rights Use, duplication or disclosure   restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final byte SE_INIT_MAJOR = 4;
    private static final byte SE_INIT_MINOR = 0;
    private static final byte MSG_NORMAL = 1;
    private static final byte MSG_DISCONNECT = 2;
    private static final byte MSG_NOT_AVAILABLE = 3;
    private static final byte MSG_CONSUMED = 4;
    private static final int MAX_BYTES_CONSUMED = 8000;
    private String hostAddr;
    private int hostPort;
    private Thread runner;
    private String serverName;
    private OutputStream os;
    private InputStream is;
    private static int cntInstances;
    private boolean fFirstInstance = false;
    private boolean fConsumed = false;
    private mrimain mri = new mrimain();
    private boolean fLogon = false;
    private chatui10 chatuiPanel;
    private byte[] byteSnd;
    private byte[] byteMsg;
    private Socket chatSocket;
    private boolean fTerminate;
    private boolean fDisconnected;
    private boolean fConnected;
    private int bytesConsumed;
    private boolean fJDK11;
    private JSObject win;
    private byte[] inputBuf = new byte[1];
    String[] dummyArgs = new String[]{""};

    public void init() {
        try {
            this.win = JSObject.getWindow((Applet)this);
        }
        catch (Exception exception) {
            this.win = null;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.chatuiPanel = new chatui10(this, true);
            this.fFirstInstance = ++cntInstances == 1;
            this.fTerminate = false;
            this.fDisconnected = false;
            this.fConnected = false;
            this.hostAddr = this.getCodeBase().getHost();
            this.hostPort = Integer.valueOf(this.getParameter("Port"));
            this.serverName = this.getParameter("ServerName");
            this.bytesConsumed = 0;
            this.fConsumed = false;
            this.chatSocket = null;
            String string = System.getProperty("java.version");
            this.fJDK11 = string.startsWith("1.1");
            if (this.win == null) {
                this.add(new Label("This browser doesn't support JavaScript or LiveConnect."));
            } else if (this.fFirstInstance) {
                this.setBackground(Color.black);
                this.chatStart();
            } else {
                this.add(new Label("Greeting Text Chat is already running."));
                this.add(new Label("This window doesn't run Greeting Text Chat."));
            }
            return;
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.chatuiPanel.termUi();
            this.chatStop();
            --cntInstances;
            return;
        }
    }

    public void paint(Graphics graphics) {
    }

    public synchronized void notifyEvent(int n) {
        switch (n) {
            case 0: {
                this.sendMsg();
                return;
            }
        }
    }

    void notifyChatUiEvent(boolean bl) {
        chatui10 chatui102 = this.chatuiPanel;
        synchronized (chatui102) {
            this.sendMsg();
            return;
        }
    }

    private void showChatUiPanel() {
        this.chatuiPanel.init();
        this.add(this.chatuiPanel);
        this.chatuiPanel.initFocus();
        this.validate();
    }

    private synchronized void chatStart() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    private synchronized void sendMsg() {
        byte[] byArray = new byte[3];
        if (this.runner != null) {
            if (!this.fJDK11) {
                String string = this.chatuiPanel.getSnd();
                this.byteSnd = new byte[string.length()];
                string.getBytes(0, string.length(), this.byteSnd, 0);
            } else {
                this.byteSnd = this.chatuiPanel.getSnd().getBytes();
            }
            byArray[0] = 1;
            byArray[1] = (byte)(this.byteSnd.length & 0xFF);
            byArray[2] = (byte)(this.byteSnd.length >> 8 & 0xFF);
            this.putBytes(byArray, 3);
            this.putBytes(this.byteSnd, this.byteSnd.length);
            this.checkConsumed(this.byteSnd.length);
            this.chatuiPanel.clearText();
        }
    }

    private synchronized void sendByte(byte by) {
        byte[] byArray = new byte[1];
        if (this.runner != null) {
            byArray[0] = by;
            boolean bl = this.putBytes(byArray, 1);
            return;
        }
    }

    private synchronized void chatStop() {
        if (this.runner != null) {
            if (!this.fDisconnected && this.fConnected) {
                this.sendByte((byte)2);
                this.fTerminate = true;
            }
            if (this.runner.isAlive()) {
                this.runner.stop();
            }
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (IOException iOException) {}
            this.os = null;
            try {
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (IOException iOException) {}
            this.is = null;
            this.closeConnection();
        }
    }

    private synchronized void closeConnection() {
        if (this.runner != null) {
            this.closeSocket(this.chatSocket);
            this.chatSocket = null;
            this.runner = null;
        }
    }

    public void run() {
        this.fTerminate = false;
        this.chatSocket = this.openSocket(this.hostAddr, this.hostPort);
        if (this.chatSocket == null) {
            return;
        }
        try {
            this.is = new BufferedInputStream(this.chatSocket.getInputStream());
            this.os = new BufferedOutputStream(this.chatSocket.getOutputStream());
        }
        catch (IOException iOException) {
            this.closeSocket(this.chatSocket);
            this.chatSocket = null;
            this.runner = null;
            return;
        }
        this.chatmain();
    }

    private boolean chatmain() {
        byte[] byArray = new byte[3];
        short[] sArray = new short[2];
        byArray[0] = 4;
        byArray[1] = 0;
        byArray[2] = 0;
        this.putBytes(byArray, 3);
        this.getShorts(sArray, 2);
        if (sArray[0] == 4) {
            this.fConnected = true;
            this.showChatUiPanel();
            while (!this.fTerminate) {
                this.receiveMsg();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.setBackground(Color.white);
            this.add(new Label("Now disconnected. Retry after reload."));
            this.add(new Label(""));
            this.validate();
        }
        return true;
    }

    public void setMsg(byte[] byArray, int n, boolean bl) {
        this.chatuiPanel.setMsg(byArray, n, bl);
    }

    private void receiveMsg() {
        byte[] byArray = new byte[1];
        short[] sArray = new short[2];
        byArray[0] = this.getByte();
        if (this.fDisconnected) {
            return;
        }
        switch (byArray[0] & 0xF) {
            case 1: {
                int n = 0;
                this.getShorts(sArray, 2);
                n = sArray[0] + (sArray[1] << 8);
                byte[] byArray2 = new byte[n];
                this.getBytes(byArray2, n);
                this.setMsg(byArray2, n, true);
                this.checkConsumed(n);
                return;
            }
            case 2: {
                this.fDisconnected = true;
                this.requestClose();
                return;
            }
        }
    }

    private Socket openSocket(String string, int n) {
        Socket socket = null;
        try {
            socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            socket = null;
        }
        catch (IOException iOException) {
            socket = null;
        }
        return socket;
    }

    private void closeSocket(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    private boolean putBytes(byte[] byArray, int n) {
        try {
            this.os.write(byArray, 0, n);
            this.os.flush();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public String getHost() {
        return this.hostAddr;
    }

    private void getShorts(short[] sArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = (short)(this.getByte() & 0xFF);
            ++n2;
        }
    }

    private void getBytes(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.getByte();
            ++n2;
        }
    }

    private byte getByte() {
        try {
            this.is.read(this.inputBuf);
        }
        catch (IOException iOException) {}
        return this.inputBuf[0];
    }

    synchronized void enableChat() {
        if (this.win == null) {
            return;
        }
        this.win.call("enableChat", this.dummyArgs);
    }

    synchronized void requestClose() {
        if (this.win == null) {
            return;
        }
        this.win.call("requestClose", this.dummyArgs);
    }

    synchronized boolean isConsumed() {
        return this.fConsumed;
    }

    public synchronized void checkConsumed(int n) {
        this.bytesConsumed += n;
        if (this.bytesConsumed >= 8000) {
            this.sendByte((byte)4);
            this.fConsumed = true;
            this.chatuiPanel.setStatus("Reached to maximum data amount.");
            this.chatuiPanel.disableSnd();
        }
    }
}

