/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman;

import com.ibm.gsk.ikeyman.awt.HelpFrame;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.LoadMonitor;
import com.ibm.gsk.ikeyman.awt.MsgDialog;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Ikeyman
implements IkeymanConstants {
    public static Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    public static Font defaultFont = Font.decode("Serif");
    public static Font defaultMonospacedFont = Font.decode("Monospaced");
    public static Font defaultBoldFont = new Font(defaultFont.getName(), 1, defaultFont.getSize());
    private static ResourceBundle guiRB;
    private static KMFrame frame;
    private static Frame helpFrame;
    private static Class helpClass;
    private static String helpClassName;
    private static boolean isHelpClassFound;
    private static boolean isHelpClassInstanceOk;
    public static boolean printDebugMsg;
    public static String defaultDebugDumpFileName;
    private static FileOutputStream debugDumpOutputStream;
    private static PrintWriter debugPrintWriter;
    public static String javaDocPath;
    public static Applet appletInstance;

    public Ikeyman() {
        this(null);
    }

    public Ikeyman(Applet applet) {
        appletInstance = applet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() {
        Object object;
        Locale locale;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        LoadMonitor loadMonitor;
        boolean bl;
        JFrame jFrame;
        Date date;
        boolean bl2;
        block50: {
            bl2 = false;
            date = new Date();
            String string = appletInstance == null ? System.getProperty("keyman.timer") : appletInstance.getParameter("keyman.timer");
            if (string != null && (string.equals("on") || string.equals("ON"))) {
                bl2 = true;
            }
            jFrame = new JFrame();
            JOptionPane.setRootFrame(jFrame);
            String string2 = null;
            bl = false;
            loadMonitor = null;
            string2 = appletInstance == null ? System.getProperty("keyman.useDosPrompt") : appletInstance.getParameter("keyman.useDosPrompt");
            this.loadGUIMessageResource();
            if (string2 != null && (string2.equals("true") || string2.equals("TRUE"))) {
                bl = true;
            }
            if (!bl) {
                loadMonitor = new LoadMonitor(Ikeyman.getNLSResString("GUI_TITLE"), Ikeyman.getNLSResString("GUI_MSG_V_LOADED_GUI_RES"));
                loadMonitor.start();
            }
            Ikeyman.initUserEnv();
            try {
                KMSystem.init(appletInstance);
                if (bl) {
                    KMSystem.verboseMsg(Ikeyman.getNLSResString("GUI_MSG_V_LOADED_GUI_RES"));
                }
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
                System.exit(1);
            }
            String string3 = null;
            boolean bl3 = false;
            string3 = appletInstance == null ? System.getProperty("keyman.javaOnly") : appletInstance.getParameter("keyman.javaOnly");
            if (string3 != null && (string3.equals("true") || string3.equals("TRUE"))) {
                bl3 = true;
            }
            if (appletInstance == null && !bl3) {
                if (!KMSystem.isJNIEnabled()) {
                    String string4;
                    if (KMSystem.getVersion() < 17) {
                        string4 = KMSystem.getNLSErrString("GSKKM_ERR_NATIVE_NOT_ENABLED");
                        object5 = UIManager.getDefaults().getIcon("OptionPane.errorIcon");
                        object4 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_ERROR");
                    } else {
                        string4 = Ikeyman.getNLSResString("GUI_MSG_NATIVE_NOT_ENABLED");
                        object4 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_WARNING");
                        object5 = UIManager.getDefaults().getIcon("OptionPane.warningIcon");
                    }
                    object3 = new MsgDialog((Frame)jFrame, (String)object4, (Icon)object5, string4);
                    object2 = ((Component)object3).getSize();
                    ((Component)object3).setLocation((Ikeyman.screenSize.width - ((Dimension)object2).width) / 2, (Ikeyman.screenSize.height - ((Dimension)object2).height) / 2);
                    ((Component)object3).setVisible(true);
                    if (KMSystem.getVersion() < 17) {
                        System.exit(1);
                    }
                }
                if (printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......examine errCode " + CMSKeyDatabaseException.MIN_CMS_KEYDB_ERR_CODE + " to " + CMSKeyDatabaseException.MAX_CMS_KEYDB_ERR_CODE);
                    int n = CMSKeyDatabaseException.MIN_CMS_KEYDB_ERR_CODE;
                    while (n <= CMSKeyDatabaseException.MAX_CMS_KEYDB_ERR_CODE) {
                        if (!CMSKeyDatabaseException.errKeyTable.containsKey(new Integer(n))) {
                            Ikeyman.debugMsg("INVALID ERROR CODE: " + n);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        object4 = CMSKeyDatabaseException.getErrKey(n);
                        if (object4 != null) {
                            object5 = KMSystem.getNLSErrString((String)object4);
                            Ikeyman.debugMsg("ERROR MESSAGE " + n + ": " + (String)object5);
                        } else {
                            Ikeyman.debugMsg("NO NAME ERROR CODE: " + n);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        ++n;
                    }
                }
            }
            try {
                helpClassName = System.getProperty("keyman.helpClassName");
                if (helpClassName == null) {
                    helpClassName = "CSSgKey";
                } else if (helpClassName.endsWith(".class")) {
                    helpClassName = helpClassName.substring(0, helpClassName.length() - 6);
                }
                helpClass = Class.forName(helpClassName);
                isHelpClassFound = true;
                if (printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......class " + helpClassName + " is found");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                isHelpClassFound = false;
                if (printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......class " + helpClassName + " is not found");
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isHelpClassFound = false;
                if (printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......class " + helpClassName + " is not found");
                }
            }
            catch (Error error) {
                isHelpClassFound = false;
                if (printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......class " + helpClassName + " is not found");
                }
            }
            catch (Exception exception) {
                isHelpClassFound = false;
                if (!printDebugMsg) break block50;
                Ikeyman.debugMsg("DEBUG......class " + helpClassName + " is not found");
            }
        }
        if ((locale = KMSystem.getLocale(appletInstance)).getLanguage().equals("ja") && appletInstance == null && (object4 = System.getProperty("os.name")) != null && ((String)object4).equals("Windows 95")) {
            object5 = UIManager.getDefaults();
            object3 = ((Hashtable)object5).keys();
            try {
                while (object3.hasMoreElements()) {
                    object2 = object3.nextElement();
                    try {
                        object = (String)object2;
                        if (!((String)object).endsWith(".font")) continue;
                        UIManager.put(object, defaultMonospacedFont);
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        KMSystem.verboseMsg(Ikeyman.getNLSResString("GUI_MSG_V_LOAD_MAIN_FRAME"));
        frame = new KMFrame(appletInstance);
        JOptionPane.setRootFrame(frame);
        jFrame.dispose();
        KMSystem.verboseMsg(Ikeyman.getNLSResString("GUI_MSG_V_SHOW_MAIN_FRAME"));
        object4 = frame.getSize();
        object5 = frame.getPreferredSize();
        object3 = frame.getBounds();
        if (printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......frameSize=" + object4 + ", preferred=" + object5 + ", bound=" + object3 + ", screenSize=" + screenSize);
        }
        if (((Dimension)object5).height <= Ikeyman.screenSize.height * 3 / 4 && ((Dimension)object5).width <= Ikeyman.screenSize.width * 3 / 4) {
            ((Component)frame).setSize(3 * Ikeyman.screenSize.width / 4, 3 * Ikeyman.screenSize.height / 4);
        } else {
            ((Component)frame).setSize(screenSize);
        }
        object4 = frame.getSize();
        object5 = frame.getPreferredSize();
        if (printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......frameSize=" + object4 + ", preferred=" + object5 + ", bound=" + object3 + ", screenSize=" + screenSize);
        }
        ((Component)frame).setLocation((Ikeyman.screenSize.width - ((Dimension)object4).width) / 2, (Ikeyman.screenSize.height - ((Dimension)object4).height) / 2);
        ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
        if (!bl && loadMonitor != null) {
            loadMonitor.stopLoop();
        }
        ((Component)frame).setVisible(true);
        defaultFont = frame.getFont();
        if (defaultFont == null) {
            defaultFont = Font.decode("Serif");
        }
        defaultBoldFont = new Font(defaultFont.getName(), 1, defaultFont.getSize());
        if (printDebugMsg) {
            Ikeyman.debugMsg("defaultFont=" + defaultFont + ", defaultBoldFont=" + defaultBoldFont + ", defaultMonospacedFont=" + defaultMonospacedFont);
        }
        object2 = null;
        object2 = appletInstance == null ? System.getProperty("keyman.keydatabase") : appletInstance.getParameter("keyman.keydatabase");
        if (object2 != null) {
            frame.menuItem_Open_Handler((String)object2);
        }
        if (bl2) {
            object = new Date();
            if (printDebugMsg) {
                Ikeyman.debugMsg("Running Time: " + (((Date)object).getTime() - date.getTime()) + " milliseconds");
                return;
            }
            System.out.println("Running Time: " + (((Date)object).getTime() - date.getTime()) + " milliseconds");
        }
    }

    public static void printUsage() {
        String[] stringArray = new String[]{"Usage: ", "    ikmgui [-options] ", "or ", "    java [-java options] com.ibm.ikeyman.Ikeyman [-options] ", "", "where options include: ", "    -h[elp]              print out this message", "    -ver[sion]           print out build version ", "    -v[erbose]           generate verbose output ", "    -db <kdb|kyr> <file> indicate a database file of the specified type", "    -dn <dn-name>        a distinguished name input with format:", "                         dn-name ::= \"cn=<common name>, \\", "                                      o=<organization name>, \\", "                                      ou=<organization unit name>, \\", "                                      c=<country name>\"", "    -l[abel] <string>    a label input for a new entry in key database", "    -in <file>           input file", "    -out <file>          output file to save result", "    -p12pwd <password>   a password for a PKCS#12 key exchange file", "    -p <password>        password input for a key database", "                         Be careful to use this option because other", "                         users in your machine can detect your password", "                         input by simply looking at process list.", "                         All the following action options need a password", "                         input. You need to pass a password with option -p,", "                         or enter a password when you are prompted to do so.", "    -c[reate] [-cert|-certreq -l <string> -dn <dn-name>] -db <kdb|kyr> <file> [-out <file>]", "                         create the named new key database, a self-signed", "                         certificate, or a new certificate request", "    -exp[ort] [-a|-d|-f] -db <kdb|kyr> <file> -p12pwd <password> -out <file>", "                         export a private key entry", "    -a                   export all keys in the database", "    -d                   export the default key", "    -f                   export the first private key found in the database", "    -ext[ract] -l <label string> -db <kdb|kyr> <file> -out <file>", "                         extract a certificate or certificate request by label", "    -imp[ort] -p12pwd <password> -in <PKCS#12 file> -db <kdb|kyr> <file>", "                         import keys from the file into the named key database", "    -kyr2kdb <keyring file> <CMS key database file> ", "                         convert a keyring file to CMS key database", "    -kdb2kyr <CMS key database file> <keyring file>", "                         convert a CMS key database to keyring file", "    -r[eceive] -in <certificate file> -db <kdb|kyr> <file> ", "                         store the certificate for your request from CA", "    -s[tore]ca -l <label> -in <certificate file> -db <kdb|kyr> <file>", "                         store a CA certificate into the key database", "    -stash -db <kdb|kyr> <file> ", "                         stash the database password"};
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        Ikeyman ikeyman = new Ikeyman();
        ikeyman.init();
    }

    public static void initUserEnv() {
        String string;
        String string2;
        if (appletInstance == null) {
            string2 = System.getProperty("keyman.debug");
            string = System.getProperty("keyman.debugDumpFileName");
        } else {
            string2 = appletInstance.getParameter("keyman.debug");
            string = appletInstance.getParameter("keyman.debugDumpFileName");
        }
        if (string2 != null && (string2.equals("true") || string2.equals("TRUE"))) {
            printDebugMsg = true;
            if (string == null) {
                string = defaultDebugDumpFileName;
            }
            if (string != null) {
                File file = new File(string);
                file.exists();
                try {
                    debugDumpOutputStream = new FileOutputStream(file);
                    debugPrintWriter = new PrintWriter(debugDumpOutputStream, true);
                }
                catch (IOException iOException) {
                    if (debugDumpOutputStream != null) {
                        try {
                            debugDumpOutputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    debugDumpOutputStream = null;
                    debugPrintWriter = null;
                }
            }
        } else {
            printDebugMsg = false;
        }
        javaDocPath = appletInstance == null ? System.getProperty("keyman.docpath") : appletInstance.getParameter("keyman.docpath");
        if (printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......javaDocPath=" + javaDocPath);
        }
    }

    public static void debugMsg(String string) {
        if (printDebugMsg) {
            if (debugDumpOutputStream != null && debugPrintWriter != null) {
                debugPrintWriter.println(string);
                return;
            }
            System.out.println(string);
        }
    }

    public static void closeDebugDumpFile() {
        if (debugDumpOutputStream != null && debugPrintWriter != null) {
            debugPrintWriter.close();
            try {
                debugDumpOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        debugDumpOutputStream = null;
        debugPrintWriter = null;
    }

    public static String getNLSResString(String string) {
        String string2;
        if (guiRB == null) {
            string2 = null;
            string2 = "Error occured while getting NLS message for " + string + " due to empty resource handle.";
        } else {
            try {
                string2 = (String)guiRB.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......can not find message for " + string);
                }
                missingResourceException.printStackTrace();
                string2 = "Error occured while getting NLS message for " + string;
            }
        }
        return string2;
    }

    public static String getNLSErrString(String string) {
        return KMSystem.getNLSErrString(string);
    }

    public void loadGUIMessageResource() {
        guiRB = null;
        Locale locale = KMSystem.getLocale(appletInstance);
        if (printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......locale=" + locale);
        }
        try {
            guiRB = ResourceBundle.getBundle("ikmgui", locale);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public static String getDatabaseNLSTypeName(int n) {
        if (n == 1) {
            return Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CMS");
        }
        if (n == 2) {
            return Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_WEBDB");
        }
        if (n == 4) {
            return Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_SSLINK");
        }
        if (n == 3) {
            return Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_SSLIGHT");
        }
        if (n == 5) {
            return Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CDSA");
        }
        if (n == 6) {
            return Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_BERKELEY");
        }
        return Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_UNKNOWN");
    }

    public static void closeHelpFrame() {
        if (helpFrame != null && helpFrame.isShowing()) {
            helpFrame.dispose();
            helpFrame = null;
        }
    }

    public static void showHelpWindow(String string) {
        Ikeyman.showHelpWindow(frame, string);
    }

    public static void showHelpWindow(Window window, String string) {
        Serializable serializable;
        if (printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......enter showHelpWindow()");
        }
        if (!isHelpClassFound) {
            return;
        }
        if (helpFrame != null && !helpFrame.isShowing()) {
            helpFrame = null;
        }
        if (helpFrame != null && printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......helpFrame show " + helpFrame.isShowing() + ", visible " + helpFrame.isVisible() + ", valid " + helpFrame.isValid());
        }
        if (window != null) {
            ((Component)window).setCursor(Cursor.getPredefinedCursor(3));
        }
        if (helpFrame == null) {
            block33: {
                if (isHelpClassFound && helpClass != null) {
                    try {
                        helpFrame = (Frame)helpClass.newInstance();
                        if (printDebugMsg) {
                            Ikeyman.debugMsg("DEBUG......class " + helpClassName + " instance is made!");
                        }
                        isHelpClassInstanceOk = true;
                    }
                    catch (InstantiationException instantiationException) {
                        isHelpClassInstanceOk = false;
                        helpFrame = null;
                        if (printDebugMsg) {
                            Ikeyman.debugMsg("DEBUG......class " + helpClassName + " instance is not made ");
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        isHelpClassInstanceOk = false;
                        helpFrame = null;
                        if (printDebugMsg) {
                            Ikeyman.debugMsg("DEBUG......class " + helpClassName + " instance is not made ");
                        }
                    }
                    catch (Error error) {
                        isHelpClassInstanceOk = false;
                        helpFrame = null;
                        if (printDebugMsg) {
                            Ikeyman.debugMsg("DEBUG......class " + helpClassName + " instance is not made ");
                        }
                    }
                    catch (Exception exception) {
                        isHelpClassInstanceOk = false;
                        helpFrame = null;
                        if (!printDebugMsg) break block33;
                        Ikeyman.debugMsg("DEBUG......class " + helpClassName + " instance is not made ");
                    }
                }
            }
            if (helpFrame == null && !isHelpClassInstanceOk) {
                if (window != null) {
                    ((Component)window).setCursor(Cursor.getPredefinedCursor(0));
                }
                return;
            }
        } else if (!(isHelpClassFound && isHelpClassInstanceOk || string == null)) {
            serializable = HelpFrame.getURL(string);
            if (serializable == null) {
                serializable = HelpFrame.getURL("packages.html");
            }
            ((HelpFrame)helpFrame).linkActivated((URL)serializable, false);
        }
        if (helpFrame.isShowing()) {
            serializable = new WindowEvent(helpFrame, 205);
            if (printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......WindowEvent " + serializable);
            }
            helpFrame.dispatchEvent((AWTEvent)serializable);
            serializable = new WindowEvent(helpFrame, 204);
            if (printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......WindowEvent " + serializable);
            }
            helpFrame.dispatchEvent((AWTEvent)serializable);
        }
        int n = Ikeyman.helpFrame.getSize().width;
        int n2 = Ikeyman.helpFrame.getSize().height;
        if (!isHelpClassFound || !isHelpClassInstanceOk) {
            Dimension dimension = helpFrame.getPreferredSize();
            n = dimension.width;
            n2 = dimension.height;
            if (n < Ikeyman.screenSize.width * 3 / 5) {
                n = Ikeyman.screenSize.width * 3 / 5;
            } else if (n > Ikeyman.screenSize.width * 4 / 5) {
                n = Ikeyman.screenSize.width * 4 / 5;
            }
            if (dimension.height < Ikeyman.screenSize.height * 3 / 4) {
                n2 = Ikeyman.screenSize.height * 3 / 4;
            } else if (dimension.height > Ikeyman.screenSize.height * 4 / 5) {
                n2 = Ikeyman.screenSize.height * 4 / 5;
            }
            if (printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......HelpFrame: prefSize=" + dimension + ", x=" + n + ",y=" + n2);
            }
            ((Component)helpFrame).setSize(n, n2);
        }
        ((Component)helpFrame).setLocation(Ikeyman.screenSize.width - n - 5, 5);
        ((Component)helpFrame).setVisible(true);
        if (window != null) {
            ((Component)window).setCursor(Cursor.getPredefinedCursor(0));
        }
        ((Component)helpFrame).setCursor(Cursor.getPredefinedCursor(0));
        helpFrame.toFront();
    }

    public static boolean isHelpAvailable() {
        return isHelpClassFound;
    }

    public static boolean isOverwriteConfirmedFileDialog() {
        if (appletInstance == null) {
            try {
                String string = System.getProperty("os.name");
                return string != null && string.startsWith("Windows");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return false;
    }

    public static char getHotKeyChars(String string) {
        int n = string.indexOf("&");
        if (n != -1) {
            return string.charAt(n + 1);
        }
        return '\u0000';
    }

    public static String getMenuItemstr(String string) {
        int n = string.indexOf("&");
        if (n != -1) {
            String string2 = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
            return string2;
        }
        return string;
    }

    static {
        helpFrame = null;
        helpClass = null;
        helpClassName = "CSSgKey";
        defaultDebugDumpFileName = "ikmgdbg.log";
        debugDumpOutputStream = null;
        javaDocPath = null;
        appletInstance = null;
    }
}

